/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.icalendarfx.properties.component.recurrence.rrule.byxxx;

import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import jfxtras.icalendarfx.properties.component.recurrence.rrule.byxxx.ByMinute;
import jfxtras.icalendarfx.properties.component.recurrence.rrule.byxxx.ByRuleIntegerAbstract;

public class BySecond
extends ByRuleIntegerAbstract<BySecond> {
    public BySecond() {
    }

    public BySecond(Integer ... minutes) {
        super(minutes);
    }

    public BySecond(BySecond source) {
        super(source);
    }

    @Override
    Predicate<Integer> isValidValue() {
        return value -> value >= 0 && value <= 59;
    }

    @Override
    public Stream<Temporal> streamRecurrences(Stream<Temporal> inStream, ChronoUnit chronoUnit, Temporal dateTimeStart) {
        if (dateTimeStart.isSupported(ChronoField.SECOND_OF_MINUTE)) {
            switch (chronoUnit) {
                case SECONDS: {
                    return inStream.filter(d -> {
                        int mySecondOfMinute = d.get(ChronoField.SECOND_OF_MINUTE);
                        Iterator iterator = ((List)this.getValue()).iterator();
                        while (iterator.hasNext()) {
                            int secondOfMinute = (Integer)iterator.next();
                            if (secondOfMinute <= 0 || secondOfMinute != mySecondOfMinute) continue;
                            return true;
                        }
                        return false;
                    });
                }
                case HOURS: 
                case MINUTES: 
                case DAYS: 
                case WEEKS: 
                case MONTHS: 
                case YEARS: {
                    return inStream.flatMap(d -> {
                        ArrayList<Temporal> dates = new ArrayList<Temporal>();
                        Iterator iterator = ((List)this.getValue()).iterator();
                        while (iterator.hasNext()) {
                            int minuteOfHour = (Integer)iterator.next();
                            Temporal newTemporal = d.with(ChronoField.SECOND_OF_MINUTE, minuteOfHour);
                            dates.add(newTemporal);
                        }
                        return dates.stream();
                    });
                }
            }
            throw new IllegalArgumentException("Not implemented: " + chronoUnit);
        }
        return inStream;
    }

    public static ByMinute parse(String content) {
        return ByMinute.parse(new ByMinute(), content);
    }
}

