/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.internal.scene.control.skin.agenda.base24hour;

import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.scene.layout.Pane;
import javafx.scene.shape.Line;
import javafx.scene.text.FontSmoothingType;
import javafx.scene.text.Text;
import jfxtras.internal.scene.control.skin.agenda.base24hour.LayoutHelp;
import jfxtras.util.NodeUtil;

class TimeScale24Hour
extends Pane {
    final Pane pane;
    final LayoutHelp layoutHelp;

    TimeScale24Hour(Pane pane, LayoutHelp layoutHelp) {
        this.pane = pane;
        this.layoutHelp = layoutHelp;
        this.layoutXProperty().set(0.0);
        this.layoutYProperty().set(0.0);
        this.prefWidthProperty().bind((ObservableValue)pane.widthProperty());
        this.prefHeightProperty().bind((ObservableValue)pane.heightProperty());
        this.setMouseTransparent(true);
        this.addTimeScale();
    }

    private void addTimeScale() {
        for (int lHour = 0; lHour < 24; ++lHour) {
            Line l = new Line(0.0, 10.0, 100.0, 10.0);
            l.setId("hourLine" + lHour);
            l.getStyleClass().add((Object)"HourLine");
            l.startXProperty().set(0.0);
            l.startYProperty().bind((ObservableValue)NodeUtil.snapXY((ObservableNumberValue)this.layoutHelp.hourHeighProperty.multiply(lHour)));
            l.endXProperty().bind((ObservableValue)NodeUtil.snapXY((ObservableNumberValue)this.pane.widthProperty()));
            l.endYProperty().bind((ObservableValue)NodeUtil.snapXY((ObservableNumberValue)l.startYProperty()));
            this.getChildren().add((Object)l);
            l = new Line(0.0, 10.0, 100.0, 10.0);
            l.setId("halfHourLine" + lHour);
            l.getStyleClass().add((Object)"HalfHourLine");
            l.startXProperty().bind((ObservableValue)NodeUtil.snapXY((ObservableNumberValue)this.layoutHelp.timeWidthProperty));
            l.endXProperty().bind((ObservableValue)NodeUtil.snapXY((ObservableNumberValue)this.pane.widthProperty()));
            l.startYProperty().bind((ObservableValue)NodeUtil.snapXY((ObservableNumberValue)this.layoutHelp.hourHeighProperty.multiply((double)lHour + 0.5)));
            l.endYProperty().bind((ObservableValue)NodeUtil.snapXY((ObservableNumberValue)l.startYProperty()));
            this.getChildren().add((Object)l);
            Text t = new Text(lHour + ":00");
            t.xProperty().bind((ObservableValue)this.layoutHelp.timeWidthProperty.subtract(t.getBoundsInParent().getWidth()).subtract(this.layoutHelp.timeColumnWhitespaceProperty.get() / 2.0));
            t.yProperty().bind((ObservableValue)this.layoutHelp.hourHeighProperty.multiply(lHour));
            t.setTranslateY(t.getBoundsInParent().getHeight());
            t.getStyleClass().add((Object)"HourLabel");
            t.setFontSmoothingType(FontSmoothingType.LCD);
            this.getChildren().add((Object)t);
        }
    }
}

