/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.internal.scene.control.skin.agenda.icalendar.base24hour;

import java.time.LocalDate;
import java.time.Period;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import javafx.util.Pair;
import jfxtras.icalendarfx.utilities.DateTimeUtilities;
import jfxtras.internal.scene.control.skin.agenda.icalendar.base24hour.Settings;

public final class AgendaDateTimeUtilities {
    private AgendaDateTimeUtilities() {
    }

    public static String formatRange(Temporal start, Temporal end) {
        Object endString;
        DateTimeFormatter startFormatter = DateTimeUtilities.DateTimeType.of(start) == DateTimeUtilities.DateTimeType.DATE ? Settings.DATE_FORMAT : Settings.DATE_TIME_FORMAT;
        String startString = startFormatter.format(start);
        if (end != null) {
            Period days = Period.between(LocalDate.from(start), LocalDate.from(end));
            if (start == end) {
                endString = "";
            } else if (days.isZero() && end.isSupported(ChronoUnit.NANOS)) {
                endString = " - " + Settings.TIME_FORMAT_END.format(end);
            } else {
                DateTimeFormatter endFormatterDifferentDay = DateTimeUtilities.DateTimeType.of(start) == DateTimeUtilities.DateTimeType.DATE ? Settings.DATE_FORMAT : Settings.DATE_TIME_FORMAT;
                endString = " - " + endFormatterDifferentDay.format(end);
            }
        } else {
            endString = Settings.resources == null ? " - forever" : " - " + Settings.resources.getString("forever");
        }
        return startString + (String)endString;
    }

    public static String formatRange(Pair<Temporal, Temporal> range) {
        Temporal start = (Temporal)range.getKey();
        Temporal end = (Temporal)range.getValue();
        return AgendaDateTimeUtilities.formatRange(start, end);
    }
}

