/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.internal.scene.control.skin.agenda.icalendar.base24hour;

import java.time.temporal.Temporal;
import java.util.Map;
import java.util.ResourceBundle;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.layout.GridPane;
import javafx.util.Pair;
import javafx.util.StringConverter;
import jfxtras.internal.scene.control.skin.agenda.icalendar.base24hour.AgendaDateTimeUtilities;
import jfxtras.internal.scene.control.skin.agenda.icalendar.base24hour.Settings;
import jfxtras.scene.control.agenda.icalendar.editors.ChangeDialogOption;

public class ComponentChangeDialog
extends Dialog<ChangeDialogOption> {
    ComboBox<ChangeDialogOption> comboBox = new ComboBox();

    public ComponentChangeDialog(Map<ChangeDialogOption, Pair<Temporal, Temporal>> choiceMap, ResourceBundle resources) {
        Settings.REPEAT_CHANGE_CHOICES.get((Object)this);
        ChangeDialogOption initialSelection = choiceMap.entrySet().iterator().next().getKey();
        this.getDialogPane().getStyleClass().add((Object)"choice-dialog");
        this.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
        this.getDialogPane().lookupButton(ButtonType.OK).setId("changeDialogOkButton");
        this.getDialogPane().lookupButton(ButtonType.CANCEL).setId("changeDialogCancelButton");
        Label label = new Label();
        this.setContentText(resources.getString("dialog.content"));
        label.textProperty().bind((ObservableValue)this.getDialogPane().contentTextProperty());
        this.comboBox.setId("changeDialogComboBox");
        this.comboBox.getItems().addAll(choiceMap.keySet());
        this.comboBox.getSelectionModel().select((Object)initialSelection);
        this.comboBox.setConverter((StringConverter)new StringConverter<ChangeDialogOption>(){

            public String toString(ChangeDialogOption selection) {
                return Settings.REPEAT_CHANGE_CHOICES.get((Object)selection);
            }

            public ChangeDialogOption fromString(String string) {
                throw new RuntimeException("not required for non editable ComboBox");
            }
        });
        GridPane grid = new GridPane();
        grid.setHgap(10.0);
        grid.add(this.comboBox, 1, 0);
        grid.add((Node)label, 0, 0);
        this.getDialogPane().setContent((Node)grid);
        String range = AgendaDateTimeUtilities.formatRange(choiceMap.get((Object)initialSelection));
        this.setHeaderText(Settings.REPEAT_CHANGE_CHOICES.get((Object)initialSelection) + ":" + System.lineSeparator() + range);
        this.comboBox.getSelectionModel().selectedItemProperty().addListener((obs, oldSelection, newSelection) -> {
            String range2 = AgendaDateTimeUtilities.formatRange((Pair<Temporal, Temporal>)((Pair)choiceMap.get(newSelection)));
            this.setHeaderText(Settings.REPEAT_CHANGE_CHOICES.get(newSelection) + ":" + System.lineSeparator() + range2);
        });
        this.setResultConverter(dialogButton -> {
            ButtonBar.ButtonData data = dialogButton == null ? null : dialogButton.getButtonData();
            return data == ButtonBar.ButtonData.OK_DONE ? (ChangeDialogOption)((Object)((Object)this.comboBox.getSelectionModel().getSelectedItem())) : null;
        });
    }
}

