/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.internal.scene.control.skin.agenda.icalendar.base24hour.popup;

import java.time.DateTimeException;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.util.List;
import java.util.Locale;
import javafx.beans.value.ChangeListener;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.util.Callback;
import jfxtras.icalendarfx.components.VLocatable;
import jfxtras.icalendarfx.components.VPrimary;
import jfxtras.internal.scene.control.skin.agenda.icalendar.base24hour.popup.EditDescriptiveVBox;
import jfxtras.scene.control.LocalDateTextField;
import jfxtras.scene.control.LocalDateTimeTextField;
import jfxtras.scene.control.agenda.TemporalUtilities;

public abstract class EditDescriptiveLocatableVBox<T extends VLocatable<T>>
extends EditDescriptiveVBox<T> {
    private static final Duration DEFAULT_DURATION = Duration.ofHours(1L);
    protected LocalDateTimeTextField endDateTimeTextField = new LocalDateTimeTextField();
    protected LocalDateTextField endDateTextField = new LocalDateTextField();
    private final ChangeListener<? super LocalDate> endDateTextListener = (observable, oldValue, newValue) -> this.synchEndDate((LocalDate)oldValue, (LocalDate)newValue);
    private final ChangeListener<? super LocalDateTime> endDateTimeTextListener = (observable, oldValue, newValue) -> this.synchEndDateTime((LocalDateTime)oldValue, (LocalDateTime)newValue);
    Temporal endNewRecurrence;

    public EditDescriptiveLocatableVBox() {
        this.endDateTimeTextField.setId("endDateTimeTextField");
        this.endDateTextField.setId("endDateTextField");
    }

    @Override
    void synchStartDateTime(LocalDateTime oldValue, LocalDateTime newValue) {
        super.synchStartDateTime(oldValue, newValue);
        LocalDateTime end = this.endDateTimeTextField.getLocalDateTime();
        if (oldValue != null && end != null) {
            Duration duration = Duration.between(oldValue, end);
            this.endDateTimeTextField.setLocalDateTime(newValue.plus(duration));
        }
    }

    @Override
    void synchStartDate(LocalDate oldValue, LocalDate newValue) {
        super.synchStartDate(oldValue, newValue);
        LocalDate end = this.endDateTextField.getLocalDate();
        if (oldValue != null && end != null) {
            Period duration = Period.between(oldValue, end);
            this.endDateTextField.setLocalDate(newValue.plus(duration));
        }
    }

    void synchEndDate(LocalDate oldValue, LocalDate newValue) {
        this.endNewRecurrence = newValue;
        this.endDateTimeTextField.localDateTimeProperty().removeListener(this.endDateTimeTextListener);
        LocalDateTime newDateTime = this.endDateTimeTextField.getLocalDateTime().with(newValue.minusDays(1L));
        this.endDateTimeTextField.setLocalDateTime(newDateTime);
        this.endDateTimeTextField.localDateTimeProperty().addListener(this.endDateTimeTextListener);
    }

    void synchEndDateTime(LocalDateTime oldValue, LocalDateTime newValue) {
        this.endNewRecurrence = this.startOriginalRecurrence.isSupported(ChronoUnit.NANOS) ? this.startOriginalRecurrence.with(newValue) : ZonedDateTime.of(newValue, ZoneId.systemDefault());
        this.endDateTextField.localDateProperty().removeListener(this.endDateTextListener);
        LocalDate newDate = LocalDate.from(this.endDateTimeTextField.getLocalDateTime()).plusDays(1L);
        this.endDateTextField.setLocalDate(newDate);
        this.endDateTextField.localDateProperty().addListener(this.endDateTextListener);
    }

    @Override
    public void setupData(T vComponent, Temporal startRecurrence, Temporal endRecurrence, List<String> categories) {
        LocalDate end2;
        LocalDateTime end1;
        String initialDescription = ((VLocatable)vComponent).getDescription() == null || ((VLocatable)vComponent).getDescription().getValue() == null ? "" : (String)((VLocatable)vComponent).getDescription().getValue();
        this.descriptionTextArea.setText(initialDescription);
        this.descriptionTextArea.textProperty().addListener((obs, oldValue, newValue) -> vComponent.setDescription((String)newValue));
        String initialLocation = ((VLocatable)vComponent).getLocation() == null || ((VLocatable)vComponent).getLocation().getValue() == null ? "" : (String)((VLocatable)vComponent).getLocation().getValue();
        this.locationTextField.setText(initialLocation);
        this.locationTextField.textProperty().addListener((obs, oldValue, newValue) -> vComponent.setLocation((String)newValue));
        this.endDateTimeTextField.setLocale(Locale.getDefault());
        this.endDateTextField.setLocale(Locale.getDefault());
        this.endDateTimeTextField.setParseErrorCallback((Callback<Throwable, Void>)this.errorCallback);
        this.endDateTextField.setParseErrorCallback((Callback<Throwable, Void>)this.errorCallback);
        if (((VPrimary)vComponent).isWholeDay()) {
            end1 = LocalDate.from(endRecurrence).minusDays(1L).atTime(DEFAULT_START_TIME).plus(DEFAULT_DURATION);
            end2 = LocalDate.from(endRecurrence);
        } else {
            end1 = TemporalUtilities.toLocalDateTime(endRecurrence);
            end2 = LocalDate.from(endRecurrence).plusDays(1L);
        }
        this.endDateTimeTextField.setLocalDateTime(end1);
        this.endDateTextField.setLocalDate(end2);
        this.endDateTimeTextField.localDateTimeProperty().addListener(this.endDateTimeTextListener);
        this.endDateTextField.localDateProperty().addListener(this.endDateTextListener);
        this.endDateTimeTextField.localDateTimeProperty().addListener((observable, oldSelection, newSelection) -> {
            if (this.startDateTimeTextField.getLocalDateTime() != null && newSelection.isBefore(this.startDateTimeTextField.getLocalDateTime())) {
                this.tooEarlyDateAlert((Temporal)newSelection, this.startDateTimeTextField.getLocalDateTime());
                this.endDateTimeTextField.setLocalDateTime((LocalDateTime)oldSelection);
            }
        });
        this.endDateTextField.localDateProperty().addListener((observable, oldSelection, newSelection) -> {
            if (this.startDateTextField.getLocalDate() != null && newSelection.minusDays(1L).isBefore(this.startDateTextField.getLocalDate())) {
                this.tooEarlyDateAlert((Temporal)newSelection, this.startDateTextField.getLocalDate());
                this.endDateTextField.setLocalDate((LocalDate)oldSelection);
            }
        });
        super.setupData(vComponent, startRecurrence, endRecurrence, categories);
    }

    private void tooEarlyDateAlert(Temporal t1, Temporal t2) {
        Alert alert = new Alert(Alert.AlertType.ERROR);
        alert.setTitle("Invalid Date Selection");
        alert.setHeaderText("End must be after start");
        alert.setContentText(t1 + " is not after" + System.lineSeparator() + t2);
        ButtonType buttonTypeOk = new ButtonType("OK", ButtonBar.ButtonData.CANCEL_CLOSE);
        alert.getButtonTypes().setAll((Object[])new ButtonType[]{buttonTypeOk});
        alert.showAndWait();
    }

    @Override
    void handleWholeDayChange(T vComponent, Boolean newSelection) {
        this.endDateTimeTextField.localDateTimeProperty().removeListener(this.endDateTimeTextListener);
        this.endDateTextField.localDateProperty().removeListener(this.endDateTextListener);
        super.handleWholeDayChange(vComponent, newSelection);
        if (newSelection.booleanValue()) {
            this.timeGridPane.getChildren().remove((Object)this.endDateTimeTextField);
            this.timeGridPane.add((Node)this.endDateTextField, 1, 1);
            this.endNewRecurrence = this.endDateTextField.getLocalDate();
        } else {
            this.timeGridPane.getChildren().remove((Object)this.endDateTextField);
            this.timeGridPane.add((Node)this.endDateTimeTextField, 1, 1);
            if (this.startOriginalRecurrence instanceof LocalDate) {
                this.endNewRecurrence = this.endDateTimeTextField.getLocalDateTime().atZone(DEFAULT_ZONE_ID);
            } else if (this.startOriginalRecurrence instanceof LocalDateTime) {
                this.endNewRecurrence = this.endDateTimeTextField.getLocalDateTime();
            } else if (this.startOriginalRecurrence instanceof ZonedDateTime) {
                ZoneId originalZoneId = ((ZonedDateTime)this.startOriginalRecurrence).getZone();
                this.endNewRecurrence = this.endDateTimeTextField.getLocalDateTime().atZone(originalZoneId);
            } else {
                throw new DateTimeException("Unsupported Temporal type:" + this.startOriginalRecurrence.getClass());
            }
        }
        this.endDateTextField.localDateProperty().addListener(this.endDateTextListener);
        this.endDateTimeTextField.localDateTimeProperty().addListener(this.endDateTimeTextListener);
    }
}

