/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.internal.scene.control.skin.agenda.icalendar.base24hour.popup;

import java.io.IOException;
import java.net.URL;
import java.time.temporal.Temporal;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.Tooltip;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;
import jfxtras.icalendarfx.VCalendar;
import jfxtras.icalendarfx.components.VComponent;
import jfxtras.icalendarfx.components.VDisplayable;
import jfxtras.icalendarfx.properties.component.descriptive.Summary;
import jfxtras.icalendarfx.properties.component.recurrence.rrule.FrequencyType;
import jfxtras.icalendarfx.properties.component.recurrence.rrule.Interval;
import jfxtras.icalendarfx.properties.component.recurrence.rrule.RecurrenceRuleValue;
import jfxtras.internal.scene.control.skin.agenda.icalendar.base24hour.DeleteChoiceDialog;
import jfxtras.internal.scene.control.skin.agenda.icalendar.base24hour.Settings;
import jfxtras.internal.scene.control.skin.agenda.icalendar.base24hour.popup.EditDescriptiveVBox;
import jfxtras.internal.scene.control.skin.agenda.icalendar.base24hour.popup.EditRecurrenceRuleVBox;
import jfxtras.scene.control.agenda.icalendar.editors.deleters.SimpleDeleterFactory;

public abstract class EditDisplayableTabPane<T extends VDisplayable<T>, U extends EditDescriptiveVBox<T>>
extends TabPane {
    U editDescriptiveVBox;
    EditRecurrenceRuleVBox<T> recurrenceRuleVBox;
    @FXML
    private ResourceBundle resources;
    @FXML
    AnchorPane descriptiveAnchorPane;
    @FXML
    AnchorPane recurrenceRuleAnchorPane;
    @FXML
    private TabPane editDisplayableTabPane;
    @FXML
    private Tab descriptiveTab;
    @FXML
    private Tab recurrenceRuleTab;
    @FXML
    private Button cancelComponentButton;
    @FXML
    private Button saveComponentButton;
    @FXML
    private Button deleteComponentButton;
    @FXML
    private Button cancelRepeatButton;
    @FXML
    private Button saveRepeatButton;
    ObjectProperty<List<VCalendar>> iTIPMessages = new SimpleObjectProperty();
    T vComponentCopy;
    T vComponentOriginal;
    public static VComponent vo;

    public ObjectProperty<List<VCalendar>> iTIPMessagesProperty() {
        return this.iTIPMessages;
    }

    public EditDisplayableTabPane() {
        EditDisplayableTabPane.loadFxml(EditDescriptiveVBox.class.getResource("EditDisplayable.fxml"), (Object)this);
    }

    @FXML
    void handleSaveButton() {
        this.removeEmptyProperties();
    }

    void removeEmptyProperties() {
        if (((VDisplayable)this.vComponentCopy).getRecurrenceRule() != null) {
            if (this.recurrenceRuleVBox.frequencyComboBox.getValue() == FrequencyType.WEEKLY && this.recurrenceRuleVBox.dayOfWeekList.isEmpty()) {
                EditDisplayableTabPane.canNotHaveZeroDaysOfWeek();
            } else if (!((VDisplayable)this.vComponentCopy).getRecurrenceRule().isValid()) {
                throw new RuntimeException("Unhandled component error" + System.lineSeparator() + ((VDisplayable)this.vComponentCopy).errors());
            }
        }
        if (((EditDescriptiveVBox)((Object)this.editDescriptiveVBox)).summaryTextField.getText().isEmpty()) {
            ((VDisplayable)this.vComponentCopy).setSummary((Summary)null);
        }
        if (((EditDescriptiveVBox)((Object)this.editDescriptiveVBox)).categoryTextField.getText().isEmpty()) {
            ((VDisplayable)this.vComponentCopy).setCategories(null);
        }
        if (((VDisplayable)this.vComponentCopy).getRecurrenceRule() != null && (Integer)this.recurrenceRuleVBox.intervalSpinner.getValue() == 1) {
            ((RecurrenceRuleValue)((VDisplayable)this.vComponentCopy).getRecurrenceRule().getValue()).setInterval((Interval)null);
        }
    }

    @FXML
    private void handleCancelButton() {
        this.iTIPMessagesProperty().set(Collections.emptyList());
    }

    @FXML
    private void handleDeleteButton() {
        this.removeEmptyProperties();
        Object[] params = new Object[]{DeleteChoiceDialog.DELETE_DIALOG_CALLBACK, ((EditDescriptiveVBox)((Object)this.editDescriptiveVBox)).startOriginalRecurrence};
        List<VCalendar> result = SimpleDeleterFactory.newDeleter(this.vComponentCopy, params).delete();
        this.iTIPMessagesProperty().set(result);
    }

    @FXML
    private void handlePressEnter(KeyEvent e) {
        if (e.getCode().equals((Object)KeyCode.ENTER)) {
            this.handleSaveButton();
        }
    }

    public void setupData(T vComponentCopy, Temporal startRecurrence, Temporal endRecurrence, List<String> categories) {
        this.vComponentCopy = vComponentCopy;
        vo = this.vComponentOriginal;
        ((EditDescriptiveVBox)((Object)this.editDescriptiveVBox)).setupData(vComponentCopy, startRecurrence, endRecurrence, categories);
        if (((VDisplayable)vComponentCopy).getRecurrenceId() != null) {
            this.recurrenceRuleTab.setDisable(true);
            this.recurrenceRuleTab.setTooltip(new Tooltip(this.resources.getString("repeat.tab.unavailable")));
        }
        this.recurrenceRuleVBox.setupData(vComponentCopy, ((EditDescriptiveVBox)((Object)this.editDescriptiveVBox)).startRecurrenceProperty);
    }

    private static void canNotHaveZeroDaysOfWeek() {
        Alert alert = new Alert(Alert.AlertType.ERROR);
        alert.setTitle("Invalid Modification");
        alert.setHeaderText("Please select at least one day of the week.");
        alert.setContentText("Weekly repeat must have at least one selected day");
        ButtonType buttonTypeOk = new ButtonType("OK", ButtonBar.ButtonData.CANCEL_CLOSE);
        alert.getButtonTypes().setAll((Object[])new ButtonType[]{buttonTypeOk});
        alert.getDialogPane().setId("zero_day_of_week_alert");
        alert.getDialogPane().lookupButton(buttonTypeOk).setId("zero_day_of_week_alert_button_ok");
        alert.showAndWait();
    }

    protected static void loadFxml(URL fxmlFile, Object rootController) {
        FXMLLoader loader = new FXMLLoader(fxmlFile);
        loader.setController(rootController);
        loader.setRoot(rootController);
        loader.setResources(Settings.resources);
        try {
            loader.load();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

