/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.internal.scene.control.skin.agenda.icalendar.base24hour.popup;

import java.io.IOException;
import java.net.URL;
import java.time.DateTimeException;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoLocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAdjuster;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.beans.InvalidationListener;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.RadioButton;
import javafx.scene.control.ScrollBar;
import javafx.scene.control.Spinner;
import javafx.scene.control.SpinnerValueFactory;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.Tooltip;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.util.Callback;
import javafx.util.StringConverter;
import jfxtras.icalendarfx.components.VDisplayable;
import jfxtras.icalendarfx.components.VPrimary;
import jfxtras.icalendarfx.properties.component.recurrence.ExceptionDates;
import jfxtras.icalendarfx.properties.component.recurrence.rrule.FrequencyType;
import jfxtras.icalendarfx.properties.component.recurrence.rrule.Interval;
import jfxtras.icalendarfx.properties.component.recurrence.rrule.RecurrenceRuleValue;
import jfxtras.icalendarfx.properties.component.recurrence.rrule.Until;
import jfxtras.icalendarfx.properties.component.recurrence.rrule.byxxx.ByDay;
import jfxtras.icalendarfx.properties.component.recurrence.rrule.byxxx.ByRule;
import jfxtras.icalendarfx.utilities.DateTimeUtilities;
import jfxtras.internal.scene.control.skin.agenda.icalendar.base24hour.Settings;
import jfxtras.internal.scene.control.skin.agenda.icalendar.base24hour.popup.EditDescriptiveVBox;

public abstract class EditRecurrenceRuleVBox<T extends VDisplayable<T>>
extends VBox {
    public static final int EXCEPTION_CHOICE_LIMIT = 50;
    public static final int INITIAL_COUNT = 10;
    public static final Period DEFAULT_UNTIL_PERIOD = Period.ofMonths(1);
    T vComponent;
    private RecurrenceRuleValue rrule;
    private RecurrenceRuleValue oldRRule;
    private ObjectProperty<RecurrenceRuleValue> recurrenceRuleProperty;
    private ObjectProperty<Temporal> dateTimeStartRecurrenceNew;
    protected ObjectProperty<Temporal> dateTimeStartProperty;
    @FXML
    private ResourceBundle resources;
    @FXML
    private CheckBox repeatableCheckBox;
    @FXML
    private GridPane repeatableGridPane;
    @FXML
    ComboBox<FrequencyType> frequencyComboBox;
    @FXML
    Spinner<Integer> intervalSpinner;
    @FXML
    private Label frequencyLabel;
    @FXML
    private Label eventLabel;
    @FXML
    private Label weeklyLabel;
    @FXML
    private HBox weeklyHBox;
    @FXML
    private CheckBox sundayCheckBox;
    @FXML
    private CheckBox mondayCheckBox;
    @FXML
    private CheckBox tuesdayCheckBox;
    @FXML
    private CheckBox wednesdayCheckBox;
    @FXML
    private CheckBox thursdayCheckBox;
    @FXML
    private CheckBox fridayCheckBox;
    @FXML
    private CheckBox saturdayCheckBox;
    private final Map<BooleanProperty, DayOfWeek> checkBoxDayOfWeekMap = new HashMap<BooleanProperty, DayOfWeek>();
    final ObservableList<DayOfWeek> dayOfWeekList = FXCollections.observableArrayList();
    private Map<DayOfWeek, BooleanProperty> dayOfWeekCheckBoxMap;
    @FXML
    private VBox monthlyVBox;
    @FXML
    private Label monthlyLabel;
    private ToggleGroup monthlyGroup;
    @FXML
    private RadioButton dayOfMonthRadioButton;
    @FXML
    private RadioButton dayOfWeekRadioButton;
    @FXML
    DatePicker startDatePicker;
    @FXML
    private RadioButton endNeverRadioButton;
    @FXML
    private RadioButton endAfterRadioButton;
    @FXML
    private RadioButton untilRadioButton;
    @FXML
    private Spinner<Integer> endAfterEventsSpinner;
    @FXML
    private DatePicker untilDatePicker;
    private ToggleGroup endGroup;
    @FXML
    private Label repeatSummaryLabel;
    @FXML
    private ComboBox<Temporal> exceptionComboBox;
    @FXML
    private Button addExceptionButton;
    @FXML
    private ListView<Temporal> exceptionsListView;
    @FXML
    private Button removeExceptionButton;
    private List<Temporal> exceptionMasterList = new ArrayList<Temporal>();
    private final ChangeListener<? super Boolean> dayOfWeekCheckBoxListener = (obs, oldSel, newSel) -> {
        DayOfWeek dayOfWeek = this.checkBoxDayOfWeekMap.get(obs);
        ByDay rule = (ByDay)((RecurrenceRuleValue)((VDisplayable)this.vComponent).getRecurrenceRule().getValue()).lookupByRule(ByDay.class);
        if (newSel.booleanValue()) {
            if (!this.dayOfWeekList.contains((Object)dayOfWeek)) {
                rule.addDayOfWeek(dayOfWeek);
                this.dayOfWeekList.add((Object)dayOfWeek);
            }
        } else {
            rule.removeDayOfWeek(dayOfWeek);
            this.dayOfWeekList.remove((Object)dayOfWeek);
        }
    };
    private ChangeListener<? super Boolean> dayOfWeekButtonListener = (observable, oldSelection, newSelection) -> {
        if (newSelection.booleanValue()) {
            int ordinalWeekNumber = DateTimeUtilities.weekOrdinalInMonth((Temporal)this.dateTimeStartRecurrenceNew.get());
            DayOfWeek dayOfWeek = DayOfWeek.from((TemporalAccessor)this.dateTimeStartRecurrenceNew.get());
            ByDay byDayRuleMonthly = new ByDay(new ByDay.ByDayPair(dayOfWeek, ordinalWeekNumber));
            this.rrule.addChild(byDayRuleMonthly);
        } else {
            ByRule<?> r = this.rrule.lookupByRule(ByDay.class);
            this.rrule.removeChild(r);
        }
        this.refreshSummary();
        this.refreshExceptionDates();
    };
    private final InvalidationListener makeExceptionDatesAndSummaryListener = obs -> {
        this.refreshSummary();
        this.refreshExceptionDates();
    };
    private final ChangeListener<? super Boolean> neverListener = (obs, oldValue, newValue) -> {
        if (newValue.booleanValue()) {
            this.refreshSummary();
            this.refreshExceptionDates();
        }
    };
    private final ChangeListener<? super Temporal> weeklyRecurrenceListener = (obs, oldValue, newValue) -> {
        DayOfWeek oldDayOfWeek = DayOfWeek.from(oldValue);
        DayOfWeek newDayOfWeek = DayOfWeek.from(newValue);
        if (!this.dayOfWeekCheckBoxMap.get(newDayOfWeek).get()) {
            this.dayOfWeekCheckBoxMap.get(oldDayOfWeek).set(false);
            this.dayOfWeekCheckBoxMap.get(newDayOfWeek).set(true);
        }
    };
    private final ChangeListener<? super FrequencyType> frequencyListener = (obs, oldValue, newValue) -> {
        ByRule<?> r;
        this.rrule.setFrequency((FrequencyType)((Object)newValue));
        if (this.rrule.getFrequency().getValue() != newValue) {
            this.exceptionsListView.getItems().clear();
            ((VDisplayable)this.vComponent).setExceptionDates(null);
        }
        if (oldValue == FrequencyType.WEEKLY) {
            this.dateTimeStartRecurrenceNew.removeListener(this.weeklyRecurrenceListener);
        }
        if (this.rrule.getByRules() != null && (r = this.rrule.lookupByRule(ByDay.class)) != null) {
            this.rrule.removeChild(r);
        }
        switch (newValue) {
            case DAILY: 
            case YEARLY: {
                break;
            }
            case MONTHLY: {
                this.dayOfMonthRadioButton.setSelected(true);
                this.dayOfWeekRadioButton.setSelected(false);
                break;
            }
            case WEEKLY: {
                this.dateTimeStartRecurrenceNew.addListener(this.weeklyRecurrenceListener);
                if (this.dayOfWeekList.isEmpty()) {
                    DayOfWeek dayOfWeek = LocalDate.from((TemporalAccessor)this.dateTimeStartRecurrenceNew.get()).getDayOfWeek();
                    this.rrule.addChild(new ByDay(dayOfWeek));
                    this.dayOfWeekCheckBoxMap.get(dayOfWeek).set(true);
                    break;
                }
                this.rrule.addChild(new ByDay((Collection<DayOfWeek>)this.dayOfWeekList));
                break;
            }
            case SECONDLY: 
            case MINUTELY: 
            case HOURLY: {
                throw new IllegalArgumentException("Frequency " + newValue + " not implemented");
            }
        }
        this.setFrequencyVisibility((FrequencyType)((Object)newValue));
        if (this.intervalSpinner.getValueFactory() != null) {
            this.setIntervalText((Integer)this.intervalSpinner.getValue());
        }
        this.refreshSummary();
        this.refreshExceptionDates();
    };
    private final ChangeListener<? super Integer> intervalSpinnerListener = (observable, oldValue, newValue) -> {
        if (newValue == 1) {
            this.rrule.setInterval((Interval)null);
        } else {
            this.rrule.setInterval((Integer)newValue);
        }
        this.setIntervalText((int)newValue);
        this.refreshSummary();
        this.refreshExceptionDates();
    };
    private final ChangeListener<? super LocalDate> untilListener = (observable, oldSelection, newSelection) -> {
        if (newSelection != null) {
            LocalDate dtstartZDate = LocalDate.from(DateTimeUtilities.DateTimeType.DATE_WITH_UTC_TIME.from((Temporal)((VPrimary)this.vComponent).getDateTimeStart().getValue()));
            if (newSelection.isBefore(dtstartZDate)) {
                EditRecurrenceRuleVBox.tooEarlyDateAlert((Temporal)((VPrimary)this.vComponent).getDateTimeStart().getValue());
                this.untilDatePicker.setValue(oldSelection);
            } else {
                Temporal until = this.findUntil((LocalDate)newSelection);
                LocalDate newSelectionZDate = LocalDate.from(DateTimeUtilities.DateTimeType.DATE_WITH_UTC_TIME.from(((Temporal)((VPrimary)this.vComponent).getDateTimeStart().getValue()).with((TemporalAdjuster)newSelection)));
                if (LocalDate.from(until).equals(newSelectionZDate)) {
                    this.rrule.setUntil(until);
                    this.refreshSummary();
                    this.refreshExceptionDates();
                } else {
                    EditRecurrenceRuleVBox.notOccurrenceDateAlert(newSelection);
                    this.untilDatePicker.setValue(oldSelection);
                }
            }
        }
    };
    private final ChangeListener<? super Boolean> untilRadioButtonListener = (observable, oldSelection, newSelection) -> {
        if (newSelection.booleanValue()) {
            if (this.rrule.getUntil() == null) {
                boolean isRecurrenceFarEnoughInFuture = DateTimeUtilities.isAfter((Temporal)this.dateTimeStartRecurrenceNew.get(), ((Temporal)((VPrimary)this.vComponent).getDateTimeStart().getValue()).plus(DEFAULT_UNTIL_PERIOD));
                LocalDate defaultEndOnDateTime = isRecurrenceFarEnoughInFuture ? LocalDate.from((TemporalAccessor)this.dateTimeStartRecurrenceNew.get()) : LocalDate.from(((Temporal)((VPrimary)this.vComponent).getDateTimeStart().getValue()).plus(DEFAULT_UNTIL_PERIOD));
                Temporal until = this.findUntil(defaultEndOnDateTime);
                this.rrule.setUntil(until);
            }
            this.untilDatePicker.setValue((Object)LocalDate.from((TemporalAccessor)this.rrule.getUntil().getValue()));
            this.untilDatePicker.setDisable(false);
            this.untilDatePicker.show();
            this.refreshExceptionDates();
        } else {
            this.untilDatePicker.setValue(null);
            this.rrule.setUntil((Until)null);
            this.untilDatePicker.setDisable(true);
        }
    };
    private final ChangeListener<? super Temporal> dateTimeStartToExceptionChangeListener = (obs, oldValue, newValue) -> {
        System.out.println("exception listener");
        this.exceptionMasterList.clear();
        this.refreshExceptionDates();
        if (!this.exceptionsListView.getItems().isEmpty()) {
            List newItems = null;
            if (newValue.isSupported(ChronoUnit.SECONDS)) {
                LocalTime time = LocalDateTime.from(newValue).toLocalTime();
                newItems = this.exceptionsListView.getItems().stream().map(d -> LocalDate.from(d).atTime(time)).collect(Collectors.toList());
            } else if (newValue.isSupported(ChronoUnit.DAYS)) {
                newItems = this.exceptionsListView.getItems().stream().map(d -> LocalDate.from(d)).collect(Collectors.toList());
            } else {
                throw new DateTimeException("Unsupported Temporal class:" + newValue.getClass());
            }
            this.exceptionsListView.setItems(FXCollections.observableArrayList(newItems));
        }
    };

    public EditRecurrenceRuleVBox() {
        EditRecurrenceRuleVBox.loadFxml(EditDescriptiveVBox.class.getResource("RecurrenceRule.fxml"), (Object)this);
    }

    private DateTimeFormatter getFormatter(Temporal t) {
        return t.isSupported(ChronoUnit.NANOS) ? Settings.DATE_FORMAT_AGENDA_EXCEPTION : Settings.DATE_FORMAT_AGENDA_EXCEPTION_DATEONLY;
    }

    private void refreshSummary() {
        String summaryString = EditRecurrenceRuleVBox.makeSummary(this.rrule, (Temporal)((VPrimary)this.vComponent).getDateTimeStart().getValue());
        this.repeatSummaryLabel.setText(summaryString);
    }

    private void setIntervalText(int value) {
        String frequencyLabelText = value == 1 ? Settings.REPEAT_FREQUENCIES_SINGULAR.get(this.frequencyComboBox.getValue()) : Settings.REPEAT_FREQUENCIES_PLURAL.get(this.frequencyComboBox.getValue());
        this.frequencyLabel.setText(frequencyLabelText);
    }

    private void setFrequencyVisibility(FrequencyType f) {
        switch (f) {
            case DAILY: 
            case YEARLY: {
                this.monthlyVBox.setVisible(false);
                this.monthlyLabel.setVisible(false);
                this.weeklyHBox.setVisible(false);
                this.weeklyLabel.setVisible(false);
                break;
            }
            case MONTHLY: {
                this.monthlyVBox.setVisible(true);
                this.monthlyLabel.setVisible(true);
                this.weeklyHBox.setVisible(false);
                this.weeklyLabel.setVisible(false);
                break;
            }
            case WEEKLY: {
                this.monthlyVBox.setVisible(false);
                this.monthlyLabel.setVisible(false);
                this.weeklyHBox.setVisible(true);
                this.weeklyLabel.setVisible(true);
                break;
            }
            case SECONDLY: 
            case MINUTELY: 
            case HOURLY: {
                throw new IllegalArgumentException("Frequency " + f + " not implemented");
            }
        }
    }

    private Temporal findUntil(LocalDate initialUntilDate) {
        Temporal temporal;
        Temporal timeAdjustedSelection = ((Temporal)((VPrimary)this.vComponent).getDateTimeStart().getValue()).with(initialUntilDate);
        RecurrenceRuleValue rruleCopy = new RecurrenceRuleValue(this.rrule);
        rruleCopy.setUntil((Until)null);
        Iterator i = rruleCopy.streamRecurrences((Temporal)((VPrimary)this.vComponent).getDateTimeStart().getValue()).iterator();
        Temporal until = (Temporal)i.next();
        while (i.hasNext() && !DateTimeUtilities.isAfter(temporal = (Temporal)i.next(), timeAdjustedSelection)) {
            until = temporal;
        }
        return until instanceof LocalDate ? until : DateTimeUtilities.DateTimeType.DATE_WITH_UTC_TIME.from(until);
    }

    void synchStartDatePickerAndComponent(LocalDate oldValue, LocalDate newValue) {
        boolean isValid;
        if (this.rrule.getFrequency().getValue() == FrequencyType.WEEKLY) {
            DayOfWeek dayOfWeek = DayOfWeek.from(newValue);
            ByDay byDay = (ByDay)this.rrule.lookupByRule(ByDay.class);
            isValid = byDay.dayOfWeekWithoutOrdinalList().contains(dayOfWeek);
        } else {
            isValid = true;
        }
        if (isValid) {
            Period shift = Period.between(oldValue, newValue);
            Temporal newStart = ((Temporal)((VPrimary)this.vComponent).getDateTimeStart().getValue()).plus(shift);
            ((VPrimary)this.vComponent).setDateTimeStart(newStart);
        } else {
            EditRecurrenceRuleVBox.notOccurrenceDateAlert(newValue);
        }
    }

    @FXML
    public void initialize() {
        this.repeatableCheckBox.selectedProperty().addListener((observable, oldSelection, newSelection) -> {
            if (newSelection.booleanValue()) {
                if (this.rrule == null) {
                    if (this.oldRRule != null) {
                        this.rrule = this.oldRRule;
                        this.vComponent.setRecurrenceRule(this.rrule);
                    } else {
                        this.rrule = new RecurrenceRuleValue().withFrequency(FrequencyType.WEEKLY).withByRules(new ByDay(DayOfWeek.from((TemporalAccessor)this.dateTimeStartRecurrenceNew.get())));
                        this.vComponent.setRecurrenceRule(this.rrule);
                        this.setInitialValues((VDisplayable<?>)this.vComponent);
                    }
                }
                this.repeatableGridPane.setDisable(false);
                this.startDatePicker.setDisable(false);
            } else {
                this.oldRRule = this.rrule;
                this.rrule = null;
                this.vComponent.setRecurrenceRule(this.rrule);
                this.repeatableGridPane.setDisable(true);
                this.startDatePicker.setDisable(true);
            }
        });
        this.checkBoxDayOfWeekMap.put(this.sundayCheckBox.selectedProperty(), DayOfWeek.SUNDAY);
        this.checkBoxDayOfWeekMap.put(this.mondayCheckBox.selectedProperty(), DayOfWeek.MONDAY);
        this.checkBoxDayOfWeekMap.put(this.tuesdayCheckBox.selectedProperty(), DayOfWeek.TUESDAY);
        this.checkBoxDayOfWeekMap.put(this.wednesdayCheckBox.selectedProperty(), DayOfWeek.WEDNESDAY);
        this.checkBoxDayOfWeekMap.put(this.thursdayCheckBox.selectedProperty(), DayOfWeek.THURSDAY);
        this.checkBoxDayOfWeekMap.put(this.fridayCheckBox.selectedProperty(), DayOfWeek.FRIDAY);
        this.checkBoxDayOfWeekMap.put(this.saturdayCheckBox.selectedProperty(), DayOfWeek.SATURDAY);
        this.dayOfWeekCheckBoxMap = this.checkBoxDayOfWeekMap.entrySet().stream().collect(Collectors.toMap(e -> (DayOfWeek)e.getValue(), e -> (BooleanProperty)e.getKey()));
        this.checkBoxDayOfWeekMap.entrySet().stream().forEach(entry -> ((BooleanProperty)entry.getKey()).addListener(this.dayOfWeekCheckBoxListener));
        FrequencyType[] supportedFrequencyProperties = new FrequencyType[]{FrequencyType.DAILY, FrequencyType.WEEKLY, FrequencyType.MONTHLY, FrequencyType.YEARLY};
        this.frequencyComboBox.setItems(FXCollections.observableArrayList((Object[])supportedFrequencyProperties));
        this.frequencyComboBox.setConverter((StringConverter)new StringConverter<FrequencyType>(){

            public String toString(FrequencyType frequencyType) {
                return Settings.REPEAT_FREQUENCIES.get((Object)frequencyType);
            }

            public FrequencyType fromString(String string) {
                throw new RuntimeException("not required for non editable ComboBox");
            }
        });
        this.intervalSpinner.setEditable(true);
        this.intervalSpinner.getEditor().addEventHandler(KeyEvent.KEY_PRESSED, event -> {
            String s;
            boolean isNumber;
            if (event.getCode() == KeyCode.ENTER && !(isNumber = (s = (String)this.intervalSpinner.getEditor().textProperty().get()).matches("[0-9]+"))) {
                String lastValue = ((Integer)this.intervalSpinner.getValue()).toString();
                this.intervalSpinner.getEditor().textProperty().set((Object)lastValue);
                EditRecurrenceRuleVBox.notNumberAlert();
            }
        });
        this.intervalSpinner.focusedProperty().addListener((obs, wasFocused, isNowFocused) -> {
            if (!isNowFocused.booleanValue()) {
                String s = (String)this.intervalSpinner.getEditor().textProperty().get();
                boolean isNumber = s.matches("[0-9]+");
                if (isNumber) {
                    int value = Integer.parseInt(s);
                    if (value > 1) {
                        this.rrule.setInterval(value);
                        this.refreshSummary();
                        this.refreshExceptionDates();
                    }
                } else {
                    String lastValue = ((Integer)this.intervalSpinner.getValue()).toString();
                    this.intervalSpinner.getEditor().textProperty().set((Object)lastValue);
                    EditRecurrenceRuleVBox.notNumberAlert();
                }
            }
        });
        this.startDatePicker.valueProperty().addListener((obs, oldValue, newValue) -> {
            if (oldValue != null) {
                this.synchStartDatePickerAndComponent((LocalDate)oldValue, (LocalDate)newValue);
            }
        });
        this.startDatePicker.focusedProperty().addListener((obs, wasFocused, isNowFocused) -> {
            if (!isNowFocused.booleanValue()) {
                try {
                    String s = this.startDatePicker.getEditor().getText();
                    LocalDate d = (LocalDate)this.startDatePicker.getConverter().fromString(s);
                    this.startDatePicker.setValue((Object)d);
                }
                catch (DateTimeParseException e) {
                    String exampleDate = this.startDatePicker.getConverter().toString((Object)LocalDate.now());
                    EditRecurrenceRuleVBox.notDateAlert(exampleDate);
                    LocalDate d = (LocalDate)this.startDatePicker.getValue();
                    String s = this.startDatePicker.getConverter().toString((Object)d);
                    this.startDatePicker.getEditor().setText(s);
                }
            }
        });
        this.endAfterEventsSpinner.valueProperty().addListener((observable, oldSelection, newSelection) -> {
            if (this.endAfterRadioButton.isSelected()) {
                this.rrule.setCount((int)newSelection);
                this.refreshSummary();
                this.refreshExceptionDates();
            }
            if (newSelection == 1) {
                this.eventLabel.setText(this.resources.getString("event"));
            } else {
                this.eventLabel.setText(this.resources.getString("events"));
            }
        });
        this.endAfterRadioButton.selectedProperty().addListener((observable, oldSelection, newSelection) -> {
            if (newSelection.booleanValue()) {
                this.endAfterEventsSpinner.setDisable(false);
                this.eventLabel.setDisable(false);
                this.rrule.setCount((Integer)this.endAfterEventsSpinner.getValue());
                this.refreshSummary();
                this.refreshExceptionDates();
            } else {
                this.rrule.setCount(null);
                this.endAfterEventsSpinner.setValueFactory(null);
                this.endAfterEventsSpinner.setDisable(true);
                this.eventLabel.setDisable(true);
            }
        });
        this.endAfterEventsSpinner.setEditable(true);
        this.endAfterEventsSpinner.getEditor().addEventHandler(KeyEvent.KEY_PRESSED, event -> {
            String s;
            boolean isNumber;
            if (event.getCode() == KeyCode.ENTER && !(isNumber = (s = (String)this.endAfterEventsSpinner.getEditor().textProperty().get()).matches("[0-9]+"))) {
                String lastValue = ((Integer)this.endAfterEventsSpinner.getValue()).toString();
                this.endAfterEventsSpinner.getEditor().textProperty().set((Object)lastValue);
                EditRecurrenceRuleVBox.notNumberAlert();
            }
        });
        this.endAfterEventsSpinner.focusedProperty().addListener((obs, wasFocused, isNowFocused) -> {
            if (!isNowFocused.booleanValue()) {
                String s = this.endAfterEventsSpinner.getEditor().getText();
                boolean isNumber = s.matches("[0-9]+");
                if (isNumber) {
                    int value = Integer.parseInt(s);
                    this.rrule.setCount(value);
                } else {
                    String lastValue = ((Integer)this.endAfterEventsSpinner.getValue()).toString();
                    this.endAfterEventsSpinner.getEditor().textProperty().set((Object)lastValue);
                    EditRecurrenceRuleVBox.notNumberAlert();
                }
            }
        });
        this.untilDatePicker.valueProperty().addListener(this.untilListener);
        this.untilRadioButton.selectedProperty().addListener(this.untilRadioButtonListener);
        this.sundayCheckBox.setTooltip(new Tooltip(this.resources.getString("sunday")));
        this.mondayCheckBox.setTooltip(new Tooltip(this.resources.getString("monday")));
        this.tuesdayCheckBox.setTooltip(new Tooltip(this.resources.getString("tuesday")));
        this.wednesdayCheckBox.setTooltip(new Tooltip(this.resources.getString("wednesday")));
        this.thursdayCheckBox.setTooltip(new Tooltip(this.resources.getString("thursday")));
        this.fridayCheckBox.setTooltip(new Tooltip(this.resources.getString("friday")));
        this.saturdayCheckBox.setTooltip(new Tooltip(this.resources.getString("saturday")));
        this.monthlyGroup = new ToggleGroup();
        this.dayOfMonthRadioButton.setToggleGroup(this.monthlyGroup);
        this.dayOfWeekRadioButton.setToggleGroup(this.monthlyGroup);
        this.endGroup = new ToggleGroup();
        this.endNeverRadioButton.setToggleGroup(this.endGroup);
        this.endAfterRadioButton.setToggleGroup(this.endGroup);
        this.untilRadioButton.setToggleGroup(this.endGroup);
        ListChangeListener exceptionsListChangeListener = change -> {
            while (change.next()) {
                if (change.wasAdded()) {
                    boolean isTemporalTypeChanged;
                    List added1 = change.getAddedSubList();
                    List exceptionDates = ((VDisplayable)this.vComponent).getExceptionDates() == null ? Collections.emptyList() : ((VDisplayable)this.vComponent).getExceptionDates();
                    boolean isEmpty = exceptionDates.isEmpty();
                    DateTimeUtilities.DateTimeType startType = DateTimeUtilities.DateTimeType.of((Temporal)((VPrimary)this.vComponent).getDateTimeStart().getValue());
                    DateTimeUtilities.DateTimeType newType = DateTimeUtilities.DateTimeType.of((Temporal)added1.get(0));
                    boolean bl = isTemporalTypeChanged = startType != newType;
                    if (isEmpty || isTemporalTypeChanged) {
                        ObservableList list = change.getList();
                        Temporal[] allExceptions = list.toArray(new Temporal[list.size()]);
                        ExceptionDates ed = new ExceptionDates(allExceptions);
                        ((VDisplayable)this.vComponent).setExceptionDates(new ArrayList<ExceptionDates>(Arrays.asList(ed)));
                        continue;
                    }
                    ((Set)((VDisplayable)this.vComponent).getExceptionDates().get(0).getValue()).addAll(added1);
                    continue;
                }
                if (!change.wasRemoved()) continue;
                List removed = change.getRemoved();
                ((Set)((VDisplayable)this.vComponent).getExceptionDates().get(0).getValue()).removeAll(removed);
            }
        };
        this.exceptionsListView.getItems().addListener(exceptionsListChangeListener);
    }

    public void setupData(T vComponent, ObjectProperty<Temporal> dateTimeStartRecurrenceNew) {
        boolean isInitiallyRepeatable;
        this.dateTimeStartProperty = new SimpleObjectProperty((Object)((Temporal)((VPrimary)vComponent).getDateTimeStart().getValue()));
        this.rrule = ((VDisplayable)vComponent).getRecurrenceRule() != null ? (RecurrenceRuleValue)((VDisplayable)vComponent).getRecurrenceRule().getValue() : null;
        this.recurrenceRuleProperty = new SimpleObjectProperty((Object)this.rrule);
        this.vComponent = vComponent;
        this.dateTimeStartRecurrenceNew = dateTimeStartRecurrenceNew;
        if (!this.isSupported((VDisplayable<?>)vComponent)) {
            throw new RuntimeException("Unsupported VComponent");
        }
        dateTimeStartRecurrenceNew.addListener((obs, oldValue, newValue) -> {
            DateTimeUtilities.DateTimeType newType = DateTimeUtilities.DateTimeType.of(newValue);
            Object[] convertedExceptions = (Temporal[])this.exceptionsListView.getItems().stream().map(e -> {
                Temporal converted = newType.from((Temporal)e);
                if (converted.isSupported(ChronoUnit.NANOS)) {
                    converted = converted.with(LocalTime.from(newValue));
                }
                return converted;
            }).toArray(Temporal[]::new);
            this.exceptionsListView.getItems().clear();
            this.exceptionsListView.getItems().addAll(convertedExceptions);
            if (this.untilRadioButton.isSelected()) {
                Comparable<ChronoLocalDate> untilNew;
                Temporal untilOld = (Temporal)((RecurrenceRuleValue)vComponent.getRecurrenceRule().getValue()).getUntil().getValue();
                if (newValue instanceof ZonedDateTime) {
                    LocalTime localTime = ((ZonedDateTime)newValue).withZoneSameInstant(ZoneId.of("Z")).toLocalTime();
                    untilNew = LocalDate.from(untilOld).atTime(localTime).atZone(ZoneId.of("Z"));
                } else if (newValue instanceof LocalDateTime) {
                    LocalTime localTime = LocalTime.from(newValue);
                    untilNew = LocalDate.from(untilOld).atTime(localTime).atZone(ZoneId.of("Z"));
                } else {
                    untilNew = LocalDate.from((TemporalAccessor)((RecurrenceRuleValue)vComponent.getRecurrenceRule().getValue()).getUntil().getValue());
                }
                this.rrule.setUntil((Temporal)((Object)untilNew));
            }
            this.exceptionMasterList.clear();
            this.refreshExceptionDates();
        });
        this.recurrenceRuleProperty.addListener((obs, oldValue, newValue) -> {
            if (newValue != null) {
                this.addListeners();
                this.dateTimeStartProperty.addListener(this.dateTimeStartToExceptionChangeListener);
            } else {
                this.removeListeners();
                this.dateTimeStartProperty.removeListener(this.dateTimeStartToExceptionChangeListener);
            }
        });
        this.exceptionComboBox.setConverter((StringConverter)new StringConverter<Temporal>(){

            public String toString(Temporal temporal) {
                DateTimeFormatter myFormatter = EditRecurrenceRuleVBox.this.getFormatter(temporal);
                return myFormatter.format(temporal);
            }

            public Temporal fromString(String string) {
                throw new RuntimeException("not required for non editable ComboBox");
            }
        });
        this.exceptionComboBox.valueProperty().addListener(obs -> this.addExceptionButton.setDisable(false));
        this.exceptionsListView.getSelectionModel().selectedItemProperty().addListener(obs -> this.removeExceptionButton.setDisable(false));
        Callback<ListView<Temporal>, ListCell<Temporal>> temporalCellFactory = new Callback<ListView<Temporal>, ListCell<Temporal>>(){

            public ListCell<Temporal> call(ListView<Temporal> list) {
                return new ListCell<Temporal>(){

                    public void updateItem(Temporal temporal, boolean empty) {
                        super.updateItem((Object)temporal, empty);
                        if (temporal == null || empty) {
                            this.setText(null);
                            this.setStyle("");
                        } else {
                            DateTimeFormatter myFormatter = EditRecurrenceRuleVBox.this.getFormatter(temporal);
                            this.setText(myFormatter.format(temporal));
                        }
                    }
                };
            }
        };
        this.exceptionsListView.setCellFactory((Callback)temporalCellFactory);
        this.sceneProperty().addListener((obs, oldScene, newScene) -> {
            if (newScene != null) {
                newScene.getWindow().setOnShown(event -> {
                    for (Node node : this.exceptionComboBox.lookupAll(".scroll-bar")) {
                        ScrollBar bar;
                        if (!(node instanceof ScrollBar) || (bar = (ScrollBar)node).getOrientation() != Orientation.VERTICAL) continue;
                        bar.valueProperty().addListener((value, oldValue, newValue) -> {
                            if ((Double)newValue > 0.9 && (Double)oldValue < 0.9) {
                                int elements = this.exceptionComboBox.getItems().size();
                                if (elements == 50) {
                                    this.makeExceptionDates();
                                    bar.setValue(0.5);
                                }
                            } else if ((Double)newValue < 0.1 && (Double)oldValue > 0.1) {
                                int elements = this.exceptionComboBox.getItems().size();
                                Temporal firstElement = (Temporal)this.exceptionComboBox.getItems().get(0);
                                int indexInMasterList = this.exceptionMasterList.indexOf(firstElement);
                                int newIndex = Math.max(indexInMasterList - elements / 3, 0);
                                if (newIndex < indexInMasterList) {
                                    this.makeExceptionDates();
                                    bar.setValue(0.5);
                                }
                            }
                        });
                    }
                });
            }
        });
        boolean bl = isInitiallyRepeatable = this.rrule != null;
        if (isInitiallyRepeatable) {
            this.setInitialValues((VDisplayable<?>)vComponent);
        }
        this.repeatableCheckBox.setSelected(isInitiallyRepeatable);
        this.dayOfWeekRadioButton.selectedProperty().addListener(this.dayOfWeekButtonListener);
        this.addListeners();
        this.frequencyComboBox.valueProperty().addListener(this.frequencyListener);
    }

    private void addListeners() {
        this.endNeverRadioButton.selectedProperty().addListener(this.neverListener);
        this.intervalSpinner.valueProperty().addListener(this.intervalSpinnerListener);
        this.dayOfWeekList.addListener(this.makeExceptionDatesAndSummaryListener);
    }

    private void removeListeners() {
        this.endNeverRadioButton.selectedProperty().removeListener(this.neverListener);
        this.intervalSpinner.valueProperty().removeListener(this.intervalSpinnerListener);
        this.dayOfWeekList.removeListener(this.makeExceptionDatesAndSummaryListener);
    }

    private void setInitialValues(VDisplayable<?> vComponent) {
        FrequencyType frequencyType = (FrequencyType)((Object)this.rrule.getFrequency().getValue());
        this.frequencyComboBox.setValue((Object)frequencyType);
        switch (frequencyType) {
            case MONTHLY: {
                ByDay rule = (ByDay)this.rrule.lookupByRule(ByDay.class);
                if (rule == null) {
                    this.dayOfMonthRadioButton.setSelected(true);
                    break;
                }
                this.dayOfWeekRadioButton.setSelected(true);
                break;
            }
            case WEEKLY: {
                this.setDayOfWeek(this.rrule);
                this.dateTimeStartRecurrenceNew.addListener(this.weeklyRecurrenceListener);
                break;
            }
        }
        this.setFrequencyVisibility(frequencyType);
        int initialInterval = this.rrule.getInterval() == null || ((Integer)this.rrule.getInterval().getValue()).equals(1) ? 1 : (Integer)this.rrule.getInterval().getValue();
        this.intervalSpinner.setValueFactory((SpinnerValueFactory)new SpinnerValueFactory.IntegerSpinnerValueFactory(1, 100, initialInterval));
        this.setIntervalText(initialInterval);
        if (vComponent.getExceptionDates() != null) {
            List collect = vComponent.getExceptionDates().stream().flatMap(e -> ((Set)e.getValue()).stream()).collect(Collectors.toList());
            this.exceptionsListView.getItems().addAll(collect);
        }
        int initialCount = this.rrule.getCount() != null ? (Integer)this.rrule.getCount().getValue() : 10;
        this.endAfterEventsSpinner.setValueFactory((SpinnerValueFactory)new SpinnerValueFactory.IntegerSpinnerValueFactory(1, 1000, initialCount));
        if (this.rrule.getCount() != null) {
            this.endAfterRadioButton.setSelected(true);
        } else if (this.rrule.getUntil() != null) {
            this.untilRadioButton.setSelected(true);
        } else {
            this.endNeverRadioButton.setSelected(true);
        }
        this.startDatePicker.setValue((Object)LocalDate.from((TemporalAccessor)vComponent.getDateTimeStart().getValue()));
        this.refreshSummary();
        this.refreshExceptionDates();
    }

    private void setDayOfWeek(RecurrenceRuleValue rRule) {
        if (rRule.getFrequency().getValue() == FrequencyType.WEEKLY) {
            ByRule<?> rule = rRule.lookupByRule(ByDay.class);
            ((ByDay)rule).dayOfWeekWithoutOrdinalList().stream().forEach(d -> {
                switch (d) {
                    case FRIDAY: {
                        this.fridayCheckBox.setSelected(true);
                        break;
                    }
                    case MONDAY: {
                        this.mondayCheckBox.setSelected(true);
                        break;
                    }
                    case SATURDAY: {
                        this.saturdayCheckBox.setSelected(true);
                        break;
                    }
                    case SUNDAY: {
                        this.sundayCheckBox.setSelected(true);
                        break;
                    }
                    case THURSDAY: {
                        this.thursdayCheckBox.setSelected(true);
                        break;
                    }
                    case TUESDAY: {
                        this.tuesdayCheckBox.setSelected(true);
                        break;
                    }
                    case WEDNESDAY: {
                        this.wednesdayCheckBox.setSelected(true);
                        break;
                    }
                }
            });
        }
    }

    private void refreshExceptionDates() {
        if (((VDisplayable)this.vComponent).getRecurrenceRule() != null) {
            this.makeExceptionDates();
        }
    }

    private void makeExceptionDates() {
        Temporal newDateTimeStart;
        Temporal dtstart = (Temporal)((VPrimary)this.vComponent).getDateTimeStart().getValue();
        if (this.dateTimeStartRecurrenceNew.get() instanceof LocalDate) {
            newDateTimeStart = LocalDate.from(dtstart);
        } else if (this.dateTimeStartRecurrenceNew.get() instanceof LocalDateTime || this.dateTimeStartRecurrenceNew.get() instanceof ZonedDateTime) {
            LocalDate dtstartLocalDate = LocalDate.from(dtstart);
            newDateTimeStart = ((Temporal)this.dateTimeStartRecurrenceNew.get()).with(dtstartLocalDate);
        } else {
            throw new DateTimeException("Unsupported Temporal type:" + ((Temporal)this.dateTimeStartRecurrenceNew.get()).getClass());
        }
        this.exceptionComboBox.getItems().clear();
        boolean isRecurrenceRuleValid = ((RecurrenceRuleValue)((VDisplayable)this.vComponent).getRecurrenceRule().getValue()).isValid();
        if (isRecurrenceRuleValid) {
            Stream<Temporal> stream1;
            if (((VDisplayable)this.vComponent).getExceptionDates() != null) {
                List allExceptions = ((VDisplayable)this.vComponent).getExceptionDates().stream().flatMap(e -> ((Set)e.getValue()).stream()).collect(Collectors.toList());
                stream1 = ((RecurrenceRuleValue)((VDisplayable)this.vComponent).getRecurrenceRule().getValue()).streamRecurrences(newDateTimeStart).filter(v -> !allExceptions.contains(v));
            } else {
                stream1 = ((RecurrenceRuleValue)((VDisplayable)this.vComponent).getRecurrenceRule().getValue()).streamRecurrences(newDateTimeStart);
            }
            Stream<Temporal> stream2 = DateTimeUtilities.DateTimeType.of(newDateTimeStart) == DateTimeUtilities.DateTimeType.DATE_WITH_LOCAL_TIME_AND_TIME_ZONE ? stream1.map(t -> ((ZonedDateTime)t).withZoneSameInstant(ZoneId.systemDefault())) : stream1;
            Temporal lastDateInMasterList = this.exceptionMasterList.isEmpty() ? newDateTimeStart.with(LocalDate.MIN) : this.exceptionMasterList.get(this.exceptionMasterList.size() - 1);
            List exceptionDates = stream2.limit(50L).peek(t -> {
                if (DateTimeUtilities.isAfter(t, lastDateInMasterList)) {
                    this.exceptionMasterList.add((Temporal)t);
                }
            }).collect(Collectors.toList());
            this.exceptionComboBox.getItems().addAll(exceptionDates);
        }
    }

    @FXML
    private void handleAddException() {
        Temporal d = (Temporal)this.exceptionComboBox.getValue();
        this.exceptionsListView.getItems().add((Object)d);
        this.refreshExceptionDates();
        Collections.sort(this.exceptionsListView.getItems(), DateTimeUtilities.TEMPORAL_COMPARATOR);
        if (this.exceptionComboBox.getValue() == null) {
            this.addExceptionButton.setDisable(true);
        }
    }

    @FXML
    private void handleRemoveException() {
        Temporal d = (Temporal)this.exceptionsListView.getSelectionModel().getSelectedItem();
        ((Set)((VDisplayable)this.vComponent).getExceptionDates().get(0).getValue()).remove(d);
        this.refreshExceptionDates();
        this.exceptionsListView.getItems().remove((Object)d);
        if (this.exceptionsListView.getSelectionModel().getSelectedItem() == null) {
            this.removeExceptionButton.setDisable(true);
        }
        if (this.exceptionsListView.getItems().isEmpty()) {
            ((VDisplayable)this.vComponent).setExceptionDates(null);
        }
    }

    private static void notNumberAlert() {
        Alert alert = new Alert(Alert.AlertType.ERROR);
        alert.setTitle("Invalid Number");
        alert.setHeaderText("Please enter valid numbers.");
        alert.setContentText("Must be greater than or equal to 1");
        ButtonType buttonTypeOk = new ButtonType("OK", ButtonBar.ButtonData.CANCEL_CLOSE);
        alert.getButtonTypes().setAll((Object[])new ButtonType[]{buttonTypeOk});
        alert.showAndWait();
    }

    private static void tooEarlyDateAlert(Temporal t) {
        Alert alert = new Alert(Alert.AlertType.ERROR);
        alert.setTitle("Invalid Date Selection");
        alert.setHeaderText("Event can't end before it begins.");
        alert.setContentText("Must be after " + Settings.DATE_FORMAT_AGENDA_DATEONLY.format(t));
        ButtonType buttonTypeOk = new ButtonType("OK", ButtonBar.ButtonData.CANCEL_CLOSE);
        alert.getButtonTypes().setAll((Object[])new ButtonType[]{buttonTypeOk});
        alert.showAndWait();
    }

    private static void notOccurrenceDateAlert(Temporal temporal) {
        Alert alert = new Alert(Alert.AlertType.ERROR);
        alert.setTitle("Invalid Date Selection");
        alert.setHeaderText(Settings.DATE_FORMAT_AGENDA_DATEONLY.format(temporal) + " is not an occurrence date");
        alert.setContentText("Please select a date following repeat rules");
        ButtonType buttonTypeOk = new ButtonType("OK", ButtonBar.ButtonData.CANCEL_CLOSE);
        alert.getButtonTypes().setAll((Object[])new ButtonType[]{buttonTypeOk});
        alert.showAndWait();
    }

    private static void notDateAlert(String exampleDate) {
        Alert alert = new Alert(Alert.AlertType.ERROR);
        alert.setTitle("Invalid Date");
        alert.setHeaderText("Please enter valid date.");
        alert.setContentText("Example date format:" + exampleDate);
        ButtonType buttonTypeOk = new ButtonType("OK", ButtonBar.ButtonData.CANCEL_CLOSE);
        alert.getButtonTypes().setAll((Object[])new ButtonType[]{buttonTypeOk});
        alert.showAndWait();
    }

    public static String makeSummary(RecurrenceRuleValue rrule, Temporal startTemporal) {
        String frequencyText;
        if (!rrule.isValid()) {
            return Settings.resources == null ? "Never" : Settings.resources.getString("rrule.summary.never");
        }
        StringBuilder builder = new StringBuilder();
        if (rrule.getCount() != null && (Integer)rrule.getCount().getValue() == 1) {
            return Settings.resources == null ? "Once" : Settings.resources.getString("rrule.summary.once");
        }
        if (rrule.getInterval() == null || (Integer)rrule.getInterval().getValue() == 1) {
            frequencyText = Settings.REPEAT_FREQUENCIES.get(rrule.getFrequency().getValue());
        } else if ((Integer)rrule.getInterval().getValue() > 1) {
            String every = Settings.resources == null ? "Every" : Settings.resources.getString("rrule.summary.every");
            builder.append(every + " ");
            builder.append(rrule.getInterval().getValue() + " ");
            frequencyText = Settings.REPEAT_FREQUENCIES_PLURAL.get(rrule.getFrequency().getValue());
        } else {
            throw new RuntimeException("Interval can't be less than 1");
        }
        builder.append(frequencyText);
        ByDay byDay = (ByDay)rrule.lookupByRule(ByDay.class);
        switch ((FrequencyType)((Object)rrule.getFrequency().getValue())) {
            case DAILY: {
                break;
            }
            case MONTHLY: {
                String onDay;
                int dayOfMonth = LocalDate.from(startTemporal).getDayOfMonth();
                String string = onDay = Settings.resources == null ? "on day" : Settings.resources.getString("rrule.summary.on.day");
                if (byDay == null) {
                    builder.append(" " + onDay + " " + dayOfMonth);
                    break;
                }
                String onThe = Settings.resources == null ? "on the" : Settings.resources.getString("rrule.summary.on.the");
                builder.append(" " + onThe + " " + EditRecurrenceRuleVBox.byDaySummary(byDay));
                break;
            }
            case WEEKLY: {
                String on;
                String string = on = Settings.resources == null ? "on" : Settings.resources.getString("rrule.summary.on");
                if (byDay == null) {
                    DayOfWeek dayOfWeek = LocalDate.from(startTemporal).getDayOfWeek();
                    String dayOfWeekString = Settings.DAYS_OF_WEEK_MAP.get(dayOfWeek);
                    builder.append(" " + on + " " + dayOfWeekString);
                    break;
                }
                builder.append(" " + on + " " + EditRecurrenceRuleVBox.byDaySummary(byDay));
                break;
            }
            case YEARLY: {
                String on = Settings.resources == null ? "on" : Settings.resources.getString("rrule.summary.on");
                String monthAndDay = Settings.DATE_FORMAT_AGENDA_MONTHDAY.format(startTemporal);
                builder.append(" " + on + " " + monthAndDay);
                break;
            }
            case SECONDLY: 
            case MINUTELY: 
            case HOURLY: {
                throw new IllegalArgumentException("Not supported:" + rrule.getFrequency().getValue());
            }
        }
        if (rrule.getCount() != null) {
            String times = Settings.resources == null ? "times" : Settings.resources.getString("rrule.summary.times");
            builder.append(", " + rrule.getCount().getValue() + " " + times);
        } else if (rrule.getUntil() != null) {
            String until = Settings.resources == null ? "until" : Settings.resources.getString("rrule.summary.until");
            String date = Settings.DATE_FORMAT_AGENDA_DATEONLY.format((TemporalAccessor)rrule.getUntil().getValue());
            builder.append(", " + until + " " + date);
        }
        return builder.toString();
    }

    private boolean isSupported(VDisplayable<?> vComponent) {
        int unsupportedRules;
        if (this.rrule == null) {
            return true;
        }
        ByDay byDay = (ByDay)this.rrule.lookupByRule(ByDay.class);
        int byRulesSize = this.rrule.getByRules() == null ? 0 : this.rrule.getByRules().size();
        int n = unsupportedRules = byDay == null ? byRulesSize : byRulesSize - 1;
        if (unsupportedRules > 0) {
            String unsupportedByRules = this.rrule.getByRules().stream().filter(b -> b instanceof ByDay).map(b -> b.name()).collect(Collectors.joining(","));
            System.out.println("RRULE contains unsupported ByRule" + (unsupportedRules > 1 ? "s:" : ":") + unsupportedByRules);
            return false;
        }
        return true;
    }

    private static String byDaySummary(ByDay byDay) {
        StringBuilder builder = new StringBuilder();
        for (ByDay.ByDayPair b : (List)byDay.getValue()) {
            int ordinal = b.getOrdinal();
            DayOfWeek dayOfWeek = b.getDayOfWeek();
            String ordinalString = ordinal > 0 ? Settings.ORDINALS.get(ordinal) + " " : "";
            String dayOfWeekString = Settings.DAYS_OF_WEEK_MAP.get(dayOfWeek);
            if (builder.length() > 0) {
                builder.append(", ");
            }
            builder.append(ordinalString + dayOfWeekString);
        }
        return builder.toString();
    }

    protected static void loadFxml(URL fxmlFile, Object rootController) {
        FXMLLoader loader = new FXMLLoader(fxmlFile);
        loader.setController(rootController);
        loader.setRoot(rootController);
        loader.setResources(Settings.resources);
        try {
            loader.load();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

