/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.resources;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javafx.scene.text.Font;

public class JFXtrasFontRoboto {
    private static final Set<AvailableFonts> loadedFonts = Collections.synchronizedSet(new HashSet());

    public static void loadAll() {
        for (AvailableFonts f : AvailableFonts.values()) {
            JFXtrasFontRoboto.load(f);
        }
    }

    public static synchronized void load(AvailableFonts font) {
        if (!loadedFonts.contains((Object)font)) {
            Font.loadFont((String)JFXtrasFontRoboto.class.getResource("/" + font.getFilename()).toExternalForm(), (double)12.0);
            loadedFonts.add(font);
        }
    }

    public static enum AvailableFonts {
        RobotoItalic("Roboto Italic", "Roboto-Italic.ttf"),
        RobotoRegular("Roboto Regular", "Roboto-Regular.ttf"),
        RobotoBlack("Roboto Black", "Roboto-Black.ttf"),
        RobotoBlackItalic("Roboto Black Italic", "Roboto-BlackItalic.ttf"),
        RobotoBold("Roboto Bold", "Roboto-Bold.ttf"),
        RobotoBoldItalic("Roboto Bold Italic", "Roboto-BoldItalic.ttf"),
        RobotoLight("Roboto Light", "Roboto-Light.ttf"),
        RobotoLightItalic("Roboto Light Italic", "Roboto-LightItalic.ttf"),
        RobotoMedium("Roboto Medium", "Roboto-Medium.ttf"),
        RobotoMediumItalic("Roboto Medium Italic", "Roboto-MediumItalic.ttf"),
        RobotoThin("Roboto Thin", "Roboto-Thin.ttf"),
        RobotoThinItalic("Roboto Thin Italic", "Roboto-ThinItalic.ttf"),
        RobotoCondensedBold("Roboto Condensed Bold", "RobotoCondensed-Bold.ttf"),
        RobotoCondensedBoldItalic("Roboto Condensed Bold Italic", "RobotoCondensed-BoldItalic.ttf"),
        RobotoCondensedItalic("Roboto Condensed Italic", "RobotoCondensed-Italic.ttf"),
        RobotoCondensedLight("Roboto Condensed Light", "RobotoCondensed-Light.ttf"),
        RobotoCondensedLightItalic("Roboto Condensed Light Italic", "RobotoCondensed-LightItalic.ttf"),
        RobotoCondensedRegular("Roboto Condensed Regular", "RobotoCondensed-Regular.ttf");

        private final String familyName;
        private final String filename;

        private AvailableFonts(String familyName, String filename) {
            this.familyName = familyName;
            this.filename = filename;
        }

        public String getFamilyName() {
            return this.familyName;
        }

        private String getFilename() {
            return this.filename;
        }
    }
}

