/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.scene.control.agenda.icalendar.factories;

import java.time.LocalDate;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAmount;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import jfxtras.icalendarfx.components.VDisplayable;
import jfxtras.icalendarfx.components.VJournal;
import jfxtras.icalendarfx.components.VLocatable;
import jfxtras.scene.control.agenda.Agenda;
import jfxtras.scene.control.agenda.icalendar.factories.RecurrenceFactory;

public class DefaultRecurrenceFactory
extends RecurrenceFactory<Agenda.Appointment> {
    private Collection<Agenda.AppointmentGroup> appointmentGroups;

    public DefaultRecurrenceFactory(Collection<Agenda.AppointmentGroup> appointmentGroups) {
        this.appointmentGroups = appointmentGroups;
    }

    @Override
    Agenda.Appointment makeRecurrence(VDisplayable<?> vComponent, Temporal startTemporal) {
        Agenda.AppointmentGroup appointmentGroup;
        Temporal endTemporal;
        String location;
        String description;
        Boolean isWholeDay = vComponent.getDateTimeStart().getValue() instanceof LocalDate;
        if (vComponent instanceof VLocatable) {
            VLocatable VComponentLocatableBase = (VLocatable)vComponent;
            description = VComponentLocatableBase.getDescription() != null ? (String)VComponentLocatableBase.getDescription().getValue() : null;
            location = VComponentLocatableBase.getLocation() != null ? (String)VComponentLocatableBase.getLocation().getValue() : null;
            TemporalAmount adjustment = VComponentLocatableBase.getActualDuration();
            endTemporal = startTemporal.plus(adjustment);
        } else if (vComponent instanceof VJournal) {
            VJournal vJournal = (VJournal)vComponent;
            description = vJournal.getDescriptions() != null ? (String)vJournal.getDescriptions().get(0).getValue() : null;
            location = null;
            endTemporal = null;
        } else {
            throw new RuntimeException("Unsupported VComponent type:" + vComponent.getClass());
        }
        if (vComponent.getCategories() != null) {
            String firstCategory = (String)((List)vComponent.getCategories().get(0).getValue()).get(0);
            Optional<Agenda.AppointmentGroup> myGroup = this.appointmentGroups.stream().filter(g -> g.getDescription().equals(firstCategory)).findAny();
            appointmentGroup = myGroup.isPresent() ? myGroup.get() : null;
        } else {
            appointmentGroup = null;
        }
        Agenda.Appointment appt = (Agenda.Appointment)((Agenda.AppointmentImplTemporal)((Agenda.AppointmentImplTemporal)((Agenda.AppointmentImplTemporal)((Agenda.AppointmentImplTemporal)new Agenda.AppointmentImplTemporal().withStartTemporal(startTemporal).withEndTemporal(endTemporal).withDescription(description)).withSummary(vComponent.getSummary() != null ? (String)vComponent.getSummary().getValue() : null)).withLocation(location)).withWholeDay(isWholeDay)).withAppointmentGroup(appointmentGroup);
        return appt;
    }
}

