/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.scene.control.agenda.icalendar.factories;

import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.Temporal;
import jfxtras.icalendarfx.components.VDisplayable;
import jfxtras.icalendarfx.components.VEvent;
import jfxtras.icalendarfx.components.VLocatable;
import jfxtras.icalendarfx.components.VTodo;
import jfxtras.icalendarfx.properties.component.relationship.Organizer;
import jfxtras.icalendarfx.utilities.Callback;
import jfxtras.scene.control.agenda.Agenda;
import jfxtras.scene.control.agenda.icalendar.factories.VComponentFactory;

public class DefaultVComponentFactory
extends VComponentFactory<Agenda.Appointment> {
    private final Organizer organizer;
    private final Callback<Void, String> uidGeneratorCallback;

    public DefaultVComponentFactory(Organizer organizer, Callback<Void, String> uidGeneratorCallback) {
        this.organizer = organizer;
        this.uidGeneratorCallback = uidGeneratorCallback;
    }

    @Override
    public VDisplayable<?> createVComponent(Agenda.Appointment appointment) {
        VLocatable newVComponent;
        boolean hasEnd;
        ZonedDateTime dtCreated = ZonedDateTime.now(ZoneId.of("Z"));
        String summary = appointment.getSummary() == null || appointment.getSummary().isEmpty() ? null : appointment.getSummary();
        String description = appointment.getDescription() == null || appointment.getDescription().isEmpty() ? null : appointment.getDescription();
        String category = appointment.getAppointmentGroup() == null ? null : appointment.getAppointmentGroup().getDescription();
        String location = appointment.getLocation() == null || appointment.getLocation().isEmpty() ? null : appointment.getLocation();
        Temporal dtstart = appointment.isWholeDay() != false ? LocalDate.from(appointment.getStartTemporal()) : appointment.getStartTemporal();
        Temporal dtend = appointment.isWholeDay() != false ? LocalDate.from(appointment.getEndTemporal()) : appointment.getEndTemporal();
        boolean bl = hasEnd = appointment.getEndTemporal() != null;
        if (hasEnd) {
            newVComponent = new VEvent();
            newVComponent.withOrganizer(this.organizer);
            newVComponent.withSummary(summary);
            newVComponent.withCategories(category);
            newVComponent.withDateTimeStart(dtstart);
            ((VEvent)newVComponent).withDateTimeEnd(dtend);
            ((VEvent)newVComponent).withDescription(description);
            ((VEvent)newVComponent).setLocation(location);
            newVComponent.setDateTimeCreated(dtCreated);
            newVComponent.setDateTimeStamp(dtCreated);
            newVComponent.setUidGeneratorCallback(this.uidGeneratorCallback);
            newVComponent.setUniqueIdentifier();
        } else {
            newVComponent = new VTodo();
            newVComponent.withOrganizer(this.organizer);
            newVComponent.withSummary(summary);
            newVComponent.withCategories(category);
            newVComponent.withDateTimeStart(dtstart);
            ((VTodo)newVComponent).withDescription(description);
            ((VTodo)newVComponent).setLocation(location);
            newVComponent.setDateTimeCreated(dtCreated);
            newVComponent.setDateTimeStamp(dtCreated);
            newVComponent.setUidGeneratorCallback(this.uidGeneratorCallback);
            newVComponent.setUniqueIdentifier();
        }
        return newVComponent;
    }
}

