/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.scene.layout;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javafx.animation.Animation;
import javafx.animation.Transition;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.SimpleObjectProperty;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Line;
import javafx.util.Duration;
import jfxtras.util.Implements;

public class CircularPane
extends Pane {
    private final ObjectProperty<Double> startAngleObjectProperty = new SimpleObjectProperty<Double>((Object)this, "startAngle", Double.valueOf(0.0)){
        {
            this.addListener(invalidationEvent -> CircularPane.this.requestLayout());
        }
    };
    private final ObjectProperty<Double> arcObjectProperty = new SimpleObjectProperty<Double>((Object)this, "arc", Double.valueOf(360.0)){
        {
            this.addListener(invalidationEvent -> CircularPane.this.requestLayout());
        }
    };
    private final ObjectProperty<Double> gapObjectProperty = new SimpleObjectProperty<Double>((Object)this, "gap", Double.valueOf(0.0)){
        {
            this.addListener(invalidationEvent -> CircularPane.this.requestLayout());
        }
    };
    private final ObjectProperty<Double> diameterObjectProperty = new SimpleObjectProperty<Double>((Object)this, "diameter", null){
        {
            this.addListener(invalidationEvent -> CircularPane.this.requestLayout());
        }
    };
    private final ObjectProperty<Boolean> childrenAreCircularObjectProperty = new SimpleObjectProperty<Boolean>((Object)this, "childrenAreCircular", Boolean.valueOf(false)){
        {
            this.addListener(invalidationEvent -> CircularPane.this.requestLayout());
        }
    };
    private final ObjectProperty<Boolean> clipAwayExcessWhitespaceObjectProperty = new SimpleObjectProperty<Boolean>((Object)this, "clipAwayExcessWhitespace", Boolean.valueOf(true)){
        {
            this.addListener(invalidationEvent -> CircularPane.this.requestLayout());
        }
    };
    private final ObjectProperty<Duration> animationDurationObjectProperty = new SimpleObjectProperty((Object)this, "animationDuration", (Object)Duration.millis((double)500.0));
    private final ObjectProperty<AnimationInterpolation> animationInterpolationObjectProperty = new SimpleObjectProperty((Object)this, "animationInterpolation", null);
    private ReadOnlyBooleanWrapper animating = new ReadOnlyBooleanWrapper((Object)this, "animating");
    private ReadOnlyBooleanWrapper animatingIn = new ReadOnlyBooleanWrapper((Object)this, "animatingIn");
    private ReadOnlyBooleanWrapper animatingOut = new ReadOnlyBooleanWrapper((Object)this, "animatingOut");
    private final ObjectProperty<EventHandler<ActionEvent>> animateInFinishedObjectProperty = new SimpleObjectProperty((Object)this, "animateInFinished", null);
    private final ObjectProperty<EventHandler<ActionEvent>> animateOutFinishedObjectProperty = new SimpleObjectProperty((Object)this, "animateOutFinished", null);
    private final ObjectProperty<Paint> showDebugObjectProperty = new SimpleObjectProperty<Paint>((Object)this, "showDebug", null){
        {
            this.addListener(invalidationEvent -> CircularPane.this.requestLayout());
        }
    };
    private final AtomicInteger layingoutChildren = new AtomicInteger(0);
    private boolean initial = true;
    private final Map<Node, Bead> nodeToBeadMap = new WeakHashMap<Node, Bead>();
    private final Map<Node, Connector> nodeToConnectorMap = new WeakHashMap<Node, Connector>();
    private final Map<MinPrefMax, LayoutInfo> calculateLayoutCache = new HashMap<MinPrefMax, LayoutInfo>();
    Transition transition = null;
    final Map<Node, AnimationLayoutInfo> animationLayoutInfos = new HashMap<Node, AnimationLayoutInfo>();

    public CircularPane withId(String v) {
        this.setId(v);
        return this;
    }

    public ObjectProperty<Double> startAngleProperty() {
        return this.startAngleObjectProperty;
    }

    public Double getStartAngle() {
        return (Double)this.startAngleObjectProperty.getValue();
    }

    public void setStartAngle(Double value) {
        this.startAngleObjectProperty.setValue((Object)value);
    }

    public CircularPane withStartAngle(Double value) {
        this.setStartAngle(value);
        return this;
    }

    private Double getStartAngle360() {
        return this.getStartAngle() % 360.0;
    }

    public ObjectProperty<Double> arcProperty() {
        return this.arcObjectProperty;
    }

    public Double getArc() {
        return (Double)this.arcObjectProperty.getValue();
    }

    public void setArc(Double value) {
        this.arcObjectProperty.setValue((Object)value);
    }

    public CircularPane withArc(Double value) {
        this.setArc(value);
        return this;
    }

    public ObjectProperty<Double> gapProperty() {
        return this.gapObjectProperty;
    }

    public Double getGap() {
        return (Double)this.gapObjectProperty.getValue();
    }

    public void setGap(Double value) {
        this.gapObjectProperty.setValue((Object)value);
    }

    public CircularPane withGap(Double value) {
        this.setGap(value);
        return this;
    }

    public ObjectProperty<Double> diameterProperty() {
        return this.diameterObjectProperty;
    }

    public Double getDiameter() {
        return (Double)this.diameterObjectProperty.getValue();
    }

    public void setDiameter(Double value) {
        this.diameterObjectProperty.setValue((Object)value);
    }

    public CircularPane withDiameter(Double value) {
        this.setDiameter(value);
        return this;
    }

    public ObjectProperty<Boolean> childrenAreCircularProperty() {
        return this.childrenAreCircularObjectProperty;
    }

    public Boolean getChildrenAreCircular() {
        return (Boolean)this.childrenAreCircularObjectProperty.getValue();
    }

    public void setChildrenAreCircular(Boolean value) {
        this.childrenAreCircularObjectProperty.setValue((Object)value);
    }

    public CircularPane withChildrenAreCircular(Boolean value) {
        this.setChildrenAreCircular(value);
        return this;
    }

    public ObjectProperty<Boolean> clipAwayExcessWhitespaceProperty() {
        return this.clipAwayExcessWhitespaceObjectProperty;
    }

    public Boolean getClipAwayExcessWhitespace() {
        return (Boolean)this.clipAwayExcessWhitespaceObjectProperty.getValue();
    }

    public void setClipAwayExcessWhitespace(Boolean value) {
        this.clipAwayExcessWhitespaceObjectProperty.setValue((Object)value);
    }

    public CircularPane withClipAwayExcessWhitespace(Boolean value) {
        this.setClipAwayExcessWhitespace(value);
        return this;
    }

    public ObjectProperty<Duration> animationDurationProperty() {
        return this.animationDurationObjectProperty;
    }

    public Duration getAnimationDuration() {
        return (Duration)this.animationDurationObjectProperty.getValue();
    }

    public void setAnimationDuration(Duration value) {
        this.animationDurationObjectProperty.setValue((Object)value);
    }

    public CircularPane withAnimationDuration(Duration value) {
        this.setAnimationDuration(value);
        return this;
    }

    public ObjectProperty<AnimationInterpolation> animationInterpolationProperty() {
        return this.animationInterpolationObjectProperty;
    }

    public AnimationInterpolation getAnimationInterpolation() {
        return (AnimationInterpolation)this.animationInterpolationObjectProperty.getValue();
    }

    public void setAnimationInterpolation(AnimationInterpolation value) {
        this.animationInterpolationObjectProperty.setValue((Object)value);
    }

    public CircularPane withAnimationInterpolation(AnimationInterpolation value) {
        this.setAnimationInterpolation(value);
        return this;
    }

    public final ReadOnlyBooleanProperty animatingProperty() {
        return this.animating.getReadOnlyProperty();
    }

    private void setAnimating(boolean value) {
        this.animating.set(value);
    }

    public final boolean isAnimating() {
        return this.animatingProperty().get();
    }

    public final ReadOnlyBooleanProperty animatingInProperty() {
        return this.animatingIn.getReadOnlyProperty();
    }

    private void setAnimatingIn(boolean value) {
        this.animatingIn.set(value);
    }

    public final boolean isAnimatingIn() {
        return this.animatingInProperty().get();
    }

    public final ReadOnlyBooleanProperty animatingOutProperty() {
        return this.animatingOut.getReadOnlyProperty();
    }

    private void setAnimatingOut(boolean value) {
        this.animatingOut.set(value);
    }

    public final boolean isAnimatingOut() {
        return this.animatingOutProperty().get();
    }

    public ObjectProperty<EventHandler<ActionEvent>> animateInFinishedProperty() {
        return this.animateInFinishedObjectProperty;
    }

    public EventHandler<ActionEvent> getOnAnimateInFinished() {
        return (EventHandler)this.animateInFinishedObjectProperty.getValue();
    }

    public void setOnAnimateInFinished(EventHandler<ActionEvent> value) {
        this.animateInFinishedObjectProperty.setValue(value);
    }

    public CircularPane witOnhAnimateInFinished(EventHandler<ActionEvent> value) {
        this.setOnAnimateInFinished(value);
        return this;
    }

    public ObjectProperty<EventHandler<ActionEvent>> animateOutFinishedProperty() {
        return this.animateOutFinishedObjectProperty;
    }

    public EventHandler<ActionEvent> getOnAnimateOutFinished() {
        return (EventHandler)this.animateOutFinishedObjectProperty.getValue();
    }

    public void setOnAnimateOutFinished(EventHandler<ActionEvent> value) {
        this.animateOutFinishedObjectProperty.setValue(value);
    }

    public CircularPane withOnAnimateOutFinished(EventHandler<ActionEvent> value) {
        this.setOnAnimateOutFinished(value);
        return this;
    }

    public ObjectProperty<Paint> showDebugProperty() {
        return this.showDebugObjectProperty;
    }

    public Paint getShowDebug() {
        return (Paint)this.showDebugObjectProperty.getValue();
    }

    public void setShowDebug(Paint value) {
        this.showDebugObjectProperty.setValue((Object)value);
    }

    public CircularPane withShowDebug(Paint value) {
        this.setShowDebug(value);
        return this;
    }

    protected double computeMinWidth(double height) {
        return this.calculateLayout((MinPrefMax)MinPrefMax.MIN).clippedWidth;
    }

    protected double computeMinHeight(double width) {
        return this.calculateLayout((MinPrefMax)MinPrefMax.MIN).clippedHeight;
    }

    protected double computePrefWidth(double height) {
        return this.calculateLayout((MinPrefMax)MinPrefMax.PREF).clippedWidth;
    }

    protected double computePrefHeight(double width) {
        return this.calculateLayout((MinPrefMax)MinPrefMax.PREF).clippedHeight;
    }

    protected double computeMaxWidth(double height) {
        return this.computePrefWidth(height);
    }

    protected double computeMaxHeight(double width) {
        return this.computePrefHeight(width);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void layoutChildren() {
        if (this.layingoutChildren.get() > 0) {
            return;
        }
        this.layingoutChildren.incrementAndGet();
        try {
            this.getChildren().removeAll(this.nodeToBeadMap.values());
            this.nodeToBeadMap.clear();
            this.getChildren().removeAll(this.nodeToConnectorMap.values());
            this.nodeToConnectorMap.clear();
            this.animationLayoutInfos.clear();
            LayoutInfo lLayoutInfo = this.calculateLayout(null);
            List nodes = this.getManagedChildren();
            int idx = 0;
            for (Node lNode : nodes) {
                NodeLayoutInfo lNodeLayoutInfo = lLayoutInfo.layoutInfoMap.get(lNode);
                lNode.resize(lNodeLayoutInfo.w, lNodeLayoutInfo.h);
                AnimationLayoutInfo lAnimationLayoutInfo = new AnimationLayoutInfo();
                lAnimationLayoutInfo.layoutInfo = lLayoutInfo;
                lAnimationLayoutInfo.node = lNode;
                lAnimationLayoutInfo.idx = idx++;
                lAnimationLayoutInfo.nodeStartX = lNode.getLayoutX() + lNode.getLayoutBounds().getMinX();
                lAnimationLayoutInfo.nodeStartY = lNode.getLayoutY() + lNode.getLayoutBounds().getMinY();
                lAnimationLayoutInfo.nodeLayoutInfo = lNodeLayoutInfo;
                lAnimationLayoutInfo.originX = lLayoutInfo.chainDiameter / 2.0 + lLayoutInfo.beadDiameter / 2.0 - lLayoutInfo.clipLeft;
                lAnimationLayoutInfo.originY = lLayoutInfo.chainDiameter / 2.0 + lLayoutInfo.beadDiameter / 2.0 - lLayoutInfo.clipTop;
                lAnimationLayoutInfo.initial = this.initial;
                this.animationLayoutInfos.put(lNode, lAnimationLayoutInfo);
                if (this.getShowDebug() != null) {
                    Bead lBead = new Bead(lNodeLayoutInfo);
                    this.nodeToBeadMap.put(lNode, lBead);
                    this.getChildren().add((Object)lBead);
                    Connector lConnector = new Connector(lAnimationLayoutInfo);
                    this.nodeToConnectorMap.put(lNode, lConnector);
                    this.getChildren().add((Object)lConnector);
                }
                if (this.initial && this.getAnimationInterpolation() != null) {
                    this.getAnimationInterpolation().interpolate(0.0, lAnimationLayoutInfo);
                    continue;
                }
                lNode.relocate(lNodeLayoutInfo.x, lNodeLayoutInfo.y);
            }
            if (this.initial && this.getAnimationInterpolation() != null) {
                this.animateIn();
            }
            if (this.initial) {
                this.initial = false;
            }
        }
        finally {
            this.layingoutChildren.decrementAndGet();
        }
    }

    public void requestLayout() {
        this.calculateLayoutCache.clear();
        super.requestLayout();
    }

    protected LayoutInfo calculateLayout(MinPrefMax size) {
        double lAngle;
        LayoutInfo lLayoutInfo = this.calculateLayoutCache.get((Object)size);
        if (lLayoutInfo != null) {
            return lLayoutInfo;
        }
        lLayoutInfo = new LayoutInfo();
        List nodes = this.getManagedChildren();
        nodes.removeAll(this.nodeToBeadMap.values());
        nodes.removeAll(this.nodeToConnectorMap.values());
        if (nodes.size() == 0) {
            return lLayoutInfo;
        }
        lLayoutInfo.numberOfNodes = nodes.size();
        double lPrefToMinScaleFactor = 1.0;
        if (size != null) {
            lLayoutInfo.beadDiameter = this.determineBeadDiameter(size);
            lLayoutInfo.chainDiameter = this.computeChainDiameter(lLayoutInfo.beadDiameter);
        } else {
            double lHeight;
            LayoutInfo lMinLayoutInfo = this.calculateLayout(MinPrefMax.MIN);
            LayoutInfo lPrefLayoutInfo = this.calculateLayout(MinPrefMax.PREF);
            double lWidth = Math.max(this.getWidth(), lMinLayoutInfo.clippedWidth);
            lPrefToMinScaleFactor = Math.min(lWidth / lPrefLayoutInfo.clippedWidth, (lHeight = Math.max(this.getHeight(), lMinLayoutInfo.clippedHeight)) / lPrefLayoutInfo.clippedHeight);
            if (lPrefToMinScaleFactor > 1.0) {
                lPrefToMinScaleFactor = 1.0;
            }
            lLayoutInfo.beadDiameter = lPrefLayoutInfo.beadDiameter * lPrefToMinScaleFactor;
            lLayoutInfo.chainDiameter = lPrefLayoutInfo.chainDiameter * lPrefToMinScaleFactor;
        }
        lLayoutInfo.minX = lLayoutInfo.chainDiameter + lLayoutInfo.beadDiameter;
        lLayoutInfo.minY = lLayoutInfo.chainDiameter + lLayoutInfo.beadDiameter;
        lLayoutInfo.maxX = 0.0;
        lLayoutInfo.maxY = 0.0;
        lLayoutInfo.angleStep = this.getArc() / (double)lLayoutInfo.numberOfNodes;
        lLayoutInfo.startAngle = lAngle = this.getStartAngle360() + lLayoutInfo.angleStep / 2.0;
        for (Node lNode : nodes) {
            NodeLayoutInfo lNodeLayoutInfo = new NodeLayoutInfo();
            lNodeLayoutInfo.layoutInfo = lLayoutInfo;
            lNodeLayoutInfo.angle = lAngle;
            lLayoutInfo.layoutInfoMap.put(lNode, lNodeLayoutInfo);
            lNodeLayoutInfo.w = this.calculateNodeWidth(lNode, MinPrefMax.PREF) * lPrefToMinScaleFactor;
            lNodeLayoutInfo.h = this.calculateNodeHeight(lNode, MinPrefMax.PREF) * lPrefToMinScaleFactor;
            lNodeLayoutInfo.beadX = CircularPane.calculateX(lLayoutInfo.chainDiameter, lAngle) + lLayoutInfo.beadDiameter / 2.0;
            lNodeLayoutInfo.beadY = CircularPane.calculateY(lLayoutInfo.chainDiameter, lAngle) + lLayoutInfo.beadDiameter / 2.0;
            lNodeLayoutInfo.x = lNodeLayoutInfo.beadX - lNodeLayoutInfo.w / 2.0;
            lNodeLayoutInfo.y = lNodeLayoutInfo.beadY - lNodeLayoutInfo.h / 2.0;
            lLayoutInfo.minX = Math.min(lLayoutInfo.minX, lNodeLayoutInfo.beadX - lLayoutInfo.beadDiameter / 2.0);
            lLayoutInfo.minY = Math.min(lLayoutInfo.minY, lNodeLayoutInfo.beadY - lLayoutInfo.beadDiameter / 2.0);
            lLayoutInfo.maxX = Math.max(lLayoutInfo.maxX, lNodeLayoutInfo.beadX - lLayoutInfo.beadDiameter / 2.0);
            lLayoutInfo.maxY = Math.max(lLayoutInfo.maxY, lNodeLayoutInfo.beadY - lLayoutInfo.beadDiameter / 2.0);
            lAngle += lLayoutInfo.angleStep;
        }
        lLayoutInfo.clipTop = this.getClipAwayExcessWhitespace() != false ? lLayoutInfo.minY : 0.0;
        lLayoutInfo.clipRight = this.getClipAwayExcessWhitespace() != false ? lLayoutInfo.chainDiameter - lLayoutInfo.maxX : 0.0;
        lLayoutInfo.clipBottom = this.getClipAwayExcessWhitespace() != false ? lLayoutInfo.chainDiameter - lLayoutInfo.maxY : 0.0;
        lLayoutInfo.clipLeft = this.getClipAwayExcessWhitespace() != false ? lLayoutInfo.minX : 0.0;
        for (Node lNode : nodes) {
            NodeLayoutInfo lNodeLayoutInfo = lLayoutInfo.layoutInfoMap.get(lNode);
            lNodeLayoutInfo.x -= lLayoutInfo.clipLeft;
            lNodeLayoutInfo.y -= lLayoutInfo.clipTop;
            lNodeLayoutInfo.beadX -= lLayoutInfo.clipLeft;
            lNodeLayoutInfo.beadY -= lLayoutInfo.clipTop;
        }
        lLayoutInfo.clippedWidth = lLayoutInfo.chainDiameter + lLayoutInfo.beadDiameter - lLayoutInfo.clipLeft - lLayoutInfo.clipRight;
        lLayoutInfo.clippedHeight = lLayoutInfo.chainDiameter + lLayoutInfo.beadDiameter - lLayoutInfo.clipTop - lLayoutInfo.clipBottom;
        if (size != null) {
            this.calculateLayoutCache.put(size, lLayoutInfo);
        }
        return lLayoutInfo;
    }

    public void animateIn() {
        this.animate(1.0);
    }

    public void animateOut() {
        this.animate(-1.0);
    }

    private void animate(double rate) {
        if (this.getAnimationInterpolation() == null) {
            return;
        }
        if (this.transition == null) {
            this.transition = new Transition(){
                {
                    this.setCycleDuration(CircularPane.this.getAnimationDuration());
                    this.setAutoReverse(false);
                    this.setCycleCount(1);
                    this.setOnFinished(event -> {
                        CircularPane.this.setAnimating(false);
                        CircularPane.this.setAnimatingIn(false);
                        CircularPane.this.setAnimatingOut(false);
                        CircularPane.this.layingoutChildren.decrementAndGet();
                        if (CircularPane.this.transition.getRate() > 0.0 && CircularPane.this.getOnAnimateInFinished() != null) {
                            CircularPane.this.transition = null;
                            CircularPane.this.getOnAnimateInFinished().handle(event);
                        }
                        if (CircularPane.this.transition.getRate() < 0.0 && CircularPane.this.getOnAnimateOutFinished() != null) {
                            CircularPane.this.transition = null;
                            CircularPane.this.getOnAnimateOutFinished().handle(event);
                        }
                    });
                }

                protected void interpolate(double progress) {
                    for (AnimationLayoutInfo lAnimationLayoutInfo : CircularPane.this.animationLayoutInfos.values()) {
                        CircularPane.this.getAnimationInterpolation().interpolate(progress, lAnimationLayoutInfo);
                    }
                }
            };
        }
        this.transition.setRate(rate);
        if (this.transition.getStatus() != Animation.Status.RUNNING) {
            this.layingoutChildren.incrementAndGet();
            this.setAnimating(true);
            this.setAnimatingIn(rate > 0.0);
            this.setAnimatingOut(rate < 0.0);
            this.transition.playFrom(this.transition.getRate() > 0.0 ? Duration.ZERO : this.transition.getCycleDuration());
        }
    }

    @Implements(interfaces={AnimationInterpolation.class})
    public static void animateFromTheOrigin(double progress, AnimationLayoutInfo animationLayoutInfo) {
        double lOX = animationLayoutInfo.originX - animationLayoutInfo.layoutInfo.beadDiameter / 2.0;
        double lOY = animationLayoutInfo.originY - animationLayoutInfo.layoutInfo.beadDiameter / 2.0;
        double lX = lOX + progress * (animationLayoutInfo.nodeLayoutInfo.x - lOX);
        double lY = lOY + progress * (animationLayoutInfo.nodeLayoutInfo.y - lOY);
        animationLayoutInfo.node.relocate(lX, lY);
    }

    @Implements(interfaces={AnimationInterpolation.class})
    public static void animateSpiralOut(double progress, AnimationLayoutInfo animationLayoutInfo) {
        double spreadWindow = 0.4;
        double animationWindow = 1.0 - spreadWindow;
        double offset = (double)animationLayoutInfo.idx / (double)animationLayoutInfo.layoutInfo.numberOfNodes * spreadWindow;
        double scaledProgress = progress < offset ? 0.0 : (progress >= offset + animationWindow ? 1.0 : (progress - offset) / animationWindow);
        CircularPane.animateFromTheOrigin(scaledProgress, animationLayoutInfo);
    }

    @Implements(interfaces={AnimationInterpolation.class})
    public static void animateFromTheOriginWithFadeRotate(double progress, AnimationLayoutInfo animationLayoutInfo) {
        CircularPane.animateFromTheOrigin(progress, animationLayoutInfo);
        animationLayoutInfo.node.setOpacity(progress);
        animationLayoutInfo.node.setRotate(720.0 * progress);
    }

    @Implements(interfaces={AnimationInterpolation.class})
    public static void animateOverTheArc(double progress, AnimationLayoutInfo animationLayoutInfo) {
        double lAngle = animationLayoutInfo.layoutInfo.startAngle + progress * (animationLayoutInfo.nodeLayoutInfo.angle - animationLayoutInfo.layoutInfo.startAngle);
        double lX = CircularPane.calculateX(animationLayoutInfo.layoutInfo.chainDiameter, lAngle) + animationLayoutInfo.layoutInfo.beadDiameter / 2.0 - animationLayoutInfo.nodeLayoutInfo.w / 2.0 - animationLayoutInfo.layoutInfo.clipLeft;
        double lY = CircularPane.calculateY(animationLayoutInfo.layoutInfo.chainDiameter, lAngle) + animationLayoutInfo.layoutInfo.beadDiameter / 2.0 - animationLayoutInfo.nodeLayoutInfo.w / 2.0 - animationLayoutInfo.layoutInfo.clipTop;
        animationLayoutInfo.node.relocate(lX, lY);
    }

    @Implements(interfaces={AnimationInterpolation.class})
    public static void animateOverTheArcWithFade(double progress, AnimationLayoutInfo animationLayoutInfo) {
        CircularPane.animateOverTheArc(progress, animationLayoutInfo);
        animationLayoutInfo.node.setOpacity(progress);
    }

    @Implements(interfaces={AnimationInterpolation.class})
    public static void animateAppear(double progress, AnimationLayoutInfo animationLayoutInfo) {
        animationLayoutInfo.node.setOpacity(progress);
        animationLayoutInfo.node.relocate(animationLayoutInfo.nodeLayoutInfo.x, animationLayoutInfo.nodeLayoutInfo.y);
    }

    public CircularPane add(Node node) {
        this.getChildren().add((Object)node);
        return this;
    }

    public CircularPane remove(Node node) {
        this.getChildren().remove((Object)node);
        return this;
    }

    private List<Node> getManagedChildrenWithoutBeads() {
        ArrayList<Node> nodes = new ArrayList<Node>(this.getManagedChildren());
        nodes.removeAll(this.nodeToBeadMap.values());
        nodes.removeAll(this.nodeToConnectorMap.values());
        return nodes;
    }

    private static double calculateX(double chainDiameter, double angle) {
        double lX = chainDiameter / 2.0 + chainDiameter / 2.0 * -1.0 * Math.sin(CircularPane.degreesToRadials((angle %= 360.0) + 180.0));
        return lX;
    }

    private static double calculateY(double chainDiameter, double angle) {
        double lY = chainDiameter / 2.0 + chainDiameter / 2.0 * Math.cos(CircularPane.degreesToRadials((angle %= 360.0) + 180.0));
        return lY;
    }

    private double computeChainDiameter(double beadDiameter) {
        if (this.getDiameter() != null) {
            return this.getDiameter() - beadDiameter;
        }
        List<Node> nodes = this.getManagedChildrenWithoutBeads();
        int numberOfNodes = nodes.size();
        int numberOfNodesOnFullChain = (int)Math.ceil((double)numberOfNodes * (360.0 / this.getArc()));
        if (numberOfNodes == 0) {
            return 0.0;
        }
        if (numberOfNodes == 1) {
            return 0.0;
        }
        double lDiameter = (beadDiameter + this.getGap()) / Math.sin(CircularPane.degreesToRadials(180.0 / (double)numberOfNodesOnFullChain));
        return lDiameter;
    }

    private double determineBeadDiameter(MinPrefMax size) {
        double lBeadDiameter = 0.0;
        lBeadDiameter = this.getChildrenAreCircular() != false ? this.determineBeadDiameterUsingWidthOrHeight(size) : this.determineBeadDiameterUsingTheDiagonal(size);
        return lBeadDiameter;
    }

    private double determineBeadDiameterUsingWidthOrHeight(MinPrefMax size) {
        List<Node> nodes = this.getManagedChildrenWithoutBeads();
        double lMaximumSize = 0.0;
        for (Node lNode : nodes) {
            double lHeight;
            if (lNode instanceof Bead) continue;
            double lWidth = this.calculateNodeWidth(lNode, size);
            if (lWidth > lMaximumSize) {
                lMaximumSize = lWidth;
            }
            if (!((lHeight = this.calculateNodeHeight(lNode, size)) > lMaximumSize)) continue;
            lMaximumSize = lHeight;
        }
        return lMaximumSize;
    }

    private double determineBeadDiameterUsingTheDiagonal(MinPrefMax size) {
        List<Node> nodes = this.getManagedChildrenWithoutBeads();
        double lMaximumSize = 0.0;
        for (Node lNode : nodes) {
            double lHeight;
            double lWidth;
            double lSize;
            if (lNode instanceof Bead || !((lSize = Math.sqrt((lWidth = this.calculateNodeWidth(lNode, size)) * lWidth + (lHeight = this.calculateNodeHeight(lNode, size)) * lHeight)) > lMaximumSize)) continue;
            lMaximumSize = lSize;
        }
        return lMaximumSize;
    }

    private double calculateNodeWidth(Node n, MinPrefMax size) {
        if (size == MinPrefMax.MIN) {
            return n.minWidth(-1.0);
        }
        if (size == MinPrefMax.MAX) {
            return n.maxWidth(-1.0);
        }
        return n.prefWidth(-1.0);
    }

    private double calculateNodeHeight(Node n, MinPrefMax size) {
        if (size == MinPrefMax.MIN) {
            return n.minHeight(-1.0);
        }
        if (size == MinPrefMax.MAX) {
            return n.maxHeight(-1.0);
        }
        return n.prefHeight(-1.0);
    }

    private static double degreesToRadials(double d) {
        double r = d % 360.0 / 360.0 * 2.0 * Math.PI;
        return r;
    }

    private class Connector
    extends Line {
        public Connector(AnimationLayoutInfo animationLayoutInfo) {
            this.setFill(null);
            this.setStroke(CircularPane.this.getShowDebug());
            this.setStartX(animationLayoutInfo.originX);
            this.setStartY(animationLayoutInfo.originY);
            this.setEndX(animationLayoutInfo.nodeLayoutInfo.beadX);
            this.setEndY(animationLayoutInfo.nodeLayoutInfo.beadY);
        }
    }

    private class Bead
    extends Circle {
        public Bead(NodeLayoutInfo nodeLayoutInfo) {
            this.setRadius((nodeLayoutInfo.layoutInfo.beadDiameter - this.getStrokeWidth()) / 2.0);
            this.setFill(null);
            this.setStroke(CircularPane.this.getShowDebug());
            this.setLayoutX(nodeLayoutInfo.beadX - nodeLayoutInfo.layoutInfo.beadDiameter / 2.0);
            this.setLayoutY(nodeLayoutInfo.beadY - nodeLayoutInfo.layoutInfo.beadDiameter / 2.0);
            this.setTranslateX(nodeLayoutInfo.layoutInfo.beadDiameter / 2.0);
            this.setTranslateY(nodeLayoutInfo.layoutInfo.beadDiameter / 2.0);
        }
    }

    @FunctionalInterface
    public static interface AnimationInterpolation {
        public void interpolate(double var1, AnimationLayoutInfo var3);
    }

    public class AnimationLayoutInfo {
        public Node node;
        public int idx;
        public LayoutInfo layoutInfo;
        public NodeLayoutInfo nodeLayoutInfo;
        public double originX;
        public double originY;
        public double nodeStartX;
        public double nodeStartY;
        public boolean initial;

        public double calculateX(double angle) {
            return CircularPane.calculateX(this.layoutInfo.chainDiameter, angle);
        }

        public double calculateY(double angle) {
            return CircularPane.calculateY(this.layoutInfo.chainDiameter, angle);
        }
    }

    public class NodeLayoutInfo {
        public LayoutInfo layoutInfo;
        public double angle;
        public double beadX;
        public double beadY;
        public double x;
        public double y;
        public double w;
        public double h;
    }

    public class LayoutInfo {
        public int numberOfNodes;
        public double startAngle;
        public double angleStep;
        public double chainDiameter = 0.0;
        public double beadDiameter = 0.0;
        public double minX = 0.0;
        public double minY = 0.0;
        public double maxX = 0.0;
        public double maxY = 0.0;
        public double clipTop = 0.0;
        public double clipRight = 0.0;
        public double clipBottom = 0.0;
        public double clipLeft = 0.0;
        public double clippedWidth = 0.0;
        public double clippedHeight = 0.0;
        public final Map<Node, NodeLayoutInfo> layoutInfoMap = new WeakHashMap<Node, NodeLayoutInfo>();
    }

    private static enum MinPrefMax {
        MIN,
        PREF,
        MAX;

    }
}

