/*
 * Decompiled with CFR 0.152.
 */
package javax.media.opengl.awt;

import com.sun.opengl.impl.Debug;
import com.sun.opengl.impl.GLContextImpl;
import com.sun.opengl.impl.GLDrawableHelper;
import com.sun.opengl.impl.ThreadingImpl;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Rectangle2D;
import java.beans.Beans;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.media.nativewindow.AbstractGraphicsConfiguration;
import javax.media.nativewindow.AbstractGraphicsScreen;
import javax.media.nativewindow.Capabilities;
import javax.media.nativewindow.CapabilitiesChooser;
import javax.media.nativewindow.GraphicsConfigurationFactory;
import javax.media.nativewindow.NativeWindow;
import javax.media.nativewindow.NativeWindowFactory;
import javax.media.nativewindow.awt.AWTGraphicsConfiguration;
import javax.media.nativewindow.awt.AWTGraphicsDevice;
import javax.media.nativewindow.awt.AWTGraphicsScreen;
import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesChooser;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawable;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLException;
import javax.media.opengl.GLProfile;
import javax.media.opengl.Threading;
import javax.media.opengl.awt.AWTGLAutoDrawable;

public class GLCanvas
extends Canvas
implements AWTGLAutoDrawable {
    private static final boolean DEBUG = Debug.debug((String)"GLCanvas");
    private static GLProfile defaultGLProfile = GLProfile.getDefault();
    private GLProfile glProfile;
    private GLDrawableHelper drawableHelper = new GLDrawableHelper();
    private GraphicsConfiguration chosen;
    private AWTGraphicsConfiguration awtConfig;
    private GLDrawable drawable;
    private GLContextImpl context;
    private boolean autoSwapBufferMode = true;
    private boolean sendReshape = false;
    private GLCapabilities capabilities;
    private GLCapabilitiesChooser chooser;
    private GLContext shareWith;
    private GraphicsDevice device;
    private Object closingListener = null;
    private Object closingListenerLock = new Object();
    private boolean disposeRegenerate;
    private DisposeAction disposeAction = new DisposeAction(this);
    private DisposeOnEventDispatchThreadAction disposeOnEventDispatchThreadAction = new DisposeOnEventDispatchThreadAction();
    private InitAction initAction = new InitAction();
    private DisplayAction displayAction = new DisplayAction();
    private SwapBuffersAction swapBuffersAction = new SwapBuffersAction();
    private DisplayOnEventDispatchThreadAction displayOnEventDispatchThreadAction = new DisplayOnEventDispatchThreadAction();
    private SwapBuffersOnEventDispatchThreadAction swapBuffersOnEventDispatchThreadAction = new SwapBuffersOnEventDispatchThreadAction();
    private static boolean disableBackgroundEraseInitialized;
    private static Method disableBackgroundEraseMethod;
    static /* synthetic */ Class class$java$awt$Canvas;

    public GLCanvas() {
        this((GLCapabilities)null);
    }

    public GLCanvas(GLCapabilities gLCapabilities) {
        this(gLCapabilities, null, null, null);
    }

    public GLCanvas(GLCapabilities gLCapabilities, GLCapabilitiesChooser gLCapabilitiesChooser, GLContext gLContext, GraphicsDevice graphicsDevice) {
        if (null == gLCapabilities) {
            gLCapabilities = new GLCapabilities(defaultGLProfile);
        }
        this.glProfile = gLCapabilities.getGLProfile();
        this.capabilities = gLCapabilities;
        this.chooser = gLCapabilitiesChooser;
        this.shareWith = gLContext;
        this.device = graphicsDevice;
    }

    protected static final Object addClosingListener(Component component, final DestroyMethod destroyMethod) {
        WindowAdapter windowAdapter = null;
        Window window = GLCanvas.getWindow(component);
        if (null != window) {
            windowAdapter = new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    destroyMethod.destroyMethod();
                }
            };
            window.addWindowListener(windowAdapter);
        }
        return windowAdapter;
    }

    protected static final Window getWindow(Component component) {
        while (component != null && !(component instanceof Window)) {
            component = component.getParent();
        }
        return (Window)component;
    }

    public GraphicsConfiguration getGraphicsConfiguration() {
        GraphicsConfiguration graphicsConfiguration = super.getGraphicsConfiguration();
        if (graphicsConfiguration != null && this.chosen != null && !this.chosen.equals(graphicsConfiguration)) {
            if (!this.chosen.getDevice().getIDstring().equals(graphicsConfiguration.getDevice().getIDstring())) {
                AWTGraphicsConfiguration aWTGraphicsConfiguration = GLCanvas.chooseGraphicsConfiguration((GLCapabilities)this.awtConfig.getRequestedCapabilities(), this.chooser, graphicsConfiguration.getDevice());
                GraphicsConfiguration graphicsConfiguration2 = null != aWTGraphicsConfiguration ? aWTGraphicsConfiguration.getGraphicsConfiguration() : null;
                boolean bl = aWTGraphicsConfiguration.getChosenCapabilities().equals((Object)this.awtConfig.getChosenCapabilities());
                if (DEBUG) {
                    Exception exception = new Exception("Call Stack: " + Thread.currentThread().getName());
                    exception.printStackTrace();
                    System.err.println("!!! Created Config (n): HAVE    GC " + this.chosen);
                    System.err.println("!!! Created Config (n): THIS    GC " + graphicsConfiguration);
                    System.err.println("!!! Created Config (n): Choosen GC " + graphicsConfiguration2);
                    System.err.println("!!! Created Config (n): HAVE    CF " + this.awtConfig);
                    System.err.println("!!! Created Config (n): Choosen CF " + aWTGraphicsConfiguration);
                    System.err.println("!!! Created Config (n): EQUALS CAPS " + bl);
                }
                if (graphicsConfiguration2 != null) {
                    this.chosen = graphicsConfiguration2;
                    this.awtConfig = aWTGraphicsConfiguration;
                    if (!bl && GLAutoDrawable.SCREEN_CHANGE_ACTION_ENABLED) {
                        this.dispose(true);
                    }
                }
            }
            return this.chosen;
        }
        if (graphicsConfiguration == null) {
            return this.chosen;
        }
        return graphicsConfiguration;
    }

    public GLContext createContext(GLContext gLContext) {
        return this.drawable.createContext(gLContext);
    }

    public void setRealized(boolean bl) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void display() {
        this.maybeDoSingleThreadedWorkaround(this.displayOnEventDispatchThreadAction, this.displayAction);
        if (null == this.closingListener) {
            Object object = this.closingListenerLock;
            synchronized (object) {
                if (null == this.closingListener) {
                    this.closingListener = GLCanvas.addClosingListener(this, new DestroyMethod(){

                        public void destroyMethod() {
                            GLCanvas.this.destroy();
                        }
                    });
                }
            }
        }
    }

    protected void dispose(boolean bl) {
        if (DEBUG) {
            Exception exception = new Exception("dispose(" + bl + ") - start");
            exception.printStackTrace();
        }
        this.disposeRegenerate = bl;
        if (Threading.isSingleThreaded() && !Threading.isOpenGLThread()) {
            if (ThreadingImpl.isAWTMode() && Thread.holdsLock(this.getTreeLock())) {
                this.drawableHelper.invokeGL(this.drawable, (GLContext)this.context, (Runnable)this.disposeAction, null);
            } else {
                Threading.invokeOnOpenGLThread((Runnable)this.disposeOnEventDispatchThreadAction);
            }
        } else {
            this.drawableHelper.invokeGL(this.drawable, (GLContext)this.context, (Runnable)this.disposeAction, null);
        }
        if (DEBUG) {
            System.err.println("dispose(" + bl + ") - stop");
        }
    }

    public void destroy() {
        this.removeNotify();
    }

    public void paint(Graphics graphics) {
        if (Beans.isDesignTime()) {
            int n;
            graphics.setColor(Color.BLACK);
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            FontMetrics fontMetrics = graphics.getFontMetrics();
            String string = this.getName();
            if (string == null && (n = (string = this.getClass().getName()).lastIndexOf(46)) >= 0) {
                string = string.substring(n + 1);
            }
            Rectangle2D rectangle2D = fontMetrics.getStringBounds(string, graphics);
            graphics.setColor(Color.WHITE);
            graphics.drawString(string, (int)(((double)this.getWidth() - rectangle2D.getWidth()) / 2.0), (int)(((double)this.getHeight() + rectangle2D.getHeight()) / 2.0));
            return;
        }
        this.display();
    }

    public void addNotify() {
        super.addNotify();
        if (!Beans.isDesignTime()) {
            Object object;
            this.disableBackgroundErase();
            if (null == this.device && null != (object = super.getGraphicsConfiguration())) {
                this.device = ((GraphicsConfiguration)object).getDevice();
            }
            this.awtConfig = GLCanvas.chooseGraphicsConfiguration(this.capabilities, this.chooser, this.device);
            if (DEBUG) {
                object = new Exception("Created Config: " + this.awtConfig);
                ((Throwable)object).printStackTrace();
            }
            if (null != this.awtConfig) {
                this.chosen = this.awtConfig.getGraphicsConfiguration();
            }
            if (null == this.awtConfig) {
                throw new GLException("Error: AWTGraphicsConfiguration is null");
            }
            this.drawable = GLDrawableFactory.getFactory((GLProfile)this.glProfile).createGLDrawable(NativeWindowFactory.getNativeWindow((Object)this, (AbstractGraphicsConfiguration)this.awtConfig));
            this.context = (GLContextImpl)this.drawable.createContext(this.shareWith);
            this.context.setSynchronized(true);
            if (DEBUG) {
                System.err.println("Created Drawable: " + this.drawable);
            }
            this.drawable.setRealized(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNotify() {
        if (DEBUG) {
            Exception exception = new Exception("removeNotify - start");
            exception.printStackTrace();
        }
        if (Beans.isDesignTime()) {
            super.removeNotify();
        } else {
            try {
                this.dispose(false);
            }
            finally {
                this.drawable = null;
                super.removeNotify();
            }
        }
        if (DEBUG) {
            System.out.println("removeNotify - end");
        }
    }

    public void reshape(int n, int n2, int n3, int n4) {
        super.reshape(n, n2, n3, n4);
        this.sendReshape = true;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void addGLEventListener(GLEventListener gLEventListener) {
        this.drawableHelper.addGLEventListener(gLEventListener);
    }

    public void removeGLEventListener(GLEventListener gLEventListener) {
        this.drawableHelper.removeGLEventListener(gLEventListener);
    }

    public void setContext(GLContext gLContext) {
        this.context = (GLContextImpl)gLContext;
    }

    public GLContext getContext() {
        return this.context;
    }

    public GL getGL() {
        if (Beans.isDesignTime()) {
            return null;
        }
        GLContext gLContext = this.getContext();
        return gLContext == null ? null : gLContext.getGL();
    }

    public GL setGL(GL gL) {
        GLContext gLContext = this.getContext();
        if (gLContext != null) {
            gLContext.setGL(gL);
            return gL;
        }
        return null;
    }

    public void setAutoSwapBufferMode(boolean bl) {
        this.drawableHelper.setAutoSwapBufferMode(bl);
    }

    public boolean getAutoSwapBufferMode() {
        return this.drawableHelper.getAutoSwapBufferMode();
    }

    public void swapBuffers() {
        this.maybeDoSingleThreadedWorkaround(this.swapBuffersOnEventDispatchThreadAction, this.swapBuffersAction);
    }

    public GLProfile getGLProfile() {
        return this.glProfile;
    }

    public GLCapabilities getChosenGLCapabilities() {
        if (this.awtConfig == null) {
            throw new GLException("No AWTGraphicsConfiguration: " + this);
        }
        return (GLCapabilities)this.awtConfig.getChosenCapabilities();
    }

    public GLCapabilities getRequestedGLCapabilities() {
        if (this.awtConfig == null) {
            throw new GLException("No AWTGraphicsConfiguration: " + this);
        }
        return (GLCapabilities)this.awtConfig.getRequestedCapabilities();
    }

    public NativeWindow getNativeWindow() {
        return this.drawable.getNativeWindow();
    }

    public GLDrawableFactory getFactory() {
        return this.drawable.getFactory();
    }

    public String toString() {
        return "AWT-GLCanvas[ " + this.awtConfig + ", " + (null != this.drawable ? this.drawable.getClass().getName() : "null-drawable") + ", " + this.drawableHelper + "]";
    }

    private void maybeDoSingleThreadedWorkaround(Runnable runnable, Runnable runnable2) {
        if (Threading.isSingleThreaded() && !Threading.isOpenGLThread()) {
            Threading.invokeOnOpenGLThread((Runnable)runnable);
        } else {
            this.drawableHelper.invokeGL(this.drawable, (GLContext)this.context, runnable2, (Runnable)this.initAction);
        }
    }

    private void disableBackgroundErase() {
        if (!disableBackgroundEraseInitialized) {
            try {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        try {
                            Class<?> clazz = GLCanvas.this.getToolkit().getClass();
                            while (clazz != null && disableBackgroundEraseMethod == null) {
                                try {
                                    disableBackgroundEraseMethod = clazz.getDeclaredMethod("disableBackgroundErase", class$java$awt$Canvas == null ? GLCanvas.class$("java.awt.Canvas") : class$java$awt$Canvas);
                                    disableBackgroundEraseMethod.setAccessible(true);
                                }
                                catch (Exception exception) {
                                    clazz = clazz.getSuperclass();
                                }
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        return null;
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
            disableBackgroundEraseInitialized = true;
        }
        if (disableBackgroundEraseMethod != null) {
            try {
                disableBackgroundEraseMethod.invoke((Object)this.getToolkit(), this);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static AWTGraphicsConfiguration chooseGraphicsConfiguration(GLCapabilities gLCapabilities, GLCapabilitiesChooser gLCapabilitiesChooser, GraphicsDevice graphicsDevice) {
        if (Beans.isDesignTime()) {
            return null;
        }
        AbstractGraphicsScreen abstractGraphicsScreen = AWTGraphicsScreen.createScreenDevice(graphicsDevice);
        AWTGraphicsConfiguration aWTGraphicsConfiguration = (AWTGraphicsConfiguration)GraphicsConfigurationFactory.getFactory((Class)AWTGraphicsDevice.class).chooseGraphicsConfiguration((Capabilities)gLCapabilities, (CapabilitiesChooser)gLCapabilitiesChooser, abstractGraphicsScreen);
        if (aWTGraphicsConfiguration == null) {
            throw new GLException("Error: Couldn't fetch AWTGraphicsConfiguration");
        }
        return aWTGraphicsConfiguration;
    }

    protected static interface DestroyMethod {
        public void destroyMethod();
    }

    class DisplayAction
    implements Runnable {
        DisplayAction() {
        }

        public void run() {
            if (GLCanvas.this.sendReshape) {
                int n = GLCanvas.this.getWidth();
                int n2 = GLCanvas.this.getHeight();
                GLCanvas.this.getGL().glViewport(0, 0, n, n2);
                GLCanvas.this.drawableHelper.reshape((GLAutoDrawable)GLCanvas.this, 0, 0, n, n2);
                GLCanvas.this.sendReshape = false;
            }
            GLCanvas.this.drawableHelper.display((GLAutoDrawable)GLCanvas.this);
        }
    }

    class DisplayOnEventDispatchThreadAction
    implements Runnable {
        DisplayOnEventDispatchThreadAction() {
        }

        public void run() {
            GLCanvas.this.drawableHelper.invokeGL(GLCanvas.this.drawable, (GLContext)GLCanvas.this.context, (Runnable)GLCanvas.this.displayAction, (Runnable)GLCanvas.this.initAction);
        }
    }

    class DisposeAction
    implements Runnable {
        private GLCanvas canvas;

        public DisposeAction(GLCanvas gLCanvas2) {
            this.canvas = gLCanvas2;
        }

        public void run() {
            GLCanvas.this.drawableHelper.dispose((GLAutoDrawable)GLCanvas.this);
            if (null != GLCanvas.this.context) {
                GLCanvas.this.context.makeCurrent();
                GLCanvas.this.context.destroy();
                GLCanvas.this.context = null;
            }
            if (null != GLCanvas.this.drawable) {
                GLCanvas.this.drawable.setRealized(false);
            }
            if (GLCanvas.this.disposeRegenerate) {
                GLCanvas.this.drawable = GLDrawableFactory.getFactory((GLProfile)GLCanvas.this.glProfile).createGLDrawable(NativeWindowFactory.getNativeWindow((Object)this.canvas, (AbstractGraphicsConfiguration)GLCanvas.this.awtConfig));
                if (DEBUG) {
                    System.err.println("GLCanvas.dispose(true): new drawable: " + GLCanvas.this.drawable);
                }
                GLCanvas.this.drawable.setRealized(true);
                GLCanvas.this.context = (GLContextImpl)GLCanvas.this.drawable.createContext(GLCanvas.this.shareWith);
                GLCanvas.this.context.setSynchronized(true);
                GLCanvas.this.sendReshape = true;
            }
        }
    }

    class DisposeOnEventDispatchThreadAction
    implements Runnable {
        DisposeOnEventDispatchThreadAction() {
        }

        public void run() {
            GLCanvas.this.drawableHelper.invokeGL(GLCanvas.this.drawable, (GLContext)GLCanvas.this.context, (Runnable)GLCanvas.this.disposeAction, null);
        }
    }

    class InitAction
    implements Runnable {
        InitAction() {
        }

        public void run() {
            GLCanvas.this.drawableHelper.init((GLAutoDrawable)GLCanvas.this);
        }
    }

    class SwapBuffersAction
    implements Runnable {
        SwapBuffersAction() {
        }

        public void run() {
            GLCanvas.this.drawable.swapBuffers();
        }
    }

    class SwapBuffersOnEventDispatchThreadAction
    implements Runnable {
        SwapBuffersOnEventDispatchThreadAction() {
        }

        public void run() {
            GLCanvas.this.drawableHelper.invokeGL(GLCanvas.this.drawable, (GLContext)GLCanvas.this.context, (Runnable)GLCanvas.this.swapBuffersAction, (Runnable)GLCanvas.this.initAction);
        }
    }
}

