/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.license;

import de.schlichtherle.license.KeyStoreParam;
import de.schlichtherle.license.LicenseNotary;
import de.schlichtherle.xml.GenericCertificate;
import de.schlichtherle.xml.PersistenceService;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class GenericCertificateTest
extends TestCase {
    protected static final KeyStoreParam keyStoreParam = new KeyStoreParam(){
        private static final String RESOURCE_NAME = "keystore";

        public InputStream getStream() throws IOException {
            InputStream in = this.getClass().getResourceAsStream(RESOURCE_NAME);
            if (in == null) {
                throw new FileNotFoundException(RESOURCE_NAME);
            }
            return in;
        }

        public String getAlias() {
            return "mykey";
        }

        public String getStorePwd() {
            return "test1234";
        }

        public String getKeyPwd() {
            return "test1234";
        }
    };
    protected final LicenseNotary notary = new LicenseNotary(keyStoreParam);
    protected GenericCertificate unsignedCert;
    protected GenericCertificate signedCert;
    protected final String content = "<signed content>";
    protected Listener listener;
    private static int staticCount;
    static /* synthetic */ Class class$0;

    public GenericCertificateTest(String testName) throws Exception {
        super(testName);
    }

    protected void setUp() throws Exception {
        this.listener = new Listener();
        this.unsignedCert = new GenericCertificate();
        this.unsignedCert.addPropertyChangeListener((PropertyChangeListener)this.listener);
        this.signedCert = this.notary.sign("<signed content>");
        this.signedCert.addPropertyChangeListener((PropertyChangeListener)this.listener);
    }

    protected void tearDown() throws Exception {
        this.signedCert.removePropertyChangeListener((PropertyChangeListener)this.listener);
        this.unsignedCert.removePropertyChangeListener((PropertyChangeListener)this.listener);
        this.listener = null;
        this.unsignedCert = null;
        this.signedCert = null;
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("de.schlichtherle.license.GenericCertificateTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestSuite suite = new TestSuite((Class)clazz);
        return suite;
    }

    public void testCopyConstructor() throws Exception {
        this.testCopy(this.unsignedCert, new GenericCertificate(this.unsignedCert));
        this.testCopy(this.signedCert, new GenericCertificate(this.signedCert));
    }

    public void testSign() throws Exception {
        GenericCertificate cert = new GenericCertificate();
        cert.addPropertyChangeListener((PropertyChangeListener)this.listener);
        VetoListener vetoer = new VetoListener();
        cert.addVetoableChangeListener((VetoableChangeListener)vetoer);
        try {
            this.notary.sign(cert, "<signed content>");
            GenericCertificateTest.fail((String)"Signing of certificate should have been vetoed!");
            return;
        }
        catch (PropertyVetoException propertyVetoException) {
            cert.removeVetoableChangeListener((VetoableChangeListener)vetoer);
            GenericCertificateTest.assertEquals((int)0, (int)this.listener.getCount());
            this.notary.sign(cert, null);
            GenericCertificateTest.assertNotNull((Object)cert.getEncoded());
            GenericCertificateTest.assertNotNull((Object)cert.getSignature());
            GenericCertificateTest.assertNotNull((Object)cert.getSignatureAlgorithm());
            GenericCertificateTest.assertNotNull((Object)cert.getSignatureEncoding());
            GenericCertificateTest.assertTrue((boolean)cert.isLocked());
            GenericCertificateTest.assertEquals((int)5, (int)this.listener.getCount());
            String actual = (String)cert.getContent();
            GenericCertificateTest.assertNull((Object)actual);
            try {
                this.notary.sign(cert, "<signed content>");
                GenericCertificateTest.fail((String)"Certificate has been signed twice!");
                return;
            }
            catch (Exception exception) {
                try {
                    this.notary.verify(cert);
                    GenericCertificateTest.fail((String)"A signed certificate has been redundantly verified!");
                    return;
                }
                catch (Exception exception2) {
                    try {
                        cert.setEncoded("<illegal encoding>");
                        GenericCertificateTest.fail((String)"Failed to detect attempt to compromise certificate integrity!");
                        return;
                    }
                    catch (Exception exception3) {
                        try {
                            cert.setSignature("<illegal signature>");
                            GenericCertificateTest.fail((String)"Failed to detect attempt to compromise certificate integrity!");
                            return;
                        }
                        catch (Exception exception4) {
                            try {
                                cert.setSignatureAlgorithm("<illegal algorithm>");
                                GenericCertificateTest.fail((String)"Failed to detect attempt to compromise certificate integrity!");
                                return;
                            }
                            catch (Exception exception5) {
                                try {
                                    cert.setSignatureEncoding("<illegal encoding>");
                                    GenericCertificateTest.fail((String)"Failed to detect attempt to compromise certificate integrity!");
                                    return;
                                }
                                catch (Exception exception6) {
                                    return;
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    public void testVerify() throws Exception {
        GenericCertificate cert = new GenericCertificate(this.signedCert);
        cert.addPropertyChangeListener((PropertyChangeListener)this.listener);
        VetoListener vetoer = new VetoListener();
        cert.addVetoableChangeListener((VetoableChangeListener)vetoer);
        try {
            this.notary.verify(cert);
            GenericCertificateTest.fail((String)"Verifying of certificate should have been vetoed!");
            return;
        }
        catch (PropertyVetoException propertyVetoException) {
            cert.removeVetoableChangeListener((VetoableChangeListener)vetoer);
            GenericCertificateTest.assertEquals((int)0, (int)this.listener.getCount());
            this.notary.verify(cert);
            GenericCertificateTest.assertNotNull((Object)cert.getEncoded());
            GenericCertificateTest.assertNotNull((Object)cert.getSignature());
            GenericCertificateTest.assertNotNull((Object)cert.getSignatureAlgorithm());
            GenericCertificateTest.assertNotNull((Object)cert.getSignatureEncoding());
            GenericCertificateTest.assertTrue((boolean)cert.isLocked());
            GenericCertificateTest.assertEquals((int)1, (int)this.listener.getCount());
            String actual = (String)cert.getContent();
            GenericCertificateTest.assertNotNull((Object)actual);
            GenericCertificateTest.assertNotSame((Object)"<signed content>", (Object)actual);
            GenericCertificateTest.assertEquals((String)"<signed content>", (String)actual);
            try {
                this.notary.sign(cert, null);
                GenericCertificateTest.fail((String)"A verified certificate has been signed again!");
                return;
            }
            catch (Exception exception) {
                try {
                    this.notary.verify(cert);
                    GenericCertificateTest.fail((String)"Certificate has been verified twice!");
                    return;
                }
                catch (Exception exception2) {
                    try {
                        cert.setEncoded("<illegal encoding>");
                        GenericCertificateTest.fail((String)"Failed to detect attempt to compromise certificate integrity!");
                        return;
                    }
                    catch (Exception exception3) {
                        try {
                            cert.setSignature("<illegal signature>");
                            GenericCertificateTest.fail((String)"Failed to detect attempt to compromise certificate integrity!");
                            return;
                        }
                        catch (Exception exception4) {
                            try {
                                cert.setSignatureAlgorithm("<illegal algorithm>");
                                GenericCertificateTest.fail((String)"Failed to detect attempt to compromise certificate integrity!");
                                return;
                            }
                            catch (Exception exception5) {
                                try {
                                    cert.setSignatureEncoding("<illegal encoding>");
                                    GenericCertificateTest.fail((String)"Failed to detect attempt to compromise certificate integrity!");
                                    return;
                                }
                                catch (Exception exception6) {
                                    return;
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    public void testIsLocked() {
        GenericCertificateTest.assertFalse((boolean)this.unsignedCert.isLocked());
        GenericCertificateTest.assertTrue((boolean)this.signedCert.isLocked());
    }

    public void testGetContentClone() throws Exception {
        String clone1 = (String)this.signedCert.getContent();
        GenericCertificateTest.assertNotNull((Object)clone1);
        GenericCertificateTest.assertNotSame((Object)"<signed content>", (Object)clone1);
        GenericCertificateTest.assertEquals((String)"<signed content>", (String)clone1);
        String clone2 = (String)this.signedCert.getContent();
        GenericCertificateTest.assertNotNull((Object)clone2);
        GenericCertificateTest.assertNotSame((Object)"<signed content>", (Object)clone2);
        GenericCertificateTest.assertEquals((String)"<signed content>", (String)clone2);
        GenericCertificateTest.assertNotSame((Object)clone1, (Object)clone2);
        GenericCertificateTest.assertEquals((String)clone1, (String)clone2);
        try {
            this.unsignedCert.getContent();
            GenericCertificateTest.fail((String)"An unsigned generic certificate returned a content clone!");
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void testGetEncoded() {
        GenericCertificateTest.assertNull((Object)this.unsignedCert.getEncoded());
        GenericCertificateTest.assertNotNull((Object)this.signedCert.getEncoded());
    }

    public void testSetEncoded() throws Exception {
        this.unsignedCert.setEncoded("<signed content>");
        try {
            this.signedCert.setEncoded("<signed content>");
            GenericCertificateTest.fail((String)"Property change should have been vetoed!");
            return;
        }
        catch (PropertyVetoException propertyVetoException) {
            return;
        }
    }

    public void testGetSignature() {
        GenericCertificateTest.assertNull((Object)this.unsignedCert.getSignature());
        GenericCertificateTest.assertNotNull((Object)this.signedCert.getSignature());
    }

    public void testSetSignature() throws Exception {
        this.unsignedCert.setSignature("<signed content>");
        try {
            this.signedCert.setSignature("<signed content>");
            GenericCertificateTest.fail((String)"Property change should have been vetoed!");
            return;
        }
        catch (PropertyVetoException propertyVetoException) {
            return;
        }
    }

    public void testGetSignatureAlgorithm() {
        GenericCertificateTest.assertNull((Object)this.unsignedCert.getSignatureAlgorithm());
        GenericCertificateTest.assertNotNull((Object)this.signedCert.getSignatureAlgorithm());
    }

    public void testSetSignatureAlgorithm() throws Exception {
        this.unsignedCert.setSignatureAlgorithm("<signed content>");
        try {
            this.signedCert.setSignatureAlgorithm("<signed content>");
            GenericCertificateTest.fail((String)"Property change should have been vetoed!");
            return;
        }
        catch (PropertyVetoException propertyVetoException) {
            return;
        }
    }

    public void testGetSignatureEncoding() {
        GenericCertificateTest.assertNull((Object)this.unsignedCert.getSignatureEncoding());
        GenericCertificateTest.assertNotNull((Object)this.signedCert.getSignatureEncoding());
    }

    public void testSetSignatureEncoding() throws Exception {
        this.unsignedCert.setSignatureEncoding("<signed content>");
        try {
            this.signedCert.setSignatureEncoding("<signed content>");
            GenericCertificateTest.fail((String)"Property change should have been vetoed!");
            return;
        }
        catch (PropertyVetoException propertyVetoException) {
            return;
        }
    }

    public void testPropertyChangeListener() throws Exception {
        this.unsignedCert.removePropertyChangeListener((PropertyChangeListener)this.listener);
        this.unsignedCert.setEncoded("<another illegal encoding>");
        GenericCertificateTest.assertEquals((int)0, (int)this.listener.getCount());
    }

    public synchronized void testObjectStreamPersistence() throws Exception {
        this.testObjectStreamPersistence(this.unsignedCert);
        this.testObjectStreamPersistence(this.signedCert);
    }

    public synchronized void testObjectStreamPersistence(GenericCertificate cert) throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(cert);
        oos.close();
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(bos.toByteArray()));
        GenericCertificate cert2 = (GenericCertificate)ois.readObject();
        ois.close();
        this.testCopy(cert, cert2);
    }

    public synchronized void testXMLPersistence() throws Exception {
        this.testXMLPersistence(this.unsignedCert);
        this.testXMLPersistence(this.signedCert);
    }

    public synchronized void testXMLPersistence(GenericCertificate cert) throws Exception {
        byte[] buf = PersistenceService.store2ByteArray((Object)cert);
        GenericCertificate cert2 = (GenericCertificate)PersistenceService.load((byte[])buf);
        this.testCopy(cert, cert2);
    }

    protected synchronized void testCopy(GenericCertificate original, GenericCertificate copy) throws Exception {
        GenericCertificateTest.assertFalse((boolean)copy.isLocked());
        original.addVetoableChangeListener((VetoableChangeListener)new VetoListener());
        this.listener.resetStaticCount();
        if (original.isLocked()) {
            this.notary.verify(copy);
            this.assertEqualsButNotSame(original, copy);
            GenericCertificateTest.assertEquals((int)0, (int)this.listener.getStaticCount());
        } else {
            this.assertEqualsButNotSame(original, copy);
            original.setEncoded("x" + original.getEncoded());
            copy.setEncoded("x" + copy.getEncoded());
            GenericCertificateTest.assertEquals((int)1, (int)this.listener.getStaticCount());
        }
        try {
            this.notary.sign(original, "<signed content>");
            GenericCertificateTest.fail((String)"Signed an either locked or vetoed certificate!");
            return;
        }
        catch (PropertyVetoException propertyVetoException) {
            return;
        }
    }

    protected void assertEqualsButNotSame(GenericCertificate expected, GenericCertificate actual) throws Exception {
        GenericCertificateTest.assertNotNull((Object)expected);
        GenericCertificateTest.assertNotNull((Object)actual);
        GenericCertificateTest.assertNotSame((Object)expected, (Object)actual);
        this.assertNullOrEquals(expected.getEncoded(), actual.getEncoded());
        this.assertNullOrEquals(expected.getSignature(), actual.getSignature());
        this.assertNullOrEquals(expected.getSignatureAlgorithm(), actual.getSignatureAlgorithm());
        this.assertNullOrEquals(expected.getSignatureEncoding(), actual.getSignatureEncoding());
        GenericCertificateTest.assertEquals((boolean)expected.isLocked(), (boolean)actual.isLocked());
        if (expected.isLocked()) {
            GenericCertificateTest.assertEquals((Object)expected.getContent(), (Object)actual.getContent());
        }
    }

    protected final void assertNullOrEquals(Object expected, Object actual) {
        if (expected != null || actual != null) {
            GenericCertificateTest.assertEquals((Object)expected, (Object)actual);
        }
    }

    protected class Listener
    implements PropertyChangeListener {
        private int count;

        protected Listener() {
        }

        public int getCount() {
            return this.count;
        }

        public int getStaticCount() {
            return staticCount;
        }

        public void resetStaticCount() {
            staticCount = 0;
        }

        public synchronized void propertyChange(PropertyChangeEvent evt) {
            GenericCertificateTest.assertNotNull((Object)evt);
            GenericCertificateTest.assertTrue((boolean)(evt.getSource() instanceof GenericCertificate));
            ++this.count;
            staticCount = staticCount + 1;
        }
    }

    protected class VetoListener
    implements VetoableChangeListener {
        protected VetoListener() {
        }

        public synchronized void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
            throw new PropertyVetoException("Why? Just for testing!", evt);
        }
    }
}

