/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.util;

import de.schlichtherle.util.ObfuscatedString;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junit.framework.TestCase;

public class ObfuscatedStringTest
extends TestCase {
    public ObfuscatedStringTest(String testName) {
        super(testName);
    }

    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
    }

    public void testRoundTripConversion() {
        String text = "Hello world!";
        String result = ObfuscatedString.obfuscate("Hello world!");
        Pattern pattern = Pattern.compile("^\\Qnew ObfuscatedString(new long[] {\\E(.*)\\Q}).toString() /* => \"Hello world!\" */\\E$", 32);
        Matcher matcher = pattern.matcher(result);
        ObfuscatedStringTest.assertTrue((boolean)matcher.matches());
        String[] es = matcher.group(1).split("\\s*,\\s*");
        long[] el = new long[es.length];
        int i = 0;
        while (i < el.length) {
            String s = es[i].toUpperCase();
            ObfuscatedStringTest.assertTrue((boolean)s.startsWith("0X"));
            ObfuscatedStringTest.assertTrue((boolean)s.endsWith("L"));
            String n = s.substring(2, s.length() - 1);
            el[i] = ObfuscatedStringTest.parseLong(n);
            ++i;
        }
        ObfuscatedStringTest.assertEquals((String)"Hello world!", (String)new ObfuscatedString(el).toString());
    }

    private static long parseLong(String s) throws NumberFormatException {
        int l = s.length();
        if (l > 16) {
            throw new NumberFormatException(s);
        }
        long result = 0L;
        int i = 0;
        while (i < l) {
            int digit = Character.digit(s.charAt(i), 16);
            if (digit < 0 || digit >= 16) {
                throw new NumberFormatException("For input string: \"" + s + "\"");
            }
            result *= 16L;
            result += (long)digit;
            ++i;
        }
        return result;
    }

    public void testToString() {
        ObfuscatedString instance = new ObfuscatedString(new long[]{4402674358599762654L, 2508255979409340499L, 5156161254026708151L});
        String expResult = "Hello world!";
        String result = instance.toString();
        ObfuscatedStringTest.assertEquals((String)expResult, (String)result);
    }
}

