/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.pensol;

import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.filter.ClientFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.WeakHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CookiesHandlerFilter
extends ClientFilter {
    private static final Log logger = LogFactory.getLog(CookiesHandlerFilter.class);
    private static WeakHashMap<String, List<Object>> cookiesByAuth = new WeakHashMap();

    private static synchronized List<Object> getCachedCookiesByAuthToken(String authToken) {
        return cookiesByAuth.get(authToken);
    }

    private static synchronized void setCookiesByAuthToken(String authToken, List<Object> cookiesList) {
        cookiesByAuth.put(authToken, cookiesList);
    }

    public ClientResponse handle(ClientRequest request) throws ClientHandlerException {
        ClientResponse response;
        List authorizationHeader = (List)request.getHeaders().get((Object)"Authorization");
        String authToken = (String)authorizationHeader.get(0);
        List<Object> cookiesList = CookiesHandlerFilter.getCachedCookiesByAuthToken(authToken);
        if (cookiesList != null) {
            request.getHeaders().put((Object)"Cookie", cookiesList);
            request.getHeaders().remove((Object)"Authorization");
        }
        if ((response = this.getNext().handle(request)).getStatus() == 401) {
            logger.warn((Object)("Request to" + request.getURI() + "returned Unauthorized."));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("http status=" + response.getStatus() + " response=" + (String)response.getEntity(String.class)));
            }
            request.getHeaders().remove((Object)"Cookie");
            request.getHeaders().put((Object)"Authorization", (Object)authorizationHeader);
            logger.warn((Object)"Trying one more time");
            response = this.getNext().handle(request);
            if (response.getStatus() == 401) {
                logger.error((Object)("Request to" + request.getURI() + "returned Unauthorized 2nd time."));
                logger.error((Object)("http status=" + response.getStatus() + " response=" + (String)response.getEntity(String.class)));
            }
        }
        if (response.getCookies() != null && !response.getCookies().isEmpty()) {
            cookiesList = new ArrayList<Object>();
            cookiesList.addAll(response.getCookies());
            CookiesHandlerFilter.setCookiesByAuthToken(authToken, cookiesList);
        }
        return response;
    }
}

