/*
 * Decompiled with CFR 0.152.
 */
package com.uploadcare.api;

import com.uploadcare.api.Client;
import com.uploadcare.data.FileData;
import com.uploadcare.urls.CdnPathBuilder;
import java.net.URI;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class File {
    private final Client client;
    private final FileData fileData;

    File(Client client, FileData fileData) {
        this.client = client;
        this.fileData = fileData;
    }

    public String getFileId() {
        return this.fileData.uuid;
    }

    public boolean isStored() {
        return this.fileData.datetimeStored != null;
    }

    public String getMimeType() {
        return this.fileData.mimeType;
    }

    public boolean hasOriginalFileUrl() {
        return this.fileData.originalFileUrl != null;
    }

    public URI getOriginalFileUrl() {
        return this.fileData.originalFileUrl;
    }

    public String getOriginalFilename() {
        return this.fileData.originalFilename;
    }

    public boolean isRemoved() {
        return this.fileData.datetimeRemoved != null;
    }

    public Date getRemoved() {
        return this.fileData.datetimeRemoved;
    }

    public int getSize() {
        return this.fileData.size;
    }

    public Date getUploadDate() {
        return this.fileData.datetimeUploaded;
    }

    public Date getStoredDate() {
        return this.fileData.datetimeStored;
    }

    public Date getRemovedDate() {
        return this.fileData.datetimeRemoved;
    }

    public String getSource() {
        return this.fileData.source;
    }

    public boolean isReady() {
        return this.fileData.isReady;
    }

    public boolean isImage() {
        return this.fileData.isImage;
    }

    public ImageInfo getImageInfo() {
        return this.fileData.imageInfo;
    }

    public VideoInfo getVideoInfo() {
        return this.fileData.videoInfo;
    }

    public Map<String, Float> getRekognitionInfo() {
        return this.fileData.rekognitionInfo;
    }

    public Map<String, String> getVariations() {
        return this.fileData.variations;
    }

    public URI getUrl() {
        return this.fileData.url;
    }

    public File update() {
        return this.client.getFile(this.fileData.uuid);
    }

    public File delete() {
        this.client.deleteFile(this.fileData.uuid);
        return this.update();
    }

    public File save() {
        this.client.saveFile(this.fileData.uuid);
        return this.update();
    }

    public CdnPathBuilder cdnPath() {
        return new CdnPathBuilder(this);
    }

    public String toString() {
        return "File{fileData=" + this.fileData + '}';
    }

    public static enum ColorMode {
        RGB,
        RGBA,
        RGBa,
        RGBX,
        L,
        LA,
        La,
        P,
        PA,
        CMYK,
        YCbCr,
        HSV,
        LAB;

    }

    public static class Video {
        public int bitrate;
        public String codec;
        public int height;
        public int width;
        public float frameRate;

        public String toString() {
            return "Video{bitrate=" + this.bitrate + ", codec='" + this.codec + '\'' + ", height=" + this.height + ", width=" + this.width + ", frameRate=" + this.frameRate + '}';
        }
    }

    public static class Audio {
        public int bitrate;
        public String codec;
        public String channels;
        public int sampleRate;

        public String toString() {
            return "Audio{bitrate=" + this.bitrate + ", codec='" + this.codec + '\'' + ", channels='" + this.channels + '\'' + ", sampleRate=" + this.sampleRate + '}';
        }
    }

    public static class GeoLocation {
        public float latitude;
        public float longitude;

        public String toString() {
            return "GeoLocation{latitude=" + this.latitude + ", longitude=" + this.longitude + '}';
        }
    }

    public static class VideoInfo {
        public String format;
        public int duration;
        public int bitrate;
        public Audio audio;
        public Video video;

        public String toString() {
            return "VideoInfo{format='" + this.format + '\'' + ", duration=" + this.duration + ", bitrate=" + this.bitrate + ", audio=" + this.audio + ", video=" + this.video + '}';
        }
    }

    public static class ImageInfo {
        public String format;
        public int height;
        public int width;
        public int orientation;
        public boolean sequence;
        public ColorMode colorMode;
        public GeoLocation geoLocation;
        public List<Float> dpi;
        public Date datetimeOriginal;

        public String toString() {
            return "ImageInfo{format='" + this.format + '\'' + ", height=" + this.height + ", width=" + this.width + ", orientation=" + this.orientation + ", sequence=" + this.sequence + ", colorMode=" + (Object)((Object)this.colorMode) + ", geoLocation=" + this.geoLocation + ", dpi=" + this.dpi + ", datetimeOriginal=" + this.datetimeOriginal + '}';
        }
    }
}

