/*
 * Decompiled with CFR 0.152.
 */
package com.uploadcare.api;

import com.uploadcare.api.Client;
import com.uploadcare.api.File;
import com.uploadcare.api.FileDataWrapper;
import com.uploadcare.api.PaginatedQueryBuilder;
import com.uploadcare.api.RequestHelper;
import com.uploadcare.data.FilePageData;
import com.uploadcare.urls.AddFieldsParameter;
import com.uploadcare.urls.FilesFromParameter;
import com.uploadcare.urls.FilesOrderParameter;
import com.uploadcare.urls.FilesRemovedParameter;
import com.uploadcare.urls.FilesStoredParameter;
import com.uploadcare.urls.UrlParameter;
import com.uploadcare.urls.Urls;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class FilesQueryBuilder
implements PaginatedQueryBuilder<File> {
    private final Client client;
    private final HashMap<String, UrlParameter> parameters = new HashMap();

    public FilesQueryBuilder(Client client) {
        this.client = client;
    }

    public FilesQueryBuilder removed(boolean removed) {
        this.parameters.put("removed", new FilesRemovedParameter(removed));
        return this;
    }

    public FilesQueryBuilder stored(boolean stored) {
        this.parameters.put("stored", new FilesStoredParameter(stored));
        return this;
    }

    public FilesQueryBuilder from(Date fromDate) {
        this.parameters.put("ordering", new FilesOrderParameter(UrlParameter.Order.UPLOAD_TIME_ASC));
        this.parameters.put("from", new FilesFromParameter(fromDate));
        return this;
    }

    public FilesQueryBuilder from(Long fromSize) {
        this.parameters.put("ordering", new FilesOrderParameter(UrlParameter.Order.SIZE_ASC));
        this.parameters.put("from", new FilesFromParameter(fromSize));
        return this;
    }

    public FilesQueryBuilder to(Date toDate) {
        this.parameters.put("ordering", new FilesOrderParameter(UrlParameter.Order.UPLOAD_TIME_DESC));
        this.parameters.put("from", new FilesFromParameter(toDate));
        return this;
    }

    public FilesQueryBuilder to(Long toSize) {
        this.parameters.put("ordering", new FilesOrderParameter(UrlParameter.Order.SIZE_DESC));
        this.parameters.put("from", new FilesFromParameter(toSize));
        return this;
    }

    public FilesQueryBuilder ordering(UrlParameter.Order order) {
        this.parameters.put("ordering", new FilesOrderParameter(order));
        this.parameters.remove("from");
        return this;
    }

    public FilesQueryBuilder addFields(String fields) {
        this.parameters.put("add_fields", new AddFieldsParameter(fields));
        return this;
    }

    @Override
    public Iterable<File> asIterable() {
        URI url = Urls.apiFiles();
        RequestHelper requestHelper = this.client.getRequestHelper();
        FileDataWrapper dataWrapper = new FileDataWrapper(this.client);
        return requestHelper.executePaginatedQuery(url, this.parameters.values(), true, FilePageData.class, dataWrapper);
    }

    @Override
    public List<File> asList() {
        ArrayList<File> files = new ArrayList<File>();
        for (File file : this.asIterable()) {
            files.add(file);
        }
        return files;
    }
}

