/*
 * Decompiled with CFR 0.152.
 */
package com.uploadcare.api;

import com.uploadcare.api.Client;
import com.uploadcare.api.File;
import com.uploadcare.api.FileDataWrapper;
import com.uploadcare.data.FileData;
import com.uploadcare.data.GroupData;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class Group {
    private final Client client;
    private final GroupData groupData;

    public Group(Client client, GroupData groupData) {
        this.client = client;
        this.groupData = groupData;
    }

    public String getId() {
        return this.groupData.id;
    }

    public URI getUrl() {
        return this.groupData.url;
    }

    public Date getCreateDate() {
        return this.groupData.datetimeCreated;
    }

    public Date getStoreDate() {
        return this.groupData.datetimeStored;
    }

    public int getFileCount() {
        return this.groupData.filesCount;
    }

    public URI getCdnUrl() {
        return this.groupData.cdnUrl;
    }

    public List<File> getFiles() {
        FileDataWrapper dataWrapper = new FileDataWrapper(this.client);
        ArrayList<File> files = new ArrayList<File>();
        for (FileData fileData : this.groupData.files) {
            files.add(dataWrapper.wrap(fileData));
        }
        return files;
    }

    public Group save() {
        this.client.saveGroup(this.getId());
        return this.client.getGroup(this.getId());
    }

    public String toString() {
        return "Group{groupData=" + this.groupData + '}';
    }
}

