/*
 * Decompiled with CFR 0.152.
 */
package com.uploadcare.api;

import com.uploadcare.api.Client;
import com.uploadcare.data.ProjectData;
import java.util.ArrayList;
import java.util.List;

public class Project {
    private final Client client;
    private final ProjectData projectData;

    public Project(Client client, ProjectData projectData) {
        this.client = client;
        this.projectData = projectData;
    }

    public String getName() {
        return this.projectData.name;
    }

    public String getPubKey() {
        return this.projectData.pubKey;
    }

    public Collaborator getOwner() {
        if (this.projectData.collaborators.size() > 0) {
            return new Collaborator(this.projectData.collaborators.get(0));
        }
        return null;
    }

    public List<Collaborator> getCollaborators() {
        ArrayList<Collaborator> collaborators = new ArrayList<Collaborator>(this.projectData.collaborators.size());
        for (ProjectData.CollaboratorData collaboratorData : this.projectData.collaborators) {
            collaborators.add(new Collaborator(collaboratorData));
        }
        return collaborators;
    }

    public String toString() {
        return "Project{projectData=" + this.projectData + '}';
    }

    public static class Collaborator {
        private final ProjectData.CollaboratorData collaboratorData;

        private Collaborator(ProjectData.CollaboratorData collaboratorData) {
            this.collaboratorData = collaboratorData;
        }

        public String getName() {
            return this.collaboratorData.name;
        }

        public String getEmail() {
            return this.collaboratorData.email;
        }

        public String toString() {
            return "Collaborator{collaboratorData=" + this.collaboratorData + '}';
        }
    }
}

