/*
 * Decompiled with CFR 0.152.
 */
package com.uploadcare.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.uploadcare.api.Client;
import com.uploadcare.data.DataWrapper;
import com.uploadcare.data.PageData;
import com.uploadcare.exceptions.UploadcareApiException;
import com.uploadcare.exceptions.UploadcareAuthenticationException;
import com.uploadcare.exceptions.UploadcareInvalidRequestException;
import com.uploadcare.exceptions.UploadcareNetworkException;
import com.uploadcare.urls.UrlParameter;
import com.uploadcare.urls.UrlUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.Locale;
import java.util.Scanner;
import java.util.TimeZone;
import javax.activation.MimetypesFileTypeMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.util.EntityUtils;

public class RequestHelper {
    private final Client client;
    public static final String LIBRARY_VERSION = "3.4.0";
    public static final String DATE_FORMAT = "EEE, dd MMM yyyy HH:mm:ss Z";
    public static final String DATE_FORMAT_ISO_8601 = "yyyy-MM-dd'T'HH:mm:ss";
    public static final TimeZone UTC = TimeZone.getTimeZone("UTC");
    public static final TimeZone GMT = TimeZone.getTimeZone("GMT");
    private static final String EMPTY_MD5 = DigestUtils.md5Hex((String)"");
    private static final String JSON_CONTENT_TYPE = "application/json";
    private static final String MAC_ALGORITHM = "HmacSHA1";

    RequestHelper(Client client) {
        this.client = client;
    }

    public static String rfc2822(Date date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT, Locale.US);
        dateFormat.setTimeZone(GMT);
        return dateFormat.format(date);
    }

    public static String iso8601(Date date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT_ISO_8601, Locale.US);
        dateFormat.setTimeZone(UTC);
        return dateFormat.format(date);
    }

    public static String getMimeType(String fileName) {
        MimetypesFileTypeMap fileTypeMap = new MimetypesFileTypeMap();
        return fileTypeMap.getContentType(fileName);
    }

    public String makeSignature(HttpUriRequest request, String date, String requestBodyMD5) throws NoSuchAlgorithmException, InvalidKeyException {
        if (requestBodyMD5 == null) {
            requestBodyMD5 = EMPTY_MD5;
        }
        StringBuilder sb = new StringBuilder();
        String uriWithoutBase = request.getURI().getRawPath();
        String query = request.getURI().getRawQuery();
        if (query != null) {
            uriWithoutBase = uriWithoutBase + String.format("?%s", query);
        }
        sb.append(request.getMethod()).append("\n").append(requestBodyMD5).append("\n").append(JSON_CONTENT_TYPE).append("\n").append(date).append("\n").append(uriWithoutBase);
        if (this.client.getSecretKey() == null) {
            throw new UploadcareAuthenticationException("Secret key is required for this request.");
        }
        byte[] secretKeyBytes = this.client.getSecretKey().getBytes();
        SecretKeySpec signingKey = new SecretKeySpec(secretKeyBytes, MAC_ALGORITHM);
        Mac mac = Mac.getInstance(MAC_ALGORITHM);
        mac.init(signingKey);
        byte[] hmacBytes = mac.doFinal(sb.toString().getBytes());
        return Hex.encodeHexString((byte[])hmacBytes);
    }

    public void setApiHeaders(HttpUriRequest request, String requestBodyMD5) {
        String authorization;
        GregorianCalendar calendar = new GregorianCalendar(GMT);
        String formattedDate = RequestHelper.rfc2822(calendar.getTime());
        request.addHeader("Content-Type", JSON_CONTENT_TYPE);
        request.setHeader("Accept", "application/vnd.uploadcare-v0.6+json");
        request.setHeader("Date", formattedDate);
        request.setHeader("User-Agent", String.format("javauploadcare/%s/%s", LIBRARY_VERSION, this.client.getPublicKey()));
        if (this.client.isSimpleAuth()) {
            authorization = "Uploadcare.Simple " + this.client.getPublicKey() + ":" + this.client.getSecretKey();
        } else {
            try {
                String signature = this.makeSignature(request, formattedDate, requestBodyMD5);
                authorization = "Uploadcare " + this.client.getPublicKey() + ":" + signature;
            }
            catch (GeneralSecurityException e) {
                throw new UploadcareApiException("Error when signing the request", e);
            }
        }
        request.setHeader("Authorization", authorization);
    }

    public <T> T executeQuery(HttpUriRequest request, boolean apiHeaders, Class<T> dataClass) {
        return this.executeQuery(request, apiHeaders, dataClass, null);
    }

    public <T> T executeQuery(HttpUriRequest request, boolean apiHeaders, TypeReference<T> dataType) {
        return this.executeQuery(request, apiHeaders, dataType, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T executeQuery(HttpUriRequest request, boolean apiHeaders, Class<T> dataClass, String requestBodyMD5) {
        if (apiHeaders) {
            this.setApiHeaders(request, requestBodyMD5);
        }
        try {
            this.checkResponseStatus((HttpResponse)response);
            try (CloseableHttpResponse response = this.client.getHttpClient().execute(request);){
                HttpEntity entity = response.getEntity();
                String data = EntityUtils.toString((HttpEntity)entity);
                Object object = this.client.getObjectMapper().readValue(data, dataClass);
                return (T)object;
            }
        }
        catch (IOException e) {
            throw new UploadcareNetworkException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T executeQuery(HttpUriRequest request, boolean apiHeaders, TypeReference<T> dataType, String requestBodyMD5) {
        if (apiHeaders) {
            this.setApiHeaders(request, requestBodyMD5);
        }
        try {
            this.checkResponseStatus((HttpResponse)response);
            try (CloseableHttpResponse response = this.client.getHttpClient().execute(request);){
                HttpEntity entity = response.getEntity();
                String data = EntityUtils.toString((HttpEntity)entity);
                Object object = this.client.getObjectMapper().readValue(data, dataType);
                return (T)object;
            }
        }
        catch (IOException e) {
            throw new UploadcareNetworkException(e);
        }
    }

    public static void setQueryParameters(URIBuilder builder, Collection<UrlParameter> parameters) {
        for (UrlParameter parameter : parameters) {
            builder.setParameter(parameter.getParam(), parameter.getValue());
        }
    }

    public <T, U> Iterable<T> executePaginatedQuery(final URI url, final Collection<UrlParameter> urlParameters, final boolean apiHeaders, final Class<? extends PageData<U>> dataClass, final DataWrapper<T, U> dataWrapper) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new Iterator<T>(){
                    private URI next = null;
                    private boolean more;
                    private Iterator<U> pageIterator;
                    {
                        this.getNext();
                    }

                    private void getNext() {
                        URI pageUrl;
                        if (this.next == null) {
                            URIBuilder builder = new URIBuilder(url);
                            RequestHelper.setQueryParameters(builder, urlParameters);
                            pageUrl = UrlUtils.trustedBuild(builder);
                        } else {
                            pageUrl = this.next;
                        }
                        PageData pageData = (PageData)RequestHelper.this.executeQuery((HttpUriRequest)new HttpGet(pageUrl), apiHeaders, dataClass);
                        this.more = pageData.hasMore();
                        this.next = pageData.getNext();
                        this.pageIterator = pageData.getResults().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        if (this.pageIterator.hasNext()) {
                            return true;
                        }
                        if (this.more) {
                            this.getNext();
                            return true;
                        }
                        return false;
                    }

                    @Override
                    public T next() {
                        return dataWrapper.wrap(this.pageIterator.next());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public HttpResponse executeCommand(HttpUriRequest request, boolean apiHeaders) {
        return this.executeCommand(request, apiHeaders, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpResponse executeCommand(HttpUriRequest request, boolean apiHeaders, String requestBodyMD5) {
        CloseableHttpResponse closeableHttpResponse;
        if (apiHeaders) {
            this.setApiHeaders(request, requestBodyMD5);
        }
        CloseableHttpResponse response = this.client.getHttpClient().execute(request);
        try {
            this.checkResponseStatus((HttpResponse)response);
            closeableHttpResponse = response;
        }
        catch (Throwable throwable) {
            try {
                response.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new UploadcareNetworkException(e);
            }
        }
        response.close();
        return closeableHttpResponse;
    }

    private void checkResponseStatus(HttpResponse response) throws IOException {
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode >= 200 && statusCode < 300) {
            return;
        }
        if (statusCode == 401 || statusCode == 403) {
            throw new UploadcareAuthenticationException(RequestHelper.streamToString(response.getEntity().getContent()));
        }
        if (statusCode == 400 || statusCode == 404) {
            throw new UploadcareInvalidRequestException(RequestHelper.streamToString(response.getEntity().getContent()));
        }
        if (statusCode == 429) {
            throw new UploadcareApiException(RequestHelper.streamToString(response.getEntity().getContent()));
        }
        throw new UploadcareApiException("Unknown exception during an API call, response:" + RequestHelper.streamToString(response.getEntity().getContent()));
    }

    private static String streamToString(InputStream is) {
        Scanner s = new Scanner(is, "UTF-8").useDelimiter("\\A");
        return s.hasNext() ? s.next() : "";
    }
}

