/*
 * Decompiled with CFR 0.152.
 */
package com.uploadcare.upload;

import com.uploadcare.api.Client;
import com.uploadcare.api.File;
import com.uploadcare.api.RequestHelper;
import com.uploadcare.data.UploadFromUrlData;
import com.uploadcare.data.UploadFromUrlStatusData;
import com.uploadcare.upload.UploadFailureException;
import com.uploadcare.upload.Uploader;
import com.uploadcare.urls.Urls;
import java.net.URI;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.util.TextUtils;

public class UrlUploader
implements Uploader {
    private final Client client;
    private final String sourceUrl;
    private String store = "auto";
    private String filename = null;
    private String checkURLDuplicates = null;
    private String saveURLDuplicates = null;
    private String signature = null;
    private String expire = null;
    private static final long DEFAULT_POLLING_INTERVAL = 500L;
    public static final int MAX_UPLOAD_STATUS_ATTEMPTS = 25;

    public UrlUploader(Client client, String sourceUrl) {
        this.client = client;
        this.sourceUrl = sourceUrl;
    }

    @Override
    public File upload() throws UploadFailureException {
        return this.upload(500L);
    }

    @Override
    public UrlUploader store(boolean store) {
        this.store = store ? String.valueOf(1) : String.valueOf(0);
        return this;
    }

    public UrlUploader checkDuplicates(boolean checkDuplicates) {
        this.checkURLDuplicates = checkDuplicates ? String.valueOf(1) : String.valueOf(0);
        return this;
    }

    public UrlUploader saveDuplicates(boolean saveDuplicates) {
        this.saveURLDuplicates = saveDuplicates ? String.valueOf(1) : String.valueOf(0);
        return this;
    }

    public UrlUploader fileName(String filename) {
        this.filename = filename;
        return this;
    }

    public UrlUploader signedUpload(String signature, String expire) {
        this.signature = signature;
        this.expire = expire;
        return this;
    }

    public File upload(long pollingInterval) throws UploadFailureException {
        block12: {
            UploadFromUrlStatusData data;
            MultipartEntityBuilder entityBuilder = MultipartEntityBuilder.create();
            entityBuilder.addTextBody("pub_key", this.client.getPublicKey());
            entityBuilder.addTextBody("source_url", this.sourceUrl);
            entityBuilder.addTextBody("store", this.store);
            if (this.filename != null) {
                entityBuilder.addTextBody("filename", this.filename);
            }
            if (this.checkURLDuplicates != null) {
                entityBuilder.addTextBody("check_URL_duplicates", this.checkURLDuplicates);
            }
            if (this.saveURLDuplicates != null) {
                entityBuilder.addTextBody("save_URL_duplicates", this.saveURLDuplicates);
            }
            if (!TextUtils.isEmpty((CharSequence)this.signature) && !TextUtils.isEmpty((CharSequence)this.expire)) {
                entityBuilder.addTextBody("signature", this.signature);
                entityBuilder.addTextBody("expire", this.expire);
            }
            URI uploadUrl = Urls.uploadFromUrl();
            HttpPost uploadRequest = new HttpPost(uploadUrl);
            uploadRequest.setEntity(entityBuilder.build());
            RequestHelper requestHelper = this.client.getRequestHelper();
            String token = requestHelper.executeQuery((HttpUriRequest)uploadRequest, (boolean)false, UploadFromUrlData.class).token;
            URI statusUrl = Urls.uploadFromUrlStatus(token);
            long waitTime = pollingInterval;
            int retries = 0;
            long progress = 0L;
            while (true) {
                this.sleep(waitTime);
                HttpGet request = new HttpGet(statusUrl);
                data = requestHelper.executeQuery((HttpUriRequest)request, false, UploadFromUrlStatusData.class);
                if (data.status.equals("success")) {
                    if (this.client.getSecretKey() != null) {
                        return this.client.getFile(data.fileId);
                    }
                    return this.client.getUploadedFile(data.fileId);
                }
                if (data.status.equals("progress")) {
                    long currentProgress = data.done * 100L / data.total;
                    if (retries < 25) {
                        if (currentProgress > progress) {
                            retries = 0;
                            waitTime = pollingInterval;
                            progress = currentProgress;
                            continue;
                        }
                        waitTime = UrlUploader.calculateTimeToWait(retries);
                        ++retries;
                        continue;
                    }
                    break block12;
                }
                if (data.status.equals("waiting") || data.status.equals("unknown")) {
                    if (retries < 25) {
                        waitTime = UrlUploader.calculateTimeToWait(retries);
                        ++retries;
                        continue;
                    }
                    break block12;
                }
                if (data.status.equals("error") || data.status.equals("failed")) break;
            }
            throw new UploadFailureException(data.error);
        }
        throw new UploadFailureException("Timeout");
    }

    private void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public static long calculateTimeToWait(int retryCount) {
        if (0 == retryCount) {
            return 500L;
        }
        return (long)Math.pow(2.0, retryCount) * 500L;
    }
}

