/*
 * Decompiled with CFR 0.152.
 */
package com.uploadcare.urls;

import com.uploadcare.api.File;
import java.awt.Color;

public class CdnPathBuilder {
    private final StringBuilder sb = new StringBuilder("/");

    public CdnPathBuilder(File file) {
        this.sb.append(file.getFileId());
    }

    private void dimensionGuard(int dim) {
        if (dim < 1 || dim > 2048) {
            throw new IllegalArgumentException("Dimensions must be in the range 1-2048");
        }
    }

    private void dimensionsGuard(int width, int height) {
        this.dimensionGuard(width);
        this.dimensionGuard(height);
        if (width > 634 && height > 634) {
            throw new IllegalArgumentException("At least one dimension must be less than 634");
        }
    }

    private String colorToHex(Color color) {
        String rgb = Integer.toHexString(color.getRGB());
        return rgb.substring(2);
    }

    public CdnPathBuilder crop(int width, int height) {
        this.dimensionsGuard(width, height);
        this.sb.append("/-/crop/").append(width).append("x").append(height);
        return this;
    }

    public CdnPathBuilder cropCenter(int width, int height) {
        this.dimensionsGuard(width, height);
        this.sb.append("/-/crop/").append(width).append("x").append(height).append("/center");
        return this;
    }

    public CdnPathBuilder cropColor(int width, int height, Color color) {
        this.dimensionsGuard(width, height);
        this.sb.append("/-/crop/").append(width).append("x").append(height).append("/").append(this.colorToHex(color));
        return this;
    }

    public CdnPathBuilder cropCenterColor(int width, int height, Color color) {
        this.dimensionsGuard(width, height);
        this.sb.append("/-/crop/").append(width).append("x").append(height).append("/center/").append(this.colorToHex(color));
        return this;
    }

    public CdnPathBuilder resizeWidth(int width) {
        this.dimensionGuard(width);
        this.sb.append("/-/resize/").append(width).append("x");
        return this;
    }

    public CdnPathBuilder resizeHeight(int height) {
        this.dimensionGuard(height);
        this.sb.append("/-/resize/x").append(height);
        return this;
    }

    public CdnPathBuilder resize(int width, int height) {
        this.dimensionsGuard(width, height);
        this.sb.append("/-/resize/").append(width).append("x").append(height);
        return this;
    }

    public CdnPathBuilder scaleCrop(int width, int height) {
        this.dimensionsGuard(width, height);
        this.sb.append("/-/scale_crop/").append(width).append("x").append(height);
        return this;
    }

    public CdnPathBuilder scaleCropCenter(int width, int height) {
        this.dimensionsGuard(width, height);
        this.sb.append("/-/scale_crop/").append(width).append("x").append(height).append("/center");
        return this;
    }

    public CdnPathBuilder flip() {
        this.sb.append("/-/flip");
        return this;
    }

    public CdnPathBuilder grayscale() {
        this.sb.append("/-/grayscale");
        return this;
    }

    public CdnPathBuilder invert() {
        this.sb.append("/-/invert");
        return this;
    }

    public CdnPathBuilder mirror() {
        this.sb.append("/-/mirror");
        return this;
    }

    public CdnPathBuilder blur() {
        this.sb.append("/-/blur");
        return this;
    }

    public CdnPathBuilder blur(int strength) {
        if (strength < 0 || strength > 5000) {
            strength = 10;
        }
        this.sb.append("/-/blur/").append(strength);
        return this;
    }

    public CdnPathBuilder sharp() {
        this.sb.append("/-/sharp");
        return this;
    }

    public CdnPathBuilder sharp(int strength) {
        if (strength < 0 || strength > 20) {
            strength = 5;
        }
        this.sb.append("/-/sharp/").append(strength);
        return this;
    }

    public CdnPathBuilder preview(int width, int height) {
        this.dimensionsGuard(width, height);
        this.sb.append("/-/preview/").append(width).append("x").append(height);
        return this;
    }

    public CdnPathBuilder format(ImageFormat format) {
        this.sb.append("/-/format/").append(format.toString());
        return this;
    }

    public CdnPathBuilder quality(ImageQuality quality) {
        this.sb.append("/-/quality/").append(quality.toString());
        return this;
    }

    public CdnPathBuilder detectFaces() {
        this.sb.append("/detect_faces");
        return this;
    }

    public String build() {
        return this.sb.append("/").toString();
    }

    public static enum ImageQuality {
        QUALITY_NORMAL{

            public String toString() {
                return "normal";
            }
        }
        ,
        QUALITY_BETTER{

            public String toString() {
                return "better";
            }
        }
        ,
        QUALITY_BEST{

            public String toString() {
                return "best";
            }
        }
        ,
        QUALITY_LIGHTER{

            public String toString() {
                return "lighter";
            }
        }
        ,
        QUALITY_LIGHTEST{

            public String toString() {
                return "lightest";
            }
        }
        ,
        QUALITY_SMART{

            public String toString() {
                return "smart";
            }
        }
        ,
        QUALITY_SMART_RETINA{

            public String toString() {
                return "smart_retina";
            }
        };

    }

    public static enum ImageFormat {
        FORMAT_JPEG{

            public String toString() {
                return "jpeg";
            }
        }
        ,
        FORMAT_PNG{

            public String toString() {
                return "png";
            }
        }
        ,
        FORMAT_WEBP{

            public String toString() {
                return "webp";
            }
        }
        ,
        FORMAT_AUTO{

            public String toString() {
                return "auto";
            }
        };

    }
}

