/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.openformula.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Locale;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import org.pentaho.openformula.ui.Messages;
import org.pentaho.reporting.libraries.formula.function.FunctionDescription;
import org.pentaho.reporting.libraries.formula.typing.Type;
import org.pentaho.reporting.libraries.formula.typing.TypeUtil;

public class FunctionInformationPanel
extends JPanel {
    private FunctionDescription selectedFunction;
    private JTextArea functionDescription;
    private JLabel functionReturnType;

    public FunctionInformationPanel() {
        JLabel returnLabel = new JLabel(Messages.getInstance().getString("FunctionInformationPanel.ReturnType"));
        Font f = new Font(returnLabel.getFont().getName(), 1, returnLabel.getFont().getSize());
        returnLabel.setFont(f);
        JLabel descLabel = new JLabel(Messages.getInstance().getString("FunctionInformationPanel.Description"));
        descLabel.setFont(f);
        this.functionDescription = new JTextArea();
        this.functionDescription.setEditable(false);
        this.functionDescription.setLineWrap(true);
        this.functionDescription.setRows(2);
        this.functionDescription.setBackground(this.getBackground());
        this.functionReturnType = new JLabel();
        this.functionReturnType.setFont(this.functionDescription.getFont());
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(2, 2, 2, 2);
        gbc.anchor = 18;
        this.add((Component)returnLabel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(2, 2, 2, 2);
        gbc.fill = 2;
        this.add((Component)this.functionReturnType, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.insets = new Insets(0, 2, 2, 2);
        gbc.anchor = 18;
        this.add((Component)descLabel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.anchor = 18;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(0, 2, 2, 2);
        gbc.fill = 1;
        this.add((Component)this.functionDescription, gbc);
        this.setPreferredSize(new Dimension(460, 60));
    }

    public FunctionDescription getSelectedFunction() {
        return this.selectedFunction;
    }

    public void setSelectedFunction(FunctionDescription selectedFunction) {
        this.selectedFunction = selectedFunction;
        if (selectedFunction == null) {
            this.functionDescription.setText("");
            this.functionReturnType.setText("");
        } else {
            this.functionDescription.setText(selectedFunction.getDescription(Locale.getDefault()));
            this.functionReturnType.setText(TypeUtil.getParameterType((Type)selectedFunction.getValueType(), (Locale)this.getLocale()));
        }
        this.repaint();
    }
}

