/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.openformula.ui;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.HashMap;
import javax.swing.Box;
import javax.swing.JPanel;
import javax.swing.event.EventListenerList;
import org.pentaho.openformula.ui.DefaultFunctionParameterEditor;
import org.pentaho.openformula.ui.FieldDefinition;
import org.pentaho.openformula.ui.FunctionParameterContext;
import org.pentaho.openformula.ui.FunctionParameterEditor;
import org.pentaho.openformula.ui.ParameterUpdateEvent;
import org.pentaho.openformula.ui.ParameterUpdateListener;
import org.pentaho.reporting.libraries.formula.function.FunctionDescription;

public class MultiplexFunctionParameterEditor
implements FunctionParameterEditor {
    private HashMap<String, FunctionParameterEditor> editors;
    private JPanel panel;
    private EventListenerList listeners;
    private FunctionParameterEditor activeEditor;
    private DefaultFunctionParameterEditor defaultEditor;
    private ParameterUpdateHandler parameterUpdateHandler = new ParameterUpdateHandler();
    private FieldDefinition[] fieldDefinitions;
    public static final FieldDefinition[] EMPTY_FIELDS = new FieldDefinition[0];
    private FunctionDescription selectedFunction;
    private int functionStartIndex;
    private JPanel rootPanel;

    public MultiplexFunctionParameterEditor() {
        this.listeners = new EventListenerList();
        this.fieldDefinitions = EMPTY_FIELDS;
        this.panel = new JPanel();
        this.panel.setLayout(new BorderLayout());
        this.rootPanel = new JPanel();
        this.rootPanel.setLayout(new CardLayout());
        this.rootPanel.add("2", this.panel);
        this.rootPanel.add("1", Box.createRigidArea(new Dimension(650, 250)));
        this.editors = new HashMap();
        this.defaultEditor = new DefaultFunctionParameterEditor();
    }

    @Override
    public void addParameterUpdateListener(ParameterUpdateListener parameterUpdateListener) {
        this.listeners.add(ParameterUpdateListener.class, parameterUpdateListener);
    }

    @Override
    public void removeParameterUpdateListener(ParameterUpdateListener parameterUpdateListener) {
        this.listeners.remove(ParameterUpdateListener.class, parameterUpdateListener);
    }

    @Override
    public Component getEditorComponent() {
        return this.rootPanel;
    }

    @Override
    public void setFields(FieldDefinition[] fieldDefinitions) {
        this.fieldDefinitions = (FieldDefinition[])fieldDefinitions.clone();
        if (this.defaultEditor != null) {
            this.defaultEditor.setFields(fieldDefinitions);
        }
        if (this.activeEditor != null) {
            this.activeEditor.setFields(fieldDefinitions);
        }
        for (FunctionParameterEditor functionParameterEditor : this.editors.values()) {
            functionParameterEditor.setFields(fieldDefinitions);
        }
    }

    public DefaultFunctionParameterEditor getDefaultEditor() {
        return this.defaultEditor;
    }

    @Override
    public void clearSelectedFunction() {
        if (this.activeEditor != null) {
            this.panel.removeAll();
            this.activeEditor.clearSelectedFunction();
            this.activeEditor.removeParameterUpdateListener(this.parameterUpdateHandler);
            this.activeEditor.setFields(EMPTY_FIELDS);
            this.activeEditor = null;
            this.selectedFunction = null;
            this.rootPanel.invalidate();
            this.rootPanel.revalidate();
            this.rootPanel.repaint();
        }
    }

    @Override
    public void setSelectedFunction(FunctionParameterContext context) {
        boolean switchParameterEditor;
        FunctionDescription fnDesc = context.getFunction();
        int functionStart = context.getFunctionInformation().getFunctionOffset();
        if (this.selectedFunction == null) {
            switchParameterEditor = true;
            context.setSwitchParameterEditor(true);
        } else {
            switchParameterEditor = context.isSwitchParameterEditor();
        }
        this.selectedFunction = fnDesc;
        this.functionStartIndex = functionStart;
        String name = fnDesc.getCanonicalName();
        if (this.activeEditor != null && switchParameterEditor) {
            this.activeEditor.removeParameterUpdateListener(this.parameterUpdateHandler);
        }
        this.activeEditor = this.getEditor(name);
        if (this.activeEditor == null) {
            this.activeEditor = this.defaultEditor;
        }
        if (switchParameterEditor) {
            this.panel.removeAll();
            this.panel.add(this.activeEditor.getEditorComponent());
            this.activeEditor.addParameterUpdateListener(this.parameterUpdateHandler);
            this.activeEditor.setFields((FieldDefinition[])this.fieldDefinitions.clone());
            this.activeEditor.setSelectedFunction(context);
            this.rootPanel.invalidate();
            this.rootPanel.revalidate();
            this.rootPanel.repaint();
        } else {
            this.activeEditor.setSelectedFunction(context);
        }
    }

    public void setEditor(String function, FunctionParameterEditor editor) {
        this.editors.put(function, editor);
    }

    public FunctionParameterEditor getEditor(String function) {
        return this.editors.get(function);
    }

    private class ParameterUpdateHandler
    implements ParameterUpdateListener {
        private ParameterUpdateHandler() {
        }

        @Override
        public void parameterUpdated(ParameterUpdateEvent event) {
            ParameterUpdateListener[] updateListeners = (ParameterUpdateListener[])MultiplexFunctionParameterEditor.this.listeners.getListeners(ParameterUpdateListener.class);
            for (int i = 0; i < updateListeners.length; ++i) {
                ParameterUpdateListener listener = updateListeners[i];
                listener.parameterUpdated(event);
            }
        }
    }
}

