/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.openformula.ui.table;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.EventObject;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.table.TableCellEditor;
import javax.swing.text.Document;
import org.pentaho.openformula.ui.FieldDefinition;
import org.pentaho.openformula.ui.FormulaEditorDialog;
import org.pentaho.openformula.ui.table.EditorMessages;
import org.pentaho.reporting.libraries.base.util.DebugLog;
import org.pentaho.reporting.libraries.designtime.swing.EllipsisButton;
import org.pentaho.reporting.libraries.designtime.swing.EmptyValueListCellRenderer;
import org.pentaho.reporting.libraries.designtime.swing.NonFilteringPlainDocument;
import org.pentaho.reporting.libraries.formula.DefaultFormulaContext;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.util.FormulaUtil;

public class FormulaFragmentCellEditor
extends JPanel
implements TableCellEditor {
    protected static final String POPUP_EDITOR = "popupEditor";
    protected static final FieldDefinition[] EMPTY_FIELDS = new FieldDefinition[0];
    private EventListenerList eventListenerList;
    private boolean nullable;
    private JButton ellipsisButton;
    private JComboBox comboBox;
    private transient Object originalValue;
    private volatile boolean filterEvents;
    private boolean formulaFragment;
    private FieldDefinition[] fields;
    private FormulaContext formulaContext;

    protected FormulaEditorDialog createEditorDialog() {
        Window windowAncestor = SwingUtilities.getWindowAncestor(this);
        if (windowAncestor instanceof Dialog) {
            return new FormulaEditorDialog((Dialog)windowAncestor);
        }
        if (windowAncestor instanceof Frame) {
            return new FormulaEditorDialog((Frame)windowAncestor);
        }
        return new FormulaEditorDialog();
    }

    public FormulaFragmentCellEditor() {
        BasicComboBoxEditor basicComboBoxEditor;
        Component editorComponent;
        this.setLayout(new BorderLayout());
        Action action = this.createExtendedEditorAction();
        this.eventListenerList = new EventListenerList();
        this.ellipsisButton = new EllipsisButton("...");
        this.ellipsisButton.addActionListener(action);
        this.comboBox = new JComboBox();
        ComboBoxEditor boxEditor = this.comboBox.getEditor();
        if (boxEditor instanceof BasicComboBoxEditor && (editorComponent = (basicComboBoxEditor = (BasicComboBoxEditor)boxEditor).getEditorComponent()) instanceof JTextField) {
            JTextField editorTextField = (JTextField)editorComponent;
            editorTextField.setDocument((Document)new NonFilteringPlainDocument());
        }
        this.comboBox.setRenderer(new EmptyValueListCellRenderer());
        this.comboBox.addActionListener(new SelectionAction());
        this.comboBox.getInputMap().put(KeyStroke.getKeyStroke(27, 0), new CancelAction());
        this.comboBox.getInputMap().put(EditorMessages.getInstance().getKeyStroke("AbstractStringValueCellEditor.Popup.Accelerator"), POPUP_EDITOR);
        this.comboBox.setBorder(BorderFactory.createEmptyBorder());
        this.comboBox.setEditable(true);
        this.add((Component)this.comboBox, "Center");
        this.add((Component)this.ellipsisButton, "East");
        this.formulaContext = new DefaultFormulaContext();
        this.nullable = false;
    }

    public boolean isFormulaFragment() {
        return this.formulaFragment;
    }

    public void setFormulaFragment(boolean formulaFragment) {
        this.formulaFragment = formulaFragment;
    }

    public FormulaContext getFormulaContext() {
        return this.formulaContext;
    }

    public void setFormulaContext(FormulaContext formulaContext) {
        this.formulaContext = formulaContext;
    }

    protected Action createExtendedEditorAction() {
        return new ExtendedEditorAction();
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        return this.create(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Component create(Object value) {
        try {
            this.filterEvents = true;
            DefaultComboBoxModel<String> comboBoxModel = new DefaultComboBoxModel<String>();
            FieldDefinition[] definitions = this.getFields();
            for (int i = 0; i < definitions.length; ++i) {
                FieldDefinition fieldDefinition = definitions[i];
                comboBoxModel.addElement("=" + FormulaUtil.quoteReference((String)fieldDefinition.getName()));
            }
            this.comboBox.setModel(comboBoxModel);
            this.comboBox.setRenderer(new EmptyValueListCellRenderer());
            this.comboBox.setEditable(true);
            this.add((Component)this.comboBox, "Center");
            this.add((Component)this.ellipsisButton, "East");
            this.comboBox.requestFocus();
            if (value == null) {
                this.comboBox.setSelectedItem(null);
            } else {
                String rawFormulaText = !this.isFormulaFragment() ? FormulaUtil.extractFormula((String)String.valueOf(value)) : String.valueOf(value);
                String formulaText = FormulaUtil.createEditorTextFromFormula((String)rawFormulaText, (FormulaContext)this.formulaContext);
                this.comboBox.setSelectedItem(formulaText);
            }
            this.originalValue = value;
            FormulaFragmentCellEditor formulaFragmentCellEditor = this;
            return formulaFragmentCellEditor;
        }
        finally {
            this.filterEvents = false;
        }
    }

    protected void configureEditorStyle(Font font, Color foreground, Color background) {
        this.comboBox.setFont(font);
        this.comboBox.setForeground(foreground);
        this.comboBox.setBackground(background);
    }

    protected JComboBox getComboBox() {
        return this.comboBox;
    }

    protected boolean isNullable() {
        return this.nullable;
    }

    protected void setNullable(boolean nullable) {
        this.nullable = nullable;
    }

    @Override
    public void requestFocus() {
        this.comboBox.requestFocus();
    }

    protected JButton getEllipsisButton() {
        return this.ellipsisButton;
    }

    @Override
    public Object getCellEditorValue() {
        Object selectedItem = this.comboBox.getSelectedItem();
        if ("".equals(selectedItem) || selectedItem == null) {
            return null;
        }
        String text = String.valueOf(selectedItem);
        if (text.startsWith("'")) {
            text = "=" + FormulaUtil.quoteString((String)text.substring(1));
        }
        if (this.isFormulaFragment()) {
            return FormulaUtil.createFormulaFromUIText((String)text);
        }
        return text;
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        return true;
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        return true;
    }

    @Override
    public boolean stopCellEditing() {
        try {
            this.comboBox.actionPerformed(new ActionEvent(this, 1001, this.comboBox.getActionCommand()));
            this.fireEditingStopped();
            return true;
        }
        catch (Exception e) {
            DebugLog.log((Object)"Exception caught while editing cell-value", (Throwable)e);
            this.fireEditingCanceled();
            return true;
        }
    }

    @Override
    public void cancelCellEditing() {
        try {
            this.filterEvents = true;
            this.comboBox.setSelectedItem(this.originalValue);
        }
        finally {
            this.filterEvents = false;
        }
        this.fireEditingCanceled();
    }

    protected void fireEditingCanceled() {
        CellEditorListener[] listeners = (CellEditorListener[])this.eventListenerList.getListeners(CellEditorListener.class);
        ChangeEvent event = new ChangeEvent(this);
        for (int i = 0; i < listeners.length; ++i) {
            CellEditorListener listener = listeners[i];
            listener.editingCanceled(event);
        }
    }

    protected void fireEditingStopped() {
        CellEditorListener[] listeners = (CellEditorListener[])this.eventListenerList.getListeners(CellEditorListener.class);
        ChangeEvent event = new ChangeEvent(this);
        for (int i = 0; i < listeners.length; ++i) {
            CellEditorListener listener = listeners[i];
            listener.editingStopped(event);
        }
    }

    @Override
    public void addCellEditorListener(CellEditorListener l) {
        this.eventListenerList.add(CellEditorListener.class, l);
    }

    @Override
    public void removeCellEditorListener(CellEditorListener l) {
        this.eventListenerList.remove(CellEditorListener.class, l);
    }

    public FieldDefinition[] getFields() {
        return this.fields;
    }

    public void setFields(FieldDefinition[] fields) {
        this.fields = fields;
    }

    protected class CancelAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            FormulaFragmentCellEditor.this.cancelCellEditing();
        }
    }

    protected class SelectionAction
    extends AbstractAction {
        public SelectionAction() {
            this.putValue("Name", EditorMessages.getInstance().getString("AbstractStringValueCellEditor.SelectValue"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (FormulaFragmentCellEditor.this.filterEvents) {
                return;
            }
            FormulaFragmentCellEditor.this.stopCellEditing();
        }
    }

    protected class ExtendedEditorAction
    extends AbstractAction {
        protected ExtendedEditorAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String originalFormula;
            JComboBox comboBox = FormulaFragmentCellEditor.this.getComboBox();
            FormulaEditorDialog editorDialog = FormulaFragmentCellEditor.this.createEditorDialog();
            String formula = editorDialog.editFormula(originalFormula = (String)comboBox.getSelectedItem(), FormulaFragmentCellEditor.this.getFields());
            if (formula != null) {
                comboBox.setSelectedItem(formula);
            }
            FormulaFragmentCellEditor.this.stopCellEditing();
        }
    }
}

