function doPlaySound(){
	try {    var snd = new Audio("data:audio/wav;base64,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");
   		snd.play(); 
	}catch (error) {
	}
	
}

function doVibrate(){
	try { 
		const canVibrate = window.navigator.vibrate;
		if (canVibrate) window.navigator.vibrate(200); 
	} catch (error) {
	}
}

function formatDate(date){
   
    var patternStr = 'yyyy-MM-dd HH:mm:ss:S';
   
    var day = date.getDate(),
        month = date.getMonth(),
        year = date.getFullYear(),
        hour = date.getHours(),
        minute = date.getMinutes(),
        second = date.getSeconds(),
        miliseconds = zeroPad(date.getMilliseconds(),3),
        HH = twoDigitPad(hour),
        mm = twoDigitPad(minute),
        ss = twoDigitPad(second),
        dd = twoDigitPad(day),
        M = month + 1,
        MM = twoDigitPad(M),
        yyyy = year + ""
    ;
    // checks to see if month name will be used
    patternStr = patternStr
      .replace('HH', HH)
      .replace('mm', mm)
      .replace('ss', ss)
      .replace('S', miliseconds)
      .replace('dd', dd)
      .replace('yyyy', yyyy)
      .replace('MM', MM)
  	  ;
    
    $.ajax('/set/time',   // request url
	{            
	 	async: false,
		success: function (data, status, xhr) {    // success callback function
					patternStr = data;
		},
		error: function(){
         	console.log("Error getting Time, use device time: "+patternStr);
    	},
		timeout: 2000 // sets timeout to 2 seconds
	});
   
    return patternStr.trim(); 
}

function twoDigitPad(num) {
    return num < 10 ? "0" + num : num;
}

function zeroPad(num, places) {
  var zero = places - num.toString().length + 1;
  return Array(+(zero > 0 && zero)).join("0") + num;
}

//wt

function addM3(){
	var m3count = parseInt(document.getElementById('m3count').value);
	var accvalue = parseFloat(document.getElementById('refscorevideo1').value.replace(',', '.'));
	
	if(accvalue > 0){
		var accvaluenew = (accvalue - 0.3).toFixed(1);
		if(accvaluenew < 0) document.getElementById('refscorevideo1').value = "0.0";
		else document.getElementById('refscorevideo1').value = (accvaluenew+"").replace(',', '.');
		document.getElementById('m3count').value = m3count + 1;
		if(document.getElementById('m3count').value > 0) document.getElementById('cm3').value = "+0.3("+document.getElementById('m3count').value+")";
		else document.getElementById('cm3').value = "+0.3";
	}
	
	document.getElementById("acctotal").innerHTML = document.getElementById('refscorevideo1').value;
	
	//doPlaySound();
	doVibrate();
}

function addM3_2(){
	var m3count = parseInt(document.getElementById('m3count_2').value);
	var accvalue = parseFloat(document.getElementById('refscorevideo1__2').value.replace(',', '.'));
	
	if(accvalue > 0){
		var accvaluenew = (accvalue - 0.3).toFixed(1);
		if(accvaluenew < 0) document.getElementById('refscorevideo1__2').value = "0.0";
		else document.getElementById('refscorevideo1__2').value = (accvaluenew+"").replace(',', '.');
		document.getElementById('m3count_2').value = m3count + 1;
		if(document.getElementById('m3count_2').value > 0) document.getElementById('cm3_2').value = "+0.3("+document.getElementById('m3count_2').value+")";
		else document.getElementById('cm3_2').value = "+0.3";
	}
	
	document.getElementById("acctotal_2").innerHTML = document.getElementById('refscorevideo1__2').value;
	
	//doPlaySound();
	doVibrate();
}

function addM1(){
	var m1count = parseInt(document.getElementById('m1count').value);
	var accvalue = parseFloat(document.getElementById('refscorevideo1').value.replace(',', '.'));
	
	if(accvalue > 0){
		var accvaluenew = (accvalue - 0.1).toFixed(1);
		if(accvaluenew < 0) document.getElementById('refscorevideo1').value = "0.0";
		else document.getElementById('refscorevideo1').value = (accvaluenew+"").replace(',', '.');
		document.getElementById('m1count').value = m1count + 1;
		if(document.getElementById('m1count').value > 0) document.getElementById('cm1').value = "+0.1("+document.getElementById('m1count').value+")";
		else document.getElementById('m1').value = "+0.1";
		
	}
	
	document.getElementById("acctotal").innerHTML = document.getElementById('refscorevideo1').value;
	
	//doPlaySound();
	doVibrate();
}

function addM1_2(){
	var m1count = parseInt(document.getElementById('m1count_2').value);
	var accvalue = parseFloat(document.getElementById('refscorevideo1__2').value.replace(',', '.'));
	
	if(accvalue > 0){
		var accvaluenew = (accvalue - 0.1).toFixed(1);
		if(accvaluenew < 0) document.getElementById('refscorevideo1__2').value = "0.0";
		else document.getElementById('refscorevideo1__2').value = (accvaluenew+"").replace(',', '.');
		document.getElementById('m1count_2').value = m1count + 1;
		if(document.getElementById('m1count_2').value > 0) document.getElementById('cm1_2').value = "+0.1("+document.getElementById('m1count_2').value+")";
		else document.getElementById('cm1_2').value = "+0.1";
		
	}
	
	document.getElementById("acctotal_2").innerHTML = document.getElementById('refscorevideo1__2').value;
	
	//doPlaySound();
	doVibrate();
}

function removeM3(){
	var m3count = parseInt(document.getElementById('m3count').value);
	var accvalue = parseFloat(document.getElementById('refscorevideo1').value.replace(',', '.'));
	
	if(m3count > 0){
		var accvaluenew = (accvalue + 0.3).toFixed(1);
		if(accvaluenew > 4) document.getElementById('refscorevideo1').value = "4.0";
		else document.getElementById('refscorevideo1').value = (accvaluenew+"").replace(',', '.');
		document.getElementById('m3count').value = m3count - 1;
		if(document.getElementById('m3count').value > 0) document.getElementById('cm3').value = "+0.3("+document.getElementById('m3count').value+")";
		else document.getElementById('cm3').value = "+0.3";
	}
	
	document.getElementById("acctotal").innerHTML = document.getElementById('refscorevideo1').value;
	
	//doPlaySound();
	doVibrate();
}

function removeM3_2(){
	var m3count = parseInt(document.getElementById('m3count_2').value);
	var accvalue = parseFloat(document.getElementById('refscorevideo1__2').value.replace(',', '.'));
	
	if(m3count > 0){
		var accvaluenew = (accvalue + 0.3).toFixed(1);
		if(accvaluenew > 4) document.getElementById('refscorevideo1__2').value = "4.0";
		else document.getElementById('refscorevideo1__2').value = (accvaluenew+"").replace(',', '.');
		document.getElementById('m3count_2').value = m3count - 1;
		if(document.getElementById('m3count_2').value > 0) document.getElementById('cm3_2').value = "+0.3("+document.getElementById('m3count_2').value+")";
		else document.getElementById('cm3_2').value = "+0.3";
	}
	
	document.getElementById("acctotal_2").innerHTML = document.getElementById('refscorevideo1__2').value;
	
	//doPlaySound();
	doVibrate();
}

function removeM1(){
	var m1count = parseInt(document.getElementById('m1count').value);
	var accvalue = parseFloat(document.getElementById('refscorevideo1').value.replace(',', '.'));
	
	if(m1count > 0){
		var accvaluenew = (accvalue + 0.1).toFixed(1);
		if(accvaluenew > 4) document.getElementById('refscorevideo1').value = "4.0";
		else document.getElementById('refscorevideo1').value = (accvaluenew+"").replace(',', '.');
		document.getElementById('m1count').value = m1count - 1;
		if(document.getElementById('m1count').value > 0) document.getElementById('cm1').value = "+0.1("+document.getElementById('m1count').value+")";
		else document.getElementById('cm1').value = "+0.1";
	}
	
	document.getElementById("acctotal").innerHTML = document.getElementById('refscorevideo1').value;
	
	//doPlaySound();
	doVibrate();
}

function removeM1_2(){
	var m1count = parseInt(document.getElementById('m1count_2').value);
	var accvalue = parseFloat(document.getElementById('refscorevideo1__2').value.replace(',', '.'));
	
	if(m1count > 0){
		var accvaluenew = (accvalue + 0.1).toFixed(1);
		if(accvaluenew > 4) document.getElementById('refscorevideo1__2').value = "4.0";
		else document.getElementById('refscorevideo1__2').value = (accvaluenew+"").replace(',', '.');
		document.getElementById('m1count_2').value = m1count - 1;
		if(document.getElementById('m1count_2').value > 0) document.getElementById('cm1_2').value = "+0.1("+document.getElementById('m1count_2').value+")";
		else document.getElementById('cm1_2').value = "+0.1";
	}
	
	document.getElementById("acctotal_2").innerHTML = document.getElementById('refscorevideo1__2').value;
	
	//doPlaySound();
	doVibrate();
}

function countPresentationWT(){
	var pre1 = document.getElementById('refscorevideo1_2').value.replace(',', '.');
	var pre2 = document.getElementById('refscorevideo1_3').value.replace(',', '.');
	var pre3 = document.getElementById('refscorevideo1_4').value.replace(',', '.');
	
	var total = parseFloat(pre1)+parseFloat(pre2)+parseFloat(pre3);
	
	document.getElementById("prestotal").innerHTML = total.toFixed(1);
}

function countPresentationWT_2(){
	var pre1 = document.getElementById('refscorevideo1_2_2').value.replace(',', '.');
	var pre2 = document.getElementById('refscorevideo1_3_2').value.replace(',', '.');
	var pre3 = document.getElementById('refscorevideo1_4_2').value.replace(',', '.');
	
	var total = parseFloat(pre1)+parseFloat(pre2)+parseFloat(pre3);
	
	document.getElementById("prestotal_2").innerHTML = total.toFixed(1);
}

function setPoomsaeWT(){
	var poomsae = document.getElementById('poomsae');
	var poomsae_value = poomsae.options[poomsae.selectedIndex].value;
	
	var poomsae_check = document.getElementById('poomsae_check');
	poomsae_check.value = poomsae_value;
	
}

function setPoomsaeWTCheck(){
	var poomsae = document.getElementById('poomsae_check');
	var poomsae_value = poomsae.options[poomsae.selectedIndex].value;
	
	var poomsae_check = document.getElementById('poomsae');
	poomsae_check.value = poomsae_value;
}

function countPresentationWTFreestyle(){
	var pre1 = document.getElementById('refscorevideo1_7').value.replace(',', '.');
	var pre2 = document.getElementById('refscorevideo1_8').value.replace(',', '.');
	var pre3 = document.getElementById('refscorevideo1_9').value.replace(',', '.');
	var pre4 = document.getElementById('refscorevideo1_10').value.replace(',', '.');
	
	var total = parseFloat(pre1)+parseFloat(pre2)+parseFloat(pre3)+parseFloat(pre4);
	
	document.getElementById("prestotal").innerHTML = total.toFixed(1);
}

function countTechnicalSkillsWTFreestyle(){
	var pre1 = document.getElementById('refscorevideo1').value.replace(',', '.');
	var pre2 = document.getElementById('refscorevideo1_2').value.replace(',', '.');
	var pre3 = document.getElementById('refscorevideo1_3').value.replace(',', '.');
	var pre4 = document.getElementById('refscorevideo1_4').value.replace(',', '.');
	var pre5 = document.getElementById('refscorevideo1_5').value.replace(',', '.');
	var pre6 = document.getElementById('refscorevideo1_6').value.replace(',', '.');
	
	var total = parseFloat(pre1)+parseFloat(pre2)+parseFloat(pre3)+parseFloat(pre4)+parseFloat(pre5)+parseFloat(pre6);
	
	document.getElementById("technicaltotal").innerHTML = total.toFixed(1);
}

//wushu judge C
function checkValueIWUFDifficulty(){
	var tdvalues2 = document.getElementById('tdvalues2').value;
	var tdvalues3 = document.getElementById('tdvalues3').value;
	var tdvalues4 = document.getElementById('tdvalues4').value;
	
	var valarray2 = tdvalues2.split(",");
	var valarray3 = tdvalues3.split(",");
	var valarray4 = tdvalues4.split(",");
	
	for (var i = 0; i < valarray2.length; i++) {
		valarray2[i] = "0";
	}
	
	for (var i = 0; i < valarray3.length; i++) {
		valarray3[i] = "";
	}
	
	for (var x = 0; x < document.getElementsByTagName('input').length; x++) {
		if (document.getElementsByTagName('input').item(x).type == 'checkbox') {

			var checkbox = document.getElementsByTagName('input').item(x);
			var checkboxname = checkbox.id;
			
			for (var i = 0; i < valarray4.length; i++) {
	
				var codeval = valarray4[i];
				
				if(checkboxname == codeval){
					if(checkbox.checked){
						valarray2[i] = "1";
						valarray3[i] = checkbox.value;
					}else{
						valarray2[i] = "0";
						valarray3[i] = "0.0";
					}
					break;
				}
			}
		}
	}

	document.getElementById('tdvalues2').value = valarray2.join(",");
	document.getElementById('tdvalues3').value = valarray3.join(",");
	
	sendCLive();
}

function checkValueIWUFDifficultySingle(id){
	
	if(!document.getElementById(id).checked){
		
		var code =  id.split("_")[0];
		var codepart =  id.split("_")[1];
		
		//alert("code: "+code);
		//alert("codepart: "+codepart);
		
		//if we are not on a connection + checkbox
		if(codepart.indexOf("+") === -1){
			
			//check if we have a connection after
			if(code.indexOf(codepart+"+") !== -1){
				
				//we have just a plus
				if(code.indexOf(codepart+"+") !== -1){
				
					var codes = code.split("+");
					for (var i = 0; i < codes.length; i++) {
					
						if(codes[i] == codepart){
							
							if(codes.length > i+1){
								var codesearch = code+"_"+"+-"+(i*2+1);
								
								if(codes[i+1].length == 1){
									codesearch = code+"_"+"+"+codes[i+1];
								}
								
								//alert("codesearch: "+codesearch);
								
								if(codesearch != "" && document.getElementById(codesearch)){
									document.getElementById(codesearch).checked = false;
								}
							}
							
							break;
						}
					}
					
				}
			}
				
			//check if we have a connection after
			if(code.indexOf("+"+codepart) !== -1){
				
				var codes = code.split("+");
				for (var i = 0; i < codes.length; i++) {
				
					if(codes[i] == codepart){
						
						if(i > 0){
							var codesearch = code+"_"+"+-"+((i-1)*2+1);
							
							//alert("codesearch: "+codesearch);
							
							if(codesearch != "" && document.getElementById(codesearch)){
								document.getElementById(codesearch).checked = false;
							}
						}
						
						break;
					}
				}
			}
		}
	}
}

function sendCLive(){
	
	$.ajax({
	    url : "/set/scoring/sc_iwuf_taolu_score_c1_live",
	    type: "POST",
	    data : { 
       'tdvalues': document.getElementById('tdvalues').value, 
       'tdvalues2': document.getElementById('tdvalues2').value, 
       'tdvalues3': document.getElementById('tdvalues3').value, 
       'tdvalues4': document.getElementById('tdvalues4').value
    	},
	    success: function(data, textStatus, jqXHR)
	    {
	       console.log("sent data "+data);
	    },
	    error: function (jqXHR, textStatus, errorThrown)
	    {
	  		console.log("error sending data ");
	    }
	});

}

function receiveCLive(){

	
	$.ajax({
	    url : "/set/scoring/sc_iwuf_taolu_score_c1_live_update",
	    success: function(data)
	    {
	      document.getElementById('c_live_update').innerHTML = data;
	    }
	    
	});

}

//wushu judge A

function addIWUFTD(datestr){

		var nodestr = datestr+"|Choose Category of Deduction|Choose Deduction";
		
		var li = document.createElement('li');
		li.id = nodestr;
		
		var liList = document.getElementById("ul_deduction").getElementsByTagName("li").length;
		
		if(liList == 0){
		 document.getElementById('ul_deduction').appendChild(li);
		 document.getElementById('tdvalues').value = nodestr;
		}else{
		 document.getElementById('ul_deduction').appendChild(li);
		 document.getElementById('tdvalues').value = document.getElementById('tdvalues').value + ","+nodestr;
		}
		
		
		checkCreateButtonsIWUF(li,nodestr);
		
		countIWUFADeductions();	
	
}

function checkCreateButtonsIWUF(li,nodestr){

		li.innerHTML = ""; 
	
		var deduction_codes = document.getElementById('deduction_codes').value;
		const deduction_codes_arr = deduction_codes.split(",");
		
		const nodestrparts = nodestr.split('|');
		
		if(nodestr.indexOf("Choose Category of Deduction") !== -1){
		
			li.innerHTML = nodestr.replace("|Choose Deduction", "").replaceAll("|", "<br>")+"<br>";
			
			var lastcat = "";
			
			for (var i = 1; i < deduction_codes_arr.length; i++) {
		
				var catcode = deduction_codes_arr[i].substring(0, 1);
				var dedcode = deduction_codes_arr[i].substring(1);
				
				if(lastcat != catcode){
		
            		var btn = document.createElement("button");
            		btn.type = "button";
            		btn.innerHTML =  catcode;
        			btn.name = nodestr;
        			btn.id = nodestr+"_catcode_"+catcode;
        			btn.addEventListener("click", function () {
  						selectCategoryIWUF(this.name,this.innerHTML);
					});
        			
        	
            		li.appendChild(btn);
            	}
            	
            	lastcat = catcode;
        	}
        	
		}else{
		
			if(nodestr.indexOf("|Choose Deduction") !== -1){
		
				var cc = nodestrparts[1];
			
				li.innerHTML = nodestr.replace("|"+nodestrparts[1]+"|", "|Category <b>"+nodestrparts[1]+
				" "+getDeductionCodeDetailsCategory(document.getElementById('deduction_codes_details').value,nodestrparts[1])+
				"</b>"+"|").replaceAll("|", "<br>")+"<br>";
		
				for (var i = 1; i < deduction_codes_arr.length; i++) {
		
					var catcode = deduction_codes_arr[i].substring(0, 1);
					var dedcode = deduction_codes_arr[i].substring(1);
				
					if(cc == catcode){
		
            			var btn = document.createElement("button");
            			btn.type = "button";
            			btn.innerHTML =  dedcode;
        				btn.name = nodestr;
        				btn.id = nodestr+"_catcode_"+catcode+"_dedcode_"+dedcode;
        				btn.addEventListener("click", function () {
  							selectDeductionIWUF(this.name,this.innerHTML);
						});
            			li.appendChild(btn);
            		}
        		}
        	}else{
        		li.innerHTML = (nodestrparts[0]+"|"+"Deduction Selected: <b>"+nodestrparts[1]+nodestrparts[2]+"</b>"+
        		"|Category:<b> "+getDeductionCodeDetails(document.getElementById('deduction_codes_details').value,nodestrparts[1]+""+nodestrparts[2],1)+"</b>"+
        		"|Deduction:<b> "+getDeductionCodeDetails(document.getElementById('deduction_codes_details').value,nodestrparts[1]+""+nodestrparts[2],2)+
        		"</b>").replaceAll("|", "<br>")+"<br>";
        	}
		
		}
		
		var btncancel = document.createElement("button");
        btncancel.type = "button";
        btncancel.innerHTML =  "Back";
        if(nodestr.indexOf("Choose Category of Deduction") !== -1 && nodestr.indexOf("|Choose Deduction") !== -1){
        	btncancel.innerHTML =  "Invalidate";
        	btncancel.style.color = "red";
        }
        btncancel.name = nodestr;
        btncancel.id = nodestr+"_cancel";
        btncancel.addEventListener("click", function () {
  			cancelIWUF(this.name);
		});
        			
        li.appendChild(btncancel);
}

function selectCategoryIWUF(id,catcode){
	var li = document.getElementById(id);
	
	var tdvalues_invalid = document.getElementById('tdvalues_invalid').value;
	if(tdvalues_invalid.indexOf(","+id) !== -1){
		document.getElementById('tdvalues_invalid').value = tdvalues_invalid.replace(","+id, "");;
	}
	
	var nodestring = id.replace("Choose Category of Deduction", catcode);
	li.id = nodestring;
	
	var tdvalues = document.getElementById('tdvalues').value;
	tdvalues = tdvalues.replace(id,nodestring);
	document.getElementById('tdvalues').value = tdvalues

	checkCreateButtonsIWUF(li,nodestring);
	
	countIWUFADeductions();
}

function selectDeductionIWUF(id,dedcode){

	
	var li = document.getElementById(id);
	
	var nodestring = id.replace("Choose Deduction", dedcode);
	li.id = nodestring;
	
	var tdvalues = document.getElementById('tdvalues').value;
	tdvalues = tdvalues.replace(id,nodestring);
	document.getElementById('tdvalues').value = tdvalues;

	checkCreateButtonsIWUF(li,nodestring);
	
	countIWUFADeductions();
}

function getDeductionCodeDetailsCategory(codelist,catcode){
	
	const deduction_codes_arr = codelist.split('|');
		
	for (var i = 1; i < deduction_codes_arr.length; i++) {
		if(deduction_codes_arr[i].startsWith(catcode)){
			var deduction_code_arr = deduction_codes_arr[i].split(';');
				
			if(deduction_code_arr.length > 1){
				return deduction_code_arr[1];
			}
		}
	}
	
	return "";
}

function getDeductionCodeDetails(codelist,code,index){
	if(codelist.indexOf(code) !== -1){
		const deduction_codes_arr = codelist.split('|');
		
		for (var i = 1; i < deduction_codes_arr.length; i++) {
			if(deduction_codes_arr[i].startsWith(code)){
				var deduction_code_arr = deduction_codes_arr[i].split(';');
				
				if(deduction_code_arr.length > index){
					return deduction_code_arr[index];
				}
			}
		}
	}
	
	return "";
}

function cancelIWUF(id){
	var li = document.getElementById(id);
	var nodestr = li.id;
	
	if(nodestr.indexOf("Choose Category of Deduction") !== -1 && nodestr.indexOf("|Choose Deduction") !== -1){
		//we need to delete completely
		
		//document.getElementById('ul_deduction').removeChild(li);
		
		var tdvalues_invalid = document.getElementById('tdvalues_invalid').value;
		
		if(tdvalues_invalid.indexOf(","+nodestr) !== -1){
			//do nothing
		}else{
			tdvalues_invalid = tdvalues_invalid+","+nodestr;
			document.getElementById('tdvalues_invalid').value = tdvalues_invalid;
		}
		
		
	}else{
		
		const nodestrparts = nodestr.split('|');
	
		if(nodestr.indexOf("|Choose Deduction") === -1){
			li.id = nodestrparts[0]+"|"+nodestrparts[1]+"|Choose Deduction";
			
			var tdvalues = document.getElementById('tdvalues').value;
			tdvalues = tdvalues.replace(nodestr,li.id);
			document.getElementById('tdvalues').value = tdvalues;
			
			checkCreateButtonsIWUF(li,li.id);
		}else{
			if(nodestr.indexOf("|Choose Category of Deduction") === -1){
				li.id = nodestrparts[0]+"|Choose Category of Deduction|Choose Deduction";
				
				var tdvalues = document.getElementById('tdvalues').value;
				tdvalues = tdvalues.replace(nodestr,li.id);
				document.getElementById('tdvalues').value = tdvalues;
				
				checkCreateButtonsIWUF(li,li.id);
			}
		}
	}
	
	countIWUFADeductions();
}

function checkMissingDeductions(){

	if(document.getElementById('tdvalues').value.indexOf("Choose Category of Deduction") !== -1 || document.getElementById('tdvalues').value.indexOf("|Choose Deduction") !== -1){
		//check now if invalidated
		//iterate all items
		
		var tdvalues_invalid = document.getElementById('tdvalues_invalid').value;
		
		var ul = document.getElementById('ul_deduction');
		
		var items = ul.getElementsByTagName("li");
		for (var i = 0; i < items.length; ++i) {
 			var itemid = items[i].id;
 			
 			if(itemid.indexOf("Choose Category of Deduction") !== -1 || itemid.indexOf("|Choose Deduction") !== -1){
 				if(document.getElementById(itemid+'_cancel').innerHTML != "Invalidated"){
 					if(tdvalues_invalid.indexOf(","+itemid) === -1){
 						return true;
 					}
 				}
 			}
		}
		
		
	}
	return false;
}


function removeIWUFLast(){

	var liList = document.getElementById("ul_deduction").getElementsByTagName("li").length;
	
	if(liList > 0){
		document.getElementById('ul_deduction').removeChild(document.getElementById('ul_deduction').getElementsByTagName('li')[liList-1]);
		
		var tdvalues = document.getElementById('tdvalues').value;
		tdvalues = tdvalues.substring(0, tdvalues.lastIndexOf(","));
		
		document.getElementById('tdvalues').value = tdvalues;
	}
}

function checkForInvalid(){

		var tdvalues_invalid = document.getElementById('tdvalues_invalid').value;

		var ul = document.getElementById('ul_deduction');
		
		var items = ul.getElementsByTagName("li");
		for (var i = 0; i < items.length; ++i) {
 			var itemid = items[i].id;
 			
 			if(tdvalues_invalid.indexOf(","+itemid) !== -1){
 				document.getElementById(itemid+'_cancel').innerHTML = "Invalidated";
				document.getElementById(itemid+'_cancel').style.background = "#f2a3a3";
 			}
		}		
}

function countIWUFADeductions(){
	var liList = document.getElementById("ul_deduction").getElementsByTagName("li").length;
	
	document.getElementById('td').value = "["+liList+"] DEDUCT";
	
	
	checkForInvalid();
	
	sendALive();
}

function checkIWUFTD(){
	
	var tdvalues = document.getElementById('tdvalues').value;
	
	if(tdvalues.length > 0){
	
		var valarray = tdvalues.split(",");
		
		document.getElementById("ul_deduction").innerHTML = '';
		
		for (var i = 0; i < valarray.length; i++) {
		
   			var li = document.createElement('li');
			li.innerHTML = "";
			li.id = valarray[i];
		
			var liList = document.getElementById("ul_deduction").getElementsByTagName("li").length;
		
			if(liList == 0){
		 		document.getElementById('ul_deduction').appendChild(li);
			}else{
		 		document.getElementById('ul_deduction').appendChild(li);
			}
			
			checkCreateButtonsIWUF(li,valarray[i]);
		}
	}
	
	countIWUFADeductions();	
}

function sendALive(){
	
	$.ajax({
	    url : "/set/scoring/sc_iwuf_taolu_score_a1_live",
	    type: "POST",
	    data : { 
       'tdvalues': document.getElementById('tdvalues').value, 
       'tdvalues_invalid': document.getElementById('tdvalues_invalid').value
    	},
	    success: function(data, textStatus, jqXHR)
	    {
	       console.log("sent data "+data);
	    },
	    error: function (jqXHR, textStatus, errorThrown)
	    {
	  		console.log("error sending data ");
	    }
	});

}

function markCodeColor(){
	$('.color-slot').each((index, element) => {
	
    		var code_search = $(element).children('text:nth-child(2)').html();
    		var fill_value  = $(element).children('rect:nth-child(1)').attr("fill");
    		var color_value = $(element).children('text:nth-child(2)').css("fill");
    		
    		if(code_search.includes("CODE")){
    		
 				$('h2[name="code_element"]').each(function(i,ce){
  					var ce_text = $(ce).html();
 
 					if(code_search == "CODE "+ce_text){
 						
 						$(ce).css("background-color", fill_value);
 						$(ce).css("color", color_value);
 					}
				});
			}
	});
}

function receiveALive(){

	
	$.ajax({
	    url : "/set/scoring/sc_iwuf_taolu_score_a1_live_update",
	    success: function(data)
	    {
	      document.getElementById('a_live_update').innerHTML = data;
	      try {
  		 	myData = document.getElementById('judgeajsonavalues').value;
  		 	var datarray = JSON.parse(myData);
		  	AChart.data(datarray);
	     	AChart.refresh();
	     	markCodeColor();
	
		} catch (exceptionVar) {
		}
	     
	    }
	    
	});

}


//wushu routine inspector
function checkValueIWUFRoutine(){
	var tdvalues = document.getElementById('tdvalues').value;
	var tdvalues2 = document.getElementById('tdvalues2').value;
	
	try {
	
	var valarray = tdvalues.split(",");
	var valarray2 = tdvalues2.split(",");
	
	for (var x = 0; x < valarray.length; x++) {
		
			var checkbox = document.getElementById(valarray[x]);
			
			if(checkbox.checked){
			
				if(valarray2[x] == "0"){
					var textarea = document.getElementById('tdcomment');
					textarea.value = textarea.value.replace(valarray[x]+' missing'+"\n","");
					textarea.scrollTop = textarea.scrollHeight;
				}
			
				valarray2[x] = "1";
			}else{
				
				if(valarray2[x] == "1"){
					var textarea = document.getElementById('tdcomment');
					textarea.value += valarray[x]+' missing'+"\n";
					textarea.scrollTop = textarea.scrollHeight;
				}
				valarray2[x] = "0";
			}
			
	}

	document.getElementById('tdvalues2').value = valarray2.join(",");
	
	} catch (error) {
	
	}
	
	sendRILive();
}

function addCodeIWUFRoutine(code){
	
	var textarea = document.getElementById('tdcomment');
	textarea.value += code+'-'+"\n";
	textarea.scrollTop = textarea.scrollHeight;
				
	sendRILive();			
}

function sendRILive(){

	$.ajax({
	    url : "/set/scoring/sc_iwuf_taolu_score_ri_live",
	    type: "POST",
	    data : { 
       'tdvalues': document.getElementById('tdvalues').value, 
       'tdvalues2': document.getElementById('tdvalues2').value, 
       'tdcomment': document.getElementById('tdcomment').value
    	},
	    success: function(data, textStatus, jqXHR)
	    {
	       console.log("sent data "+data);
	    },
	    error: function (jqXHR, textStatus, errorThrown)
	    {
	  		console.log("error sending data ");
	    }
	});

}

function receiveRILive(){

	
	$.ajax({
	    url : "/set/scoring/sc_iwuf_taolu_score_ri_live_update",
	    success: function(data)
	    {
	      document.getElementById('ri_live_update').innerHTML = data;
	    }
	    
	});

}

// b judges
function sendBILive(){

	var  formData = "refscorevideo1="+ document.getElementById('refscorevideo1').value;
	if(document.getElementById('refscorevideo1').value == ""){
		formData = "refscorevideo1=0.00";
	}

	$.ajax({
	    url : "/set/scoring/sc_iwuf_taolu_score_b1_live",
	    type: "POST",
	    data : formData,
	    success: function(data, textStatus, jqXHR)
	    {
	       console.log("sent data "+data);
	    },
	    error: function (jqXHR, textStatus, errorThrown)
	    {
	  		console.log("error sending data ");
	    }
	});

}

function receiveBLive(){

	
	$.ajax({
	    url : "/set/scoring/sc_iwuf_taolu_score_b1_live_update",
	    success: function(data)
	    {
	      document.getElementById('b_live_update').innerHTML = data;
	    }
	    
	});

}

function getLastBScores(){

	
	$.ajax({
	    url : "/set/scoring/sc_iwuf_taolu_score_b1_lastscores",
	    success: function(data)
	    {
	      document.getElementById('b_lastscores').innerHTML = data;
	    }
	    
	});

}

// HJ
function hjCheckOverwrite(){

	try {
  		var a_overwrite = document.getElementById('a_overwrite');
	
		if(a_overwrite.checked){
			a_overwrite_span.style.display = "block";
			var deductions = document.getElementById('matched_deductions').innerHTML;
			document.getElementById('judgea').value = deductions;
		}else{
			a_overwrite_span.style.display = "none";
		}
	
	} catch (exceptionVar) {
  		
	}

	try {
  		var c_overwrite = document.getElementById('c_overwrite');
	
		if(c_overwrite.checked){
			c_overwrite_span.style.display = "block";
		}else{
			c_overwrite_span.style.display = "none";
		}
	} catch (exceptionVar) {
  		
	}
	
	try {
  		var b_overwrite = document.getElementById('b_overwrite');
	
		if(b_overwrite.checked){
		
			b_overwrite_span.style.display = "block";
			
			var scoreb1 = document.getElementById('scoreb1');
			if ((scoreb1.value == null || scoreb1.value == "") && document.getElementById('scoreb1judge') != null && document.getElementById('scoreb1judge').innerHTML  != null && document.getElementById('scoreb1judge').innerHTML  != "") {
				scoreb1.value = document.getElementById('scoreb1judge').innerHTML;
			}
			
			var scoreb2 = document.getElementById('scoreb2');
			if ((scoreb2.value == null || scoreb2.value == "") && document.getElementById('scoreb2judge') != null && document.getElementById('scoreb2judge').innerHTML  != null && document.getElementById('scoreb2judge').innerHTML  != "") {
				scoreb2.value = document.getElementById('scoreb2judge').innerHTML;
			}
			var scoreb3 = document.getElementById('scoreb3');
			if ((scoreb3.value == null || scoreb3.value == "") && document.getElementById('scoreb3judge') != null && document.getElementById('scoreb3judge').innerHTML  != null && document.getElementById('scoreb3judge').innerHTML  != "") {
				scoreb3.value = document.getElementById('scoreb3judge').innerHTML;
			}
			
			var scoreb4 = document.getElementById('scoreb4');
			if ((scoreb4.value == null || scoreb4.value == "") && document.getElementById('scoreb4judge') != null && document.getElementById('scoreb4judge').innerHTML  != null && document.getElementById('scoreb4judge').innerHTML  != "") {
				scoreb4.value = document.getElementById('scoreb4judge').innerHTML;
			}
			
			var scoreb5 = document.getElementById('scoreb5');
			if ((scoreb5.value == null || scoreb5.value == "") && document.getElementById('scoreb5judge') != null && document.getElementById('scoreb5judge').innerHTML  != null && document.getElementById('scoreb5judge').innerHTML  != "") {
				scoreb5.value = document.getElementById('scoreb5judge').innerHTML;
			}
		}else{
			b_overwrite_span.style.display = "none";
		}
		
	} catch (exceptionVar) {
  		
	}
	
}

function hjCheckHasOverwrite(){

	var hasoverwrite = false; 

	try {
  		var a_overwrite = document.getElementById('a_overwrite');
	
		if(a_overwrite.checked){
			hasoverwrite = true; 
		}
	
	} catch (exceptionVar) {
  		
	}

	try {
  		var c_overwrite = document.getElementById('c_overwrite');
	
		if(c_overwrite.checked){
			hasoverwrite = true; 
		}
	} catch (exceptionVar) {
  		
	}
	
	try {
  		var b_overwrite = document.getElementById('b_overwrite');
	
		if(b_overwrite.checked){
		
			hasoverwrite = true; 
		}
		
	} catch (exceptionVar) {
  		
	}
	
	return hasoverwrite;
}

function checkValueIWUFDifficultyHJ(){
	try {
		var tdvalues2 = document.getElementById('tdvalues2').value;
		var tdvalues3 = document.getElementById('tdvalues3').value;
		var tdvalues4 = document.getElementById('tdvalues4').value;
		
		var valarray2 = tdvalues2.split(",");
		var valarray3 = tdvalues3.split(",");
		var valarray4 = tdvalues4.split(",");
		
		for (var i = 0; i < valarray2.length; i++) {
			valarray2[i] = "0";
		}
		
		for (var i = 0; i < valarray3.length; i++) {
			valarray3[i] = "";
		}
		
		for (var x = 0; x < document.getElementsByTagName('input').length; x++) {
			if (document.getElementsByTagName('input').item(x).type == 'checkbox') {
	
				var checkbox = document.getElementsByTagName('input').item(x);
				var checkboxname = checkbox.id;
				
				for (var i = 0; i < valarray4.length; i++) {
		
					var codeval = valarray4[i];
					
					if(checkboxname == codeval){
						if(checkbox.checked){
							valarray2[i] = "1";
							valarray3[i] = checkbox.value;
						}else{
							valarray2[i] = "0";
							valarray3[i] = "0.0";
						}
						break;
					}
				}
			}
		}
	
		document.getElementById('tdvalues2').value = valarray2.join(",");
		document.getElementById('tdvalues3').value = valarray3.join(",");
	
	} catch (exceptionVar) {
  		
	}
}

function receiveHJTotalsLive(){

	
	$.ajax({
	    url : "/set/scoring/sc_iwuf_taolu_score_hj_live_update",
	    success: function(data)
	    {
	    
	    const totals = data.split(';');
	    
	    try {
  			document.getElementById('total_judgea').innerHTML = totals[0];
		} catch (exceptionVar) {
  			
		}
		
		 try {
  			 document.getElementById('total_judgeb').innerHTML = totals[1];
		} catch (exceptionVar) {
  			
		}
		
		 try {
  			document.getElementById('total_judgec').innerHTML = totals[2];
		} catch (exceptionVar) {
  			
		}
		
		//HJ
	     
	      try {
  			 document.getElementById('total_time').innerHTML = totals[3];
		} catch (exceptionVar) {
  			
		}
	     
	    try {
  			document.getElementById('total_judgea').innerHTML = totals[0];
		} catch (exceptionVar) {
  			
		}
		
		 try {
  			 document.getElementById('total_judgeb').innerHTML = totals[1];
		} catch (exceptionVar) {
  			
		}
		
		 try {
  			document.getElementById('total_judgec').innerHTML = totals[2];
		} catch (exceptionVar) {
  			
		}
	     
	      try {
  			 document.getElementById('total_time').innerHTML = totals[3];
		} catch (exceptionVar) {
  			
		}  
		
		  try {
  			 document.getElementById('total_abc').innerHTML = totals[4];
		} catch (exceptionVar) {
  			
		}  
		
		  try {
  			 document.getElementById('total_final').innerHTML = totals[5];
		} catch (exceptionVar) {
  			
		}  
	     
	    }
	    
	});

}

/* Enter fullscreen */
function enterFullScreen() {
  
  var docElm = document.documentElement;
    if (docElm.requestFullscreen) {
      docElm.requestFullscreen();
    } else if (docElm.msRequestFullscreen) {
      docElm.msRequestFullscreen();
    } else if (docElm.mozRequestFullScreen) {
      docElm.mozRequestFullScreen();
    } else if (docElm.webkitRequestFullScreen) {
      docElm.webkitRequestFullScreen();
    }
};

/* Close fullscreen */
function closeFullscreen() {
  if (document.exitFullscreen) {
    document.exitFullscreen();
  } else if (document.webkitExitFullscreen) { /* Safari */
    document.webkitExitFullscreen();
  } else if (document.msExitFullscreen) { /* IE11 */
    document.msExitFullscreen();
  }
}

function receiveNameInformation(){

	
	$.ajax({
	    url : "/set/scoring/sc_iwuf_taolu_score_name_live_update",
	    success: function(data)
	    {
	      document.getElementById('name_live_update').innerHTML = data;
	    }
	    
	});
}

function initDropdownPopups(){

  var _btns = document.querySelectorAll('.btn'),

    _eachBtn = function(callback) {
      Array.prototype.forEach.call(_btns, function(elem) {
        callback.call(this, elem);
      });
    },
    _initListener = function(e) {
      e.preventDefault();
      e.stopPropagation();
      _eachBtn(function(btn) {
        btn.classList.remove('dropdown-open')
      });
      this.classList.toggle('dropdown-open');
    },
    _hideAll = function() {
      _eachBtn(function(btn) {
        btn.classList.remove('dropdown-open');
      });
    };

  _eachBtn(function(btn) {
    btn.addEventListener('touchend', function(e) {
      _initListener.call(this, e);
    });

    btn.addEventListener('click', function(e) {
      _initListener.call(this, e);
    });
  });

  document.addEventListener('touchend', function() {
    _hideAll();
  });
  
  document.addEventListener('click', function() {
    _hideAll();
  });

}