<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.1"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format"
	exclude-result-prefixes="fo">
	<xsl:output method="xml" version="1.0" omit-xml-declaration="no"
		indent="yes" />

	<xsl:param name="licencse" select="''" />
	<xsl:param name="date" select="''" />

	<!-- ========================= -->
	<!-- root element: projectteam -->
	<!-- ========================= -->
	<xsl:template match="Filereport">
		<fo:root xmlns:fo="http://www.w3.org/1999/XSL/Format"
			font-family="Arial">
			<fo:layout-master-set>
				<fo:simple-page-master master-name="simpleA4"
					page-height="279.4mm" page-width="215.9mm" margin-top="6mm"
					margin-bottom="6mm" margin-left="16mm" margin-right="16mm">
					<fo:region-body margin-top="0cm" margin-bottom="0cm" />
				</fo:simple-page-master>
			</fo:layout-master-set>
			<fo:page-sequence master-reference="simpleA4"
				language="de">


				<fo:flow flow-name="xsl-region-body">
					<fo:block font-size="8pt">
						<fo:table table-layout="fixed" width="100%">
							<fo:table-column column-width="9.2cm" />
							<fo:table-column column-width="9.2cm" />
							<fo:table-body>
								<xsl:apply-templates />
							</fo:table-body>
						</fo:table>
					</fo:block>
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>

	<xsl:template match="row">
		
		<fo:table-row height="13.3cm">
			<xsl:apply-templates select="person" />
		</fo:table-row>
			
	</xsl:template>
	

	<xsl:template match="person">
		<xsl:choose>
			<xsl:when test="string(picture)">
				<xsl:call-template name="personphoto" />
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="personnophoto" />
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template name="personphoto">
	<fo:table-cell border-style="dotted" border="0.5pt solid #aaaaaa"
			height="13.3cm" padding="0mm">

			<fo:block-container width="9.2cm" height="13.3cm"
				background-repeat="no-repeat" background-position-horizontal="center"
				background-position-vertical="top">
				<xsl:attribute name="background-image">
             	templates/accreditation/commenwealth2014/vip.png
            </xsl:attribute>

				<fo:block font-size="10pt" text-align="center" font-weight="bold">
					<fo:table table-layout="fixed" width="100%">
						<fo:table-column column-width="9.2cm" />
						<fo:table-body>
							<fo:table-row height="1.0cm">
							<fo:table-cell height="1.0cm">
								<fo:block font-size="10pt" text-align="center">
									<xsl:text> </xsl:text>
								</fo:block>
							</fo:table-cell>
							</fo:table-row>
						</fo:table-body>
					</fo:table>
				</fo:block>
				<fo:block font-size="8pt" text-align="center">
					<fo:table table-layout="fixed" width="100%">
						
						<fo:table-column column-width="9.2cm" />
	
						<fo:table-body>
							<fo:table-row height="140px">
								
								<xsl:choose>
									<xsl:when test="string(picture)">
										<fo:table-cell height="140px" >
											<fo:block text-align="center" display-align="center" margin-top="20px">
												<fo:external-graphic height="120px"
													width="5cm" content-height="scale-to-fit" content-width="scale-to-fit"
													scaling="uniform">
													<xsl:attribute name="src">
                          <xsl:value-of select="picture" />
                        </xsl:attribute>
												</fo:external-graphic>
											</fo:block>
										</fo:table-cell>
									</xsl:when>
									 <xsl:otherwise>
                    <fo:table-cell height="140px" >
											<fo:block text-align="center" display-align="center" margin-top="20px">
											<xsl:text></xsl:text>
										</fo:block>
										</fo:table-cell>	
                  </xsl:otherwise>
								</xsl:choose>
								
							</fo:table-row>
							<fo:table-row height="40px">
							<fo:table-cell height="40px">
							<fo:block font-size="12pt" text-align="center" display-align="bottom" font-weight="bold" >
					<xsl:value-of select="name" />
				</fo:block>
				<fo:block font-size="10pt" text-align="center" display-align="bottom" font-weight="bold">
					<xsl:text> </xsl:text>
					<xsl:value-of select="nation" />
				</fo:block>
				
				</fo:table-cell>
							
							</fo:table-row>
						</fo:table-body>
					</fo:table>
				</fo:block>
				<xsl:choose>
					<xsl:when test="not(string(picture))">
						<fo:block font-size="8pt" text-align="center">
							<xsl:text> </xsl:text>
						</fo:block>
					</xsl:when>
				</xsl:choose>
				
			</fo:block-container>
		</fo:table-cell>
	</xsl:template>	
	
	<xsl:template name="personnophoto">
	<fo:table-cell border-style="dotted" border="0.5pt solid #aaaaaa"
			height="13.3cm" padding="0mm">

			<fo:block-container width="9.2cm" height="13.3cm"
				background-repeat="no-repeat" background-position-horizontal="center"
				background-position-vertical="top">
				<xsl:attribute name="background-image">
             	templates/accreditation/commenwealth2014/vip-nophoto.png
            </xsl:attribute>

				<fo:block font-size="10pt" text-align="center" font-weight="bold">
					<fo:table table-layout="fixed" width="100%">
						<fo:table-column column-width="9.2cm" />
						<fo:table-body>
							<fo:table-row height="1.0cm">
							<fo:table-cell height="1.0cm">
								<fo:block font-size="10pt" text-align="center">
									<xsl:text> </xsl:text>
								</fo:block>
							</fo:table-cell>
							</fo:table-row>
						</fo:table-body>
					</fo:table>
				</fo:block>
				<fo:block font-size="8pt" text-align="center">
					<fo:table table-layout="fixed" width="100%">
						
						<fo:table-column column-width="9.2cm" />
	
						<fo:table-body>
							<fo:table-row height="220px">
								
								<xsl:choose>
									<xsl:when test="string(picture)">
										<fo:table-cell height="220px" >
											<fo:block text-align="center" display-align="center" margin-top="20px">
												<fo:external-graphic height="80px"
													width="5cm" content-height="scale-to-fit" content-width="scale-to-fit"
													scaling="uniform">
													<xsl:attribute name="src">
                          <xsl:value-of select="picture" />
                        </xsl:attribute>
												</fo:external-graphic>
											</fo:block>
										</fo:table-cell>
									</xsl:when>
									 <xsl:otherwise>
                    <fo:table-cell height="220px" >
											<fo:block text-align="center" display-align="center" margin-top="20px">
											<xsl:text></xsl:text>
										</fo:block>
										</fo:table-cell>	
                  </xsl:otherwise>
								</xsl:choose>
								
							</fo:table-row>
							<fo:table-row height="40px">
							<fo:table-cell height="40px">
							<fo:block font-size="12pt" text-align="center" display-align="bottom" font-weight="bold" >
					<xsl:value-of select="name" />
				</fo:block>
				<fo:block font-size="10pt" text-align="center" display-align="bottom" font-weight="bold">
					<xsl:text> </xsl:text>
					<xsl:value-of select="nation" />
				</fo:block>
				
				</fo:table-cell>
							
							</fo:table-row>
						</fo:table-body>
					</fo:table>
				</fo:block>
				<xsl:choose>
					<xsl:when test="not(string(picture))">
						<fo:block font-size="8pt" text-align="center">
							<xsl:text> </xsl:text>
						</fo:block>
					</xsl:when>
				</xsl:choose>
				
			</fo:block-container>
		</fo:table-cell>
	</xsl:template>	

	<xsl:template match="categories">
		<fo:block>
			<fo:table table-layout="fixed" width="100%">
				<fo:table-column column-width="9.2cm" />
				<fo:table-body>
					<fo:table-row >
						<fo:table-cell >
							<xsl:for-each select="category">
								<fo:block font-size="8pt" text-align="center"
									font-weight="bold">
									<xsl:value-of select="." />
								</fo:block>
							</xsl:for-each>
						</fo:table-cell>
					</fo:table-row>
				</fo:table-body>
			</fo:table>
		</fo:block>
	</xsl:template>

</xsl:stylesheet>
