<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.1"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format"
	exclude-result-prefixes="fo">
	<xsl:output method="xml" version="1.0" omit-xml-declaration="no"
		indent="yes" />

	<xsl:param name="licencse" select="''" />
	<xsl:param name="date" select="''" />

	<!-- ========================= -->
	<!-- root element: projectteam -->
	<!-- ========================= -->
	<xsl:template match="Filereport">
		<fo:root xmlns:fo="http://www.w3.org/1999/XSL/Format"
			font-family="Arial">
			<fo:layout-master-set>
				 <fo:simple-page-master master-name="simpleA4" page-height="21cm" page-width="29.7cm" margin-top="0mm" margin-bottom="0mm" margin-left="0mm" margin-right="0mm">
					<fo:region-body margin-top="0cm" margin-bottom="0cm" />
				</fo:simple-page-master>
			</fo:layout-master-set>
			<fo:page-sequence master-reference="simpleA4"
				language="de">
				<fo:flow flow-name="xsl-region-body">
					<fo:block font-size="8pt">
						<fo:table table-layout="fixed" width="100%">
							  <fo:table-column column-width="29.7cm"/>
							<fo:table-body>
								<xsl:apply-templates />
							</fo:table-body>
						</fo:table>
					</fo:block>
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>

	<xsl:template match="row">
		<xsl:apply-templates select="person" />
	</xsl:template>

	<xsl:template match="person">
		<fo:table-row height="20.2cm">
			<fo:table-cell border-style="dotted" height="20cm"
				width="29cm" border="0pt #aaaaaa" padding="3mm" text-align="center">

				<fo:block text-align="center" space-before="20mm"
					space-after="2mm">
					<fo:table table-layout="fixed" width="100%">
						 <fo:table-column column-width="29cm"/>
						<fo:table-body>
							<fo:table-row height="15cm">
								<fo:table-cell height="4.5cm" text-align="center"
									display-align="center">
									<xsl:choose>
										<xsl:when test="string(competitornumber)">
											<fo:block font-size="500pt" font-weight="bold">
												<xsl:value-of select="competitornumber" />
											</fo:block>
										</xsl:when>
										<xsl:otherwise>
											<fo:block font-size="320pt" font-weight="bold">
													<xsl:value-of select="natid" />
											</fo:block>
										</xsl:otherwise>
									</xsl:choose>
								</fo:table-cell>
							</fo:table-row>
						</fo:table-body>
					</fo:table>
				</fo:block>


				      <fo:block text-align="center" space-before="2mm" space-after="2mm">
  				  <fo:table table-layout="fixed" width="100%" >
              <fo:table-column column-width="10cm"/>
              <fo:table-column column-width="9cm"/>
              <fo:table-column column-width="10cm"/>
              <fo:table-body>
                <fo:table-row height="5cm">
  	              <xsl:choose>
                  <xsl:when test="string(eventlogo)">
                   <fo:table-cell text-align="center" display-align="center">
  	                 <fo:block text-align="center">
    				          <fo:external-graphic height="5cm" width="10cm" content-height="scale-to-fit" content-width="scale-to-fit" scaling="uniform">
                        <xsl:attribute name="src">
                          <xsl:value-of select="eventlogo" />
                        </xsl:attribute>
                      </fo:external-graphic>
    			         </fo:block>
    			        </fo:table-cell> 
                 </xsl:when>
                 <xsl:otherwise>
                  <fo:table-cell  text-align="center" display-align="center" background-color="green">
  	                <fo:block>
    			         </fo:block>
    			        </fo:table-cell> 
                </xsl:otherwise>
                </xsl:choose>	
  	              <fo:table-cell text-align="center" display-align="center" background-color="green">
  	              <xsl:choose>
                    <xsl:when test="string(competitornumber)">
                      <fo:block font-size="16pt" font-weight="bold" width="9cm">
    				    
    			           </fo:block>
                    </xsl:when>
                  <xsl:otherwise/>
                  </xsl:choose>
  	                 <fo:block font-size="16pt" font-weight="bold" width="9cm">
    				         <xsl:text> </xsl:text>
    			           </fo:block>	
  	              </fo:table-cell>
  	              <xsl:choose>
                  <xsl:when test="string(sponsorlogo)">
                   <fo:table-cell  text-align="center" display-align="center">
  	                 <fo:block >
    				          <fo:external-graphic height="5cm" width="10cm" content-height="scale-to-fit" content-width="scale-to-fit" scaling="uniform">
                        <xsl:attribute name="src">
                          <xsl:value-of select="sponsorlogo" />
                        </xsl:attribute>
                      </fo:external-graphic>
    			         </fo:block>
    			        </fo:table-cell> 
                 </xsl:when>
                 <xsl:otherwise>
                <fo:table-cell  text-align="center" display-align="center">
  	                <fo:block text-align="center">
    			         </fo:block>
    			        </fo:table-cell> 
                </xsl:otherwise>
                </xsl:choose>	
                </fo:table-row>
              </fo:table-body>
            </fo:table>
          </fo:block>

			</fo:table-cell>
		</fo:table-row>
	</xsl:template>

</xsl:stylesheet>
