<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" exclude-result-prefixes="fo">
  <xsl:output method="xml" version="1.0" omit-xml-declaration="no" indent="yes"/>
  
  <xsl:param name="licencse" select="''"/> 
  <xsl:param name="date" select="''"/>
  <xsl:param name="dateShort" select="''"/>
  
  <!-- ========================= -->
  <!-- root element: projectteam -->
  <!-- ========================= -->
  <xsl:template match="Filereport">
    <fo:root xmlns:fo="http://www.w3.org/1999/XSL/Format" font-family="Arial">     
      <fo:layout-master-set>
        <fo:simple-page-master master-name="simpleA4" page-height="29.7cm" page-width="21cm" margin-top="0mm" margin-bottom="0mm" margin-left="0mm" margin-right="0mm">
          <fo:region-body margin-top="0cm" margin-bottom="0cm" 
          background-repeat="no-repeat" 
          background-position-horizontal="center" 
          background-position-vertical="center">
          <xsl:choose>
          <xsl:when test="string(@bgimage)">
            <xsl:attribute name="background-image">
              <xsl:value-of select="@bgimage" />
            </xsl:attribute>
          </xsl:when>
          </xsl:choose>
         </fo:region-body> 
        </fo:simple-page-master>
      </fo:layout-master-set>
      <fo:page-sequence master-reference="simpleA4" language="de">
        <fo:flow flow-name="xsl-region-body">
          <fo:block font-size="8pt">
              
              <fo:table table-layout="fixed" width="100%" >
	            <fo:table-column column-width="21cm"/>
              <fo:table-body>
              <xsl:apply-templates />
              </fo:table-body>
              
            </fo:table>
          </fo:block>
        </fo:flow>
     </fo:page-sequence>   
    </fo:root>
  </xsl:template>
  
  <xsl:template match="row">
    
  	 <xsl:apply-templates select="person"/>
  	
  </xsl:template>
  
  <xsl:template match="person">
        <fo:table-row height="29.7cm">
  			<fo:table-cell border-style="dotted" height="29.7cm" width="21cm" border="0.5pt #aaaaaa" padding="3mm" text-align="center">
  			  <fo:block font-size="10pt" text-align="center" space-before="30mm" space-after="2mm">
          		
          </fo:block>
         
  				<fo:block text-align="center" space-before="1cm" space-after="2mm" margin-left="10mm" margin-right="10mm">
  				  <fo:table table-layout="fixed" width="100%" >
              <fo:table-column column-width="18cm"/>
              <fo:table-body>
                <fo:table-row height="4cm">
                    <fo:table-cell height="4cm" text-align="center" display-align="after" >
  	                 <fo:block width="18cm" font-weight="bold" font-style="italic" font-size="30pt">
    				              <xsl:value-of select="event" />
    			           </fo:block>	
  	              </fo:table-cell>
                </fo:table-row>
              </fo:table-body>
            </fo:table>
          </fo:block>
  				
    			<fo:block text-align="center" space-before="1cm" space-after="2mm" margin-left="10mm" margin-right="10mm">
  				  <fo:table table-layout="fixed" width="100%">
              <fo:table-column column-width="18cm"/>
              <fo:table-body>
                <fo:table-row height="1cm">
                    <fo:table-cell height="1cm" text-align="center" display-align="center" >
                       <fo:block width="18cm" font-weight="bold" font-style="italic" font-size="15pt">
    				               Hiermit wird die Teilnahme von
    			           </fo:block>
  	              </fo:table-cell>
                </fo:table-row>
                <fo:table-row height="3cm">
                    <fo:table-cell height="3cm" text-align="center" display-align="center">
    			           <fo:block width="18cm" font-weight="bold" font-size="26pt">
    				             <xsl:choose>
                          <xsl:when test="string(name)">
                            <xsl:value-of select="name" /> 
                          </xsl:when>
                          </xsl:choose> 
    			           </fo:block>
    			           <fo:block width="18cm" font-weight="bold" font-size="20pt">
    				              <xsl:choose>
                          <xsl:when test="string(name)">
                            <xsl:value-of select="substring-before(club, '(')" /> (<xsl:value-of select="natid" /><xsl:text> </xsl:text> 
                            <fo:external-graphic content-height="15px" border="0.5pt solid black">
                              <xsl:attribute name="src">
                                  images/flags/<xsl:value-of select="natid" />.gif
                              </xsl:attribute>
                            </fo:external-graphic>) 
                          </xsl:when>
                          </xsl:choose> 
    			           </fo:block>
  	              </fo:table-cell>
                </fo:table-row>
                 <fo:table-row height="0.5cm">
                    <fo:table-cell width="15cm" height="0.5cm" text-align="center" display-align="center">
    			           <fo:block width="15cm" font-weight="bold" font-style="italic" font-size="15pt" border-bottom="2pt solid #000000">
    				             <xsl:text> </xsl:text>
    			           </fo:block>
  	              </fo:table-cell>
                </fo:table-row>
                <fo:table-row height="1cm">
                    <fo:table-cell height="1cm" text-align="center" display-align="center">
    			           <fo:block width="18cm" font-weight="bold" font-style="italic" font-size="15pt">
    				              an der Veranstaltung <xsl:value-of select="event" /> 
    			           </fo:block>
  	              </fo:table-cell>
                </fo:table-row>
                <fo:table-row height="1cm">
                    <fo:table-cell height="1cm" text-align="center" display-align="center">
    			           <fo:block width="18cm" font-weight="bold" font-style="italic" font-size="15pt">
    				             in <xsl:value-of select="eventaddress" />, <xsl:value-of select="eventnation" />
    			           </fo:block>
  	              </fo:table-cell>
                </fo:table-row>
                <fo:table-row height="1cm">
                    <fo:table-cell height="1cm" text-align="center" display-align="center">
                    <xsl:choose>
                      <xsl:when test="string(date_to)">
                        <fo:block width="18cm" font-weight="bold" font-style="italic" font-size="15pt">
    				              von <xsl:value-of select="eventdate" /> bis <xsl:value-of select="date_to" />  bescheinigt.
    			              </fo:block>
                      </xsl:when>
                      <xsl:otherwise>
                        <fo:block width="18cm" font-weight="bold" font-style="italic" font-size="15pt">
    				              am <xsl:value-of select="eventdate" /> bescheinigt.
    			              </fo:block>
                      </xsl:otherwise>
                    </xsl:choose> 
    			        
  	              </fo:table-cell>
                </fo:table-row>
              </fo:table-body>
            </fo:table>
          </fo:block>
          
          <fo:block text-align="center" space-before="5mm" space-after="2mm" margin-left="10mm" margin-right="10mm">
  				  <fo:table table-layout="fixed" width="100%" >
              <fo:table-column column-width="9cm"/>
              <fo:table-column column-width="9cm"/>
              <fo:table-body>
                <fo:table-row height="7cm">
  	              <xsl:choose>
                  <xsl:when test="string(eventlogo)">
                   <fo:table-cell text-align="center" display-align="center">
  	                 <fo:block text-align="center">
    				          <fo:external-graphic height="7cm" width="9cm" content-height="scale-to-fit" content-width="scale-to-fit" scaling="uniform">
                        <xsl:attribute name="src">
                          <xsl:value-of select="eventlogo" />
                        </xsl:attribute>
                      </fo:external-graphic>
    			         </fo:block>
    			        </fo:table-cell> 
                 </xsl:when>
                 <xsl:otherwise>
                  <fo:table-cell  text-align="center" display-align="center">
  	                <fo:block>
    			         </fo:block>
    			        </fo:table-cell> 
                </xsl:otherwise>
                </xsl:choose>	
                <xsl:choose> 
                  <xsl:when test="string(sponsorlogo)">
                   <fo:table-cell  text-align="center" display-align="center">
  	                 <fo:block >
    				          <fo:external-graphic height="7cm" width="9cm" content-height="scale-to-fit" content-width="scale-to-fit" scaling="uniform">
                        <xsl:attribute name="src">
                          <xsl:value-of select="sponsorlogo" />
                        </xsl:attribute>
                      </fo:external-graphic>
    			         </fo:block>
    			        </fo:table-cell> 
                 </xsl:when>
                 <xsl:otherwise>
                <fo:table-cell  text-align="center" display-align="center">
  	                <fo:block text-align="center">
    			         </fo:block>
    			        </fo:table-cell> 
                </xsl:otherwise>
                </xsl:choose>	
              </fo:table-row>
              </fo:table-body>
            </fo:table>
          </fo:block>
          
          <fo:block text-align="center" space-before="5mm" space-after="2mm" margin-left="10mm" margin-right="10mm">
  				  <fo:table table-layout="fixed" width="100%" >
              <fo:table-column column-width="9cm"/>
              <fo:table-column column-width="9cm"/>
              <fo:table-body>
                <fo:table-row height="5cm">
  	            <fo:table-cell  text-align="center" display-align="after">
  	                <fo:block border-bottom="2pt solid #000000" font-weight="bold" font-style="italic" font-size="15pt">
  	                   <xsl:value-of select="$dateShort" /> 
    			          </fo:block>
    			          <fo:block font-weight="bold" font-style="italic" font-size="10pt" margin-bottom="20mm">
    			          Datum
    			          </fo:block>
    			      </fo:table-cell> 
    			      <fo:table-cell  text-align="center" display-align="after">
  	                <fo:block border-bottom="2pt solid #000000" font-weight="bold" font-style="italic" font-size="15pt">
  	                 <xsl:value-of select="organizer" />
    			          </fo:block>
    			          <fo:block font-weight="bold" font-style="italic" font-size="10pt" margin-bottom="20mm">
    			          Organisator
    			          </fo:block>
    			      </fo:table-cell>
              </fo:table-row>
              </fo:table-body>
            </fo:table>
          </fo:block>
          
       </fo:table-cell>
       </fo:table-row>   
   </xsl:template>       

</xsl:stylesheet>
