<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method='html'/>
 
 <xsl:param name="copyright" select="''"/> 
 <xsl:param name="gendate" select="''"/> 
 <xsl:variable name="daycount" select="count(/timetable/day)"/>
  
  <xsl:template match="timetable">
	<html>
			<head>
			<meta http-equiv="Content-Type" content="text/html;charset=UTF-8"/>	
			<title>Intranet</title>
			<style type="text/css">
			body { background:#000000;
					color:#ffffff; 
					font-family: Helvetica,Arial,sans-serif;
					font-size: 14px;
					margin: 0;
					padding: 0;
					text-align: center;
					background-image: url("images/award-cermony/award-bg-9.jpg");
					background-repeat: no-repeat;
					background-position: center center;
					background-attachment: fixed;
					background-size: cover;
					}
			
			.card { color:#ffffff; box-shadow: 0 4px 8px 0 rgba(0,0,0,0.2); transition: 0.3s; width: 80%; background:rgba(255,255,255,0.1);text-align: center; margin-left: auto; margin-right: auto; margin-bottom: 30px;}
			.card:hover { box-shadow: 0 8px 16px 0 rgba(209,210,255,0.7);}
			.container {  padding: 2px 16px;}
			
			.card2 { color:#ffffff; box-shadow: 0 4px 8px 0 rgba(0,0,0,0.2); transition: 0.3s; width: 80%; background:rgba(255,255,255,0.1);text-align: center; margin-left: auto; margin-right: auto; margin-bottom: 30px;}
			
			
			img {  max-width:100%;height: auto;}

			.centered {margin: auto;width: 100%;}
			
			a { color:#ffffff;text-decoration:none}
			a:hover { color: rgba(168,170,255,1); }
			
			table td {
    padding: 3px;
    margin: 0px;
    font-weight: normal;
    border: 1px solid #848383;
    text-align: center;
    color: #000000;
  font-size:14px;
}

	.time {
    padding: 3px;
    margin: 0px;
    font-weight: normal;
    border: 1px solid #848383;
    text-align: center;
  	color: #ffffff;
  	font-size:12px;
}

			</style>
			</head>
			<body>
			
			<div class="centered">
			<img src="images/sportdata-logo-klein.png" border="0" />
			</div>
			
	<xsl:apply-templates select="day"/>
	</body>
	</html>
  </xsl:template>
  
  <xsl:template match="day">
  	<div class="centered">  
  	<table class="centered"> 
           <xsl:apply-templates select="headerRow"/>
           <xsl:apply-templates select="row"/>  
    </table>    
    </div>   
  </xsl:template>
  
  <xsl:template match="headerRow">
     <tr>
      <th>
         <xsl:attribute name="colspan">                
           <xsl:value-of select="../@tatamis + 1"/>                  
         </xsl:attribute>
         <xsl:attribute name="id"><xsl:value-of select="../@date"/></xsl:attribute>
      
         	<div class="card2">
         	<div class="container">
         	<h2><xsl:value-of select="//@event"/><br/><xsl:value-of select="../@date"/></h2>
         	</div>
         	</div>
      
          <h3>
         	<xsl:for-each select="/timetable/day">
         		<a>
				<xsl:attribute name="href">#<xsl:value-of select="@date"/></xsl:attribute>
				<xsl:attribute name="alt"><xsl:value-of select="@date"/></xsl:attribute>
				<xsl:value-of select="@date"/>
				</a>	
         		<xsl:text> / </xsl:text>
         	</xsl:for-each>
         </h3> 
         <p class="copyright">
         <xsl:value-of select="$copyright"/><xsl:text>    </xsl:text><xsl:value-of select="$gendate"/>
         </p>
  	  </th>
     </tr>
     <tr>
  	  <th>
  	  </th>
      <xsl:for-each select="headerCell">
  	  <th>
    	<xsl:value-of select="@name" />
      </th>
  	  </xsl:for-each>
    </tr>
  </xsl:template>
  
  <xsl:template match="row">
    <xsl:variable name="rowspanned" select="last() - position() + 1"/>

  	<tr>
  	  <td class="time">
           <xsl:value-of select="@time" />  
  	  </td>
    	<xsl:for-each select="cell">
    	   <xsl:choose>
           <xsl:when test="string(@id)">
                 <xsl:choose>
                    <xsl:when test="@firstCell = 'yes'">
    				          <xsl:choose>
    				          <!-- if it is a cateogry item -->
                        <xsl:when test="string(@catname)">
                          <td>
                            <xsl:attribute name="rowspan">                
    			                <xsl:choose>
                                 <xsl:when test="@rowcount > $rowspanned">
                                    <xsl:value-of select="$rowspanned"/>
                                </xsl:when>
                                <xsl:otherwise>
                                  <xsl:value-of select="@rowcount"/>  
                               </xsl:otherwise> 
                              </xsl:choose>                  
                            </xsl:attribute> 
                            <xsl:attribute name="bgcolor">                
                              <xsl:value-of select="@bgcolor"/>                    
                            </xsl:attribute>
                            <xsl:attribute name="title">                
                              <xsl:value-of select="@origCatname" /> - <xsl:value-of select='substring(@starttime,12,5)'/> - <xsl:value-of select='substring(@endtime,12,5)'/> (<xsl:value-of select='@duration'/>)            
                            </xsl:attribute>
                            <b><xsl:value-of select="@origCatname" /></b>
                            <xsl:text> (</xsl:text>
							<xsl:value-of select="@entries" />
							<xsl:text>)</xsl:text>
    				        <br/>  
    				          <!-- print additional cateory name string -->
    				           <xsl:choose>
                                <xsl:when test="not(@origCatname = @catname)">
                                	<xsl:value-of select='substring(@catname,string-length(@origCatname)+1)'/><br/>  
                                </xsl:when>
                                <xsl:otherwise>
                                
                               </xsl:otherwise> 
                              </xsl:choose>
                              
                            <!-- print information of time -->
                             <xsl:choose>
                                <xsl:when test="@rowcount > 1">
    				               <xsl:value-of select='substring(@starttime,12,5)'/> - <xsl:value-of select='substring(@endtime,12,5)'/> (<xsl:value-of select='@duration'/>)
                                </xsl:when>
                                <xsl:otherwise>
                                
                               </xsl:otherwise> 
                              </xsl:choose> 
                          </td> 
    				    </xsl:when>
                        <xsl:otherwise>
                        <!-- if it is a custom item -->
                          <td>
                            <xsl:attribute name="rowspan">                
                              <xsl:choose>
                                 <xsl:when test="@rowcount > $rowspanned">
                                    <xsl:value-of select="$rowspanned"/>
                                </xsl:when>
                                <xsl:otherwise>
                                  <xsl:value-of select="@rowcount"/>  
                               </xsl:otherwise> 
                              </xsl:choose>                        
                            </xsl:attribute>
                            <xsl:attribute name="bgcolor">                
                              <xsl:value-of select="@bgcolor"/>                    
                            </xsl:attribute>
    				          <xsl:value-of select="@comment" /><br/>    
                            <!-- print information of time -->
                            <xsl:choose>
                                <xsl:when test="@rowcount > 1"> 
    				               <xsl:value-of select='substring(@starttime,12,5)'/> - <xsl:value-of select='substring(@endtime,12,5)'/> (<xsl:value-of select='@duration'/>)
                                </xsl:when>
                                <xsl:otherwise>
                                
                               </xsl:otherwise> 
                            </xsl:choose> 
                          </td>
                        </xsl:otherwise> 
                      </xsl:choose>   
    				 </xsl:when>
                   <xsl:otherwise>
                     
                   </xsl:otherwise> 
                </xsl:choose> 
          </xsl:when>
          <xsl:otherwise>
  			<td>
                <xsl:text> </xsl:text>
            </td>   	
          </xsl:otherwise>
        </xsl:choose>
  		</xsl:for-each>
    </tr>	
  </xsl:template>
</xsl:stylesheet>