<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" exclude-result-prefixes="fo">
  <xsl:output method="xml" version="1.0" omit-xml-declaration="no" indent="yes"/>
  
 	<xsl:param name="licencse" select="''"/> 
	<xsl:param name="date" select="''"/>
	<xsl:param name="hideclub" select="''"/>
	<xsl:param name="hidecountry" select="''"/>
	<xsl:param name="logo_event" select="''"/>
	<xsl:param name="logo_sponsor" select="''"/>
	<xsl:param name="logo_federation" select="''"/>
  
  <!-- ========================= -->
  <!-- root element: projectteam -->
  <!-- ========================= -->
  <xsl:template match="timetable">
    <fo:root xmlns:fo="http://www.w3.org/1999/XSL/Format" font-family="Arial">
     
     <fo:layout-master-set>
				<fo:simple-page-master master-name="simpleA4" page-height="29.7cm" page-width="21cm" margin-top="2cm" margin-bottom="2cm" margin-left="2cm" margin-right="2cm">
					<fo:region-body margin-top="2.5cm" margin-bottom="1.5cm"/>
					<fo:region-before extent="1.0cm"/>
					<fo:region-after extent="1.0cm"/>
				</fo:simple-page-master>
			</fo:layout-master-set>
			<fo:page-sequence master-reference="simpleA4">
      
      	<fo:static-content flow-name="xsl-region-before" display-align="before">
					<fo:block font-size="8pt" text-align="center">
						<fo:table table-layout="fixed" width="100%" >
							<fo:table-column column-width="4cm"/>
							<fo:table-column column-width="9cm"/>
							<fo:table-column column-width="4cm"/>
							<fo:table-body>
								<fo:table-row>
									<xsl:choose>
										<xsl:when test="string($logo_event)">
											<fo:table-cell text-align="center" display-align="center">
												<fo:block text-align="center">
													<fo:external-graphic height="2cm" width="4cm" content-height="scale-to-fit" content-width="scale-to-fit" scaling="uniform">
														<xsl:attribute name="src">
															url(file:/<xsl:value-of select="$logo_event" />)
														</xsl:attribute>
													</fo:external-graphic>
												</fo:block>
											</fo:table-cell> 
										</xsl:when>
										<xsl:otherwise>
											<fo:table-cell  text-align="center" display-align="center">
												<fo:block>
												</fo:block>
											</fo:table-cell> 
										</xsl:otherwise>
									</xsl:choose>	
									<fo:table-cell text-align="center" display-align="center">
										<fo:block font-size="10pt" font-weight="bold" space-after="5mm" text-align="center">
											<xsl:value-of select="@event"/> - <xsl:value-of select="@date"/>
										</fo:block>
										<fo:block font-size="12pt" font-weight="bold" space-after="5mm" text-align="center">
											<xsl:value-of select="@title"/>
										</fo:block>
									</fo:table-cell>
									<xsl:choose>
										<xsl:when test="string($logo_federation)">
											<fo:table-cell text-align="center" display-align="center">
												<fo:block text-align="center">
													<fo:external-graphic height="2cm" width="4cm" content-height="scale-to-fit" content-width="scale-to-fit" scaling="uniform">
														<xsl:attribute name="src">
															url(file:/<xsl:value-of select="$logo_federation" />)
														</xsl:attribute>
													</fo:external-graphic>
												</fo:block>
											</fo:table-cell> 
										</xsl:when>
										<xsl:otherwise>
											<fo:table-cell  text-align="center" display-align="center">
												<fo:block>
												</fo:block>
											</fo:table-cell> 
										</xsl:otherwise>
									</xsl:choose>				 
								</fo:table-row>
							</fo:table-body>
						</fo:table>
					</fo:block>
				</fo:static-content>

				<fo:static-content flow-name="xsl-region-after">
					<fo:block font-size="8pt" text-align="center">
						<fo:table table-layout="fixed" width="100%" >
							<fo:table-column column-width="14cm"/>
							<fo:table-column column-width="4cm"/>
							<fo:table-body>
								<fo:table-row>
									<xsl:choose>
										<xsl:when test="string($logo_sponsor)">
											<fo:table-cell text-align="center" display-align="center">
												<fo:block text-align="center">
													<fo:external-graphic height="3cm" width="14cm" content-height="scale-to-fit" content-width="scale-to-fit" scaling="uniform">
														<xsl:attribute name="src">
															url(file:/<xsl:value-of select="$logo_sponsor" />)
														</xsl:attribute>
													</fo:external-graphic>
												</fo:block>
											</fo:table-cell> 
										</xsl:when>
										<xsl:otherwise>
											<fo:table-cell  text-align="center" display-align="center">
												<fo:block>
												</fo:block>
											</fo:table-cell> 
										</xsl:otherwise>
									</xsl:choose>	
									
									<fo:table-cell text-align="left" display-align="center">
										<fo:block font-size="8pt" text-align="right">
											<fo:page-number/> / <fo:page-number-citation  ref-id="theEnd" />
										</fo:block>
									</fo:table-cell> 
								</fo:table-row>
							</fo:table-body>
						</fo:table>
					</fo:block>
				</fo:static-content>
        
        <fo:flow flow-name="xsl-region-body">
          <fo:block font-size="7pt">
              <xsl:apply-templates select="day"/>
          </fo:block>
          <fo:block id="theEnd" />
        </fo:flow>
     </fo:page-sequence>   
    </fo:root>
  </xsl:template>
  
  <xsl:template match="day">   
        <fo:table  table-layout="fixed" width="100%" >
           
            <fo:table-column column-width="2cm"/>
            <fo:table-column column-width="1cm"/>
			<fo:table-column column-width="0.3cm"/>
	        <fo:table-column column-width="proportional-column-width(1)"/>
			<fo:table-column column-width="2cm"/>
            
            <xsl:apply-templates select="headerRow"/>
            <fo:table-body>
              <xsl:apply-templates select="row"/> 
            </fo:table-body>  
        </fo:table>
        <xsl:if test="not(position() = last())">
        	<xsl:choose>
             <xsl:when test="@pagebreak = 'yes'">
                 <fo:block break-after="page">
               <xsl:text> </xsl:text>
            </fo:block> 
             </xsl:when>
             <xsl:otherwise/>
           </xsl:choose> 
    		
        </xsl:if>
  </xsl:template>
  
  <xsl:template match="headerRow">
    <fo:table-header text-align="center" display-align="center">
     <fo:table-row>
  	  <fo:table-cell border="1pt solid black"  display-align="center">
  	     <xsl:attribute name="number-columns-spanned">                
           5                
         </xsl:attribute>
         <fo:block font-size="12pt" font-weight="bold">
            <xsl:value-of select="//@event"/> - <xsl:value-of select="../@date"/>
         </fo:block>  
  	  </fo:table-cell>
     </fo:table-row>
      <fo:table-row>
  	  <fo:table-cell border="1pt solid black"  display-align="center">
  	     <xsl:attribute name="number-columns-spanned">                
           5                
         </xsl:attribute>
         <fo:block font-size="12pt" font-weight="bold">
            <xsl:value-of select="@tataminame"/>
         </fo:block>  
  	  </fo:table-cell>
     </fo:table-row>
     <fo:table-row>
  	  <fo:table-cell border="1pt solid black"  display-align="center">
         <fo:block font-size="10pt" font-weight="bold">
            Time
         </fo:block>  
  	  </fo:table-cell>
  	   <fo:table-cell border="1pt solid black"  display-align="center">
         <fo:block font-size="10pt" font-weight="bold">
            #
         </fo:block>  
  	  </fo:table-cell>
	   <fo:table-cell border="1pt solid black"  display-align="center">
         <fo:block font-size="10pt" font-weight="bold">
            
         </fo:block>  
  	  </fo:table-cell>
  	  <fo:table-cell border="1pt solid black"  display-align="center">
         <fo:block font-size="10pt" font-weight="bold">
            Match
         </fo:block>  
  	  </fo:table-cell>
	   <fo:table-cell border="1pt solid black"  display-align="center">
         <fo:block font-size="10pt" font-weight="bold">
            Info
         </fo:block>  
  	  </fo:table-cell>
     </fo:table-row>
   </fo:table-header> 
  </xsl:template>
  
  <xsl:template match="row">
  	<xsl:apply-templates select="cell"/>
  </xsl:template> 	
  
  
   <xsl:template match="cell">
   
   	   <xsl:choose>
           <xsl:when test="string(@id)">
                 <xsl:choose>
                    <xsl:when test="@firstCell = 'yes'">
                    
                    	 <fo:table-row>
                    	 
                    	 <!-- print information of time -->
                    	  <fo:table-cell  border="1pt solid black" text-align="center" display-align="center">
                           
                                   <fo:block font-size="8pt">
                                      <xsl:choose>
                                        <xsl:when test="@active = 'no'">
                                          <xsl:attribute name="font-weight">                
                                            normal                  
                                          </xsl:attribute>
                                          <xsl:attribute name="font-size">                
                                            5pt                  
                                          </xsl:attribute>     
                                        </xsl:when>
                                        <xsl:otherwise/>
                                      </xsl:choose> 
    				                  
    				                  <xsl:choose>
                                        <xsl:when test="@hidetime = 'no'">
                                         	<xsl:value-of select='substring(@starttime,12,5)'/> - <xsl:value-of select='substring(@endtime,12,5)'/>   
                                        </xsl:when>
                                        <xsl:otherwise/>
                                      </xsl:choose> 
    				                    </fo:block>
                               
                             </fo:table-cell> 
                             
                             <!-- print information of tatami -->
                             <!--
                             <fo:table-cell  border="1pt solid black" text-align="center" display-align="center">
                           
                                   <fo:block font-size="8pt">
                                      <xsl:choose>
                                        <xsl:when test="@active = 'no'">
                                          <xsl:attribute name="font-weight">                
                                            normal                  
                                          </xsl:attribute>
                                          <xsl:attribute name="font-size">                
                                            5pt                  
                                          </xsl:attribute>     
                                        </xsl:when>
                                        <xsl:otherwise/>
                                      </xsl:choose> 
    				                          <xsl:value-of select='@tatami'/>
    				                    </fo:block>
                               
                             </fo:table-cell> 
                             -->
                             <!-- end print information of tatami -->
                             
                             <!-- print information of match order -->
                             
                             <fo:table-cell  border="1pt solid black" text-align="center" display-align="center">
                           
                                   <fo:block font-size="8pt">
                                      <xsl:choose>
                                        <xsl:when test="@active = 'no'">
                                          <xsl:attribute name="font-weight">                
                                            normal                  
                                          </xsl:attribute>
                                          <xsl:attribute name="font-size">                
                                            5pt                  
                                          </xsl:attribute>     
                                        </xsl:when>
                                        <xsl:otherwise/>
                                      </xsl:choose> 
                                      
                                      <xsl:choose>
                    					<xsl:when test="@fightordershow = 'true'">
    				                		<xsl:value-of select='@fightorder'/>
    				                	</xsl:when>
                                        <xsl:otherwise/>
                                      </xsl:choose> 
    				                  
    				               </fo:block>
                               
                             </fo:table-cell> 
                             <!-- end print information of match order -->
                             
                            
							
							 
							 <fo:table-cell  border="1pt solid black" text-align="center" display-align="center">
								<xsl:attribute name="background-color">                
									<xsl:value-of select="@bgcolor"/>                    
								</xsl:attribute>
                                   <fo:block font-size="8pt">
                                      <xsl:choose>
                                        <xsl:when test="@active = 'no'">
                                          <xsl:attribute name="font-weight">                
                                            normal                  
                                          </xsl:attribute>
                                          <xsl:attribute name="font-size">                
                                            5pt                  
                                          </xsl:attribute>     
                                        </xsl:when>
                                        <xsl:otherwise/>
                                      </xsl:choose> 
    				                    </fo:block>
                               
                             </fo:table-cell> 
                    
    				          <xsl:choose>
    				          <!-- if it is a cateogry item -->
                        <xsl:when test="string(@catname)">
                          <fo:table-cell  border="1pt solid black" text-align="left" display-align="center">
                             
                            <fo:block font-size="10pt" font-weight="bold">
                              <xsl:choose>
                              <xsl:when test="@active = 'no'">
                                 <xsl:attribute name="font-weight">                
                                    normal                
                                 </xsl:attribute>
                                 <xsl:attribute name="font-size">                
                                    10pt                  
                                 </xsl:attribute>     
                              </xsl:when>
                              <xsl:otherwise>
                                  <xsl:attribute name="text-decoration">                
                                    underline                  
                                 </xsl:attribute>
                              </xsl:otherwise>
                              </xsl:choose>  
    				                  <xsl:value-of select="@origCatname" /> (<xsl:value-of select="@entries" />)
    				                </fo:block>
    				                
    				                  <!-- print additional cateory name string -->
    				                 <xsl:choose>
                                <xsl:when test="starts-with(@catname, @origCatname)">
                                   <fo:block font-size="12pt" font-weight="normal">
                                      <xsl:choose>
                                        <xsl:when test="@active = 'no'">
                                          <xsl:attribute name="font-weight">                
                                            normal                  
                                          </xsl:attribute>
                                          <xsl:attribute name="font-size">                
                                            10pt                  
                                          </xsl:attribute>     
                                        </xsl:when>
                                        <xsl:otherwise/>
                                      </xsl:choose>
                                      
                                      <xsl:choose>
        							  <xsl:when test="contains(@catname, 'vs')">
        							  <fo:block>
        							  <xsl:value-of select="substring-before(substring(@catname,string-length(@origCatname)+1), 'vs')" />
        							  </fo:block>
        							  <fo:block>
        							  <xsl:text>&#160;&#160;&#160;&#160;</xsl:text><xsl:value-of select="substring-after(substring(@catname,string-length(@origCatname)+1), 'vs')" />
        							  </fo:block>
        							  </xsl:when>
        							  <xsl:otherwise>
        							  <xsl:value-of select='substring(@catname,string-length(@origCatname)+1)'/> 
        							  </xsl:otherwise>
    								  </xsl:choose>
                                       
    				                          
          	                       </fo:block>
                                </xsl:when>
                                <xsl:otherwise>
                                	<fo:block font-size="10pt"  font-weight="normal">
                                      <xsl:choose>
                                        <xsl:when test="@active = 'no'">
                                          <xsl:attribute name="font-weight">                
                                            normal                  
                                          </xsl:attribute>
                                          <xsl:attribute name="font-size">                
                                            10pt                  
                                          </xsl:attribute>     
                                        </xsl:when>
                                        <xsl:otherwise/>
                                      </xsl:choose> 
    				                          <xsl:value-of select='@catname'/> 
          	                       </fo:block>
                               </xsl:otherwise> 
                              </xsl:choose>
                              
                          </fo:table-cell> 
    				            </xsl:when>
                        <xsl:otherwise>
                        <!-- if it is a custom item -->
                          <fo:table-cell  border="1pt solid black" text-align="center" display-align="center">
                     
                            <xsl:attribute name="background-color">                
                              <xsl:value-of select="@bgcolor"/>                    
                            </xsl:attribute>
                            <fo:block font-size="10pt" font-weight="bold">
                              <xsl:choose>
                                        <xsl:when test="@active = 'no'">
                                          <xsl:attribute name="font-weight">                
                                            normal                  
                                          </xsl:attribute>
                                          <xsl:attribute name="font-size">                
                                            10pt                  
                                          </xsl:attribute>     
                                        </xsl:when>
                                       <xsl:otherwise>
                                        <xsl:attribute name="text-decoration">                
                                          underline                  
                                        </xsl:attribute>
                                      </xsl:otherwise>
                              </xsl:choose> 
    				                  <xsl:value-of select="@comment" />
    				                </fo:block>
    				                
                          </fo:table-cell>
                        </xsl:otherwise> 
                      </xsl:choose>   
					  
					   <!-- print information of info -->
                             
                             <fo:table-cell  border="1pt solid black" text-align="center" display-align="center">
                           
                                   <fo:block font-size="8pt">
                                      <xsl:choose>
                                        <xsl:when test="@active = 'no'">
                                          <xsl:attribute name="font-weight">                
                                            normal                  
                                          </xsl:attribute>
                                          <xsl:attribute name="font-size">                
                                            5pt                  
                                          </xsl:attribute>     
                                        </xsl:when>
                                        <xsl:otherwise/>
                                      </xsl:choose> 
    				                          <xsl:value-of select='@info'/>
    				                    </fo:block>
                               
                             </fo:table-cell> 
                             <!-- end print information of info -->
                      
                       </fo:table-row>
    				  </xsl:when>
                   <xsl:otherwise>
                     
                   </xsl:otherwise> 
                </xsl:choose> 
          </xsl:when>
          <xsl:otherwise>
          </xsl:otherwise>
        </xsl:choose>
   
   </xsl:template> 

</xsl:stylesheet>
