<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" exclude-result-prefixes="fo">
  <xsl:output method="xml" version="1.0" omit-xml-declaration="no" indent="yes"/>
  
  <xsl:param name="licencse" select="''"/> 
  <xsl:param name="date" select="''"/>
  
  <!-- ========================= -->
  <!-- root element: projectteam -->
  <!-- ========================= -->
  <xsl:template match="timetable">
    <fo:root xmlns:fo="http://www.w3.org/1999/XSL/Format" font-family="Arial">
     
      <fo:layout-master-set>
        <fo:simple-page-master master-name="simpleA4" page-height="21cm" page-width="29.7cm" margin-top="1cm" margin-bottom="1cm" margin-left="1cm" margin-right="1cm">
          <fo:region-body margin-top="0.5cm" margin-bottom="0.5cm"/>
		      <fo:region-before extent="0.5cm"/>
          <fo:region-after extent="0.1cm"/>
        </fo:simple-page-master>
      </fo:layout-master-set>
      <fo:page-sequence master-reference="simpleA4" language="de">
      
      	<fo:static-content flow-name="xsl-region-before" display-align="before">
      	  <fo:block font-size="8pt" font-weight="bold" space-after="2mm" text-align="center">
      	  <xsl:text>  </xsl:text>
          </fo:block>
   		</fo:static-content>
   		
  		<fo:static-content flow-name="xsl-region-after">
	          <fo:block font-size="6pt" text-align="center" space-before="3mm">
          		<xsl:value-of select="$licencse"/>
          	</fo:block>
          	<fo:block font-size="6pt" text-align="right">
          		<fo:page-number/> / <fo:page-number-citation  ref-id="theEnd" />
          	</fo:block>
   		</fo:static-content>
        
        <fo:flow flow-name="xsl-region-body">
          <fo:block font-size="7pt">
              <xsl:apply-templates select="day"/>
          </fo:block>
          <fo:block id="theEnd" />
        </fo:flow>
     </fo:page-sequence>   
    </fo:root>
  </xsl:template>
  
  <xsl:template match="day">   
        <fo:table  table-layout="fixed" width="100%" >
            <fo:table-column column-width="1cm"/>
  	        <xsl:for-each select="headerRow/headerCell">
	               <fo:table-column column-width="proportional-column-width(1)"/>
            </xsl:for-each>
            <xsl:apply-templates select="headerRow"/>
            <fo:table-body>
              <xsl:apply-templates select="row"/> 
            </fo:table-body>  
        </fo:table>
       <xsl:if test="not(position() = last())">
        	<xsl:choose>
             <xsl:when test="@pagebreak = 'yes'">
                 <fo:block break-after="page">
               <xsl:text> </xsl:text>
            </fo:block> 
             </xsl:when>
             <xsl:otherwise/>
           </xsl:choose> 
    		
        </xsl:if>
  </xsl:template>
  
  <xsl:template match="headerRow">
    <fo:table-header text-align="center" display-align="center">
     <fo:table-row>
  	  <fo:table-cell border="1pt solid black"  display-align="center">
  	     <xsl:attribute name="number-columns-spanned">                
           <xsl:value-of select="../@tatamis"/>  + 1                  
         </xsl:attribute>
         <fo:block font-size="12pt" font-weight="bold">
            <xsl:value-of select="//@event"/> - <xsl:value-of select="../@date"/>
         </fo:block>  
  	  </fo:table-cell>
     </fo:table-row>
     <fo:table-row>
  	  <fo:table-cell border="1pt solid black" background-color="#c6c6c6" display-align="center">
  	     <fo:block font-size="7pt">  
         </fo:block>  
  	  </fo:table-cell>
    	<xsl:for-each select="headerCell">
  			<fo:table-cell border="1pt solid black" background-color="#c6c6c6" display-align="center">
  				<fo:block font-size="7pt" font-weight="bold" text-align="center">
    				<xsl:value-of select="@name" />
    			</fo:block>
    		</fo:table-cell>
  		</xsl:for-each>
    </fo:table-row>
   </fo:table-header> 
  </xsl:template>
  
  <xsl:template match="row">
    <xsl:variable name="rowspanned" select="last() - position() + 1"/>
    
  	<fo:table-row>
  	  <fo:table-cell border="1pt solid black" text-align="center" display-align="center">
  	     <fo:block font-size="7pt">  
          <xsl:choose>
             <xsl:when test="@hidetime = 'no'">
                 <xsl:value-of select="@time" /> 
             </xsl:when>
             <xsl:otherwise/>
           </xsl:choose> 
         	</fo:block>  
  	  </fo:table-cell>
      <xsl:for-each select="cell">
    	   <xsl:choose>
           <xsl:when test="string(@id)">
                 <xsl:choose>
                    <xsl:when test="@firstCell = 'yes'">
    				          <xsl:choose>
    				          <!-- if it is a cateogry item -->
                        <xsl:when test="string(@catname)">
                          <fo:table-cell  border="1pt solid black" text-align="center" display-align="center">
                            <xsl:attribute name="number-rows-spanned">                
    			                    <xsl:choose>
                                 <xsl:when test="@rowcount > $rowspanned">
                                    <xsl:value-of select="$rowspanned"/>
                                </xsl:when>
                                <xsl:otherwise>
                                  <xsl:value-of select="@rowcount"/>  
                               </xsl:otherwise> 
                              </xsl:choose>                  
                            </xsl:attribute> 
                            <xsl:attribute name="background-color">                
                              <xsl:value-of select="@bgcolor"/>                    
                            </xsl:attribute>
                            <fo:block font-size="7pt" font-weight="bold">
                              <xsl:choose>
                                        <xsl:when test="@active = 'no'">
                                          <xsl:attribute name="font-weight">                
                                            normal                  
                                          </xsl:attribute>
                                          <xsl:attribute name="font-size">                
                                            5pt                  
                                          </xsl:attribute>     
                                        </xsl:when>
                                        <xsl:otherwise>
                                          <xsl:attribute name="text-decoration">                
                                            underline                  
                                          </xsl:attribute>
                                        </xsl:otherwise>
                              </xsl:choose> 
    				                  <xsl:value-of select="@origCatname" /> (<xsl:value-of select="@entries" />)
    				                </fo:block>
    				                
    				                  <!-- print additional cateory name string -->
    				                 <xsl:choose>
                                <xsl:when test="starts-with(@catname, @origCatname)">
                                   <fo:block font-size="7pt">
                                      <xsl:choose>
                                        <xsl:when test="@active = 'no'">
                                          <xsl:attribute name="font-weight">                
                                            normal                  
                                          </xsl:attribute>
                                          <xsl:attribute name="font-size">                
                                            5pt                  
                                          </xsl:attribute>     
                                        </xsl:when>
                                        <xsl:otherwise/>
                                      </xsl:choose> 
    				                          <xsl:value-of select='substring(@catname,string-length(@origCatname)+1)'/> 
          	                       </fo:block>
                                </xsl:when>
                                <xsl:otherwise>
                                	<fo:block font-size="7pt">
                                      <xsl:choose>
                                        <xsl:when test="@active = 'no'">
                                          <xsl:attribute name="font-weight">                
                                            normal                  
                                          </xsl:attribute>
                                          <xsl:attribute name="font-size">                
                                            5pt                  
                                          </xsl:attribute>     
                                        </xsl:when>
                                        <xsl:otherwise/>
                                      </xsl:choose> 
    				                          <xsl:value-of select='@catname'/> 
          	                       </fo:block>
                               </xsl:otherwise> 
                              </xsl:choose>
                              
                            <!-- print information of time -->
                             <xsl:choose>
                                <xsl:when test="@rowcount > 1">
                                   <fo:block font-size="6pt">
                                      <xsl:choose>
                                        <xsl:when test="@active = 'no'">
                                          <xsl:attribute name="font-weight">                
                                            normal                  
                                          </xsl:attribute>
                                          <xsl:attribute name="font-size">                
                                            5pt                  
                                          </xsl:attribute>     
                                        </xsl:when>
                                        <xsl:otherwise/>
                                      </xsl:choose> 
    				                  
    				                  <xsl:choose>
                                        <xsl:when test="@hidetime = 'no'">
                                         	<xsl:value-of select='substring(@starttime,12,5)'/> - <xsl:value-of select='substring(@endtime,12,5)'/>   
                                        </xsl:when>
                                        <xsl:otherwise/>
                                      </xsl:choose> 
    				                       </fo:block>
                                </xsl:when>
                                <xsl:otherwise>
                                
                               </xsl:otherwise> 
                              </xsl:choose> 
                          </fo:table-cell> 
    				            </xsl:when>
                        <xsl:otherwise>
                        <!-- if it is a custom item -->
                          <fo:table-cell  border="1pt solid black" text-align="center" display-align="center">
                            <xsl:attribute name="number-rows-spanned">                
                              <xsl:choose>
                                 <xsl:when test="@rowcount > $rowspanned">
                                    <xsl:value-of select="$rowspanned"/>
                                </xsl:when>
                                <xsl:otherwise>
                                  <xsl:value-of select="@rowcount"/>  
                               </xsl:otherwise> 
                              </xsl:choose>                        
                            </xsl:attribute>
                            <xsl:attribute name="background-color">                
                              <xsl:value-of select="@bgcolor"/>                    
                            </xsl:attribute>
                            <fo:block font-size="7pt" font-weight="bold">
                              <xsl:choose>
                                        <xsl:when test="@active = 'no'">
                                          <xsl:attribute name="font-weight">                
                                            normal                  
                                          </xsl:attribute>
                                          <xsl:attribute name="font-size">                
                                            5pt                  
                                          </xsl:attribute>     
                                        </xsl:when>
                                        <xsl:otherwise>
                                          <xsl:attribute name="text-decoration">                
                                            underline                  
                                          </xsl:attribute>
                                        </xsl:otherwise>
                              </xsl:choose> 
    				                  <xsl:value-of select="@comment" />
    				                </fo:block>
    				                
                            <!-- print information of time -->
                            <xsl:choose>
                                <xsl:when test="@rowcount > 1">
                                   <fo:block font-size="6pt">
                                      <xsl:choose>
                                        <xsl:when test="@active = 'no'">
                                          <xsl:attribute name="font-weight">                
                                            normal                  
                                          </xsl:attribute>
                                          <xsl:attribute name="font-size">                
                                            5pt                  
                                          </xsl:attribute>     
                                        </xsl:when>
                                        <xsl:otherwise/>
                                      </xsl:choose> 
    				                          <xsl:value-of select='substring(@starttime,12,5)'/> - <xsl:value-of select='substring(@endtime,12,5)'/> (<xsl:value-of select='@duration'/>)
    				                       </fo:block>
                                </xsl:when>
                                <xsl:otherwise>
                                
                               </xsl:otherwise> 
                            </xsl:choose> 
                          </fo:table-cell>
                        </xsl:otherwise> 
                      </xsl:choose>   
    				        </xsl:when>
                   <xsl:otherwise>
                     
                   </xsl:otherwise> 
                </xsl:choose> 
          </xsl:when>
          <xsl:otherwise>
  				  <fo:table-cell border="1pt solid black" text-align="center">
              <fo:block font-size="7pt">
                <xsl:text> </xsl:text>
    			    </fo:block>
            </fo:table-cell>   	
          </xsl:otherwise>
        </xsl:choose>
  		</xsl:for-each>
    </fo:table-row>	
  </xsl:template>

</xsl:stylesheet>
