<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" exclude-result-prefixes="fo">
	<xsl:output method="xml" version="1.0" omit-xml-declaration="no" indent="yes"/>

	<xsl:param name="licencse" select="''"/> 
	<xsl:param name="date" select="''"/>
	<xsl:param name="logo_event" select="''"/>
	<xsl:param name="logo_sponsor" select="''"/>
	<xsl:param name="logo_federation" select="''"/>

	<!-- ========================= -->
	<!-- root element: projectteam -->
	<!-- ========================= -->
	<xsl:template match="List_of_medals">
		<fo:root xmlns:fo="http://www.w3.org/1999/XSL/Format" font-family="Arial">

			<fo:layout-master-set>
				<fo:simple-page-master master-name="simpleA4" page-height="21cm" page-width="29.7cm" margin-top="2cm" margin-bottom="2cm" margin-left="2cm" margin-right="2cm">
					<fo:region-body margin-top="2.5cm" margin-bottom="1.5cm"/>
					<fo:region-before extent="1.0cm"/>
					<fo:region-after extent="1.0cm"/>
				</fo:simple-page-master>
			</fo:layout-master-set>
			<fo:page-sequence master-reference="simpleA4" language="de">

				<fo:static-content flow-name="xsl-region-before" display-align="before">
					<fo:block font-size="8pt" text-align="center">
						<fo:table table-layout="fixed" width="100%" >
							<fo:table-column column-width="4cm"/>
							<fo:table-column column-width="17cm"/>
							<fo:table-column column-width="4cm"/>
							<fo:table-body>
								<fo:table-row>
									<xsl:choose>
										<xsl:when test="string($logo_event)">
											<fo:table-cell text-align="center" display-align="center">
												<fo:block text-align="center">
													<fo:external-graphic height="2cm" width="4cm" content-height="scale-to-fit" content-width="scale-to-fit" scaling="uniform">
														<xsl:attribute name="src">
															url(file:/<xsl:value-of select="$logo_event" />)
														</xsl:attribute>
													</fo:external-graphic>
												</fo:block>
											</fo:table-cell> 
										</xsl:when>
										<xsl:otherwise>
											<fo:table-cell  text-align="center" display-align="center">
												<fo:block>
												</fo:block>
											</fo:table-cell> 
										</xsl:otherwise>
									</xsl:choose>	
									<fo:table-cell text-align="center" display-align="center">
										<fo:block font-size="10pt" font-weight="bold" space-after="5mm" text-align="center">
											<xsl:value-of select="@event"/> - <xsl:value-of select="@date"/>
										</fo:block>
										<fo:block font-size="12pt" font-weight="bold" space-after="5mm" text-align="center">
											<xsl:value-of select="@title"/>
										</fo:block>

									</fo:table-cell>
									<xsl:choose>
										<xsl:when test="string($logo_federation)">
											<fo:table-cell text-align="center" display-align="center">
												<fo:block text-align="center">
													<fo:external-graphic height="2cm" width="4cm" content-height="scale-to-fit" content-width="scale-to-fit" scaling="uniform">
														<xsl:attribute name="src">
															url(file:/<xsl:value-of select="$logo_federation" />)
														</xsl:attribute>
													</fo:external-graphic>
												</fo:block>
											</fo:table-cell> 
										</xsl:when>
										<xsl:otherwise>
											<fo:table-cell  text-align="center" display-align="center">
												<fo:block>
												</fo:block>
											</fo:table-cell> 
										</xsl:otherwise>
									</xsl:choose>				 
								</fo:table-row>
							</fo:table-body>
						</fo:table>
					</fo:block>
				</fo:static-content>

				<fo:static-content flow-name="xsl-region-after">
					<fo:block font-size="8pt" text-align="center">
						<fo:table table-layout="fixed" width="100%" >
							<fo:table-column column-width="4cm"/>
							<fo:table-column column-width="17cm"/>
							<fo:table-column column-width="4cm"/>
							<fo:table-body>
								<fo:table-row>
									<xsl:choose>
										<xsl:when test="string($logo_sponsor)">
											<fo:table-cell text-align="center" display-align="center">
												<fo:block text-align="center">
													<fo:external-graphic height="2cm" width="4cm" content-height="scale-to-fit" content-width="scale-to-fit" scaling="uniform">
														<xsl:attribute name="src">
															url(file:/<xsl:value-of select="$logo_sponsor" />)
														</xsl:attribute>
													</fo:external-graphic>
												</fo:block>
											</fo:table-cell> 
										</xsl:when>
										<xsl:otherwise>
											<fo:table-cell  text-align="center" display-align="center">
												<fo:block>
												</fo:block>
											</fo:table-cell> 
										</xsl:otherwise>
									</xsl:choose>	
									<fo:table-cell text-align="center" display-align="center">
										<fo:block font-size="7pt" text-align="center">
											<xsl:value-of select="$licencse"/>
										</fo:block>
									</fo:table-cell> 
									<fo:table-cell text-align="center" display-align="center">
										<fo:block font-size="8pt" text-align="right">
											<fo:page-number/> / <fo:page-number-citation  ref-id="theEnd" />
										</fo:block>
									</fo:table-cell> 
								</fo:table-row>
							</fo:table-body>
						</fo:table>
					</fo:block>
				</fo:static-content>

				<fo:flow flow-name="xsl-region-body">
					<fo:block font-size="8pt">
						<fo:table table-layout="fixed" width="100%" border-collapse="separate">
							<fo:table-column column-width="2cm"/>
							<fo:table-column column-width="13.5cm"/>
							<fo:table-column column-width="2cm"/>
							<fo:table-column column-width="2cm"/>
							<fo:table-column column-width="2cm"/>
							<fo:table-column column-width="2cm"/>
							<fo:table-column column-width="2cm"/>
							<fo:table-body>
								<xsl:apply-templates select="Medals"/>
							</fo:table-body>
						</fo:table>
					</fo:block>
					<fo:block id="theEnd" />
				</fo:flow>
			</fo:page-sequence>   
		</fo:root>
	</xsl:template>

	<xsl:template match="Medals">
		<fo:table-row background-color="#cccccc">
			<fo:table-cell border="0.5pt solid black">
				<fo:block  text-align="center">
					<xsl:attribute name="font-weight">bold</xsl:attribute>
					<xsl:attribute name="font-size">10pt</xsl:attribute>
					<xsl:value-of select="@head1"/>
				</fo:block>
			</fo:table-cell>
			<fo:table-cell border="0.5pt solid black">
				<fo:block  >
					<xsl:attribute name="font-weight">bold</xsl:attribute>
					<xsl:attribute name="font-size">10pt</xsl:attribute>
					<xsl:value-of select="@head2"/>
				</fo:block>
			</fo:table-cell>
			<fo:table-cell border="0.5pt solid black">
				<fo:block  text-align="center">
					<xsl:attribute name="font-weight">bold</xsl:attribute>
					<xsl:attribute name="font-size">10pt</xsl:attribute>
					<xsl:value-of select="@head3"/>
				</fo:block>
			</fo:table-cell>
			<fo:table-cell border="0.5pt solid black">
				<fo:block  text-align="center">
					<xsl:attribute name="font-weight">bold</xsl:attribute>
					<xsl:attribute name="font-size">10pt</xsl:attribute>
					<xsl:value-of select="@head4"/>
				</fo:block>
			</fo:table-cell>
			<fo:table-cell border="0.5pt solid black">
				<fo:block  text-align="center">
					<xsl:attribute name="font-weight">bold</xsl:attribute>
					<xsl:attribute name="font-size">10pt</xsl:attribute>
					<xsl:value-of select="@head5"/>
				</fo:block>
			</fo:table-cell>
			<fo:table-cell border="0.5pt solid black">
				<fo:block  text-align="center">
					<xsl:attribute name="font-weight">bold</xsl:attribute>
					<xsl:attribute name="font-size">10pt</xsl:attribute>
					<xsl:value-of select="@head6"/>
				</fo:block>
			</fo:table-cell>
			<fo:table-cell border="0.5pt solid black">
				<fo:block  text-align="center">
					<xsl:attribute name="font-weight">bold</xsl:attribute>
					<xsl:attribute name="font-size">10pt</xsl:attribute>
					<xsl:value-of select="@head7"/>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
		<xsl:apply-templates select="Medal"/>
	</xsl:template>

	<xsl:template match="Medal">
		<fo:table-row>
			<fo:table-cell border-bottom="0.5pt solid black">
				<fo:block text-align="center">
					<xsl:value-of select="Rank"/>
				</fo:block>
			</fo:table-cell>
			<fo:table-cell border-bottom="0.5pt solid black">
				<fo:block>
					<fo:external-graphic height="0.3cm" width="0.6cm" content-height="scale-to-fit" content-width="scale-to-fit" scaling="uniform">
						<xsl:attribute name="src">
							<xsl:value-of select="Nation_Img" />
						</xsl:attribute>
					</fo:external-graphic>
					<xsl:value-of select="Club"/>
				</fo:block>
			</fo:table-cell>
			<fo:table-cell border-bottom="0.5pt solid black">
				<fo:block text-align="center">
					<xsl:value-of select="Place1"/>
				</fo:block>
			</fo:table-cell>
			<fo:table-cell border-bottom="0.5pt solid black">
				<fo:block text-align="center">
					<xsl:value-of select="Place2"/>
				</fo:block>
			</fo:table-cell>
			<fo:table-cell border-bottom="0.5pt solid black">
				<fo:block text-align="center">
					<xsl:value-of select="Place3"/>
				</fo:block>
			</fo:table-cell>
			<fo:table-cell border-bottom="0.5pt solid black">
				<fo:block text-align="center">
					<xsl:value-of select="Place5"/>
				</fo:block>
			</fo:table-cell>
			<fo:table-cell border-bottom="0.5pt solid black">
				<fo:block text-align="center">
					<xsl:value-of select="Place7"/>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
	</xsl:template>

</xsl:stylesheet>
