<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" exclude-result-prefixes="fo">
	<xsl:output method="xml" version="1.0" omit-xml-declaration="no" indent="yes"/>

	<xsl:param name="licencse" select="''"/> 
	<xsl:param name="date" select="''"/>
	<xsl:param name="logo_event" select="''"/>
	<xsl:param name="logo_sponsor" select="''"/>
	<xsl:param name="logo_federation" select="''"/>

	<!-- ========================= -->
	<!-- root element: projectteam -->
	<!-- ========================= -->
	<xsl:template match="List_of_medals">
		<fo:root xmlns:fo="http://www.w3.org/1999/XSL/Format" font-family="Arial">

			<fo:layout-master-set>
				<fo:simple-page-master master-name="simpleA4" page-height="21cm" page-width="29.7cm" margin-top="2cm" margin-bottom="2cm" margin-left="2cm" margin-right="2cm">
					<fo:region-body margin-top="2.5cm" margin-bottom="1.5cm"/>
					<fo:region-before extent="1.0cm"/>
					<fo:region-after extent="1.0cm"/>
				</fo:simple-page-master>
			</fo:layout-master-set>
			<fo:page-sequence master-reference="simpleA4" language="de">

				<fo:static-content flow-name="xsl-region-before" display-align="before">
					<fo:block font-size="8pt" text-align="center">
						<fo:table table-layout="fixed" width="100%" >
							<fo:table-column column-width="4cm"/>
							<fo:table-column column-width="17cm"/>
							<fo:table-column column-width="4cm"/>
							<fo:table-body>
								<fo:table-row>
									<xsl:choose>
										<xsl:when test="string($logo_event)">
											<fo:table-cell text-align="center" display-align="center">
												<fo:block text-align="center">
													<fo:external-graphic height="2cm" width="4cm" content-height="scale-to-fit" content-width="scale-to-fit" scaling="uniform">
														<xsl:attribute name="src">
															url(file:/<xsl:value-of select="$logo_event" />)
														</xsl:attribute>
													</fo:external-graphic>
												</fo:block>
											</fo:table-cell> 
										</xsl:when>
										<xsl:otherwise>
											<fo:table-cell  text-align="center" display-align="center">
												<fo:block>
												</fo:block>
											</fo:table-cell> 
										</xsl:otherwise>
									</xsl:choose>	
									<fo:table-cell text-align="center" display-align="center">
										<fo:block font-size="10pt" font-weight="bold" space-after="5mm" text-align="center">
											<xsl:value-of select="@event"/> - <xsl:value-of select="@date"/>
										</fo:block>
										<fo:block font-size="12pt" font-weight="bold" space-after="5mm" text-align="center">
											<xsl:value-of select="@title"/>
										</fo:block>

									</fo:table-cell>
									<xsl:choose>
										<xsl:when test="string($logo_federation)">
											<fo:table-cell text-align="center" display-align="center">
												<fo:block text-align="center">
													<fo:external-graphic height="2cm" width="4cm" content-height="scale-to-fit" content-width="scale-to-fit" scaling="uniform">
														<xsl:attribute name="src">
															url(file:/<xsl:value-of select="$logo_federation" />)
														</xsl:attribute>
													</fo:external-graphic>
												</fo:block>
											</fo:table-cell> 
										</xsl:when>
										<xsl:otherwise>
											<fo:table-cell  text-align="center" display-align="center">
												<fo:block>
												</fo:block>
											</fo:table-cell> 
										</xsl:otherwise>
									</xsl:choose>				 
								</fo:table-row>
							</fo:table-body>
						</fo:table>
					</fo:block>
				</fo:static-content>

				<fo:static-content flow-name="xsl-region-after">
					<fo:block font-size="8pt" text-align="center">
						<fo:table table-layout="fixed" width="100%" >
							<fo:table-column column-width="4cm"/>
							<fo:table-column column-width="17cm"/>
							<fo:table-column column-width="4cm"/>
							<fo:table-body>
								<fo:table-row>
									<xsl:choose>
										<xsl:when test="string($logo_sponsor)">
											<fo:table-cell text-align="center" display-align="center">
												<fo:block text-align="center">
													<fo:external-graphic height="2cm" width="4cm" content-height="scale-to-fit" content-width="scale-to-fit" scaling="uniform">
														<xsl:attribute name="src">
															url(file:/<xsl:value-of select="$logo_sponsor" />)
														</xsl:attribute>
													</fo:external-graphic>
												</fo:block>
											</fo:table-cell> 
										</xsl:when>
										<xsl:otherwise>
											<fo:table-cell  text-align="center" display-align="center">
												<fo:block>
												</fo:block>
											</fo:table-cell> 
										</xsl:otherwise>
									</xsl:choose>	
									<fo:table-cell text-align="center" display-align="center">
										<fo:block font-size="7pt" text-align="center">
											<xsl:value-of select="$licencse"/>
										</fo:block>
									</fo:table-cell> 
									<fo:table-cell text-align="center" display-align="center">
										<fo:block font-size="8pt" text-align="right">
											<fo:page-number/> / <fo:page-number-citation  ref-id="theEnd" />
										</fo:block>
									</fo:table-cell> 
								</fo:table-row>
							</fo:table-body>
						</fo:table>
					</fo:block>
				</fo:static-content>

				<fo:flow flow-name="xsl-region-body">
					<fo:block font-size="8pt">
						<fo:table table-layout="fixed" width="100%" border-collapse="separate">
							<fo:table-column column-width="1cm"/>
							<fo:table-column column-width="8cm"/>
							
							<xsl:for-each select="Rowcount">
								<fo:table-column column-width="proportional-column-width(1)"/>
							</xsl:for-each>
							
							<fo:table-body>
								<xsl:apply-templates />
							</fo:table-body>
						</fo:table>
					</fo:block>
					<fo:block id="theEnd" />
				</fo:flow>
			</fo:page-sequence>   
		</fo:root>
	</xsl:template>
	
	<xsl:template match="Head">
		<fo:table-row background-color="#cccccc">
			<fo:table-cell border-top="0.5pt solid black" border-left="0.5pt solid black" border-right="0.5pt solid black" number-rows-spanned="2" display-align="center">
				<fo:block font-size="7pt" font-weight="bold" text-align="center"  display-align="center" >
					Rank
				</fo:block>
			</fo:table-cell>
			
			<fo:table-cell border-top="0.5pt solid black" border-left="0.5pt solid black" border-right="0.5pt solid black" number-rows-spanned="2" display-align="center">
				<fo:block font-size="7pt" font-weight="bold" text-align="left"   margin-left="1mm" display-align="center">
					Country
				</fo:block>
			</fo:table-cell>
			
			<fo:table-cell border="0.5pt solid black"  number-columns-spanned="4">
				<fo:block font-size="10pt" font-weight="bold" text-align="center">
					Men
				</fo:block>
			</fo:table-cell>
			
			<fo:table-cell border="0.5pt solid black"  number-columns-spanned="4">
				<fo:block font-size="10pt" font-weight="bold" text-align="center">
					Women
				</fo:block>
			</fo:table-cell>
			
			<fo:table-cell border="0.5pt solid black"  number-columns-spanned="4">
				<fo:block font-size="10pt" font-weight="bold" text-align="center">
					Mixed
				</fo:block>
			</fo:table-cell>
			
			<fo:table-cell border="0.5pt solid black"  number-columns-spanned="4">
				<fo:block font-size="10pt" font-weight="bold" text-align="center">
					Total
				</fo:block>
			</fo:table-cell>
			
		</fo:table-row>
		
		<fo:table-row>
			<xsl:for-each select="Headfield">
				<xsl:if test="position() > 2">
				<fo:table-cell border="0.5pt solid black">
					<fo:block font-size="7pt" font-weight="bold" text-align="right"  margin-right="1mm">
						<xsl:choose>
							<xsl:when test=". = 'Total'">
								<xsl:text>Tot</xsl:text>
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="." />
							</xsl:otherwise>
						</xsl:choose>	
					</fo:block>
				</fo:table-cell>
				</xsl:if>
			</xsl:for-each>
		</fo:table-row>	
		
	</xsl:template>

	<xsl:template match="Medal">
		<fo:table-row>
			<fo:table-cell border="0.5pt solid black">
				<fo:block text-align="right" font-size="7pt" margin-right="1mm">
					<xsl:value-of select="Rank"/>
				</fo:block>
			</fo:table-cell>
			<fo:table-cell border="0.5pt solid black"  margin-left="1mm">
				<fo:block font-size="7pt">
					<xsl:value-of select="Club"/>
				</fo:block>
			</fo:table-cell>
			<xsl:for-each select="Place">
				<fo:table-cell border="0.5pt solid black">
						<xsl:choose>
							<xsl:when test=". != '0'">
								<fo:block text-align="right" font-size="7pt" margin-right="1mm" >
									<xsl:value-of select="."/>
								</fo:block>
							</xsl:when>
							<xsl:otherwise>
								<fo:block>
								</fo:block>
							</xsl:otherwise>
						</xsl:choose>
				</fo:table-cell>
			</xsl:for-each>
			
		</fo:table-row>
	</xsl:template>
	
	<xsl:template match="Totals">
		<fo:table-row>
			<fo:table-cell border="0.5pt solid black">
				<fo:block text-align="right" font-size="7pt" margin-right="1mm"  >
					<xsl:value-of select="Rank"/>
				</fo:block>
			</fo:table-cell>
			<fo:table-cell border="0.5pt solid black"  margin-left="1mm"  >
				<fo:block font-size="7pt" text-align="right">
					<xsl:value-of select="Club"/>
				</fo:block>
			</fo:table-cell>
			<xsl:for-each select="Place">
				<fo:table-cell border="0.5pt solid black">
						<xsl:choose>
							<xsl:when test=". != '0'">
								<fo:block text-align="right" font-size="7pt" margin-right="1mm"  >
									<xsl:value-of select="."/>
								</fo:block>
							</xsl:when>
							<xsl:otherwise>
								<fo:block>
								</fo:block>
							</xsl:otherwise>
						</xsl:choose>
				</fo:table-cell>
			</xsl:for-each>
			
		</fo:table-row>
	</xsl:template>

</xsl:stylesheet>
