<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" exclude-result-prefixes="fo">
  <xsl:output method="xml" version="1.0" omit-xml-declaration="no" indent="yes"/>
  
  <xsl:param name="licencse" select="''"/> 
  <xsl:param name="date" select="''"/>
  
  <!-- ========================= -->
  <!-- root element: projectteam -->
  <!-- ========================= -->
  <xsl:template match="List_of_medals">
    <fo:root xmlns:fo="http://www.w3.org/1999/XSL/Format" font-family="Arial">
     
      <fo:layout-master-set>
        <fo:simple-page-master master-name="simpleA4" page-height="21cm" page-width="29.7cm" margin-top="2cm" margin-bottom="2cm" margin-left="2cm" margin-right="2cm">
          <fo:region-body margin-top="5mm" margin-bottom="1.5cm"/>
		  <fo:region-before extent="1cm"/>
          <fo:region-after extent="1.0cm"/>
        </fo:simple-page-master>
      </fo:layout-master-set>
      <fo:page-sequence master-reference="simpleA4" language="de">
   		
   		<fo:static-content flow-name="xsl-region-before" display-align="before">
      	  <fo:block font-size="8pt" text-align="center">
            Classifica Società Sportive / <xsl:value-of select="@event"/> - <xsl:value-of select="@date"/>
          </fo:block>
   		</fo:static-content>
   		
  		<fo:static-content flow-name="xsl-region-after">
	          <fo:block font-size="8pt" text-align="center">
          		<xsl:value-of select="$licencse"/>
          	</fo:block>
          	<fo:block font-size="8pt" text-align="right">
          		<fo:page-number/> / <fo:page-number-citation  ref-id="theEnd" />
          	</fo:block>
          	
   		</fo:static-content>
        
        <fo:flow flow-name="xsl-region-body">
		   <fo:block font-size="8pt" text-align="center">
		  <fo:external-graphic content-height="3cm"
						border="0pt solid black">
						<xsl:attribute name="src">
               images/fijlkam_logo.png
              </xsl:attribute>
					</fo:external-graphic>
		  </fo:block>
          <fo:block font-size="16pt" font-weight="bold" space-after="1mm" text-align="center">
          Classifica Società Sportive
          </fo:block>
          <fo:block font-size="16pt" font-weight="bold" space-after="5mm" text-align="center">
            <xsl:value-of select="@event"/> - <xsl:value-of select="@date"/>
          </fo:block>
          <fo:block font-size="8pt">
            <fo:table table-layout="fixed" width="100%" border-collapse="separate">
              <fo:table-column column-width="2cm"/>
			  <fo:table-column column-width="7cm"/>
              <fo:table-column column-width="2cm"/>
              <fo:table-column column-width="2cm"/>
              <fo:table-column column-width="2cm"/>
              <fo:table-column column-width="1.5cm"/>
              <fo:table-column column-width="1.5cm"/>
              <fo:table-column column-width="1.5cm"/>
			  <fo:table-column column-width="1.5cm"/>
			  <fo:table-column column-width="1.5cm"/>
			  <fo:table-column column-width="1.5cm"/>
			  <fo:table-column column-width="2cm"/>
              <fo:table-body>
                <xsl:apply-templates select="Medals"/>
              </fo:table-body>
            </fo:table>
          </fo:block>
          <fo:block id="theEnd" />
        </fo:flow>
     </fo:page-sequence>   
    </fo:root>
  </xsl:template>
  
  <xsl:template match="Medals">
  	<fo:table-row>
  	  <fo:table-cell >
        <fo:block color="blue" text-align="center">
          <xsl:attribute name="font-weight">bold</xsl:attribute>
          <xsl:attribute name="font-style">italic</xsl:attribute>
          <xsl:attribute name="font-size">10pt</xsl:attribute>
          <xsl:value-of select="@head1"/>
        </fo:block>
      </fo:table-cell>
      <fo:table-cell >
        <fo:block color="blue" >
          <xsl:attribute name="font-weight">bold</xsl:attribute>
          <xsl:attribute name="font-style">italic</xsl:attribute>
          <xsl:attribute name="font-size">10pt</xsl:attribute>
          <xsl:value-of select="@head2"/>
        </fo:block>
      </fo:table-cell>
	  <fo:table-cell >
        <fo:block color="blue" >
          <xsl:attribute name="font-weight">bold</xsl:attribute>
          <xsl:attribute name="font-style">italic</xsl:attribute>
          <xsl:attribute name="font-size">10pt</xsl:attribute>
          <xsl:value-of select="@head2_1"/>
        </fo:block>
      </fo:table-cell>
      <fo:table-cell >
        <fo:block color="blue" text-align="center">
          <xsl:attribute name="font-weight">bold</xsl:attribute>
          <xsl:attribute name="font-style">italic</xsl:attribute>
          <xsl:attribute name="font-size">10pt</xsl:attribute>
          <xsl:value-of select="@head3"/>
        </fo:block>
      </fo:table-cell>
      <fo:table-cell >
        <fo:block color="blue" text-align="center">
          <xsl:attribute name="font-weight">bold</xsl:attribute>
          <xsl:attribute name="font-style">italic</xsl:attribute>
          <xsl:attribute name="font-size">10pt</xsl:attribute>
          <xsl:value-of select="@head4"/>
        </fo:block>
      </fo:table-cell>
      <fo:table-cell >
        <fo:block color="blue" text-align="center">
          <xsl:attribute name="font-weight">bold</xsl:attribute>
          <xsl:attribute name="font-style">italic</xsl:attribute>
          <xsl:attribute name="font-size">10pt</xsl:attribute>
          <xsl:value-of select="@head5"/>
        </fo:block>
      </fo:table-cell>
      <fo:table-cell >
        <fo:block color="blue" text-align="center">
          <xsl:attribute name="font-weight">bold</xsl:attribute>
          <xsl:attribute name="font-style">italic</xsl:attribute>
          <xsl:attribute name="font-size">10pt</xsl:attribute>
          <xsl:value-of select="@head6"/>
        </fo:block>
      </fo:table-cell>
      <fo:table-cell >
        <fo:block color="blue" text-align="center">
          <xsl:attribute name="font-weight">bold</xsl:attribute>
          <xsl:attribute name="font-style">italic</xsl:attribute>
          <xsl:attribute name="font-size">10pt</xsl:attribute>
          <xsl:value-of select="@head7"/>
        </fo:block>
      </fo:table-cell>
        <fo:table-cell >
        <fo:block color="blue" text-align="center">
          <xsl:attribute name="font-weight">bold</xsl:attribute>
          <xsl:attribute name="font-style">italic</xsl:attribute>
          <xsl:attribute name="font-size">10pt</xsl:attribute>
          <xsl:value-of select="@head8"/>
        </fo:block>
      </fo:table-cell>
	  <fo:table-cell >
        <fo:block color="blue" text-align="center">
          <xsl:attribute name="font-weight">bold</xsl:attribute>
          <xsl:attribute name="font-style">italic</xsl:attribute>
          <xsl:attribute name="font-size">10pt</xsl:attribute>
          <xsl:value-of select="@head11"/>
        </fo:block>
      </fo:table-cell>
      <fo:table-cell >
        <fo:block color="blue" text-align="center">
          <xsl:attribute name="font-weight">bold</xsl:attribute>
          <xsl:attribute name="font-style">italic</xsl:attribute>
          <xsl:attribute name="font-size">10pt</xsl:attribute>
          <xsl:value-of select="@headothers"/>
        </fo:block>
      </fo:table-cell>
	  <fo:table-cell >
        <fo:block color="blue" text-align="center">
          <xsl:attribute name="font-weight">bold</xsl:attribute>
          <xsl:attribute name="font-style">italic</xsl:attribute>
          <xsl:attribute name="font-size">10pt</xsl:attribute>
          <xsl:value-of select="@total"/>
        </fo:block>
      </fo:table-cell>
    </fo:table-row>
    	<xsl:apply-templates select="Medal"/>
  </xsl:template>
  
  <xsl:template match="Medal">
  	<fo:table-row>
  	  <fo:table-cell border-bottom="0.5pt solid black">
        <fo:block text-align="center">
          <xsl:value-of select="Rank"/>
        </fo:block>
      </fo:table-cell>
      <fo:table-cell border-bottom="0.5pt solid black">
        <fo:block>
        	<fo:external-graphic height="0.3cm" width="0.6cm" content-height="scale-to-fit" content-width="scale-to-fit" scaling="uniform">
               <xsl:attribute name="src">
                 <xsl:value-of select="Nation_Img" />
        		</xsl:attribute>
          </fo:external-graphic>
          <xsl:value-of select="Club"/>
        </fo:block>
      </fo:table-cell>
	  <fo:table-cell border-bottom="0.5pt solid black">
        <fo:block text-align="center">
         <xsl:value-of select="Athlete"/>
        </fo:block>
      </fo:table-cell>
      <fo:table-cell border-bottom="0.5pt solid black">
        <fo:block text-align="center">
         <xsl:value-of select="Place1"/>
        </fo:block>
      </fo:table-cell>
      <fo:table-cell border-bottom="0.5pt solid black">
        <fo:block text-align="center">
          <xsl:value-of select="Place2"/>
        </fo:block>
      </fo:table-cell>
      <fo:table-cell border-bottom="0.5pt solid black">
        <fo:block text-align="center">
          <xsl:value-of select="Place3"/>
        </fo:block>
      </fo:table-cell>
      <fo:table-cell border-bottom="0.5pt solid black">
        <fo:block text-align="center">
          <xsl:value-of select="Place5"/>
        </fo:block>
      </fo:table-cell>
      <fo:table-cell border-bottom="0.5pt solid black">
        <fo:block text-align="center">
          <xsl:value-of select="Place7"/>
        </fo:block>
      </fo:table-cell>
      <fo:table-cell border-bottom="0.5pt solid black">
        <fo:block text-align="center">
          <xsl:value-of select="Place9"/>
        </fo:block>
      </fo:table-cell>
	  <fo:table-cell border-bottom="0.5pt solid black">
        <fo:block text-align="center">
          <xsl:value-of select="Place11"/>
        </fo:block>
      </fo:table-cell>
       <fo:table-cell border-bottom="0.5pt solid black">
        <fo:block text-align="center">
          <xsl:value-of select="Others"/>
        </fo:block>
      </fo:table-cell>
	  <fo:table-cell border-bottom="0.5pt solid black">
        <fo:block text-align="right">
          <xsl:value-of select="total"/>
        </fo:block>
      </fo:table-cell>
    </fo:table-row>
  </xsl:template>

</xsl:stylesheet>
