<?xml version="1.0"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
<xsl:output method="text" omit-xml-declaration="yes" indent="no" />
<xsl:strip-space elements="*"/>

<xsl:template match="Medals">
<xsl:for-each select="@*">
<xsl:value-of select="normalize-space(.)" /><xsl:text>;</xsl:text>
</xsl:for-each>
<xsl:text>&#xA;</xsl:text>
<xsl:apply-templates select="Medal"/>
</xsl:template>

<xsl:template match="Head">
<xsl:for-each select="*">
<xsl:if test="position() != last()">
<xsl:value-of select="normalize-space(.)" /><xsl:text>;</xsl:text>
</xsl:if>
<xsl:if test="position()  = last()">
<xsl:value-of select="normalize-space(.)" />
<xsl:text>&#xA;</xsl:text>
</xsl:if>
</xsl:for-each>
</xsl:template>

<xsl:template match="Medal">
<xsl:for-each select="*">
<xsl:if test="position() != last()">
<xsl:value-of select="normalize-space(.)" /><xsl:text>;</xsl:text>
</xsl:if>
<xsl:if test="position()  = last()">
<xsl:value-of select="normalize-space(.)" />
<xsl:text>&#xA;</xsl:text>
</xsl:if>
</xsl:for-each>
</xsl:template>
</xsl:stylesheet>