<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" exclude-result-prefixes="fo">
  <xsl:output method="xml" version="1.0" omit-xml-declaration="no" indent="yes"/>
  
  <xsl:param name="hideclub" select="''"/>
	<xsl:param name="hidecountry" select="''"/>
  <xsl:param name="licencse" select="''"/> 
	<xsl:param name="date" select="''"/>
	<xsl:param name="logo_event" select="''"/>
	<xsl:param name="logo_sponsor" select="''"/>
	<xsl:param name="logo_federation" select="''"/>
  
  <!-- ========================= -->
  <!-- root element: projectteam -->
  <!-- ========================= -->
  <xsl:template match="Filereport">
    <fo:root xmlns:fo="http://www.w3.org/1999/XSL/Format" font-family="Arial">
     
      <fo:layout-master-set>
        <fo:simple-page-master master-name="simpleA4" page-height="21cm" page-width="29.7cm" margin-top="1cm" margin-bottom="1.5cm" margin-left="1.5cm" margin-right="1.5cm">
          <fo:region-body margin-top="1.0cm" margin-bottom="1.5cm"/>
		      <fo:region-before extent="1.0cm"/>
          <fo:region-after extent="1.0cm"/>
        </fo:simple-page-master>
      </fo:layout-master-set>
      <fo:page-sequence master-reference="simpleA4" language="de">
      
      
      <fo:static-content flow-name="xsl-region-before" display-align="before">
					<fo:block font-size="8pt" text-align="center">
						<fo:table table-layout="fixed" width="100%" >
							<fo:table-column column-width="4cm"/>
							<fo:table-column column-width="19cm"/>
							<fo:table-column column-width="4cm"/>
							<fo:table-body>
								<fo:table-row>
									<xsl:choose>
										<xsl:when test="string($logo_event)">
											<fo:table-cell text-align="center" display-align="center">
												<fo:block text-align="center">
													<fo:external-graphic height="2cm" width="4cm" content-height="scale-to-fit" content-width="scale-to-fit" scaling="uniform">
														<xsl:attribute name="src">
															url(file:/<xsl:value-of select="$logo_event" />)
														</xsl:attribute>
													</fo:external-graphic>
												</fo:block>
											</fo:table-cell> 
										</xsl:when>
										<xsl:otherwise>
											<fo:table-cell  text-align="center" display-align="center">
												<fo:block>
												</fo:block>
											</fo:table-cell> 
										</xsl:otherwise>
									</xsl:choose>	
									<fo:table-cell text-align="center" display-align="center">
										<fo:block font-size="10pt" font-weight="bold" space-after="1mm" text-align="center">
											<xsl:value-of select="@event"/> - <xsl:value-of select="@date"/>
										</fo:block>
										
									</fo:table-cell>
									<xsl:choose>
										<xsl:when test="string($logo_federation)">
											<fo:table-cell text-align="center" display-align="center">
												<fo:block text-align="center">
													<fo:external-graphic height="2cm" width="4cm" content-height="scale-to-fit" content-width="scale-to-fit" scaling="uniform">
														<xsl:attribute name="src">
															url(file:/<xsl:value-of select="$logo_federation" />)
														</xsl:attribute>
													</fo:external-graphic>
												</fo:block>
											</fo:table-cell> 
										</xsl:when>
										<xsl:otherwise>
											<fo:table-cell  text-align="center" display-align="center">
												<fo:block>
												</fo:block>
											</fo:table-cell> 
										</xsl:otherwise>
									</xsl:choose>				 
								</fo:table-row>
							</fo:table-body>
						</fo:table>
					</fo:block>
				</fo:static-content>

				<fo:static-content flow-name="xsl-region-after">
					<fo:block font-size="8pt" text-align="center">
						<fo:table table-layout="fixed" width="100%" >
							<fo:table-column column-width="4cm"/>
							<fo:table-column column-width="17cm"/>
							<fo:table-column column-width="4cm"/>
							<fo:table-body>
								<fo:table-row>
									<xsl:choose>
										<xsl:when test="string($logo_sponsor)">
											<fo:table-cell text-align="center" display-align="center">
												<fo:block text-align="center">
													<fo:external-graphic height="2cm" width="4cm" content-height="scale-to-fit" content-width="scale-to-fit" scaling="uniform">
														<xsl:attribute name="src">
															url(file:/<xsl:value-of select="$logo_sponsor" />)
														</xsl:attribute>
													</fo:external-graphic>
												</fo:block>
											</fo:table-cell> 
										</xsl:when>
										<xsl:otherwise>
											<fo:table-cell  text-align="center" display-align="center">
												<fo:block>
												</fo:block>
											</fo:table-cell> 
										</xsl:otherwise>
									</xsl:choose>	
									<fo:table-cell text-align="center" display-align="center">
										<fo:block font-size="7pt" text-align="center">
											<xsl:value-of select="$licencse"/>
										</fo:block>
									</fo:table-cell> 
									<fo:table-cell text-align="center" display-align="center">
										<fo:block font-size="8pt" text-align="right">
											<fo:page-number/> / <fo:page-number-citation  ref-id="theEnd" />
										</fo:block>
									</fo:table-cell> 
								</fo:table-row>
							</fo:table-body>
						</fo:table>
					</fo:block>
				</fo:static-content>
        
        <fo:flow flow-name="xsl-region-body">
          <fo:block font-size="12pt" font-weight="bold" space-after="5mm" text-align="center" margin-top="0.5cm">
            <xsl:value-of select="@name"/>
          </fo:block>
          <fo:block font-size="6pt">
            <fo:table table-layout="fixed" width="100%">
              <fo:table-column column-width="0.5cm"/>
              <fo:table-column column-width="0.5cm"/>
              <fo:table-column column-width="6.5cm"/>
              <fo:table-column column-width="1cm"/>
              <fo:table-column column-width="1.8cm"/>
			  <fo:table-column column-width="1cm"/>
			  <fo:table-column column-width="1.1cm"/>
			  
              <xsl:variable name="rowcounter" select="count(Rowcount) - 7"/>
              
              <xsl:for-each select="Rowcount">
              	<xsl:if test="$rowcounter >= position()">
              		<fo:table-column column-width="proportional-column-width(1)"/>
				</xsl:if>
			  </xsl:for-each>
              <fo:table-body>
                <xsl:apply-templates select="Head" />
                <xsl:apply-templates select="Row" />
              </fo:table-body>
            </fo:table>
          </fo:block>
<!--           <xsl:if test="Records/Record"> -->
<!--            <fo:block font-size="8pt" margin-top="0.5cm" font-family="Arial Unicode MS" font-weight="bold" > -->
<!--             New records: -->
<!--            </fo:block> -->
<!--           <fo:block font-size="6pt" > -->
<!--             <fo:table table-layout="fixed" width="100%"> -->
<!--               <fo:table-column column-width="5.0cm"/> -->
<!--               <fo:table-column column-width="1.0cm"/> -->
<!--               <fo:table-column column-width="6.0cm"/> -->
<!--               <fo:table-column column-width="1.5cm"/> -->
<!--               <fo:table-column column-width="1.0cm"/> -->
              
<!--               <fo:table-body> -->
<!--                 <xsl:apply-templates select="Records" /> -->
<!--               </fo:table-body> -->
<!--             </fo:table> -->
<!--           </fo:block> -->
<!--           </xsl:if> -->
          <xsl:if test="Officials/Official">
          <fo:block keep-together.within-page="always">
           <fo:block font-size="8pt" margin-top="0.5cm" font-family="Arial Unicode MS" font-weight="bold" 
           border-bottom-width="0.5pt"  border-bottom-style="solid"  border-bottom-color="black" >
            Officials
           </fo:block>
          <fo:block font-size="6pt" >
            <fo:table table-layout="fixed" width="100%" border="none" >
              <fo:table-column column-width="3.2cm"/>
              <fo:table-column column-width="1.0cm"/>
              <fo:table-column column-width="6.5cm"/>
              <fo:table-column column-width="3.2cm"/>
              <fo:table-column column-width="1.0cm"/>
              <fo:table-column column-width="6.5cm"/>
              <fo:table-body>
                <xsl:apply-templates select="Officials" />
              </fo:table-body>
            </fo:table>
          </fo:block>
          </fo:block>
          </xsl:if>
          <fo:block id="theEnd" />
        </fo:flow>
     </fo:page-sequence>   
    </fo:root>
  </xsl:template>
  
  <xsl:template match="Head">
  <fo:table-row border-top="1pt solid black" border-bottom="1pt solid black">
    <xsl:for-each select="Headfield">
      <xsl:choose>
        <!-- Erste Spalte: linke Außenlinie -->
        <xsl:when test="position() = 1">
          <fo:table-cell border-left="1pt solid black"
                         height="10pt"
                         text-align="center"
                         display-align="center">
            <fo:block color="black" font-size="5pt" font-weight="bold">
              <xsl:value-of select="."/>
            </fo:block>
          </fo:table-cell>
        </xsl:when>

        <!-- Letzte Spalte: rechte Außenlinie -->
        <xsl:when test="position() = last()">
          <fo:table-cell border-right="1pt solid black"
                         height="10pt"
                         text-align="center"
                         display-align="center">
            <fo:block color="black" font-size="5pt" font-weight="bold">
              <xsl:value-of select="."/>
            </fo:block>
          </fo:table-cell>
        </xsl:when>

        <!-- Mittlere Spalten: keine vertikalen Linien -->
        <xsl:otherwise>
          <fo:table-cell height="10pt"
                         text-align="center"
                         display-align="center">
            <fo:block color="black" font-size="5pt" font-weight="bold">
              <xsl:value-of select="."/>
            </fo:block>
          </fo:table-cell>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:for-each>
  </fo:table-row>
</xsl:template>
  
<xsl:template match="Row">
  <fo:table-row>
    <xsl:for-each select="Rowfield">
     
      <xsl:choose>
        <xsl:when test="position() = 3">
          <fo:table-cell border="0.5pt solid black" text-align="left" display-align="center" min-height="15pt">
            <fo:block font-size="8pt" margin-left="0.1cm"><xsl:value-of select="."/></fo:block>
          </fo:table-cell>
        </xsl:when>
		<xsl:when test="position() = 5">
          <fo:table-cell border="0.5pt solid black" text-align="right" display-align="center" min-height="15pt">
            <fo:block font-size="8pt" margin-right="0.1cm"><xsl:value-of select="."/></fo:block>
          </fo:table-cell>
        </xsl:when>
		<xsl:when test="position() >7">
          <fo:table-cell border="0.5pt solid black" text-align="right" display-align="center" min-height="15pt">
            <fo:block font-size="8pt" margin-right="0.1cm"></fo:block>
          </fo:table-cell>
        </xsl:when>
        <xsl:otherwise>
          <fo:table-cell border="0.5pt solid black" text-align="center" display-align="center" min-height="15pt">
            <fo:block font-size="8pt"><xsl:value-of select="."/></fo:block>
          </fo:table-cell>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:for-each>
  </fo:table-row>
</xsl:template>

<xsl:template match="Records">
 
    <xsl:for-each select="Record">
     <fo:table-row>
    <fo:table-cell border="0pt solid black" text-align="left" display-align="center" min-height="10pt">
           <fo:block font-size="6pt">
            <xsl:value-of select="Category/@Name"/><xsl:text> </xsl:text><xsl:value-of select="Category/@Discipline"/>
           </fo:block>
      </fo:table-cell>
       <fo:table-cell border="0pt solid black" text-align="left" display-align="center" min-height="10pt">
           <fo:block font-size="6pt"> <xsl:value-of select="@RecordValue"/></fo:block>
      </fo:table-cell>
       <fo:table-cell border="0pt solid black" text-align="left" display-align="center" min-height="10pt">
           <fo:block font-size="6pt"> <xsl:value-of select="Athlete/@TVName"/></fo:block>
      </fo:table-cell>
       <fo:table-cell border="0pt solid black" text-align="left" display-align="center" min-height="10pt">
           <fo:block font-size="6pt"> <xsl:value-of select="Athlete/@Nation"/></fo:block>
      </fo:table-cell>
       <fo:table-cell border="0pt solid black" text-align="left" display-align="center" min-height="10pt">
           <fo:block font-size="6pt"> <xsl:value-of select="@Type"/></fo:block>
      </fo:table-cell>
     </fo:table-row>
    </xsl:for-each>
</xsl:template>


<xsl:template match="Officials">
    <xsl:variable name="half" select="ceiling(count(Official) div 2)"/>
    <xsl:for-each select="Official[position() &lt;= $half]">
        <xsl:variable name="pos" select="position()"/>
        <fo:table-row>
            <fo:table-cell border="0pt solid black" text-align="right" display-align="center" min-height="10pt" border-style="none" margin-right="0.3cm">
                <fo:block font-size="7pt" font-family="Arial Unicode MS" font-weight="bold">
                    <xsl:value-of select="@Function"/>
                </fo:block>
            </fo:table-cell>
            
            <fo:table-cell border="0pt solid black" text-align="left" display-align="center" min-height="10pt" border-style="none">
                <fo:block font-size="7pt">
                    <xsl:value-of select="@Nation"/>
                </fo:block>
            </fo:table-cell>
            <fo:table-cell border="0pt solid black" text-align="left" display-align="center" min-height="10pt" border-style="none">
                <fo:block font-size="7pt">
                    <xsl:value-of select="@GivenName"/><xsl:text> </xsl:text><xsl:value-of select="@FamilyName"/>
                </fo:block>
            </fo:table-cell>
            <xsl:choose>
                <xsl:when test="../Official[position() = $pos + $half]">
                    <fo:table-cell border="0pt solid black" text-align="right" display-align="center" min-height="10pt" border-style="none" margin-right="0.3cm">
                        <fo:block font-size="7pt" font-family="Arial Unicode MS" font-weight="bold">
                            <xsl:value-of select="../Official[$pos + $half]/@Function"/>
                        </fo:block>
                    </fo:table-cell>
                    <fo:table-cell border="0pt solid black" text-align="left" display-align="center" min-height="10pt" border-style="none">
                        <fo:block font-size="7pt">
                            <xsl:value-of select="../Official[$pos + $half]/@Nation"/>
                        </fo:block>
                    </fo:table-cell>
                    <fo:table-cell border="0pt solid black" text-align="left" display-align="center" min-height="10pt" border-style="none">
                        <fo:block font-size="7pt">
                            <xsl:value-of select="../Official[$pos + $half]/@GivenName"/>
                            <xsl:text> </xsl:text>
                            <xsl:value-of select="../Official[$pos + $half]/@FamilyName"/>
                        </fo:block>
                    </fo:table-cell>
                </xsl:when>
                <xsl:otherwise>
                    <fo:table-cell border-style="none"><fo:block/></fo:table-cell>
                    <fo:table-cell border-style="none"><fo:block/></fo:table-cell>
                    <fo:table-cell border-style="none"><fo:block/></fo:table-cell>
                </xsl:otherwise>
            </xsl:choose>
        </fo:table-row>
    </xsl:for-each>
</xsl:template>
</xsl:stylesheet>
