<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" exclude-result-prefixes="fo">
  <xsl:output method="xml" version="1.0" omit-xml-declaration="no" indent="yes"/>
  
  <xsl:param name="hideclub" select="''"/>
	<xsl:param name="hidecountry" select="''"/>
 <xsl:param name="licencse" select="''"/> 
	<xsl:param name="date" select="''"/>
	<xsl:param name="logo_event" select="''"/>
	<xsl:param name="logo_sponsor" select="''"/>
	<xsl:param name="logo_federation" select="''"/>
  
  <!-- ========================= -->
  <!-- root element: projectteam -->
  <!-- ========================= -->
  <xsl:template match="Filereport">
    <fo:root xmlns:fo="http://www.w3.org/1999/XSL/Format" font-family="Arial Narrow">
     
      <fo:layout-master-set>
        <fo:simple-page-master master-name="simpleA4" page-height="29.7cm" page-width="21.0cm" margin-top="2.0cm" margin-bottom="2.0cm" margin-left="1.0cm" margin-right="1.5cm">
          <fo:region-body margin-top="2.5cm" margin-bottom="1.5cm"/>
		      <fo:region-before extent="1.0cm"/>
          <fo:region-after extent="2.0cm"/>
        </fo:simple-page-master>
      </fo:layout-master-set>
      <fo:page-sequence master-reference="simpleA4" language="de">
      
      	<fo:static-content flow-name="xsl-region-before" display-align="before">
					<fo:block font-size="8pt" text-align="center">
						<fo:table table-layout="fixed" width="100%" >
							<fo:table-column column-width="3cm"/>
							<fo:table-column column-width="13.4cm"/>
							<fo:table-column column-width="3cm"/>
							<fo:table-body>
								<fo:table-row>
									<xsl:choose>
										<xsl:when test="string($logo_event)">
											<fo:table-cell text-align="center" display-align="center">
												<fo:block text-align="center">
													<fo:external-graphic height="2cm" width="2cm" content-height="scale-to-fit" content-width="scale-to-fit" scaling="uniform">
														<xsl:attribute name="src">
															url(file:/<xsl:value-of select="$logo_event" />)
														</xsl:attribute>
													</fo:external-graphic>
												</fo:block>
											</fo:table-cell> 
										</xsl:when>
										<xsl:otherwise>
											<fo:table-cell  text-align="center" display-align="center">
												<fo:block>
												</fo:block>
											</fo:table-cell> 
										</xsl:otherwise>
									</xsl:choose>	
									<fo:table-cell text-align="center" display-align="center">
										<fo:block font-size="10pt" font-weight="bold" space-after="0mm" text-align="center">
											<xsl:value-of select="@event"/>
										</fo:block>
										
									</fo:table-cell>
									<xsl:choose>
										<xsl:when test="string($logo_federation)">
											<fo:table-cell text-align="center" display-align="center">
												<fo:block text-align="center">
													<fo:external-graphic height="2cm" width="2cm" content-height="scale-to-fit" content-width="scale-to-fit" scaling="uniform">
														<xsl:attribute name="src">
															url(file:/<xsl:value-of select="$logo_federation" />)
														</xsl:attribute>
													</fo:external-graphic>
												</fo:block>
											</fo:table-cell> 
										</xsl:when>
										<xsl:otherwise>
											<fo:table-cell  text-align="center" display-align="center">
												<fo:block>
												</fo:block>
											</fo:table-cell> 
										</xsl:otherwise>
									</xsl:choose>				 
								</fo:table-row>
							</fo:table-body>
						</fo:table>
					</fo:block>
				</fo:static-content>

				<fo:static-content flow-name="xsl-region-after">
					<fo:block font-size="8pt" text-align="center">
						<fo:table table-layout="fixed" width="100%" >
							<fo:table-column column-width="4cm"/>
							<fo:table-column column-width="11.4cm"/>
							<fo:table-column column-width="4cm"/>
							<fo:table-body>
								<fo:table-row>
									<xsl:choose>
										<xsl:when test="string($logo_sponsor)">
											<fo:table-cell text-align="center" display-align="center">
												<fo:block text-align="center">
													<fo:external-graphic height="3cm" width="4cm" content-height="scale-to-fit" content-width="scale-to-fit" scaling="uniform">
														<xsl:attribute name="src">
															url(file:/<xsl:value-of select="$logo_sponsor" />)
														</xsl:attribute>
													</fo:external-graphic>
												</fo:block>
											</fo:table-cell> 
										</xsl:when>
										<xsl:otherwise>
											<fo:table-cell  text-align="center" display-align="center">
												<fo:block>
												</fo:block>
											</fo:table-cell> 
										</xsl:otherwise>
									</xsl:choose>	
									<fo:table-cell text-align="center" display-align="center">
										<fo:block font-size="8pt" text-align="center">
											<xsl:value-of select="$licencse"/>
										</fo:block>
									</fo:table-cell> 
									<fo:table-cell text-align="center" display-align="center" text-transform="uppercase">
										<fo:block font-size="12pt" text-align="right">
											<fo:page-number/> / <fo:page-number-citation  ref-id="theEnd" /> -- <xsl:value-of select="@date"/>
										</fo:block>
									</fo:table-cell> 
								</fo:table-row>
							</fo:table-body>
						</fo:table>
					</fo:block>
				</fo:static-content>
        
        <fo:flow flow-name="xsl-region-body">
          <fo:block font-size="12pt" font-weight="bold" space-after="10mm" text-align="center" text-transform="uppercase" >
            <xsl:value-of select="@name"/>
          </fo:block >
                  <fo:block font-size="8pt">
            <fo:table table-layout="fixed" width="100%">
              <fo:table-column column-width="1.0cm"/>
              <fo:table-column column-width="1.8cm"/>
              <fo:table-column column-width="3.0cm"/>
              <fo:table-column column-width="3.0cm"/>
              <fo:table-column column-width="4.5cm"/>
              <fo:table-column column-width="4.5cm"/>
              <fo:table-column column-width="1.2cm"/>
             
              <xsl:variable name="rowcounter" select="count(Rowcount) - 7"/>
              
              <xsl:for-each select="Rowcount">
              	<xsl:if test="$rowcounter >= position()">
              		<fo:table-column column-width="proportional-column-width(1)"/>
				</xsl:if>
			  </xsl:for-each>
              
              
              <fo:table-body>
                <xsl:apply-templates />
              </fo:table-body>
            </fo:table>
          </fo:block>
          <fo:block id="theEnd" />
        </fo:flow>
     </fo:page-sequence>   
    </fo:root>
  </xsl:template>
  
  <xsl:template match="Head">
  	<fo:table-row>
    	<xsl:for-each select="Headfield">
  			<fo:table-cell text-transform="uppercase">
  				<fo:block color="blue" font-size="7pt" font-weight="regular" text-align="center" margin-top="-20pt" margin-bottom="3pt">
    				<xsl:value-of select="." />
    			</fo:block>
    		</fo:table-cell>
  		</xsl:for-each>
    </fo:table-row>	
  </xsl:template>
  
  <xsl:template match="Row">
  	<fo:table-row>
    	<xsl:for-each select="Rowfield">
    	
    		
              		<fo:table-cell border="0.5pt solid black" text-align="center" display-align="center" min-height="25pt" text-transform="uppercase">
  					<fo:block  font-size="7pt">
    				<xsl:value-of select="." />
    			</fo:block>
    		</fo:table-cell>
	
  			
  		</xsl:for-each>
    </fo:table-row>	
  </xsl:template>

</xsl:stylesheet>
