<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" exclude-result-prefixes="fo">
	<xsl:output method="xml" version="1.0" omit-xml-declaration="no" indent="yes"/>

	<xsl:param name="licencse" select="''"/> 
	<xsl:param name="date" select="''"/>
	<xsl:param name="hideclub" select="''"/>
	<xsl:param name="hidecountry" select="''"/>
	<xsl:param name="logo_event" select="''"/>
	<xsl:param name="logo_sponsor" select="''"/>
	<xsl:param name="logo_federation" select="''"/>



	<!-- ========================= -->
	<!-- root element: projectteam -->
	<!-- ========================= -->
	<xsl:template match="List_of_results">
		<fo:root xmlns:fo="http://www.w3.org/1999/XSL/Format" font-family="Arial">      
			<fo:layout-master-set>
				<fo:simple-page-master master-name="simpleA4" page-height="29.7cm" page-width="21cm" margin-top="2cm" margin-bottom="2cm" margin-left="2cm" margin-right="2cm">
					<fo:region-body margin-top="2.5cm" margin-bottom="1.5cm"/>
					<fo:region-before extent="1.0cm"/>
					<fo:region-after extent="1.0cm"/>
				</fo:simple-page-master>
			</fo:layout-master-set>
			<fo:page-sequence master-reference="simpleA4">

				<fo:static-content flow-name="xsl-region-before" display-align="before">
					<fo:block font-size="10pt" text-align="center">
						<fo:table table-layout="fixed" width="100%" >
							<fo:table-column column-width="4cm"/>
							<fo:table-column column-width="9cm"/>
							<fo:table-column column-width="4cm"/>
							<fo:table-body>
								<fo:table-row>
									<xsl:choose>
										<xsl:when test="string($logo_event)">
											<fo:table-cell text-align="start" display-align="center">
												<fo:block text-align="start">
													<fo:external-graphic height="2cm" width="3cm" content-height="scale-to-fit" content-width="scale-to-fit" scaling="uniform">
														<xsl:attribute name="src">
															url(file:/<xsl:value-of select="$logo_event" />)
														</xsl:attribute>
													</fo:external-graphic>
												</fo:block>
											</fo:table-cell> 
										</xsl:when>
										<xsl:otherwise>
											<fo:table-cell  text-align="center" display-align="center">
												<fo:block>
												</fo:block>
											</fo:table-cell> 
										</xsl:otherwise>
									</xsl:choose>	
									<fo:table-cell text-align="center" display-align="after" margin-top="30mm">
										<fo:block font-size="12pt"  font-weight="bold" space-after="1mm" text-align="center">
											MEDALLISTS
										</fo:block>
										<fo:block font-size="12pt" font-weight="bold" space-after="1mm" text-align="center">
											<xsl:value-of select="@event"/>
										</fo:block>
									</fo:table-cell>
									<xsl:choose>
										<xsl:when test="string($logo_federation)">
											<fo:table-cell text-align="start" display-align="center">
												<fo:block text-align="start">
													<fo:external-graphic height="2cm" width="3cm" content-height="scale-to-fit" content-width="scale-to-fit" scaling="uniform">
														<xsl:attribute name="src">
															url(file:/<xsl:value-of select="$logo_federation" />)
														</xsl:attribute>
													</fo:external-graphic>
												</fo:block>
											</fo:table-cell> 
										</xsl:when>
										<xsl:otherwise>
											<fo:table-cell  text-align="center" display-align="center">
												<fo:block>
												</fo:block>
											</fo:table-cell> 
										</xsl:otherwise>
									</xsl:choose>				 
								</fo:table-row>
							</fo:table-body>
						</fo:table>
					</fo:block>
				</fo:static-content>

				<fo:static-content flow-name="xsl-region-after">
					<fo:block font-size="12pt" text-align="center">
						<fo:table table-layout="fixed" width="100%" >
							<fo:table-column column-width="4cm"/>
							<fo:table-column column-width="9cm"/>
							<fo:table-column column-width="4cm"/>
							<fo:table-body>
								<fo:table-row>
									<xsl:choose>
										<xsl:when test="string($logo_sponsor)">
											<fo:table-cell text-align="center" display-align="center">
												<fo:block text-align="center">
													<fo:external-graphic height="2cm" width="4cm" content-height="scale-to-fit" content-width="scale-to-fit" scaling="uniform">
														<xsl:attribute name="src">
															url(file:/<xsl:value-of select="$logo_sponsor" />)
														</xsl:attribute>
													</fo:external-graphic>
												</fo:block>
											</fo:table-cell> 
										</xsl:when>
										<xsl:otherwise>
											<fo:table-cell  text-align="center" display-align="center">
												<fo:block>
												</fo:block>
											</fo:table-cell> 
										</xsl:otherwise>
									</xsl:choose>	
									<fo:table-cell text-align="center" display-align="center">
										<fo:block font-size="7pt" text-align="center">
											
										</fo:block>
									</fo:table-cell> 
									<fo:table-cell text-align="center" display-align="center">
										<fo:block font-size="8pt" text-align="right">
											<fo:page-number/> / <fo:page-number-citation  ref-id="theEnd" />
										</fo:block>
									</fo:table-cell> 
								</fo:table-row>
							</fo:table-body>
						</fo:table>
					</fo:block>
				</fo:static-content>

				<fo:flow flow-name="xsl-region-body">
					<fo:block font-size="8pt">
						
												<fo:table table-layout="fixed" width="100%" border-collapse="separate">
													<fo:table-column column-width="3cm"/>
													<fo:table-column column-width="8cm"/>
													<fo:table-column column-width="6cm"/>
													<fo:table-body>
														<xsl:apply-templates select="Results"/>
													</fo:table-body>
												</fo:table>	
											
					</fo:block>
					<fo:block id="theEnd" />
				</fo:flow>
			</fo:page-sequence>   
		</fo:root>
	</xsl:template>

	<xsl:template match="Results">
		<xsl:apply-templates select="Result"/>
	</xsl:template>

	<xsl:template match="Result">
	
	 <xsl:variable  name="catname" select="Category"/> 
     <xsl:variable  name="restofstring" select="substring-after($catname, '|')"/>
     <xsl:variable  name="patronomic" select="substring-after($restofstring, '|')"/>
	
		<xsl:if test="Nextcat = 'true'">
			<fo:table-row keep-with-next="always" >
			<fo:table-cell display-align="before" text-align="center">
				<xsl:attribute name="number-columns-spanned">3</xsl:attribute>
				
				<fo:block text-align="center" display-align="before">
				<xsl:attribute name="break-before">
							<xsl:text>page</xsl:text>
						</xsl:attribute>
					<xsl:attribute name="font-weight">bold</xsl:attribute>
					<xsl:attribute name="font-size">14pt</xsl:attribute>
					<xsl:choose>
    							<xsl:when test="contains(Category, '|')">
    								<xsl:value-of select="$patronomic" />
  								</xsl:when>
  								<xsl:otherwise>
 									<xsl:value-of select="Category" />
  								</xsl:otherwise>
  							</xsl:choose> 
				</fo:block>
				
			</fo:table-cell>
		</fo:table-row>
		<fo:table-row >
		<fo:table-cell border-left="0.5pt solid black" border-top="0.5pt solid black" border-bottom="0.5pt solid black">
			<fo:block font-weight="bold">
				Medal
			</fo:block>
		</fo:table-cell>
		<fo:table-cell border-top="0.5pt solid black" border-bottom="0.5pt solid black">
			<fo:block font-weight="bold">
				Name
			</fo:block>
		</fo:table-cell>
		
		<fo:table-cell border-right="0.5pt solid black" border-top="0.5pt solid black" border-bottom="0.5pt solid black">
			<fo:block font-weight="bold">
				NOC
			</fo:block>
		</fo:table-cell>
	</fo:table-row>
	</xsl:if>
	
	<xsl:if test="Place ='1'">
	<fo:table-row >
		<fo:table-cell border="0pt solid black">
			<fo:block>
				GOLD
			</fo:block>
		</fo:table-cell>
		<fo:table-cell border="0pt solid black">
			<fo:block >
				<xsl:value-of select="Name_Report"/>
			</fo:block>
			<xsl:if test="CategoryType = 't'">
				<xsl:if test="Teammembers/Teammember[1]">
					<xsl:apply-templates select="Teammembers"/>
				</xsl:if>
			</xsl:if>
		</fo:table-cell>
		
		<fo:table-cell border="0pt solid black">
			<fo:block>
				<xsl:value-of select="Nation_Short"/> - <xsl:value-of select="Nation"/>
			</fo:block>
		</fo:table-cell>
	</fo:table-row>
</xsl:if>	

<xsl:if test="Place ='2'">
	<fo:table-row >
		<fo:table-cell border="0pt solid black">
			<fo:block >
				SILVER
			</fo:block>
		</fo:table-cell>
		<fo:table-cell border="0pt solid black">
			<fo:block >
				<xsl:value-of select="Name_Report"/>
			</fo:block>
			<xsl:if test="CategoryType = 't'">
				<xsl:if test="Teammembers/Teammember[1]">
					<xsl:apply-templates select="Teammembers"/>
				</xsl:if>
			</xsl:if>
		</fo:table-cell>
		
		<fo:table-cell border="0pt solid black">
			<fo:block>
				<xsl:value-of select="Nation_Short"/> - <xsl:value-of select="Nation"/>
			</fo:block>
		</fo:table-cell>
	</fo:table-row>
</xsl:if>	

<xsl:if test="Place ='3'">
	<fo:table-row >
		<fo:table-cell border="0pt solid black">
			<fo:block >
				BRONZE
			</fo:block>
		</fo:table-cell>
		<fo:table-cell border="0pt solid black">
			<fo:block >
				<xsl:value-of select="Name_Report"/>
			</fo:block>
			<xsl:if test="CategoryType = 't'">
				<xsl:if test="Teammembers/Teammember[1]">
					<xsl:apply-templates select="Teammembers"/>
				</xsl:if>
			</xsl:if>
		</fo:table-cell>
		
		<fo:table-cell border="0pt solid black">
			<fo:block>
				<xsl:value-of select="Nation_Short"/> - <xsl:value-of select="Nation"/>
			</fo:block>
		</fo:table-cell>
	</fo:table-row>
</xsl:if>	
	
</xsl:template>

<xsl:template match="Teammembers">
	<xsl:apply-templates select="Teammember"/>
</xsl:template>

<xsl:template match="Teammember">
	<fo:block keep-with-next="always">
         - <xsl:value-of select="NameTeam"/>
	</fo:block>
</xsl:template>

</xsl:stylesheet>