CREATE TABLE IF NOT EXISTS `accessarea` (
  `ACCNR` INT(10) NOT NULL AUTO_INCREMENT ,
  `BEZEICHNUNG` VARCHAR(255) NOT NULL,
  PRIMARY KEY (`accnr`)
) ENGINE=MyISAM  AUTO_INCREMENT=34  DEFAULT CHARSET=utf8;[EOL]

CREATE TABLE IF NOT EXISTS `auslosungeinzel` (
  `VERNR` INT(10) NOT NULL,
  `KNR` INT(10) NOT NULL,
  `NNR` INT(10) NOT NULL,
  `POS` INT(10) NOT NULL,
  `POOL` INT(10) NOT NULL,
  `DEL` INT(10),
  `FIELDPOS` INT(10) NOT NULL
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;[EOL]


CREATE TABLE IF NOT EXISTS `auslosungteam` (
  `VERNR` INT(10) NOT NULL,
  `KNR` INT(10) NOT NULL,
  `VEREINNR` INT(10) NOT NULL,
  `MANNSCHAFT` TEXT NOT NULL,
  `POS` INT(10) NOT NULL,
  `POOL` INT(10) NOT NULL,
  `DEL` INT(10),
  `FIELDPOS` INT(10) NOT NULL
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;[EOL]


CREATE TABLE IF NOT EXISTS `barcode` (
  `VERID` INT(10) NOT NULL,
  `BARCODE` VARCHAR(50) NOT NULL,
  `ID` INT(10) NOT NULL,
  `PERSONTYPE` INT(10) NOT NULL,
  `PERSONID` INT(10) NOT NULL
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;[EOL]


CREATE TABLE IF NOT EXISTS `binomio` (
  `ID` INT(10) NOT NULL AUTO_INCREMENT ,
  `CONDUTTORE` INT(10) NOT NULL,
  `CANE` INT(10) NOT NULL,
  `CREATED` TIMESTAMP NOT NULL,
  `CLUBID` INT(10) NOT NULL,
  `STATUS` INT(10) NOT NULL,
  `RALLY` VARCHAR(255),
  `KANITO` INT(10) NOT NULL,
  `SICHTBAR` INT(10) NOT NULL,
  `GRADOSDSFREESTYLE` VARCHAR(50),
  `GRADOSDSSPEEDWATER` VARCHAR(50),
  `GRADOSDSSPLASHDOG` VARCHAR(50),
  `GRADOSDSOBEDIENCE` VARCHAR(50),
  `GRADOSDSHOOPERS` VARCHAR(50),
  `GRADOSDSNOSEWORK` VARCHAR(50),
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  AUTO_INCREMENT=1  DEFAULT CHARSET=utf8;[EOL]


CREATE TABLE IF NOT EXISTS `category_match` (
  `ID` INT(10) NOT NULL AUTO_INCREMENT ,
  `TITLE` VARCHAR(255) NOT NULL,
  `VERNR` INT(10) NOT NULL,
  `CATEGORY` TEXT NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  AUTO_INCREMENT=1  DEFAULT CHARSET=utf8;[EOL]


CREATE TABLE IF NOT EXISTS `clientmonitor` (
  `IP` VARCHAR(30) NOT NULL,
  `HOSTNAME` VARCHAR(100) NOT NULL,
  `NAME` VARCHAR(100),
  `CREATION` TIMESTAMP NOT NULL,
  `EXPIRE` TIMESTAMP NOT NULL,
  `MESSAGE` TEXT,
  `VERID` INT(10) NOT NULL,
  `TYPE` INT(10) NOT NULL,
  `MS` INT(10),
  `MATCHID` VARCHAR(50),
  `NAMEID1` INT(10),
  `NAMEID2` INT(10),
  `SYNC` INT(10),
  `CLIENTMODE` INT(10)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;[EOL]

INSERT INTO `clientmonitor` VALUES ('192.168.1.179', 'RBNB', 'Tatami 3', '2025-10-24 11:14:16.917', '2025-10-24 11:34:16.917', 'Memory status: 7%  152086K used / 2097151K allocated', 194, 0, 917, '', 0, 0, 0, 0);[EOL]
INSERT INTO `clientmonitor` VALUES ('192.168.1.179', 'RBNB', 'Tatami 3', '2025-10-24 11:17:25.376', '2025-10-24 11:37:25.376', 'Memory status: 7%  152938K used / 2097151K allocated', 194, 0, 375, '', 0, 0, 0, 0);[EOL]
INSERT INTO `clientmonitor` VALUES ('192.168.1.179', 'RBNB', 'Tatami 3', '2025-10-24 11:19:48.565', '2025-10-24 11:39:48.565', 'Memory status: 7%  153558K used / 2097151K allocated', 194, 0, 565, '', 0, 0, 0, 0);[EOL]
INSERT INTO `clientmonitor` VALUES ('192.168.1.179', 'RBNB', 'Tatami 3', '2025-10-24 11:25:17.737', '2025-10-24 11:45:17.737', 'Memory status: 18%  391338K used / 2097151K allocated', 194, 0, 737, '', 0, 0, 0, 0);[EOL]
INSERT INTO `clientmonitor` VALUES ('192.168.1.179', 'RBNB', 'Tatami 3', '2025-10-24 11:25:27.097', '2025-10-24 11:45:27.097', 'Memory status: 18%  394410K used / 2097151K allocated', 194, 0, 96, '', 0, 0, 0, 0);[EOL]
INSERT INTO `clientmonitor` VALUES ('192.168.1.179', 'RBNB', 'Tatami 3', '2025-10-24 11:30:17.783', '2025-10-24 11:50:17.783', 'Memory status: 23%  499882K used / 2097151K allocated', 194, 0, 781, '', 0, 0, 0, 0);[EOL]
INSERT INTO `clientmonitor` VALUES ('192.168.1.179', 'RBNB', 'Tatami 3', '2025-10-24 11:32:57.352', '2025-10-24 11:52:57.352', 'Memory status: 25%  529580K used / 2097151K allocated', 194, 0, 351, '', 0, 0, 0, 0);[EOL]

CREATE TABLE IF NOT EXISTS `coach` (
  `ID` INT(10) NOT NULL AUTO_INCREMENT ,
  `TITEL` VARCHAR(50),
  `VORNAME` VARCHAR(255) NOT NULL,
  `NACHNAME` VARCHAR(255) NOT NULL,
  `GEBURT` DATE NOT NULL,
  `SICHTBAR` INT(10) NOT NULL,
  `KYU` INT(10),
  `DAN` INT(10),
  `SONSTIGES` TEXT,
  `GESCHLECHT` VARCHAR(1) NOT NULL,
  `VEREINNR` INT(10) NOT NULL,
  `EMAIL` VARCHAR(255),
  `WKFID` VARCHAR(100),
  `PASSPORTID` VARCHAR(50),
  `EXTID` VARCHAR(30),
  `EXTHASPRIVATECOMMENT` INT(10),
  `EXTHASPUBLICCOMMENT` INT(10),
  `PUUID` VARCHAR(50),
  `DATAFIELD1` VARCHAR(255),
  `DATAFIELD2` VARCHAR(255),
  `DATAFIELD3` VARCHAR(255),
  `DATAFIELD4` VARCHAR(255),
  `DATAFIELD5` VARCHAR(255),
  `DATAFIELD6` VARCHAR(255),
  `DATAFIELD7` VARCHAR(255),
  `DATAFIELD8` VARCHAR(255),
  `DATAFIELD9` VARCHAR(255),
  `DATAFIELD10` VARCHAR(255),
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  AUTO_INCREMENT=1  DEFAULT CHARSET=utf8;[EOL]


CREATE TABLE IF NOT EXISTS `coach_category` (
  `ID` INT(10) NOT NULL AUTO_INCREMENT ,
  `BEZEICHNUNG` VARCHAR(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  AUTO_INCREMENT=4  DEFAULT CHARSET=utf8;[EOL]

CREATE TABLE IF NOT EXISTS `coachcat_access` (
  `VERNR` INT(10) NOT NULL,
  `ACCNR` INT(10) NOT NULL,
  `OCID` INT(10) NOT NULL
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;[EOL]


CREATE TABLE IF NOT EXISTS `doubleeliminationeinzel` (
  `VERNR` INT(10) NOT NULL,
  `KNR` INT(10) NOT NULL,
  `NNR` INT(10) NOT NULL,
  `XPOS` INT(10) NOT NULL,
  `YPOS` INT(10) NOT NULL,
  `FIELDPOS` INT(10) NOT NULL,
  `POOL` INT(10) NOT NULL,
  `TABLETYPE` INT(10) NOT NULL,
  `POINTS` INT(10),
  `KATA` INT(10),
  `MATCHID` VARCHAR(50),
  `MATCHTIME` TIMESTAMP NOT NULL,
  `WINTYPE` INT(10)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;[EOL]


CREATE TABLE IF NOT EXISTS `doubleeliminationteam` (
  `VERNR` INT(10) NOT NULL,
  `KNR` INT(10) NOT NULL,
  `VEREINNR` INT(10) NOT NULL,
  `MANNSCHAFT` TEXT NOT NULL,
  `XPOS` INT(10) NOT NULL,
  `YPOS` INT(10) NOT NULL,
  `FIELDPOS` INT(10) NOT NULL,
  `POOL` INT(10) NOT NULL,
  `TABLETYPE` INT(10) NOT NULL,
  `POINTS` INT(10),
  `KATA` INT(10),
  `MATCHID` VARCHAR(50),
  `MATCHTIME` TIMESTAMP NOT NULL,
  `WINTYPE` INT(10)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;[EOL]


CREATE TABLE IF NOT EXISTS `dtmdefaults` (
  `ID` INT(10) NOT NULL AUTO_INCREMENT ,
  `VERNR` INT(10) NOT NULL,
  `TYPE` VARCHAR(1),
  `SEX` VARCHAR(1),
  `CATNAME` VARCHAR(255),
  `FIGHTTIME` INT(10) NOT NULL,
  `COLOR` VARCHAR(7),
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  AUTO_INCREMENT=1  DEFAULT CHARSET=utf8;[EOL]


CREATE TABLE IF NOT EXISTS `entryfeemodel` (
  `ID` INT(10) NOT NULL AUTO_INCREMENT ,
  `MODEL` INT(10) NOT NULL,
  `VERID` INT(10) NOT NULL,
  `DISCOUNTENTRY` INT(10) NOT NULL,
  `DISCOUNT` FLOAT NOT NULL,
  `MAXCLUB` FLOAT NOT NULL,
  `ENABLEDISCOUNT` INT(10) NOT NULL,
  `ENABLEMAXCLUB` INT(10) NOT NULL,
  `INDENTRYDISCOUNTTYPE` INT(10) NOT NULL,
  `DISCOUNTFLAT` FLOAT NOT NULL,
  `DISCOUNTCATFLAT` TEXT,
  `COACHFEE` FLOAT NOT NULL,
  `DATEENTRYFEE` INT(10) NOT NULL,
  `DATECATENTRYFEECOACH` TEXT,
  `DATECATENTRYFEEIND` TEXT,
  `DATECATENTRYFEETEAM` TEXT,
  `FEEIGONREDISCOUNT` TEXT,
  `REFEREEFEE` FLOAT NOT NULL,
  `OFFICIALFEE` FLOAT NOT NULL,
  `DATECATENTRYFEEREFEREE` TEXT,
  `DATECATENTRYFEEOFFICIAL` TEXT,
  `NOSPORTSIDEXTRAFEE` FLOAT NOT NULL,
  `ENABLEDISCOUNTTEAM` INT(10) NOT NULL,
  `DISCOUNTENTRYTEAM` INT(10) NOT NULL,
  `INDENTRYDISCOUNTTYPETEAM` INT(10) NOT NULL,
  `DISCOUNTTEAM` FLOAT NOT NULL,
  `DISCOUNTFLATTEAM` FLOAT NOT NULL,
  `DISCOUNTCATFLATTEAM` TEXT,
  `CLUBFEE` FLOAT NOT NULL,
  `TEAMENTRYFEEPERCOMPETITOR` INT(10) NOT NULL,
  `INCLUDEALLDISCOUNT` INT(10),
  `INCLUDEALLDISCOUNTTEAM` INT(10),
  `DATEENTRYFEEWL` INT(10),
  `BINOMIOSAMECODE` INT(10),
  `BINOMIOAGEFLATFEEENABLE` INT(10),
  `BINOMIOAGEFLATFEE` FLOAT,
  `BINOMIOAGEFLATFEEAGE` INT(10),
  `CUSTOMDESCRIPTION` TEXT,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  AUTO_INCREMENT=1  DEFAULT CHARSET=utf8;[EOL]


CREATE TABLE IF NOT EXISTS `ergebniseinzel` (
  `VERNR` INT(10) NOT NULL,
  `KNR` INT(10) NOT NULL,
  `NNR` INT(10) NOT NULL,
  `ERG` INT(10) NOT NULL,
  `DONE` INT(10),
  `ERGREAL` INT(10) NOT NULL,
  `COMMENT` VARCHAR(255)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;[EOL]


CREATE TABLE IF NOT EXISTS `ergebnisteam` (
  `VERNR` INT(10) NOT NULL,
  `KNR` INT(10) NOT NULL,
  `VEREINNR` INT(10) NOT NULL,
  `MANNSCHAFT` TEXT NOT NULL,
  `ERG` INT(10) NOT NULL,
  `DONE` INT(10),
  `ERGREAL` INT(10) NOT NULL,
  `COMMENT` VARCHAR(255)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;[EOL]


CREATE TABLE IF NOT EXISTS `exam` (
  `ID` INT(10) NOT NULL AUTO_INCREMENT ,
  `TITLE` VARCHAR(255) NOT NULL,
  `THEORETICALEXAM` INT(10) NOT NULL,
  `TEWRONGANSWERS` TEXT,
  `PRACTICALEXAM` INT(10) NOT NULL,
  `PECRITERIAS` TEXT,
  `TEPERCENTAGE` INT(10),
  `PASSMARK` INT(10) NOT NULL,
  `PECRITERIASMAX` INT(10),
  `VERNR` INT(10) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  AUTO_INCREMENT=1  DEFAULT CHARSET=utf8;[EOL]


CREATE TABLE IF NOT EXISTS `kata` (
  `ID` INT(10) NOT NULL AUTO_INCREMENT ,
  `BEZEICHNUNG` VARCHAR(255) NOT NULL,
  `STILNR` INT(10) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  AUTO_INCREMENT=1  DEFAULT CHARSET=utf8;[EOL]


CREATE TABLE IF NOT EXISTS `kategorie` (
  `KNR` INT(10) NOT NULL AUTO_INCREMENT ,
  `KATBEZ` VARCHAR(255) NOT NULL,
  `ALTERVON` INT(10) NOT NULL,
  `ALTERNICHTMEHR` INT(10) NOT NULL,
  `GESCHLECHT` VARCHAR(1),
  `TEAM` VARCHAR(1),
  `SPORTART` INT(10),
  `TYP` INT(10) NOT NULL,
  `EXTID` VARCHAR(100),
  PRIMARY KEY (`knr`)
) ENGINE=MyISAM  AUTO_INCREMENT=9  DEFAULT CHARSET=utf8;[EOL]

CREATE TABLE IF NOT EXISTS `landesverband` (
  `ID` INT(10) NOT NULL AUTO_INCREMENT ,
  `NATIONNR` INT(10) NOT NULL,
  `BEZEICHNUNG` VARCHAR(255) NOT NULL,
  `KURZ` VARCHAR(20),
  `NATID` VARCHAR(7),
  `EXTID` INT(10),
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  AUTO_INCREMENT=1  DEFAULT CHARSET=utf8;[EOL]


CREATE TABLE IF NOT EXISTS `match_calling` (
  `EVENTID` INT(10) NOT NULL,
  `MATCHNUMBER` INT(10) NOT NULL,
  `CATID` INT(10) NOT NULL,
  `POOL` INT(10) NOT NULL,
  `FIELDPOS` INT(10) NOT NULL,
  `FIELDPOSOLD` INT(10) NOT NULL,
  `ROUND` INT(10) NOT NULL,
  `CATMATCHNUMBER` INT(10),
  `TABLETYPE` INT(10) NOT NULL,
  `CALLMATCH` INT(10) NOT NULL,
  `HIDEMATCH` INT(10) NOT NULL,
  `CALLTIME` TIMESTAMP,
  `NAME1` TEXT,
  `NAME2` TEXT,
  `CALLTIME2` TIMESTAMP,
  `CALLMATCH2` INT(10),
  `SHOWUPTIME` TIMESTAMP,
  `SHOWUPTIME2` TIMESTAMP,
  `MATCHNUMBER_SHOW` INT(10),
  `RING` INT(10),
  `WINNER` INT(10),
  `WINNER_BY` VARCHAR(15),
  `RESULT` VARCHAR(15),
  `MATCHFROMPRINTED` INT(10) NOT NULL,
  `RESULT_STATUS` VARCHAR(50),
  `SCHEDULE_STATUS` VARCHAR(50)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;[EOL]


CREATE TABLE IF NOT EXISTS `matchinfo` (
  `MATCHID` VARCHAR(255) NOT NULL,
  `MATCHINFO` TEXT,
  PRIMARY KEY (`matchid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;[EOL]


CREATE TABLE IF NOT EXISTS `mitschrifteinzel` (
  `VERNR` INT(10) NOT NULL,
  `KNR` INT(10) NOT NULL,
  `NNR` INT(10) NOT NULL,
  `XPOS` INT(10) NOT NULL,
  `YPOS` INT(10) NOT NULL,
  `FIELDPOS` INT(10) NOT NULL,
  `POOL` INT(10) NOT NULL,
  `TABLETYPE` INT(10) NOT NULL,
  `POINTS` INT(10),
  `KATA` INT(10),
  `MATCHID` VARCHAR(50),
  `MATCHTIME` TIMESTAMP NOT NULL,
  `WINTYPE` INT(10)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;[EOL]


CREATE TABLE IF NOT EXISTS `mitschriftteam` (
  `VERNR` INT(10) NOT NULL,
  `KNR` INT(10) NOT NULL,
  `VEREINNR` INT(10) NOT NULL,
  `MANNSCHAFT` TEXT NOT NULL,
  `XPOS` INT(10) NOT NULL,
  `YPOS` INT(10) NOT NULL,
  `FIELDPOS` INT(10) NOT NULL,
  `POOL` INT(10) NOT NULL,
  `TABLETYPE` INT(10) NOT NULL,
  `POINTS` INT(10),
  `KATA` INT(10),
  `MATCHID` VARCHAR(50),
  `MATCHTIME` TIMESTAMP NOT NULL,
  `WINTYPE` INT(10)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;[EOL]


CREATE TABLE IF NOT EXISTS `names` (
  `NNR` INT(10) NOT NULL AUTO_INCREMENT ,
  `NAME` VARCHAR(255) NOT NULL,
  `GEBURT` DATE NOT NULL,
  `VEREINNR` INT(10) NOT NULL,
  `GESCHLECHT` VARCHAR(1),
  `GEWICHT` INT(10),
  `GROESSE` INT(10),
  `SICHTBAR` INT(10) NOT NULL,
  `KYU` INT(10),
  `DAN` INT(10),
  `NATIONNR` INT(10),
  `STPKTNR` INT(10),
  `NATIONALID` VARCHAR(30),
  `EMAIL` VARCHAR(255),
  `SONSTIGES` TEXT,
  `WKFID` VARCHAR(100),
  `PASSPORTID` VARCHAR(50),
  `EXTID` VARCHAR(30),
  `EXTHASPRIVATECOMMENT` INT(10),
  `EXTHASPUBLICCOMMENT` INT(10),
  `PUUID` VARCHAR(50),
  `EXTTYPE` VARCHAR(50),
  `ISNOHUMAN` INT(10),
  `DATAFIELD1` VARCHAR(255),
  `DATAFIELD2` VARCHAR(255),
  `DATAFIELD3` VARCHAR(255),
  `DATAFIELD4` VARCHAR(255),
  `DATAFIELD5` VARCHAR(255),
  `DATAFIELD6` VARCHAR(255),
  `DATAFIELD7` VARCHAR(255),
  `DATAFIELD8` VARCHAR(255),
  `DATAFIELD9` VARCHAR(255),
  `DATAFIELD10` VARCHAR(255),
  `ACCOUNTENABLED` INT(10),
  `ACCOUNTUSERNAME` VARCHAR(50),
  `ACCOUNTPASSWORD` VARCHAR(50),
  `CLASSECANESDEHOOPERS` VARCHAR(255),
  PRIMARY KEY (`nnr`)
) ENGINE=MyISAM  AUTO_INCREMENT=221  DEFAULT CHARSET=utf8;[EOL]

CREATE TABLE IF NOT EXISTS `nation` (
  `ID` INT(10) NOT NULL AUTO_INCREMENT ,
  `BEZEICHNUNG` VARCHAR(255) NOT NULL,
  `ISO` VARCHAR(5) NOT NULL,
  `KURZ` VARCHAR(15),
  `LAT` VARCHAR(50),
  `LON` VARCHAR(50),
  `EXTID` INT(10),
  `HIDE` INT(10),
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  AUTO_INCREMENT=257  DEFAULT CHARSET=utf8;[EOL]

INSERT INTO `nation` VALUES (3, 'ALBANIA', 'AL', 'ALB', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (4, 'ALGERIA', 'DZ', 'ALG', '28.0338860', '1.6596260', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (5, 'AMERICAN SAMOA', 'AS', 'ASA', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (6, 'ANDORRA', 'AD', 'AND', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (7, 'ANGOLA', 'AO', 'ANG', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (8, 'ANGUILLA', 'AI', 'AIA', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (9, 'ANTARCTICA', 'AQ', 'ATA', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (10, 'ANTIGUA AND BARBUDA', 'AG', 'ANT', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (11, 'ARGENTINA', 'AR', 'ARG', '-38.4160970', '-63.6166720', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (12, 'ARMENIA', 'AM', 'ARM', '40.0690990', '45.0381890', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (13, 'ARUBA', 'AW', 'ARU', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (14, 'AUSTRALIA', 'AU', 'AUS', '-25.2743980', '133.7751360', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (15, 'AUSTRIA', 'AT', 'AUT', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (16, 'AZERBAIJAN', 'AZ', 'AZE', '40.1431050', '47.5769270', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (17, 'BAHAMAS', 'BS', 'BAH', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (18, 'BAHRAIN', 'BH', 'BRN', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (19, 'BANGLADESH', 'BD', 'BAN', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (20, 'BARBADOS', 'BB', 'BAR', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (21, 'BELARUS', 'BY', 'BLR', '53.7098070', '27.9533890', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (22, 'BELGIUM', 'BE', 'BEL', '50.5038870', '4.4699360', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (23, 'BELIZE', 'BZ', 'BIZ', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (24, 'BENIN', 'BJ', 'BEN', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (25, 'BERMUDA', 'BM', 'BER', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (26, 'BHUTAN', 'BT', 'BHU', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (27, 'BOLIVIA', 'BO', 'BOL', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (28, 'BOSNIA AND HERZEGOVINA', 'BA', 'BIH', '43.9158860', '17.6790760', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (29, 'BOTSWANA', 'BW', 'BOT', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (30, 'BOUVET ISLAND', 'BV', 'BVT', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (31, 'BRAZIL', 'BR', 'BRA', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (32, 'BRITISH INDIAN OCEAN TERRITORY', 'IO', 'IOT', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (33, 'BRUNEI DARUSSALAM', 'BN', 'BRU', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (34, 'BULGARIA', 'BG', 'BUL', '42.7338830', '25.4858300', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (35, 'BURKINA FASO', 'BF', 'BUR', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (36, 'BURUNDI', 'BI', 'BDI', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (37, 'CAMBODIA', 'KH', 'CAM', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (38, 'CAMEROON', 'CM', 'CMR', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (39, 'CANADA', 'CA', 'CAN', '56.1303660', '-106.3467710', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (40, 'CAPE VERDE', 'CV', 'CPV', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (41, 'CAYMAN ISLANDS', 'KY', 'CAY', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (42, 'CENTRAL AFRICAN REPUBLIC', 'CF', 'CAF', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (43, 'CHAD', 'TD', 'CHA', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (44, 'CHILE', 'CL', 'CHI', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (45, 'PEOPLES REPUBLIC OF CHINA', 'CN', 'CHN', '35.8616600', '104.1953970', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (46, 'CHRISTMAS ISLAND', 'CX', 'CXR', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (47, 'COCOS (KEELING) ISLANDS', 'CC', 'CCK', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (48, 'COLOMBIA', 'CO', 'COL', '4.5708680', '-74.2973330', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (49, 'COMOROS', 'KM', 'COM', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (50, 'CONGO', 'CG', 'CGO', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (51, 'DEMOCRATIC REPUBLIC OF THE CONGO', 'CD', 'COD', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (52, 'COOK ISLANDS', 'CK', 'COK', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (53, 'COSTA RICA', 'CR', 'CRC', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (54, 'COTE D`IVOIRE', 'CI', 'CIV', '7.5399890', '-5.5470800', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (55, 'CROATIA', 'HR', 'CRO', '45.1000000', '15.2000000', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (56, 'CUBA', 'CU', 'CUB', '21.5217570', '-77.7811670', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (57, 'CYPRUS', 'CY', 'CYP', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (58, 'CZECH REPUBLIC', 'CZ', 'CZE', '49.8174920', '15.4729620', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (59, 'DENMARK', 'DK', 'DEN', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (60, 'DJIBOUTI', 'DJ', 'DJI', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (61, 'DOMINICA', 'DM', 'DMA', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (62, 'DOMINICAN REPUBLIC', 'DO', 'DOM', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (63, 'ECUADOR', 'EC', 'ECU', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (64, 'EGYPT', 'EG', 'EGY', '26.8205530', '30.8024980', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (65, 'EL SALVADOR', 'SV', 'ESA', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (66, 'EQUATORIAL GUINEA', 'GQ', 'GEQ', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (67, 'ERITREA', 'ER', 'ERI', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (68, 'ESTONIA', 'EE', 'EST', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (69, 'ETHIOPIA', 'ET', 'ETH', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (70, 'FALKLAND ISLANDS (MALVINAS)', 'FK', 'FLK', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (71, 'FAROE ISLANDS', 'FO', 'FRO', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (72, 'FIJI', 'FJ', 'FIJ', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (73, 'FINLAND', 'FI', 'FIN', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (74, 'FRANCE', 'FR', 'FRA', '46.2276380', '2.2137490', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (75, 'FRENCH GUIANA', 'GF', 'GUF', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (76, 'FRENCH POLYNESIA', 'PF', 'PYF', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (77, 'FRENCH SOUTHERN TERRITORIES', 'TF', 'ATF', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (78, 'GABON', 'GA', 'GAB', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (79, 'GAMBIA', 'GM', 'GAM', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (80, 'GEORGIA', 'GE', 'GEO', '41.7324592', '44.8070955', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (81, 'GERMANY', 'DE', 'GER', '51.1656910', '10.4515260', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (82, 'GHANA', 'GH', 'GHA', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (83, 'GIBRALTAR', 'GI', 'GIB', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (84, 'GREECE', 'GR', 'GRE', '39.0742080', '21.8243120', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (85, 'GREENLAND', 'GL', 'GRL', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (86, 'GRENADA', 'GD', 'GRN', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (87, 'GUADELOUPE', 'GP', 'GLP', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (88, 'GUAM', 'GU', 'GUM', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (89, 'GUATEMALA', 'GT', 'GUA', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (90, 'GUINEA', 'GN', 'GUI', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (91, 'GUINEA-BISSAU', 'GW', 'GBS', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (92, 'GUYANA', 'GY', 'GUY', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (93, 'HAITI', 'HT', 'HAI', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (94, 'HEARD ISLAND AND MCDONALD ISLANDS', 'HM', 'HMD', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (95, 'HOLY SEE (VATICAN CITY STATE)', 'VA', 'VAT', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (96, 'HONDURAS', 'HN', 'HON', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (97, 'HONG KONG, CHINA', 'HK', 'HKG', '22.3964280', '114.1094970', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (98, 'HUNGARY', 'HU', 'HUN', '47.1624940', '19.5033040', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (99, 'ICELAND', 'IS', 'ISL', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (100, 'INDIA', 'IN', 'IND', '20.5936840', '78.9628800', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (101, 'INDONESIA', 'ID', 'INA', '-0.7892750', '113.9213270', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (102, 'ISLAMIC REPUBLIC OF IRAN', 'IR', 'IRI', '38.4705621', '47.0572944', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (103, 'IRAQ', 'IQ', 'IRQ', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (104, 'IRELAND', 'IE', 'IRL', '53.1423672', '-7.6920536', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (105, 'ISRAEL', 'IL', 'ISR', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (106, 'ITALY', 'IT', 'ITA', '41.8719400', '12.5673800', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (107, 'JAMAICA', 'JM', 'JAM', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (108, 'JAPAN', 'JP', 'JPN', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (109, 'JORDAN', 'JO', 'JOR', '40.7405570', '-73.9858427', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (110, 'KAZAKHSTAN', 'KZ', 'KAZ', '48.0195730', '66.9236840', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (111, 'KENYA', 'KE', 'KEN', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (112, 'KIRIBATI', 'KI', 'KIR', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (113, 'DEMOCRATIC PEOPLES REPUBLIC OF KOREA', 'KP', 'PRK', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (114, 'REPUBLIC OF KOREA', 'KR', 'KOR', '40.7512100', '-73.9689230', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (115, 'KUWAIT', 'KW', 'KUW', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (116, 'KYRGYZSTAN', 'KG', 'KGZ', '41.2043800', '74.7660980', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (117, 'LAO PEOPLES DEMOCRATIC REPUBLIC', 'LA', 'LAO', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (118, 'LATVIA', 'LV', 'LAT', '56.8796350', '24.6031890', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (119, 'LEBANON', 'LB', 'LBN', '33.8547210', '35.8622850', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (120, 'LESOTHO', 'LS', 'LES', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (121, 'LIBERIA', 'LR', 'LBR', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (122, 'LIBYA', 'LY', 'LBA', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (123, 'LIECHTENSTEIN', 'LI', 'LIE', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (124, 'LITHUANIA', 'LT', 'LTU', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (125, 'LUXEMBOURG', 'LU', 'LUX', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (126, 'MACAU, CHINA', 'MO', 'MAC', '22.1987450', '113.5438730', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (127, 'NORTH MACEDONIA', 'MK', 'MKD', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (128, 'MADAGASCAR', 'MG', 'MAD', '-18.7669470', '46.8691070', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (129, 'MALAWI', 'MW', 'MAW', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (130, 'MALAYSIA', 'MY', 'MAS', '4.2104840', '101.9757660', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (131, 'MALDIVES', 'MV', 'MDV', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (132, 'MALI', 'ML', 'MLI', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (133, 'MALTA', 'MT', 'MLT', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (134, 'MARSHALL ISLANDS', 'MH', 'MHL', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (135, 'MARTINIQUE', 'MQ', 'MTQ', '14.6415280', '-61.0241740', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (136, 'MAURITANIA', 'MR', 'MTN', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (137, 'MAURITIUS', 'MU', 'MRI', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (138, 'MAYOTTE', 'YT', 'MYT', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (139, 'MEXICO', 'MX', 'MEX', '23.6345010', '-102.5527840', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (140, 'MICRONESIA, FEDERATED STATES OF', 'FM', 'FSM', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (141, 'MOLDOVA, REPUBLIC OF', 'MD', 'MDA', '47.0272465', '28.8265479', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (142, 'MONACO', 'MC', 'MON', '43.7384176', '7.4246158', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (143, 'MONGOLIA', 'MN', 'MGL', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (144, 'MONTSERRAT', 'MS', 'MSR', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (145, 'MOROCCO', 'MA', 'MAR', '31.7917020', '-7.0926200', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (146, 'MOZAMBIQUE', 'MZ', 'MOZ', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (147, 'MYANMAR', 'MM', 'MYA', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (148, 'NAMIBIA', 'NA', 'NAM', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (149, 'NAURU', 'NR', 'NRU', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (150, 'NEPAL', 'NP', 'NEP', '28.3948570', '84.1240080', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (151, 'NETHERLANDS', 'NL', 'NED', '52.1326330', '5.2912660', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (152, 'NETHERLANDS ANTILLES', 'AN', 'AHO', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (153, 'NEW CALEDONIA', 'NC', 'NCL', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (154, 'NEW ZEALAND', 'NZ', 'NZL', '-40.9005570', '174.8859710', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (155, 'NICARAGUA', 'NI', 'NCA', '12.8654160', '-85.2072290', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (156, 'NIGER', 'NE', 'NIG', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (157, 'NIGERIA', 'NG', 'NGR', '9.0819990', '8.6752770', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (158, 'NIUE', 'NU', 'NIU', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (159, 'NORFOLK ISLAND', 'NF', 'NFK', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (160, 'NORTHERN MARIANA ISLANDS', 'MP', 'MNP', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (161, 'NORWAY', 'NO', 'NOR', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (162, 'OMAN', 'OM', 'OMA', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (163, 'PAKISTAN', 'PK', 'PAK', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (164, 'PALAU', 'PW', 'PLW', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (165, 'PALESTINE', 'PS', 'PLE', '31.947351', '35.227163', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (166, 'PANAMA', 'PA', 'PAN', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (167, 'PAPUA NEW GUINEA', 'PG', 'PNG', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (168, 'PARAGUAY', 'PY', 'PAR', '-23.4425030', '-58.4438320', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (169, 'PERU', 'PE', 'PER', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (170, 'PHILIPPINES', 'PH', 'PHI', '12.8797210', '121.7740170', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (171, 'PITCAIRN', 'PN', 'PCN', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (172, 'POLAND', 'PL', 'POL', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (173, 'PORTUGAL', 'PT', 'POR', '39.3998720', '-8.2244540', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (174, 'PUERTO RICO', 'PR', 'PUR', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (175, 'QATAR', 'QA', 'QAT', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (176, 'REUNION', 'RE', 'REU', '-21.1151410', '55.5363840', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (177, 'ROMANIA', 'RO', 'ROU', '45.9431610', '24.9667600', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (178, 'RUSSIAN FEDERATION', 'RU', 'RUS', '61.5240100', '105.3187560', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (179, 'RWANDA', 'RW', 'RWA', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (180, 'SAINT HELENA', 'SH', 'SHN', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (181, 'SAINT KITTS AND NEVIS', 'KN', 'SKN', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (182, 'SAINT LUCIA', 'LC', 'LCA', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (183, 'SAINT PIERRE AND MIQUELON', 'PM', 'SPM', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (184, 'SAINT VINCENT AND THE GRENADINES', 'VC', 'VIN', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (185, 'SAMOA', 'WS', 'SAM', '-13.7590290', '-172.1046290', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (186, 'SAN MARINO', 'SM', 'SMR', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (187, 'SAO TOME AND PRINCIPE', 'ST', 'STP', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (188, 'SAUDI ARABIA', 'SA', 'KSA', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (189, 'SENEGAL', 'SN', 'SEN', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (190, 'SERBIA', 'RS', 'SRB', '44.0165210', '21.0058590', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (191, 'SEYCHELLES', 'SC', 'SEY', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (192, 'SIERRA LEONE', 'SL', 'SLE', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (193, 'SINGAPORE', 'SG', 'SGP', '1.3520830', '103.8198360', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (194, 'SLOVAKIA', 'SK', 'SVK', '48.6690260', '19.6990240', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (195, 'SLOVENIA', 'SI', 'SLO', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (196, 'SOLOMON ISLANDS', 'SB', 'SOL', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (197, 'SOMALIA', 'SO', 'SOM', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (198, 'SOUTH AFRICA', 'ZA', 'RSA', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (199, 'SOUTH GEORGIA AND THE SOUTH SANDWICH ISLANDS', 'GS', 'SGS', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (200, 'SPAIN', 'ES', 'ESP', '40.4636670', '-3.7492200', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (201, 'SRI LANKA', 'LK', 'SRI', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (202, 'SUDAN', 'SD', 'SUD', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (203, 'SURINAME', 'SR', 'SUR', '3.9193050', '-56.0277830', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (204, 'SVALBARD AND JAN MAYEN', 'SJ', 'SJM', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (205, 'ESWATINI', 'SZ', 'SWZ', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (206, 'SWEDEN', 'SE', 'SWE', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (207, 'SWITZERLAND', 'CH', 'SUI', '46.8181880', '8.2275120', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (208, 'SYRIAN ARAB REPUBLIC', 'SY', 'SYR', '34.8020750', '38.9968150', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (209, 'CHINESE TAIPEI', 'TW', 'TPE', '2.9970000', '101.5277501', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (210, 'TAJIKISTAN', 'TJ', 'TJK', '38.8610340', '71.2760930', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (211, 'TANZANIA, UNITED REPUBLIC OF', 'TZ', 'TAN', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (212, 'THAILAND', 'TH', 'THA', '15.8700320', '100.9925410', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (213, 'TIMOR-LESTE', 'TL', 'TLS', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (214, 'TOGO', 'TG', 'TOG', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (215, 'TOKELAU', 'TK', 'TKL', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (216, 'TONGA', 'TO', 'TGA', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (217, 'TRINIDAD AND TOBAGO', 'TT', 'TTO', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (218, 'TUNISIA', 'TN', 'TUN', '33.8869170', '9.5374990', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (219, 'TURKIYE', 'TR', 'TUR', '38.9637450', '35.2433220', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (220, 'TURKMENISTAN', 'TM', 'TKM', '38.9697190', '59.5562780', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (221, 'TURKS AND CAICOS ISLANDS', 'TC', 'TCA', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (222, 'TUVALU', 'TV', 'TUV', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (223, 'UGANDA', 'UG', 'UGA', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (224, 'UKRAINE', 'UA', 'UKR', '48.3794330', '31.1655800', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (225, 'UNITED ARAB EMIRATES', 'AE', 'UAE', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (226, 'UNITED KINGDOM', 'GB', 'GBR', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (227, 'UNITED STATES', 'US', 'USA', '37.0902400', '-95.7128910', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (228, 'UNITED STATES MINOR OUTLYING ISLANDS', 'UM', 'UMI', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (229, 'URUGUAY', 'UY', 'URU', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (230, 'UZBEKISTAN', 'UZ', 'UZB', '41.3774910', '64.5852620', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (231, 'VANUATU', 'VU', 'VAN', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (232, 'VENEZUELA', 'VE', 'VEN', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (233, 'VIETNAM', 'VN', 'VIE', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (234, 'VIRGIN ISLANDS, BRITISH', 'VG', 'IVB', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (235, 'VIRGIN ISLANDS, U.S.', 'VI', 'ISV', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (236, 'WALLIS AND FUTUNA', 'WF', 'WLF', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (237, 'WESTERN SAHARA', 'EH', 'ESH', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (238, 'YEMEN', 'YE', 'YEM', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (239, 'ZAMBIA', 'ZM', 'ZAM', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (240, 'ZIMBABWE', 'ZW', 'ZIM', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (242, 'AFGHANISTAN', 'AF', 'AFG', '33.9391100', '67.7099530', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (243, 'MONTENEGRO', 'ME', 'MNE', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (246, 'ENGLAND', 'GBENG', 'ENG', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (247, 'WALES', 'GBWLS', 'WAL', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (248, 'SCOTLAND', 'GBSCO', 'SCO', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (249, 'NORTHERN IRELAND', 'GBNIR', 'NIR', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (250, 'KOSOVO', 'KOS', 'KOS', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (251, 'ABKHAZIA ', 'ABK', 'ABK', '', '', NULL, 1);[EOL]
INSERT INTO `nation` VALUES (252, 'CURACAO', 'CUR', 'CUR', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (253, 'SOUTH SUDAN', 'SSD', 'SSD', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (254, 'BONAIRE', 'BON', 'BON', '12.2018902', '-68.2623822', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (255, 'GAMMA', 'GAMMA', 'GAMMA', '', '', NULL, 0);[EOL]
INSERT INTO `nation` VALUES (256, 'GAMMA Approved Association', 'GAA', 'GAA', '', '', NULL, 0);[EOL]

CREATE TABLE IF NOT EXISTS `nennungencoach` (
  `ID` INT(10) NOT NULL,
  `VERNR` INT(10) NOT NULL,
  `TIME` TIMESTAMP NOT NULL,
  `REGISTRATOR` INT(10),
  `CHECKOK` INT(10),
  `CHECKCOM` TEXT,
  `CATID` INT(10),
  `ACCPRINTED` INT(10) NOT NULL,
  `ACCPRINTEDTIME` TIMESTAMP,
  `ACCCUSTOM` VARCHAR(255),
  `CHECKOK2` INT(10),
  `CHECKCOM2` TEXT,
  `CHECKCOM3` TEXT,
  `MS` INT(10)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;[EOL]


CREATE TABLE IF NOT EXISTS `nennungeneinzel` (
  `VERNR` INT(10) NOT NULL,
  `KATNR` INT(10) NOT NULL,
  `NNR` INT(10) NOT NULL,
  `GESETZT` INT(10),
  `TIME` TIMESTAMP NOT NULL,
  `REGISTRATOR` INT(10),
  `CHECKOK` INT(10),
  `CHECKCOM` TEXT,
  `CHECKOKENTRY` INT(10),
  `CHECKCOMENTRY` TEXT,
  `MEASUREMENT` FLOAT,
  `ACCPRINTED` INT(10) NOT NULL,
  `ACCPRINTEDTIME` TIMESTAMP,
  `ACCCUSTOM` VARCHAR(255),
  `REGDOB` DATE,
  `CHECKOKMEDICAL` INT(10),
  `MS` INT(10),
  PRIMARY KEY (`katnr`, `nnr`, `vernr`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;[EOL]

CREATE TABLE IF NOT EXISTS `nennungenofficial` (
  `ID` INT(10) NOT NULL,
  `VERNR` INT(10) NOT NULL,
  `TIME` TIMESTAMP NOT NULL,
  `REGISTRATOR` INT(10),
  `DAYSINFO` VARCHAR(50),
  `CATID` INT(10),
  `CHECKOK` INT(10),
  `CHECKCOM` TEXT,
  `ACCPRINTED` INT(10) NOT NULL,
  `ACCPRINTEDTIME` TIMESTAMP,
  `ACCCUSTOM` VARCHAR(255),
  `CHECKOK2` INT(10),
  `CHECKCOM2` TEXT,
  `CHECKCOM3` TEXT,
  `MS` INT(10)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;[EOL]


CREATE TABLE IF NOT EXISTS `nennungenreferee` (
  `ID` INT(10) NOT NULL,
  `VERNR` INT(10) NOT NULL,
  `TIME` TIMESTAMP NOT NULL,
  `REGISTRATOR` INT(10),
  `DAYSINFO` VARCHAR(50),
  `CHECKOK` INT(10),
  `CHECKCOM` TEXT,
  `CATID` INT(10),
  `ACCPRINTED` INT(10) NOT NULL,
  `ACCPRINTEDTIME` TIMESTAMP,
  `ACCCUSTOM` VARCHAR(255),
  `CHECKOK2` INT(10),
  `CHECKCOM2` TEXT,
  `CHECKCOM3` TEXT,
  `MS` INT(10)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;[EOL]


CREATE TABLE IF NOT EXISTS `nennungenteam` (
  `VERNR` INT(10) NOT NULL,
  `KNR` INT(10) NOT NULL,
  `VEREINNR` INT(10) NOT NULL,
  `MANNSCHAFT` TEXT NOT NULL,
  `GESETZT` INT(10),
  `TIME` TIMESTAMP NOT NULL,
  `REGISTRATOR` INT(10),
  `TEAMID` INT(10) NOT NULL AUTO_INCREMENT ,
  `MS` INT(10),
 UNIQUE KEY `TEAMID` (`TEAMID`) ) ENGINE=MyISAM  AUTO_INCREMENT=1  DEFAULT CHARSET=utf8;[EOL]


CREATE TABLE IF NOT EXISTS `official` (
  `ID` INT(10) NOT NULL AUTO_INCREMENT ,
  `TITEL` VARCHAR(50),
  `VORNAME` VARCHAR(255) NOT NULL,
  `NACHNAME` VARCHAR(255) NOT NULL,
  `GEBURT` DATE NOT NULL,
  `SICHTBAR` INT(10) NOT NULL,
  `GESCHLECHT` VARCHAR(1) NOT NULL,
  `VEREINNR` INT(10) NOT NULL,
  `ROLEID` INT(10) NOT NULL,
  `SONSTIGES` TEXT,
  `EMAIL` VARCHAR(255),
  `WKFID` VARCHAR(100),
  `PASSPORTID` VARCHAR(50),
  `EXTID` VARCHAR(30),
  `EXTHASPRIVATECOMMENT` INT(10),
  `EXTHASPUBLICCOMMENT` INT(10),
  `PUUID` VARCHAR(50),
  `ROLEPOSITION` VARCHAR(255),
  `FOTOWESTE` INT(10) NOT NULL,
  `FOTOWESTENR` VARCHAR(255),
  `OTHERINFO` TEXT,
  `DATAFIELD1` VARCHAR(255),
  `DATAFIELD2` VARCHAR(255),
  `DATAFIELD3` VARCHAR(255),
  `DATAFIELD4` VARCHAR(255),
  `DATAFIELD5` VARCHAR(255),
  `DATAFIELD6` VARCHAR(255),
  `DATAFIELD7` VARCHAR(255),
  `DATAFIELD8` VARCHAR(255),
  `DATAFIELD9` VARCHAR(255),
  `DATAFIELD10` VARCHAR(255),
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  AUTO_INCREMENT=1  DEFAULT CHARSET=utf8;[EOL]


CREATE TABLE IF NOT EXISTS `official_category` (
  `ID` INT(10) NOT NULL AUTO_INCREMENT ,
  `BEZEICHNUNG` VARCHAR(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  AUTO_INCREMENT=106  DEFAULT CHARSET=utf8;[EOL]

CREATE TABLE IF NOT EXISTS `officialcat_access` (
  `VERNR` INT(10) NOT NULL,
  `ACCNR` INT(10) NOT NULL,
  `OCID` INT(10) NOT NULL
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;[EOL]


CREATE TABLE IF NOT EXISTS `patter_match` (
  `ID` INT(10) NOT NULL AUTO_INCREMENT ,
  `TITLE` VARCHAR(255) NOT NULL,
  `REGEXSTRING` VARCHAR(255) NOT NULL,
  `VERNR` INT(10) NOT NULL,
  `KATA` TEXT NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  AUTO_INCREMENT=1  DEFAULT CHARSET=utf8;[EOL]


CREATE TABLE IF NOT EXISTS `personemail` (
  `PERSONTYPE` INT(10) NOT NULL,
  `ID` INT(10) NOT NULL,
  `EMAIL` VARCHAR(255) NOT NULL,
  `ISADDRESS` INT(10) NOT NULL
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;[EOL]


CREATE TABLE IF NOT EXISTS `poolsiegereinzel` (
  `VERNR` INT(10) NOT NULL,
  `KNR` INT(10) NOT NULL,
  `NNR` INT(10) NOT NULL,
  `XPOS` INT(10) NOT NULL,
  `YPOS` INT(10) NOT NULL,
  `FIELDPOS` INT(10) NOT NULL,
  `POOL` INT(10) NOT NULL,
  `TABLETYPE` INT(10) NOT NULL,
  `POINTS` INT(10),
  `KATA` INT(10),
  `MATCHID` VARCHAR(50),
  `MATCHTIME` TIMESTAMP NOT NULL,
  `WINTYPE` INT(10)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;[EOL]


CREATE TABLE IF NOT EXISTS `poolsiegerteam` (
  `VERNR` INT(10) NOT NULL,
  `KNR` INT(10) NOT NULL,
  `VEREINNR` INT(10) NOT NULL,
  `MANNSCHAFT` TEXT NOT NULL,
  `XPOS` INT(10) NOT NULL,
  `YPOS` INT(10) NOT NULL,
  `FIELDPOS` INT(10) NOT NULL,
  `POOL` INT(10) NOT NULL,
  `TABLETYPE` INT(10) NOT NULL,
  `POINTS` INT(10),
  `KATA` INT(10),
  `MATCHID` VARCHAR(50),
  `MATCHTIME` TIMESTAMP NOT NULL,
  `WINTYPE` INT(10)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;[EOL]


CREATE TABLE IF NOT EXISTS `press_function` (
  `ID` INT(10) NOT NULL AUTO_INCREMENT ,
  `NAME` VARCHAR(150) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  AUTO_INCREMENT=4  DEFAULT CHARSET=utf8;[EOL]

INSERT INTO `press_function` VALUES (1, 'press_function_writtenpress');[EOL]
INSERT INTO `press_function` VALUES (2, 'press_function_photographer');[EOL]
INSERT INTO `press_function` VALUES (3, 'press_function_other');[EOL]

CREATE TABLE IF NOT EXISTS `press_registration` (
  `ID` INT(10) NOT NULL AUTO_INCREMENT ,
  `FIRSTNAME` VARCHAR(150) NOT NULL,
  `LASTNAME` VARCHAR(150) NOT NULL,
  `MEDIANAME` VARCHAR(255) NOT NULL,
  `TYPE` INT(10) NOT NULL,
  `OTHERTYPE` VARCHAR(150),
  `FUNCTIONNAME` INT(10) NOT NULL,
  `OTHERFUNCTION` VARCHAR(255),
  `PRESSID` VARCHAR(150),
  `EMAIL` VARCHAR(255) NOT NULL,
  `PHONE` VARCHAR(100),
  `MOBILE` VARCHAR(100),
  `COUNTRYID` INT(10) NOT NULL,
  `VERID` INT(10) NOT NULL,
  `REGTIME` TIMESTAMP NOT NULL,
  `CHECKOKENTRY` INT(10),
  `CHECKCOMENTRY` TEXT,
  `ACCPRINTED` INT(10) NOT NULL,
  `ACCPRINTEDTIME` TIMESTAMP,
  `ACCCUSTOM` VARCHAR(255),
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  AUTO_INCREMENT=1  DEFAULT CHARSET=utf8;[EOL]


CREATE TABLE IF NOT EXISTS `press_type` (
  `ID` INT(10) NOT NULL AUTO_INCREMENT ,
  `NAME` VARCHAR(150) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  AUTO_INCREMENT=6  DEFAULT CHARSET=utf8;[EOL]

INSERT INTO `press_type` VALUES (1, 'press_type_newspaper');[EOL]
INSERT INTO `press_type` VALUES (2, 'press_type_radio');[EOL]
INSERT INTO `press_type` VALUES (3, 'press_type_internet');[EOL]
INSERT INTO `press_type` VALUES (4, 'press_type_tv');[EOL]
INSERT INTO `press_type` VALUES (5, 'press_type_other');[EOL]

CREATE TABLE IF NOT EXISTS `presstype_access` (
  `VERNR` INT(10) NOT NULL,
  `ACCNR` INT(10) NOT NULL,
  `TYPEID` INT(10) NOT NULL
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;[EOL]


CREATE TABLE IF NOT EXISTS `punktelisteeinzel` (
  `VERNR` INT(10) NOT NULL,
  `KNR` INT(10) NOT NULL,
  `NNR` INT(10) NOT NULL,
  `FIELDPOS` INT(10) NOT NULL,
  `POOL` INT(10) NOT NULL,
  `S1` FLOAT,
  `S2` FLOAT,
  `S3` FLOAT,
  `S4` FLOAT,
  `S5` FLOAT,
  `S6` FLOAT,
  `S7` FLOAT,
  `KATA` INT(10),
  `EXTRA` FLOAT,
  `GENERATEDFROMCAT` INT(10) NOT NULL,
  `SOTHERS` TEXT
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;[EOL]


CREATE TABLE IF NOT EXISTS `punktelisteteam` (
  `VERNR` INT(10) NOT NULL,
  `KNR` INT(10) NOT NULL,
  `VEREINNR` INT(10) NOT NULL,
  `MANNSCHAFT` TEXT NOT NULL,
  `FIELDPOS` INT(10) NOT NULL,
  `POOL` INT(10) NOT NULL,
  `S1` FLOAT,
  `S2` FLOAT,
  `S3` FLOAT,
  `S4` FLOAT,
  `S5` FLOAT,
  `S6` FLOAT,
  `S7` FLOAT,
  `KATA` INT(10),
  `EXTRA` FLOAT,
  `GENERATEDFROMCAT` INT(10) NOT NULL,
  `SOTHERS` TEXT
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;[EOL]


CREATE TABLE IF NOT EXISTS `referee` (
  `ID` INT(10) NOT NULL AUTO_INCREMENT ,
  `TITEL` VARCHAR(50),
  `VORNAME` VARCHAR(255) NOT NULL,
  `NACHNAME` VARCHAR(255) NOT NULL,
  `GEBURT` DATE NOT NULL,
  `SICHTBAR` INT(10) NOT NULL,
  `KYU` INT(10),
  `DAN` INT(10),
  `LIZENZNAT` TEXT,
  `GESCHLECHT` VARCHAR(1) NOT NULL,
  `VEREINNR` INT(10) NOT NULL,
  `NATIONNR` INT(10),
  `LIZENZINT` TEXT,
  `LIZENZNR` VARCHAR(255),
  `EMAIL` VARCHAR(255),
  `WKFID` VARCHAR(100),
  `PASSPORTID` VARCHAR(50),
  `EXTID` VARCHAR(30),
  `EXTHASPRIVATECOMMENT` INT(10),
  `EXTHASPUBLICCOMMENT` INT(10),
  `PUUID` VARCHAR(50),
  `DATAFIELD1` VARCHAR(255),
  `DATAFIELD2` VARCHAR(255),
  `DATAFIELD3` VARCHAR(255),
  `DATAFIELD4` VARCHAR(255),
  `DATAFIELD5` VARCHAR(255),
  `DATAFIELD6` VARCHAR(255),
  `DATAFIELD7` VARCHAR(255),
  `DATAFIELD8` VARCHAR(255),
  `DATAFIELD9` VARCHAR(255),
  `DATAFIELD10` VARCHAR(255),
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  AUTO_INCREMENT=1  DEFAULT CHARSET=utf8;[EOL]


CREATE TABLE IF NOT EXISTS `referee_category` (
  `ID` INT(10) NOT NULL AUTO_INCREMENT ,
  `BEZEICHNUNG` VARCHAR(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  AUTO_INCREMENT=49  DEFAULT CHARSET=utf8;[EOL]

CREATE TABLE IF NOT EXISTS `referee_exam` (
  `VERNR` INT(10) NOT NULL,
  `REFID` INT(10) NOT NULL,
  `EXAMID` INT(10) NOT NULL,
  `ISEXAMINER` INT(10) NOT NULL,
  `EVENTCOUNT` INT(10)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;[EOL]


CREATE TABLE IF NOT EXISTS `referee_exam_decision` (
  `VERNR` INT(10) NOT NULL,
  `DECISION` INT(10) NOT NULL,
  `REFID` INT(10) NOT NULL,
  `EXAMID` INT(10) NOT NULL
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;[EOL]


CREATE TABLE IF NOT EXISTS `referee_exam_result` (
  `VERNR` INT(10) NOT NULL,
  `EXAMID` INT(10) NOT NULL,
  `TEWRONGANSWERS` INT(10) NOT NULL,
  `PECRITERIAPOINTS` TEXT,
  `EXAMINERID` INT(10) NOT NULL,
  `TYPE` INT(10) NOT NULL,
  `REFID` INT(10) NOT NULL
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;[EOL]


CREATE TABLE IF NOT EXISTS `referee_match` (
  `ID` INT(10) NOT NULL AUTO_INCREMENT ,
  `VERNR` INT(10),
  `REFID` INT(10),
  `MATCHID` VARCHAR(50),
  `MATCHAREA` INT(10),
  `KATNR` INT(10),
  `TYPE` INT(10),
  `POOL` INT(10),
  `POSITION` INT(10),
  `POINTSCORE` FLOAT,
  `FLAGSCORE` INT(10),
  `PUUID` VARCHAR(50),
  `REFPOSITION` INT(10),
  `LASTCHANGE` TIMESTAMP NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  AUTO_INCREMENT=1  DEFAULT CHARSET=utf8;[EOL]


CREATE TABLE IF NOT EXISTS `referee_matcharea` (
  `VERNR` INT(10) NOT NULL,
  `REFID` INT(10),
  `AREA` INT(10)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;[EOL]


CREATE TABLE IF NOT EXISTS `refereecat_access` (
  `VERNR` INT(10) NOT NULL,
  `ACCNR` INT(10) NOT NULL,
  `OCID` INT(10) NOT NULL
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;[EOL]


CREATE TABLE IF NOT EXISTS `role_typ` (
  `ID` INT(10) NOT NULL AUTO_INCREMENT ,
  `BEZEICHNUNG` VARCHAR(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  AUTO_INCREMENT=6  DEFAULT CHARSET=utf8;[EOL]

INSERT INTO `role_typ` VALUES (1, 'official_type_a_medical');[EOL]
INSERT INTO `role_typ` VALUES (2, 'official_type_b_representative');[EOL]
INSERT INTO `role_typ` VALUES (3, 'official_type_c_press');[EOL]
INSERT INTO `role_typ` VALUES (4, 'official_type_d_physio');[EOL]
INSERT INTO `role_typ` VALUES (5, 'official_type_e_others');[EOL]

CREATE TABLE IF NOT EXISTS `siegerehrung_erledigt` (
  `VERNR` INT(10) NOT NULL,
  `KNR` INT(10) NOT NULL
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;[EOL]


CREATE TABLE IF NOT EXISTS `sportart` (
  `SPORTARTNR` INT(10) NOT NULL AUTO_INCREMENT ,
  `BEZEICHNUNG` VARCHAR(255) NOT NULL,
  PRIMARY KEY (`sportartnr`)
) ENGINE=MyISAM  AUTO_INCREMENT=1  DEFAULT CHARSET=utf8;[EOL]


CREATE TABLE IF NOT EXISTS `stilrichtung` (
  `ID` INT(10) NOT NULL AUTO_INCREMENT ,
  `BEZEICHNUNG` VARCHAR(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  AUTO_INCREMENT=1  DEFAULT CHARSET=utf8;[EOL]


CREATE TABLE IF NOT EXISTS `sysparam` (
  `PARAM` VARCHAR(255),
  `VALUE` VARCHAR(255)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;[EOL]

INSERT INTO `sysparam` VALUES ('dbimport', '2025-10-19 16:42:06.967');[EOL]
INSERT INTO `sysparam` VALUES ('setversion', '11000001');[EOL]
INSERT INTO `sysparam` VALUES ('dbuuid', '0853ad73-1c36-4e86-856f-9c56f462c847');[EOL]

CREATE TABLE IF NOT EXISTS `team` (
  `TEAMID` INT(10) NOT NULL,
  `NNR` INT(10) NOT NULL,
  `CHECKOKENTRY` INT(10),
  `CHECKCOMENTRY` TEXT,
  `MEASUREMENT` FLOAT,
  `CHECKOK` INT(10),
  `CHECKCOM` TEXT,
  `ACCPRINTED` INT(10) NOT NULL,
  `ACCPRINTEDTIME` TIMESTAMP,
  `ACCCUSTOM` VARCHAR(255),
  `CHECKOKMEDICAL` INT(10)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;[EOL]


CREATE TABLE IF NOT EXISTS `team_warteliste` (
  `TEAMID` INT(10) NOT NULL,
  `NNR` INT(10) NOT NULL
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;[EOL]


CREATE TABLE IF NOT EXISTS `timetable` (
  `ID` INT(10) NOT NULL AUTO_INCREMENT ,
  `VERNR` INT(10) NOT NULL,
  `DATE` DATE NOT NULL,
  `TATAMIS` INT(10) NOT NULL,
  `KNR` INT(10) NOT NULL,
  `CATNAME` TEXT,
  `SEX` VARCHAR(1) NOT NULL,
  `TYPE` INT(10) NOT NULL,
  `TATAMI` INT(10) NOT NULL,
  `POOL` INT(10) NOT NULL,
  `POOLS` INT(10) NOT NULL,
  `ENTRIES` INT(10) NOT NULL,
  `FIGHTTIME` INT(10) NOT NULL,
  `EDITED` INT(10) NOT NULL,
  `COLOR` VARCHAR(7) NOT NULL,
  `STARTTIME` TIMESTAMP NOT NULL,
  `ENDTIME` TIMESTAMP NOT NULL,
  `COMMENT` VARCHAR(255),
  `MATCHNUMBER` INT(10) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  AUTO_INCREMENT=1  DEFAULT CHARSET=utf8;[EOL]


CREATE TABLE IF NOT EXISTS `trostrunde_pool` (
  `ID` BIGINT(19) NOT NULL,
  `VERNR` INT(10) NOT NULL,
  `KNR` INT(10) NOT NULL,
  `POOL` INT(10) NOT NULL
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;[EOL]


CREATE TABLE IF NOT EXISTS `trostrundeeinzel` (
  `ID` BIGINT(19) NOT NULL,
  `NNR` INT(10) NOT NULL,
  `FIELDPOS` INT(10) NOT NULL,
  `TROSTRUNDE` INT(10) NOT NULL,
  `POINTS` INT(10),
  `KATA` INT(10),
  `MATCHID` VARCHAR(50),
  `MATCHTIME` TIMESTAMP NOT NULL,
  `WINTYPE` INT(10)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;[EOL]


CREATE TABLE IF NOT EXISTS `trostrundeteam` (
  `ID` BIGINT(19) NOT NULL,
  `VEREINNR` INT(10) NOT NULL,
  `MANNSCHAFT` TEXT NOT NULL,
  `FIELDPOS` INT(10) NOT NULL,
  `TROSTRUNDE` INT(10) NOT NULL,
  `POINTS` INT(10),
  `KATA` INT(10),
  `MATCHID` VARCHAR(50),
  `MATCHTIME` TIMESTAMP NOT NULL,
  `WINTYPE` INT(10)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;[EOL]


CREATE TABLE IF NOT EXISTS `user` (
  `ID` INT(10) NOT NULL AUTO_INCREMENT ,
  `USER` VARCHAR(50),
  `PASSWORT` VARCHAR(50) NOT NULL,
  `EMAIL` VARCHAR(255),
  `GESPERRT` INT(10) NOT NULL,
  `TITEL` VARCHAR(50),
  `VORNAME` VARCHAR(100),
  `NACHNAME` VARCHAR(100),
  `GEBURTSTAG` DATE,
  `ADRESSE` VARCHAR(255),
  `PLZ` VARCHAR(50),
  `ORT` VARCHAR(50),
  `NATION` INT(10),
  `TELEFON` VARCHAR(50),
  `FAX` VARCHAR(50),
  `MOBILTELEFON` VARCHAR(50),
  `CREATE` TIMESTAMP NOT NULL,
  `AKTIV` INT(10) NOT NULL,
  `BILLINGADDRESS` TEXT,
  `MANDANT` INT(10) NOT NULL,
  `AUTOPAYMENT` INT(10) NOT NULL,
  `PAYPALACCOUNT` VARCHAR(255),
  `BANKACCOUNT` TEXT,
  `EXTREGOPTION` INT(10),
  `GESTPAYSHOPLOGIN` VARCHAR(30),
  `PRIVACYPOLICYAGREE` INT(10) NOT NULL,
  `PRIVACYPOLICYAGREEDATE` TIMESTAMP NOT NULL,
  `STRIPEPK` VARCHAR(255),
  `STRIPESK` VARCHAR(255),
  `PKPASS` INT(10) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  AUTO_INCREMENT=3  DEFAULT CHARSET=utf8;[EOL]

INSERT INTO `user` VALUES (1, 'administrator', 'cdaeeeba9b4a4c5ebf042c0215a7bb0e', 'admin@sportdata.org', 0, 'DI Mag.', 'Roland', 'Breiteneder', '1978-08-13', 'Otterkringerstrasse 12 Tür 9', '1170', 'Wien', 15, '+436763704602', '', '', '0001-01-01 00:00:00', 1, 'sportdata GmbH & Co KG\nGumpendorderstrasse 60\n1060 Vienna\nAustria', 0, 0, '', NULL, 1, '', 1, '2019-01-20 18:21:48', '', '', 0);[EOL]
INSERT INTO `user` VALUES (2, 'setuser', 'cdaeeeba9b4a4c5ebf042c0215a7bb0e', '', 0, '', '', '', '1990-01-01', NULL, NULL, NULL, 0, NULL, NULL, NULL, '2025-10-19 16:43:10.027', 0, NULL, 2, 1, NULL, NULL, 1, NULL, 0, '1990-01-01 01:01:01', NULL, NULL, 0);[EOL]

CREATE TABLE IF NOT EXISTS `veranstaltung` (
  `VERNR` INT(10) NOT NULL AUTO_INCREMENT ,
  `BEZEICHNUNG` VARCHAR(255) NOT NULL,
  `VERDATUM` VARCHAR(20) NOT NULL,
  `NENNSTART` VARCHAR(20) NOT NULL,
  `NENNENDE` VARCHAR(20) NOT NULL,
  `USER` INT(10),
  `GESPERRT` INT(10) NOT NULL,
  `INFO` TEXT,
  `PASSWD` VARCHAR(50),
  `OFFEN` INT(10),
  `SHOWSTARTER` INT(10),
  `REGMODE` INT(10),
  `ADRESSE` VARCHAR(255),
  `AUSLOSUNGEN` INT(10),
  `LAND` INT(10) NOT NULL,
  `LASTCHANGE` TIMESTAMP NOT NULL,
  `LIMITEDTO` INT(10),
  `DELETETODRAW` INT(10),
  `WAEHRUNG` INT(10) NOT NULL,
  `TYP` INT(10),
  `LAT` VARCHAR(50),
  `LON` VARCHAR(50),
  `LIVEBLOG` INT(10) NOT NULL,
  `INDLIMITCLUB` INT(10) NOT NULL,
  `TEAMLIMITCLUB` INT(10) NOT NULL,
  `USEPAYPAL` INT(10),
  `PAYPALACCOUNT` VARCHAR(255),
  `PAYPALNOAMOUNT` INT(10),
  `SYSTEMTYPE` VARCHAR(150),
  `BISDATUM` VARCHAR(20),
  `HIDEFROMCALENDAR` INT(10),
  `GOOGLECALID` VARCHAR(250),
  `INVOICED` INT(10),
  `PAID` INT(10),
  `INTERNATIONAL` INT(10),
  `INFOEVENT` INT(10) NOT NULL,
  `USEOTHERCUTOFFDAY` INT(10),
  `OTHERCUTOFFDAY` VARCHAR(20),
  `ENTRYLIMIT` INT(10) NOT NULL,
  `PREMIUMEVENT` INT(10),
  `TICKETSHOPURL` VARCHAR(255),
  `HIDEREFEREEENTRIES` INT(10),
  `ALLENTRIESONWAITINGLIST` INT(10),
  `USEBOTHCUTOFFDATES` INT(10),
  `LIVEDTM` INT(10),
  `COACHLIMITCLUB` INT(10) NOT NULL,
  `REFEREELIMITCLUB` INT(10) NOT NULL,
  `OFFICIALLIMITCLUB` INT(10) NOT NULL,
  `USEDISCLAIMER` INT(10),
  `EVENTCONTACTEMAIL` VARCHAR(255),
  `TIMEZONE` VARCHAR(50),
  `LIVESTREAM` INT(10),
  `HOTEL` INT(10),
  `APPSYNCEVENT` INT(10),
  `APPSYNCCAT` INT(10),
  `APPSYNCCLUB` INT(10),
  `PUUID` VARCHAR(50),
  `HEADOFDELEGATION` INT(10),
  `HIDEINDREG` INT(10),
  `HIDETEAMREG` INT(10),
  `HIDECOACHREG` INT(10),
  `HIDEREFEREEREG` INT(10),
  `HIDEOFFICIALREG` INT(10),
  `BANKACCOUNT` TEXT,
  `USEBANKACCOUNT` INT(10) NOT NULL,
  `HIDECOACHENTRIES` INT(10),
  `HIDEOFFICIALENTRIES` INT(10),
  `HIDEATHLETEENTRIES` INT(10),
  `LINKEVENT` INT(10) NOT NULL,
  `LINKEVENTURL` VARCHAR(255),
  `EXTREGISTRATIONMODE` INT(10),
  `EXTREGISTRATIONMODEROLES` VARCHAR(100),
  `BILLINGADDRESS` TEXT,
  `USEBILLINGADDRESS` INT(10),
  `USERANKING` INT(10) NOT NULL,
  `PAYPALEXTRAFEE` FLOAT,
  `ALLENTRIESONWAITINGLISTCOACH` INT(10) NOT NULL,
  `ALLENTRIESONWAITINGLISTREFEREE` INT(10) NOT NULL,
  `ALLENTRIESONWAITINGLISTOFFICIAL` INT(10) NOT NULL,
  `ENTRYLIMITCOACH` INT(10) NOT NULL,
  `ENTRYLIMITREFEREE` INT(10) NOT NULL,
  `ENTRYLIMITOFFICIAL` INT(10) NOT NULL,
  `WAITINGLISTPUBLIC` INT(10) NOT NULL,
  `ENABLEPRESSREGISTRATION` INT(10) NOT NULL,
  `EXTREGISTRATIONNOPERMISSION` INT(10),
  `PAYPALEXTRAFEEPERCENTAGE` FLOAT,
  `SMFACEBOOK` VARCHAR(255),
  `SMWEBSITE` VARCHAR(255),
  `SMTWITTER` VARCHAR(255),
  `SMYOUTUBE` VARCHAR(255),
  `SMFLICKR` VARCHAR(255),
  `SMGOOGLE` VARCHAR(255),
  `SMINSTAGRAM` VARCHAR(255),
  `EXTREGISTRATIONINTREFEREEONLY` INT(10) NOT NULL,
  `EXTREGISTRATIONINTCOACHONLY` INT(10) NOT NULL,
  `STARTTIME` VARCHAR(20),
  `ENDTIME` VARCHAR(20),
  `REGSTARTTIME` VARCHAR(20),
  `REGENDTIME` VARCHAR(20),
  `EXTID` INT(10) NOT NULL,
  `CARTKEEPOPENAFTERDEADLINE` INT(10),
  `HIDEMEDALSTATISTIC` INT(10),
  `NOTEINFO` TEXT,
  `NOTESHOW` INT(10),
  `SHOWSTARTERONLYBYPERMISSION` INT(10) NOT NULL,
  `SHOWDRAWSONLYBYPERMISSION` INT(10) NOT NULL,
  `USEGESTPAY` INT(10) NOT NULL,
  `GESTPAYSHOPLOGIN` VARCHAR(30),
  `GESTPAYNOAMOUNT` INT(10) NOT NULL,
  `GESTPAYEXTRAFEE` FLOAT NOT NULL,
  `GESTPAYEXTRAFEEPERCENTAGE` FLOAT NOT NULL,
  `LIMITINDATHLETE` INT(10) NOT NULL,
  `LIMITINDATHLETE_WAITINGLIST` INT(10) NOT NULL,
  `INDLIMITCOUNTRY` INT(10) NOT NULL,
  `INDENTRYUSESPORTSID` INT(10) NOT NULL,
  `INDENTRYUSERANKINGTOPRANK` INT(10) NOT NULL,
  `INDENTRYUSERANKINGTOPRANKENDATE` VARCHAR(20),
  `PAYPALWLAUTOAPPROVEONPAYMENT` INT(10) NOT NULL,
  `GESTPAYWLAUTOAPPROVEONPAYMENT` INT(10) NOT NULL,
  `ENABLEWLPAYMENTENTRYREMOVER` INT(10) NOT NULL,
  `WLPAYMENTENTRYREMOVERMAXMINUTES` INT(10) NOT NULL,
  `EXTTYPEFILTER` VARCHAR(150),
  `EVENTAGEGENERALFROM` DATE,
  `EVENTAGEGENERALTO` DATE,
  `CUSTOMPAYMENTURL` VARCHAR(255),
  `SHOWSTARTERCOUNTONLY` INT(10),
  `USEPAYPALDONATIONBUTTON` INT(10),
  `SCOREMODE` INT(10) NOT NULL,
  `HIDERESULTLIST` INT(10),
  `PHOTOUPLOADKEY` VARCHAR(50),
  `INDENTRYSHOWRANKINGPOS` INT(10),
  `EXTSYSTEMS` VARCHAR(255),
  `SHOWATHLETEPROFILESPUBLIC` INT(10),
  `USESTRIPE` INT(10) NOT NULL,
  `STRIPEPUBKEY` VARCHAR(255),
  `STRIPESECKEY` VARCHAR(255),
  `STRIPEWLAUTOAPPROVEONPAYMENT` INT(10) NOT NULL,
  `ETREFEREESELFASSIGNMENT` INT(10) NOT NULL,
  `ETREFEREESELFASSIGNMENT_ONEPERCOUNTRY` INT(10),
  `ENABLEVOLUNTEERREGISTRATION` INT(10),
  `USEMATCHNUMBERCODES` INT(10),
  `USEMATCHNUMBERCODESTIME` INT(10),
  `EXTREGSYSTEMINFOTEXT` TEXT,
  `USEALLMATCHCODES` INT(10),
  `SUPERLICENSEEVENT` INT(10),
  `ADMINALLOWREFEREESCORES` INT(10),
  `EXTSYSTEMSWHITELIST` VARCHAR(255),
  `RESULTSCUSTOMURL` VARCHAR(255),
  `MEDALSCUSTOMURL` VARCHAR(255),
  `ENABLEWLPAYMENTENTRYREMOVER_COACH` INT(10) NOT NULL,
  `WLPAYMENTENTRYREMOVERMAXMINUTES_COACH` INT(10) NOT NULL,
  `ENABLEWLPAYMENTENTRYREMOVER_REFEREE` INT(10) NOT NULL,
  `WLPAYMENTENTRYREMOVERMAXMINUTES_REFEREE` INT(10) NOT NULL,
  `ENABLEWLPAYMENTENTRYREMOVER_OFFICIAL` INT(10) NOT NULL,
  `WLPAYMENTENTRYREMOVERMAXMINUTES_OFFICIAL` INT(10) NOT NULL,
  `INDENTRYUSERANKINGTOPRANKFROM` INT(10) NOT NULL,
  `EVENTCODE` VARCHAR(20),
  `ATHLETELIMITFILTER` TEXT,
  `INDENTRYUSERANKINGTOPRANKFROM_CHECKOTHERCATEGORIES` INT(10),
  `CUSTOMMAP` TEXT,
  `REGION` INT(10),
  `CATTOTALLIMITPUTWLCAT` INT(10),
  `DISABLEENTRYDELETE` INT(10),
  `DISABLEENTRYDELETEWL` INT(10),
  `CATEGORYFILTER` TEXT,
  `SPORTSIDAPIFILTER` TEXT,
  `ENTRYLIMITNOWAITINGLIST` INT(10),
  `INVOICE_ID` VARCHAR(30),
  `INVOICE_AMOUNT` FLOAT,
  `INVOICE_PAYMENTINFO` VARCHAR(255),
  `INVOICE_ENABLE_PAYPAL` INT(10),
  `INVOICE_ENABLE_STRIPE` INT(10),
  `INVOICE_DOCUMENTURL` VARCHAR(255),
  `INVOICE_INTERNAL_NOTE` TEXT,
  `INVOICE_PUBLIC_NOTE` TEXT,
  PRIMARY KEY (`vernr`)
) ENGINE=MyISAM  AUTO_INCREMENT=195  DEFAULT CHARSET=utf8;[EOL]

CREATE TABLE IF NOT EXISTS `veranstaltung_area` (
  `VERNR` INT(10) NOT NULL,
  `ACCNR` INT(10) NOT NULL,
  `KURZBEZ` VARCHAR(5) NOT NULL,
  `NR` INT(10),
  `ATHLETESALLOWED` INT(10),
  `COACHESALLOWED` INT(10),
  `REFEREESALLOWED` INT(10),
  `OFFICIALSALLOWED` INT(10),
  `OFFCATSALLOWED` INT(10),
  `PRESSALLOWED` INT(10),
  `PRESSTYPEALLOWED` INT(10),
  `COACHCATSALLOWED` INT(10),
  `REFEREECATSALLOWED` INT(10)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;[EOL]


CREATE TABLE IF NOT EXISTS `veranstaltung_club_entryfee` (
  `VERNR` INT(10) NOT NULL,
  `VEREINNR` INT(10) NOT NULL,
  `PAIDAMMOUNT` FLOAT,
  `COMMENT` VARCHAR(255),
  `CHANGES` INT(10) NOT NULL,
  `DISCOUNT` FLOAT,
  `NOTIFICATIONSENT` DATE,
  `COMMENT2` TEXT
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;[EOL]


CREATE TABLE IF NOT EXISTS `veranstaltung_coach_category` (
  `VERNR` INT(10) NOT NULL,
  `ID` INT(10) NOT NULL,
  `MAXENTRIES` INT(10),
  `FEE` FLOAT,
  `MAXENTRIESTOTAL` INT(10)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;[EOL]


CREATE TABLE IF NOT EXISTS `veranstaltung_compcount` (
  `VERNR` INT(10) NOT NULL,
  `NNR` INT(10) NOT NULL,
  `EVENTCOUNT` INT(10) NOT NULL
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;[EOL]


CREATE TABLE IF NOT EXISTS `veranstaltung_exchangerate` (
  `VERNR` INT(10) NOT NULL,
  `WID` INT(10) NOT NULL,
  `RATE` FLOAT NOT NULL
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;[EOL]


CREATE TABLE IF NOT EXISTS `veranstaltung_headofdelegation` (
  `VERANSTALTUNG_ID` INT(10) NOT NULL,
  `CLUB_ID` INT(10) NOT NULL,
  `PERSON_ID` INT(10) NOT NULL,
  `PERSON_TYPE` INT(10) NOT NULL
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;[EOL]


CREATE TABLE IF NOT EXISTS `veranstaltung_hotel` (
  `VERNR` INT(10) NOT NULL,
  `TITLE` VARCHAR(255) NOT NULL,
  `URL` VARCHAR(255) NOT NULL,
  `DESCRIPTION` TEXT
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;[EOL]


CREATE TABLE IF NOT EXISTS `veranstaltung_limitbasedoncompetitors` (
  `VERANSTALTUNG_ID` INT(10) NOT NULL,
  `PERSON_TYPE` INT(10) NOT NULL,
  `LIMITRULE` TEXT NOT NULL
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;[EOL]


CREATE TABLE IF NOT EXISTS `veranstaltung_matchduration` (
  `MATCHID` VARCHAR(100),
  `CATID` INT(10),
  `ATHLETEID1` INT(10),
  `ATHLETEID2` INT(10),
  `MATCHDURATION` INT(10),
  `VERID` INT(10)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;[EOL]


CREATE TABLE IF NOT EXISTS `veranstaltung_official_category` (
  `VERNR` INT(10) NOT NULL,
  `ID` INT(10) NOT NULL,
  `MAXENTRIES` INT(10),
  `FEE` FLOAT,
  `MAXENTRIESTOTAL` INT(10)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;[EOL]


CREATE TABLE IF NOT EXISTS `veranstaltung_protest` (
  `VERNR` INT(10) NOT NULL,
  `ID` INT(10) NOT NULL,
  `CREATION` TIMESTAMP NOT NULL,
  `RINGNAME` VARCHAR(100),
  `MATCHID` VARCHAR(50),
  `SECONDS` INT(10) NOT NULL,
  `ATHNNR` INT(10),
  `CATID` INT(10)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;[EOL]


CREATE TABLE IF NOT EXISTS `veranstaltung_referee_category` (
  `VERNR` INT(10) NOT NULL,
  `ID` INT(10) NOT NULL,
  `MAXENTRIES` INT(10),
  `FEE` FLOAT,
  `MAXENTRIESTOTAL` INT(10)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;[EOL]


CREATE TABLE IF NOT EXISTS `veranstaltung_seat_area` (
  `VERID` INT(10) NOT NULL,
  `ID` INT(10) NOT NULL AUTO_INCREMENT ,
  `TITLE` VARCHAR(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  AUTO_INCREMENT=1  DEFAULT CHARSET=utf8;[EOL]


CREATE TABLE IF NOT EXISTS `veranstaltung_seat_area_seats` (
  `ID` INT(10) NOT NULL AUTO_INCREMENT ,
  `AREAID` INT(10) NOT NULL,
  `ROW` INT(10) NOT NULL,
  `SEAT` INT(10) NOT NULL,
  `RESERVED` INT(10),
  `ISAVAILABLE` INT(10) NOT NULL,
  `CUSTOMNAME` VARCHAR(100),
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  AUTO_INCREMENT=1  DEFAULT CHARSET=utf8;[EOL]


CREATE TABLE IF NOT EXISTS `veranstaltung_typ` (
  `ID` INT(10) NOT NULL AUTO_INCREMENT ,
  `BEZEICHNUNG` VARCHAR(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  AUTO_INCREMENT=6  DEFAULT CHARSET=utf8;[EOL]

INSERT INTO `veranstaltung_typ` VALUES (1, 'db_var_event_typ_tournament');[EOL]
INSERT INTO `veranstaltung_typ` VALUES (2, 'db_var_event_typ_seminar');[EOL]
INSERT INTO `veranstaltung_typ` VALUES (3, 'db_var_event_typ_other');[EOL]
INSERT INTO `veranstaltung_typ` VALUES (4, 'db_var_event_typ_league');[EOL]
INSERT INTO `veranstaltung_typ` VALUES (5, 'db_var_event_typ_gala');[EOL]

CREATE TABLE IF NOT EXISTS `veranstaltung_user` (
  `VERID` INT(10) NOT NULL,
  `USERID` INT(10) NOT NULL,
  `TIME` TIMESTAMP NOT NULL,
  `EMAILNOTIFICATION` INT(10) NOT NULL,
  `ROLELEVEL` INT(10) NOT NULL
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;[EOL]

INSERT INTO `veranstaltung_user` VALUES (194, 3, '2025-10-19 16:43:15', 0, 0);[EOL]
INSERT INTO `veranstaltung_user` VALUES (194, 47, '2025-10-19 16:43:15', 0, 0);[EOL]
INSERT INTO `veranstaltung_user` VALUES (194, 2, '2025-10-19 16:43:10.029', 1, 0);[EOL]

CREATE TABLE IF NOT EXISTS `veranstaltungkat` (
  `VERNR` INT(10) NOT NULL,
  `KNR` INT(10) NOT NULL,
  `ALTERVON` INT(10) NOT NULL,
  `ALTERNICHTMEHR` INT(10) NOT NULL,
  `STARTGELD` FLOAT,
  `TEAMMIN` INT(10),
  `TEAMMAX` INT(10),
  `RESULTTYPE` INT(10),
  `OTHERCUTOFFDAY` VARCHAR(20),
  `ROUNDROBIN` INT(10),
  `POOLS` INT(10),
  `DRAWMODESUBMODE` INT(10),
  `NEEDSIZE` INT(10) NOT NULL,
  `NEEDWEIGHT` INT(10) NOT NULL,
  `MAXENTRIES` INT(10) NOT NULL,
  `KYUFILTER` VARCHAR(50),
  `DANFILTER` VARCHAR(50),
  `MAXENTRIESTOTAL` INT(10) NOT NULL,
  `ISRANKINGCAT` INT(10),
  `BODY_LEVEL` INT(10),
  `HEAD_LEVEL` INT(10),
  `ROUNDS` INT(10),
  `ROUND_TIME` VARCHAR(5),
  `KYESHI_TIME` VARCHAR(5),
  `REST_TIME` VARCHAR(5),
  `GOLDENPOINT_ENABLE` INT(10),
  `GOLDENPOINT_TIME` VARCHAR(5),
  `WEST_SIZE` VARCHAR(255),
  `WEIGHTMIN` FLOAT,
  `WEIGHTMAX` FLOAT,
  `SHORTNAME` VARCHAR(50),
  `MATCHTYPE` VARCHAR(20),
  `SEEDMODE` INT(10),
  `MATCHFORM` VARCHAR(255),
  `SCOREMODE` INT(10),
  `EXREFSELFASS` INT(10),
  `CLASSEDECANE` VARCHAR(100),
  `GRADOAGILITY` VARCHAR(255),
  `GRADORALLYOBEDIENCE` VARCHAR(255),
  `REFDEPLOYMENT` INT(10),
  `OTHERCUTOFFDAYSTART` VARCHAR(20),
  `GRADOSDSFREESTYLE` VARCHAR(255),
  `GRADOSDSSPEEDWATER` VARCHAR(255),
  `GRADOSDSSPLASHDOG` VARCHAR(255),
  `GRADOSDSOBEDIENCE` VARCHAR(255),
  `GRADOSDSHOOPERS` VARCHAR(255),
  `CLASSEDECANESAH` VARCHAR(255),
  `IWUF_DIFFICULTY` INT(10),
  `IWUF_COMPMOVEMENT` INT(10),
  `IWUF_ADEDTF` INT(10),
  `IWUF_STYLE` VARCHAR(255),
  `IWUF_DATA` VARCHAR(255),
  `CATEGORYFILTER` TEXT,
  `GRADOSDSNOSEWORK` VARCHAR(255),
  `REGDATEFROM` DATE,
  `REGDATETO` DATE
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;[EOL]

CREATE TABLE IF NOT EXISTS `verein` (
  `VEREINNR` INT(10) NOT NULL AUTO_INCREMENT ,
  `BEZEICHNUNG` VARCHAR(255) NOT NULL,
  `NATION` INT(10) NOT NULL,
  `LVNR` INT(10),
  `SEKTIONNR` INT(10),
  `STPKTNR` INT(10),
  `CREATEDBYMANAGER` INT(10),
  `WEBSITE` VARCHAR(255),
  `NATIONALID` VARCHAR(30),
  `EXTID` VARCHAR(30),
  `PUUID` VARCHAR(50),
  `NATACCOUNTID` VARCHAR(30),
  `TEAMTYPE` INT(10),
  `TAXID` VARCHAR(100),
  `ADDRESS` VARCHAR(255),
  `CONTACT` VARCHAR(255),
  `PHONE` VARCHAR(50),
  `EMAIL` VARCHAR(255),
  `DATAFIELD1` VARCHAR(255),
  `DATAFIELD2` VARCHAR(255),
  `DATAFIELD3` VARCHAR(255),
  `DATAFIELD4` VARCHAR(255),
  `DATAFIELD5` VARCHAR(255),
  `DATAFIELD6` VARCHAR(255),
  `DATAFIELD7` VARCHAR(255),
  `DATAFIELD8` VARCHAR(255),
  `DATAFIELD9` VARCHAR(255),
  `DATAFIELD10` VARCHAR(255),
  PRIMARY KEY (`vereinnr`)
) ENGINE=MyISAM  AUTO_INCREMENT=53  DEFAULT CHARSET=utf8;[EOL]


CREATE TABLE IF NOT EXISTS `waehrung` (
  `ID` INT(10) NOT NULL AUTO_INCREMENT ,
  `BEZEICHNUNG` VARCHAR(10) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  AUTO_INCREMENT=163  DEFAULT CHARSET=utf8;[EOL]

INSERT INTO `waehrung` VALUES (1, 'AED');[EOL]
INSERT INTO `waehrung` VALUES (2, 'AFN');[EOL]
INSERT INTO `waehrung` VALUES (3, 'ALL');[EOL]
INSERT INTO `waehrung` VALUES (4, 'AMD');[EOL]
INSERT INTO `waehrung` VALUES (5, 'ANG');[EOL]
INSERT INTO `waehrung` VALUES (6, 'AOA');[EOL]
INSERT INTO `waehrung` VALUES (7, 'ARS');[EOL]
INSERT INTO `waehrung` VALUES (8, 'AUD');[EOL]
INSERT INTO `waehrung` VALUES (9, 'AWG');[EOL]
INSERT INTO `waehrung` VALUES (10, 'AZN');[EOL]
INSERT INTO `waehrung` VALUES (11, 'BAM');[EOL]
INSERT INTO `waehrung` VALUES (12, 'BBD');[EOL]
INSERT INTO `waehrung` VALUES (13, 'BDT');[EOL]
INSERT INTO `waehrung` VALUES (14, 'BGN');[EOL]
INSERT INTO `waehrung` VALUES (15, 'BHD');[EOL]
INSERT INTO `waehrung` VALUES (16, 'BIF');[EOL]
INSERT INTO `waehrung` VALUES (17, 'BMD');[EOL]
INSERT INTO `waehrung` VALUES (18, 'BND');[EOL]
INSERT INTO `waehrung` VALUES (19, 'BOB');[EOL]
INSERT INTO `waehrung` VALUES (20, 'BRL');[EOL]
INSERT INTO `waehrung` VALUES (21, 'BSD');[EOL]
INSERT INTO `waehrung` VALUES (22, 'BTN');[EOL]
INSERT INTO `waehrung` VALUES (23, 'BWP');[EOL]
INSERT INTO `waehrung` VALUES (24, 'BYR');[EOL]
INSERT INTO `waehrung` VALUES (25, 'BZD');[EOL]
INSERT INTO `waehrung` VALUES (26, 'CAD');[EOL]
INSERT INTO `waehrung` VALUES (27, 'CDF');[EOL]
INSERT INTO `waehrung` VALUES (28, 'CHF');[EOL]
INSERT INTO `waehrung` VALUES (29, 'CLP');[EOL]
INSERT INTO `waehrung` VALUES (30, 'CNY');[EOL]
INSERT INTO `waehrung` VALUES (31, 'COP');[EOL]
INSERT INTO `waehrung` VALUES (32, 'CRC');[EOL]
INSERT INTO `waehrung` VALUES (33, 'CUC');[EOL]
INSERT INTO `waehrung` VALUES (34, 'CUP');[EOL]
INSERT INTO `waehrung` VALUES (35, 'CVE');[EOL]
INSERT INTO `waehrung` VALUES (36, 'CZK');[EOL]
INSERT INTO `waehrung` VALUES (37, 'DJF');[EOL]
INSERT INTO `waehrung` VALUES (38, 'DKK');[EOL]
INSERT INTO `waehrung` VALUES (39, 'DOP');[EOL]
INSERT INTO `waehrung` VALUES (40, 'DZD');[EOL]
INSERT INTO `waehrung` VALUES (41, 'EEK');[EOL]
INSERT INTO `waehrung` VALUES (42, 'EGP');[EOL]
INSERT INTO `waehrung` VALUES (43, 'ETB');[EOL]
INSERT INTO `waehrung` VALUES (44, 'ERN');[EOL]
INSERT INTO `waehrung` VALUES (45, 'EUR');[EOL]
INSERT INTO `waehrung` VALUES (46, 'FJD');[EOL]
INSERT INTO `waehrung` VALUES (47, 'FKP');[EOL]
INSERT INTO `waehrung` VALUES (48, 'GBP');[EOL]
INSERT INTO `waehrung` VALUES (49, 'GEL');[EOL]
INSERT INTO `waehrung` VALUES (50, 'GHS');[EOL]
INSERT INTO `waehrung` VALUES (51, 'GIP');[EOL]
INSERT INTO `waehrung` VALUES (52, 'GMD');[EOL]
INSERT INTO `waehrung` VALUES (53, 'GNF');[EOL]
INSERT INTO `waehrung` VALUES (54, 'GTQ');[EOL]
INSERT INTO `waehrung` VALUES (55, 'GYD');[EOL]
INSERT INTO `waehrung` VALUES (56, 'HKD');[EOL]
INSERT INTO `waehrung` VALUES (57, 'HNL');[EOL]
INSERT INTO `waehrung` VALUES (58, 'HRK');[EOL]
INSERT INTO `waehrung` VALUES (59, 'HTG');[EOL]
INSERT INTO `waehrung` VALUES (60, 'HUF');[EOL]
INSERT INTO `waehrung` VALUES (61, 'IDR');[EOL]
INSERT INTO `waehrung` VALUES (62, 'ILS');[EOL]
INSERT INTO `waehrung` VALUES (63, 'INR');[EOL]
INSERT INTO `waehrung` VALUES (64, 'IQD');[EOL]
INSERT INTO `waehrung` VALUES (65, 'IRR');[EOL]
INSERT INTO `waehrung` VALUES (66, 'ISK');[EOL]
INSERT INTO `waehrung` VALUES (67, 'JMD');[EOL]
INSERT INTO `waehrung` VALUES (68, 'JOD');[EOL]
INSERT INTO `waehrung` VALUES (69, 'JPY');[EOL]
INSERT INTO `waehrung` VALUES (70, 'KES');[EOL]
INSERT INTO `waehrung` VALUES (71, 'KGS');[EOL]
INSERT INTO `waehrung` VALUES (72, 'KHR');[EOL]
INSERT INTO `waehrung` VALUES (73, 'KMF');[EOL]
INSERT INTO `waehrung` VALUES (74, 'KPW');[EOL]
INSERT INTO `waehrung` VALUES (75, 'KRW');[EOL]
INSERT INTO `waehrung` VALUES (76, 'KWD');[EOL]
INSERT INTO `waehrung` VALUES (77, 'KYD');[EOL]
INSERT INTO `waehrung` VALUES (78, 'KZT');[EOL]
INSERT INTO `waehrung` VALUES (79, 'LAK');[EOL]
INSERT INTO `waehrung` VALUES (80, 'LBP');[EOL]
INSERT INTO `waehrung` VALUES (81, 'LKR');[EOL]
INSERT INTO `waehrung` VALUES (82, 'LRD');[EOL]
INSERT INTO `waehrung` VALUES (83, 'LSL');[EOL]
INSERT INTO `waehrung` VALUES (84, 'LTL');[EOL]
INSERT INTO `waehrung` VALUES (85, 'LVL');[EOL]
INSERT INTO `waehrung` VALUES (86, 'LYD');[EOL]
INSERT INTO `waehrung` VALUES (87, 'MAD');[EOL]
INSERT INTO `waehrung` VALUES (88, 'MDL');[EOL]
INSERT INTO `waehrung` VALUES (89, 'MGA');[EOL]
INSERT INTO `waehrung` VALUES (90, 'MKD');[EOL]
INSERT INTO `waehrung` VALUES (91, 'MMK');[EOL]
INSERT INTO `waehrung` VALUES (92, 'MNT');[EOL]
INSERT INTO `waehrung` VALUES (93, 'MOP');[EOL]
INSERT INTO `waehrung` VALUES (94, 'MRO');[EOL]
INSERT INTO `waehrung` VALUES (95, 'MUR');[EOL]
INSERT INTO `waehrung` VALUES (96, 'MVR');[EOL]
INSERT INTO `waehrung` VALUES (97, 'MWK');[EOL]
INSERT INTO `waehrung` VALUES (98, 'MXN');[EOL]
INSERT INTO `waehrung` VALUES (99, 'MYR');[EOL]
INSERT INTO `waehrung` VALUES (100, 'MZN');[EOL]
INSERT INTO `waehrung` VALUES (101, 'NAD');[EOL]
INSERT INTO `waehrung` VALUES (102, 'NGN');[EOL]
INSERT INTO `waehrung` VALUES (103, 'NIO');[EOL]
INSERT INTO `waehrung` VALUES (104, 'NOK');[EOL]
INSERT INTO `waehrung` VALUES (105, 'NPR');[EOL]
INSERT INTO `waehrung` VALUES (106, 'NZD');[EOL]
INSERT INTO `waehrung` VALUES (107, 'OMR');[EOL]
INSERT INTO `waehrung` VALUES (108, 'PAB');[EOL]
INSERT INTO `waehrung` VALUES (109, 'PEN');[EOL]
INSERT INTO `waehrung` VALUES (110, 'PGK');[EOL]
INSERT INTO `waehrung` VALUES (111, 'PHP');[EOL]
INSERT INTO `waehrung` VALUES (112, 'PKR');[EOL]
INSERT INTO `waehrung` VALUES (113, 'PLN');[EOL]
INSERT INTO `waehrung` VALUES (114, 'PYG');[EOL]
INSERT INTO `waehrung` VALUES (115, 'QAR');[EOL]
INSERT INTO `waehrung` VALUES (116, 'RON');[EOL]
INSERT INTO `waehrung` VALUES (117, 'RSD');[EOL]
INSERT INTO `waehrung` VALUES (118, 'RUB');[EOL]
INSERT INTO `waehrung` VALUES (119, 'RWF');[EOL]
INSERT INTO `waehrung` VALUES (120, 'SAR');[EOL]
INSERT INTO `waehrung` VALUES (121, 'SBD');[EOL]
INSERT INTO `waehrung` VALUES (122, 'SCR');[EOL]
INSERT INTO `waehrung` VALUES (123, 'SDG');[EOL]
INSERT INTO `waehrung` VALUES (124, 'SEK');[EOL]
INSERT INTO `waehrung` VALUES (125, 'SGD');[EOL]
INSERT INTO `waehrung` VALUES (126, 'SHP');[EOL]
INSERT INTO `waehrung` VALUES (127, 'SKK');[EOL]
INSERT INTO `waehrung` VALUES (128, 'SLL');[EOL]
INSERT INTO `waehrung` VALUES (129, 'SOS');[EOL]
INSERT INTO `waehrung` VALUES (130, 'SRD');[EOL]
INSERT INTO `waehrung` VALUES (131, 'STD');[EOL]
INSERT INTO `waehrung` VALUES (132, 'SVC');[EOL]
INSERT INTO `waehrung` VALUES (133, 'SYP');[EOL]
INSERT INTO `waehrung` VALUES (134, 'SZL');[EOL]
INSERT INTO `waehrung` VALUES (135, 'THB');[EOL]
INSERT INTO `waehrung` VALUES (136, 'TJS');[EOL]
INSERT INTO `waehrung` VALUES (137, 'TMM');[EOL]
INSERT INTO `waehrung` VALUES (138, 'TND');[EOL]
INSERT INTO `waehrung` VALUES (139, 'TOP');[EOL]
INSERT INTO `waehrung` VALUES (140, 'TRY');[EOL]
INSERT INTO `waehrung` VALUES (141, 'TTD');[EOL]
INSERT INTO `waehrung` VALUES (142, 'TWD');[EOL]
INSERT INTO `waehrung` VALUES (143, 'TZS');[EOL]
INSERT INTO `waehrung` VALUES (144, 'UAH');[EOL]
INSERT INTO `waehrung` VALUES (145, 'UGX');[EOL]
INSERT INTO `waehrung` VALUES (146, 'USD');[EOL]
INSERT INTO `waehrung` VALUES (147, 'UYU');[EOL]
INSERT INTO `waehrung` VALUES (148, 'UZS');[EOL]
INSERT INTO `waehrung` VALUES (149, 'VEB');[EOL]
INSERT INTO `waehrung` VALUES (150, 'VEF');[EOL]
INSERT INTO `waehrung` VALUES (151, 'VND');[EOL]
INSERT INTO `waehrung` VALUES (152, 'VUV');[EOL]
INSERT INTO `waehrung` VALUES (153, 'WST');[EOL]
INSERT INTO `waehrung` VALUES (154, 'XAF');[EOL]
INSERT INTO `waehrung` VALUES (155, 'XCD');[EOL]
INSERT INTO `waehrung` VALUES (156, 'XDR');[EOL]
INSERT INTO `waehrung` VALUES (157, 'XOF');[EOL]
INSERT INTO `waehrung` VALUES (158, 'XPF');[EOL]
INSERT INTO `waehrung` VALUES (159, 'YER');[EOL]
INSERT INTO `waehrung` VALUES (160, 'ZAR');[EOL]
INSERT INTO `waehrung` VALUES (161, 'ZMK');[EOL]
INSERT INTO `waehrung` VALUES (162, 'ZWD');[EOL]

CREATE TABLE IF NOT EXISTS `wartelistecoach` (
  `VERNR` INT(10) NOT NULL,
  `KATNR` INT(10) NOT NULL,
  `ID` INT(10) NOT NULL,
  `TIME` TIMESTAMP NOT NULL,
  `REGISTRATOR` INT(10),
  `APPROVED` INT(10) NOT NULL,
  `COMMENT` TEXT,
  `MS` INT(10)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;[EOL]


CREATE TABLE IF NOT EXISTS `wartelisteeinzel` (
  `VERNR` INT(10) NOT NULL,
  `KATNR` INT(10) NOT NULL,
  `NNR` INT(10) NOT NULL,
  `TIME` TIMESTAMP NOT NULL,
  `REGISTRATOR` INT(10),
  `APPROVED` INT(10) NOT NULL,
  `COMMENT` TEXT,
  `REPLACEMENT` INT(10),
  `MS` INT(10),
  PRIMARY KEY (`katnr`, `nnr`, `vernr`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;[EOL]


CREATE TABLE IF NOT EXISTS `wartelisteofficial` (
  `VERNR` INT(10) NOT NULL,
  `KATNR` INT(10) NOT NULL,
  `ID` INT(10) NOT NULL,
  `TIME` TIMESTAMP NOT NULL,
  `REGISTRATOR` INT(10),
  `DAYSINFO` VARCHAR(50),
  `APPROVED` INT(10) NOT NULL,
  `COMMENT` TEXT,
  `MS` INT(10)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;[EOL]


CREATE TABLE IF NOT EXISTS `wartelistereferee` (
  `VERNR` INT(10) NOT NULL,
  `KATNR` INT(10) NOT NULL,
  `ID` INT(10) NOT NULL,
  `TIME` TIMESTAMP NOT NULL,
  `REGISTRATOR` INT(10),
  `DAYSINFO` VARCHAR(50),
  `APPROVED` INT(10) NOT NULL,
  `COMMENT` TEXT,
  `MS` INT(10)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;[EOL]


CREATE TABLE IF NOT EXISTS `wartelisteteam` (
  `VERNR` INT(10) NOT NULL,
  `KNR` INT(10) NOT NULL,
  `VEREINNR` INT(10) NOT NULL,
  `MANNSCHAFT` TEXT NOT NULL,
  `TIME` TIMESTAMP NOT NULL,
  `REGISTRATOR` INT(10),
  `TEAMID` INT(10) NOT NULL AUTO_INCREMENT ,
  `APPROVED` INT(10) NOT NULL,
  `COMMENT` TEXT,
  `REPLACEMENT` INT(10),
  `MS` INT(10),
 UNIQUE KEY `TEAMID` (`TEAMID`) ) ENGINE=MyISAM  AUTO_INCREMENT=1  DEFAULT CHARSET=utf8;[EOL]


CREATE TABLE IF NOT EXISTS `wintype` (
  `ID` INT(10) NOT NULL AUTO_INCREMENT ,
  `TITLE` VARCHAR(100) NOT NULL,
  `SHORT` VARCHAR(100) NOT NULL,
  `SPORT` INT(10) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  AUTO_INCREMENT=17  DEFAULT CHARSET=utf8;[EOL]