<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.1"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format"
	exclude-result-prefixes="fo">
	<xsl:output method="xml" version="1.0" omit-xml-declaration="no"
		indent="yes" />

	<xsl:param name="licencse" select="''" />
	<xsl:param name="date" select="''" />

	<!-- ========================= -->
	<!-- root element: projectteam -->
	<!-- ========================= -->
	<xsl:template match="Filereport">
		<fo:root xmlns:fo="http://www.w3.org/1999/XSL/Format"
			font-family="Arial">
			<fo:layout-master-set>
				<fo:simple-page-master master-name="simpleA4"
					page-height="29.7cm" page-width="21cm" margin-top="0mm"
					margin-bottom="0mm" margin-left="0mm" margin-right="0mm">
					<fo:region-body margin-top="0cm" margin-bottom="0cm" />
				</fo:simple-page-master>
			</fo:layout-master-set>
			<fo:page-sequence master-reference="simpleA4"
				language="de">


				<fo:flow flow-name="xsl-region-body">
					<fo:block font-size="8pt">
						<fo:table table-layout="fixed" width="100%">
							<fo:table-column column-width="10.5cm" />
							<fo:table-column column-width="10.5cm" />
							<fo:table-body>
								<xsl:apply-templates />
							</fo:table-body>
						</fo:table>
					</fo:block>
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>

	<xsl:template match="row">
			<xsl:apply-templates select="person" />
	</xsl:template>

	<xsl:template match="person">
	<fo:table-row height="14.8cm">
		<fo:table-cell border-style="dotted" border="0.5pt solid #aaaaaa"
			height="14.8cm" padding="0mm">

			<fo:block-container width="10.5cm" height="14.8cm">
				

				<fo:block font-size="10pt" text-align="center" font-weight="bold">
					<fo:table table-layout="fixed" width="100%">
						<fo:table-column column-width="10.5cm" />
						<fo:table-body>
							<fo:table-row height="2cm">
							<fo:table-cell height="2cm">
								<fo:block font-size="10pt" text-align="center">
									<xsl:text> </xsl:text>
								</fo:block>
							</fo:table-cell>
							</fo:table-row>
						</fo:table-body>
					</fo:table>
				</fo:block>
				<fo:block font-size="8pt" text-align="center">
					<fo:table table-layout="fixed" width="100%">
						<xsl:choose>
							<xsl:when test="string(picture)">
								<fo:table-column column-width="5cm" />
								<fo:table-column column-width="5cm" />
							</xsl:when>
							<xsl:otherwise>
								<fo:table-column column-width="10cm" />
							</xsl:otherwise>
						</xsl:choose>
						<fo:table-body>
							<fo:table-row height="140px">
								<xsl:choose>
									<xsl:when test="string(picture)">
										<fo:table-cell height="140px">
											<fo:block text-align="right" margin-right="2mm" display-align="center">
												<fo:external-graphic height="120px"
													width="4cm" content-height="scale-to-fit" content-width="scale-to-fit"
													scaling="uniform">
													<xsl:attribute name="src">
                          <xsl:value-of select="picture" />
                        </xsl:attribute>
												</fo:external-graphic>
											</fo:block>
										</fo:table-cell>
									</xsl:when>
								</xsl:choose>
								<fo:table-cell>
									<fo:block text-align="center" display-align="center">
										<xsl:choose>
											<xsl:when test="string(eventlogo)">
												<xsl:choose>
													<xsl:when test="string(picture)">
														
													</xsl:when>
													<xsl:otherwise>
														<fo:external-graphic height="120px"
															width="9.8cm" content-height="scale-to-fit"
															content-width="scale-to-fit" scaling="uniform">
															<xsl:attribute name="src">
                                <xsl:value-of select="eventlogo" />
                              </xsl:attribute>
														</fo:external-graphic>
													</xsl:otherwise>
												</xsl:choose>
											</xsl:when>
										</xsl:choose>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
						</fo:table-body>
					</fo:table>
				</fo:block>
				<xsl:choose>
					<xsl:when test="not(string(picture))">
						<fo:block font-size="8pt" text-align="center">
							<xsl:text> </xsl:text>
						</fo:block>
					</xsl:when>
				</xsl:choose>
				<fo:block font-size="11pt" text-align="center" font-weight="bold">
					<xsl:value-of select="name" />
				</fo:block>
				<fo:block font-size="10pt" text-align="center">
					<xsl:choose>
					<xsl:when test="string(substring-before(club, ' -'))">
						<xsl:value-of select="substring-before(club, ' -')"/>
					</xsl:when>
					<xsl:otherwise>
					<xsl:value-of select="club"/>
				</xsl:otherwise>
				</xsl:choose>	 
				</fo:block>
				<fo:block font-size="10pt" text-align="center" space-after="2mm">
				<xsl:choose>
					<xsl:when test="string(nation)">
					<fo:external-graphic content-height="10px"
						border="0.5pt solid black">
						<xsl:attribute name="src">
               images/flags/<xsl:value-of select="natid" />.gif
              </xsl:attribute>
					</fo:external-graphic>
					</xsl:when>
				</xsl:choose>
					<xsl:text> </xsl:text>
					<xsl:value-of select="nation" />
				</fo:block>
				<fo:block font-size="12pt" text-align="center" color="blue"
				font-weight="bold" space-after="2mm">
				<xsl:value-of select="role" />
				</fo:block>
				<xsl:apply-templates select="categories" />
				<fo:block text-align="center" space-before="10px">
				<fo:table table-layout="fixed" width="100%">
					<fo:table-column column-width="9.8cm" />
						<fo:table-body>
						<fo:table-row height="60px">
						<fo:table-cell height="60px">
						<fo:block text-align="center" space-before="3mm" height="60px" display-align="center">
								<xsl:choose>
						<xsl:when test="string(sponsorlogo)">
							<fo:external-graphic height="60px" width="10cm"
								content-height="scale-to-fit" content-width="scale-to-fit"
								scaling="uniform">
								<xsl:attribute name="src">
                  <xsl:value-of select="sponsorlogo" />
                </xsl:attribute>
							</fo:external-graphic>
						</xsl:when>
					</xsl:choose>
				</fo:block>
					
						</fo:table-cell>
						</fo:table-row>
						</fo:table-body>
					</fo:table>
				</fo:block>
				
			</fo:block-container>
		</fo:table-cell>
		<fo:table-cell border-style="dotted" border="0pt solid #aaaaaa"
			height="14.8cm" padding="0mm">
			<fo:block font-size="5pt" text-align="center" space-before="2mm"  margin-bottom="2mm">
				</fo:block>
				</fo:table-cell>
			</fo:table-row>
	</xsl:template>

	<xsl:template match="categories">
		<fo:block>
			<fo:table table-layout="fixed" width="100%">
				<fo:table-column column-width="10.5cm" />
				<fo:table-body>
					<fo:table-row height="80px">
						<fo:table-cell height="80px">
							<xsl:for-each select="category">
								<fo:block font-size="10pt" text-align="center"
									font-weight="bold">
									<xsl:value-of select="." />
								</fo:block>
							</xsl:for-each>
						</fo:table-cell>
					</fo:table-row>
				</fo:table-body>
			</fo:table>
		</fo:block>
	</xsl:template>

</xsl:stylesheet>
