<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.1"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format"
	exclude-result-prefixes="fo">
	<xsl:output method="xml" version="1.0" omit-xml-declaration="no"
		indent="yes" />

	<xsl:param name="licencse" select="''" />
	<xsl:param name="date" select="''" />

	<!-- ========================= -->
	<!-- root element: projectteam -->
	<!-- ========================= -->
	<xsl:template match="Filereport">
		<fo:root xmlns:fo="http://www.w3.org/1999/XSL/Format"
			font-family="Arial">
			<fo:layout-master-set>
				<fo:simple-page-master master-name="simpleA4"
					page-height="14.8cm" page-width="10.5cm" margin-top="0mm"
					margin-bottom="0mm" margin-left="5mm" margin-right="5mm">
					<fo:region-body margin-top="0cm" margin-bottom="0cm" />
				</fo:simple-page-master>
			</fo:layout-master-set>
			<fo:page-sequence master-reference="simpleA4"
				language="de">
				<fo:flow flow-name="xsl-region-body">
					<fo:block font-size="8pt">
						<fo:table table-layout="fixed" width="100%">
							<fo:table-column column-width="9.5cm" />
							<fo:table-body>
								<xsl:apply-templates />
							</fo:table-body>
						</fo:table>
					</fo:block>
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>

	<xsl:template match="row">
		<xsl:apply-templates select="person" />
	</xsl:template>

	<xsl:template match="person">
		<fo:table-row height="14.2cm">
			<fo:table-cell border-style="dotted" height="13.8cm"
				width="9.5cm" border="0pt #aaaaaa" padding="3mm" text-align="center">

				<fo:block text-align="center" space-before="2mm"
					space-after="2mm">
					<fo:table table-layout="fixed" width="100%">
						<fo:table-column column-width="9cm" />
						<fo:table-body>
							<fo:table-row height="7.0cm">
								<fo:table-cell height="7cm" text-align="center"
									display-align="center">
									<xsl:choose>
										<xsl:when test="string(competitornumber)">
											<fo:block font-size="150pt" font-weight="bold">
												<xsl:value-of select="competitornumber" />
											</fo:block>
										</xsl:when>
										<xsl:otherwise>
											<fo:block font-weight="bold" font-size="25pt">
												<xsl:value-of select="name" />
											</fo:block>
										</xsl:otherwise>
									</xsl:choose>
								</fo:table-cell>
							</fo:table-row>
						</fo:table-body>
					</fo:table>
				</fo:block>


				<fo:block font-size="18pt" space-before="2mm" space-after="2mm">
					<fo:table table-layout="fixed" width="100%">
						<fo:table-column column-width="9cm" />
						<fo:table-body>
							<fo:table-row height="4cm">
								<fo:table-cell height="2cm" text-align="left"
									display-align="center" border="0pt solid #000000">
									<fo:block font-size="20pt" font-weight="bold">
										<xsl:value-of select="name" />
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row height="2cm">
								<fo:table-cell height="2cm" text-align="right"
									display-align="center" border="0pt solid #000000">
									<fo:block font-size="70pt" font-weight="bold">
										<xsl:value-of select="natid" />
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
						</fo:table-body>
					</fo:table>
				</fo:block>

			</fo:table-cell>
		</fo:table-row>
	</xsl:template>

</xsl:stylesheet>
