<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" exclude-result-prefixes="fo">
  <xsl:output method="xml" version="1.0" omit-xml-declaration="no" indent="yes"/>
  
  <xsl:param name="licencse" select="''"/> 
  <xsl:param name="date" select="''"/>
  <xsl:param name="dateShort" select="''"/>
  
  <!-- ========================= -->
  <!-- root element: projectteam -->
  <!-- ========================= -->
  <xsl:template match="Filereport">
    <fo:root xmlns:fo="http://www.w3.org/1999/XSL/Format" font-family="Arial">     
      <fo:layout-master-set>
       <fo:simple-page-master master-name="simpleA4" page-height="29.7cm" page-width="21cm" margin-top="0mm" margin-bottom="0mm" margin-left="0mm" margin-right="0mm">
          <fo:region-body margin-top="0cm" margin-bottom="0cm" 
          background-repeat="no-repeat" 
          background-position-horizontal="center" 
          background-position-vertical="center">
		    <xsl:choose>
          <xsl:when test="string(@bgimage)">
            <xsl:attribute name="background-image">
              <xsl:value-of select="@bgimage" />
            </xsl:attribute>
          </xsl:when>
          </xsl:choose>
         </fo:region-body> 
        </fo:simple-page-master>
      </fo:layout-master-set>
      <fo:page-sequence master-reference="simpleA4" language="de">
        <fo:flow flow-name="xsl-region-body">
          <fo:block font-size="8pt">
              
              <fo:table table-layout="fixed" width="100%" >
	            <fo:table-column column-width="29.7cm"/>
              <fo:table-body>
              <xsl:apply-templates />
              </fo:table-body>
              
            </fo:table>
          </fo:block>
        </fo:flow>
     </fo:page-sequence>   
    </fo:root>
  </xsl:template>
  
  <xsl:template match="row">
    
  	 <xsl:apply-templates select="person"/>
  	
  </xsl:template>
  
  <xsl:template match="person">
        <fo:table-row height="21cm">
  			<fo:table-cell border-style="none" height="21cm" width="18cm" border="0.5pt #aaaaaa" padding="3mm" text-align="center">
  			
  			  <fo:block font-size="10pt" text-align="center" space-before="10mm" space-after="2mm">
          		
          </fo:block>
         
  				<fo:block text-align="center" space-before="2mm" space-after="2mm" margin-left="10mm" margin-right="10mm">
  				  <fo:table table-layout="fixed" width="100%" >
              <fo:table-column column-width="18cm"/>
              <fo:table-body>
                <fo:table-row height="10.5cm">
                    <fo:table-cell height="2cm" text-align="center" display-align="after" >
  	                 <fo:block font-weight="bold"  font-size="20pt">
    				               <xsl:value-of select="event" />
    			           </fo:block>	
  	              </fo:table-cell>
                </fo:table-row>
              </fo:table-body>
            </fo:table>
          </fo:block>
  				
    			<fo:block text-align="center" space-before="20mm" space-after="2mm" margin-left="5mm" margin-right="5mm">
  			<fo:table table-layout="fixed" width="100%">
              <fo:table-column column-width="18cm"/>
              <fo:table-body>
                <fo:table-row height="1cm">
                    <fo:table-cell height="1cm" text-align="center" display-align="center">
    			           <fo:block font-weight="bold" font-size="16pt">
    				             <xsl:choose>
                          <xsl:when test="string(name)">
                            <xsl:value-of select="name" /> 
                          </xsl:when>
                          </xsl:choose> 
    			           </fo:block>
  	              </fo:table-cell>
                </fo:table-row>
				
				
               
                <fo:table-row height="1.5cm">
                    <fo:table-cell height="1cm" text-align="left" display-align="center" >
                       <fo:block width="20cm" font-weight="bold" font-size="15pt" space-before="12mm" margin-left="85mm">
    				               <xsl:value-of select="category" /> 
    			           </fo:block>
  	              </fo:table-cell>
                </fo:table-row>
				
				<fo:table-row height="0.5cm" >
                    <fo:table-cell height="0.5cm" text-align="center" display-align="center" >
                       <fo:block width="27cm" font-weight="bold" font-size="12pt" font-style="italic" space-before="10mm">
    				              
    			           </fo:block>
  	              </fo:table-cell>
                </fo:table-row>
				
				<fo:table-row height="0.5cm" >
                    <fo:table-cell height="0.5cm" text-align="center" display-align="center" >
                       <fo:block width="27cm" font-weight="bold" font-size="12pt" font-style="italic" space-before="10mm">
    				              
    			           </fo:block>
  	              </fo:table-cell>
                </fo:table-row>
				
				<fo:table-row height="1cm" >
                    <fo:table-cell height="1cm" text-align="left" display-align="center" space-before="30mm">
                       <fo:block width="20cm" font-weight="bold" font-size="18pt"  margin-left="75mm">
    				               <xsl:value-of select="Place" />.
    			           </fo:block>
  	              </fo:table-cell>
                </fo:table-row>
				
              </fo:table-body>
            </fo:table>
          </fo:block>
		  
		  <fo:block text-align="center" space-before="40mm" space-after="2mm" margin-left="10mm" margin-right="10mm">
  				  <fo:table table-layout="fixed" width="100%" >
              <fo:table-column column-width="9cm"/>
              <fo:table-column column-width="9cm"/>
              <fo:table-body>
                <fo:table-row height="3cm">
  	            <fo:table-cell  text-align="left" display-align="after">
  	                <fo:block  font-weight="bold" font-size="14pt" margin-left="10mm">
  	                   <xsl:value-of select="$dateShort" /> 
    			          </fo:block>
    			         
    			      </fo:table-cell> 
    			      <fo:table-cell  text-align="left" display-align="after" margin-left="40mm">
  	                <fo:block  font-weight="bold" font-size="14pt">
  	                 <xsl:value-of select="organizer" />
    			          </fo:block>
    			          
    			      </fo:table-cell>
              </fo:table-row>
              </fo:table-body>
            </fo:table>
          </fo:block>
         
          
       </fo:table-cell>
       </fo:table-row>   
   </xsl:template>       

</xsl:stylesheet>
