<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.1"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format"
	exclude-result-prefixes="fo">
	<xsl:output method="xml" version="1.0" omit-xml-declaration="no"
		indent="yes" />

	<xsl:param name="licencse" select="''" />
	<xsl:param name="date" select="''" />

	<!-- ========================= -->
	<!-- root element: projectteam -->
	<!-- ========================= -->
	<xsl:template match="Filereport">
		<fo:root xmlns:fo="http://www.w3.org/1999/XSL/Format"
			font-family="Arial">

			<fo:layout-master-set>
				<fo:simple-page-master master-name="simpleA4"
					page-height="21cm" page-width="29.7cm" margin-top="2cm"
					margin-bottom="2cm" margin-left="2cm" margin-right="2cm">
					<fo:region-body margin-top="1.5cm" margin-bottom="1.5cm" />
					<fo:region-before extent="1.0cm" />
					<fo:region-after extent="1.0cm" />
				</fo:simple-page-master>
			</fo:layout-master-set>
			<fo:page-sequence master-reference="simpleA4"
				language="de">

				<fo:static-content flow-name="xsl-region-before"
	display-align="before">
	<fo:block font-size="16pt" font-weight="bold" space-before="1mm"
		keep-together="always" text-align="center">
		<fo:external-graphic height="1cm" width="3cm"
			content-height="scale-to-fit" content-width="scale-to-fit" scaling="uniform">
			<xsl:attribute name="src">
        	<xsl:value-of select="'templates/matchlist/oersv_logo.gif'" />
    	</xsl:attribute>
		</fo:external-graphic>
		<xsl:text> </xsl:text>
		Österreichischer Ringsportverband - Punktezettel
	</fo:block>
	<fo:block font-size="12pt" font-weight="bold" space-before="0mm"
		keep-together="always" text-align="center">
		<xsl:value-of select="@event" /> - <xsl:value-of select="@date" />
	</fo:block>

				</fo:static-content>

				<fo:static-content flow-name="xsl-region-after">
					<fo:block font-size="8pt" text-align="center">
						<xsl:value-of select="$licencse" />
					</fo:block>
					<fo:block font-size="8pt" text-align="right">
						<fo:page-number />
						/
						<fo:page-number-citation ref-id="theEnd" />
					</fo:block>
				</fo:static-content>

				<fo:flow flow-name="xsl-region-body">
					<xsl:apply-templates select="category" />
					<fo:block id="theEnd" />
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>

	<xsl:template match="category">
		<xsl:apply-templates select="match" />
	</xsl:template>

	<xsl:template match="match">
	<!-- match head -->
	
		<!-- six boxes -->
		<fo:block font-size="9pt" space-before="5mm" keep-together="always"
			text-align="center">

			<fo:table table-layout="fixed" width="100%" border="0pt solid #aaaaaa"
				text-align="center" padding="3mm" border-collapse="separate"
				border-separation="5mm">
				<fo:table-column column-width="4cm" />
				<fo:table-column column-width="4cm" />
				<fo:table-column column-width="4cm" />
				<fo:table-column column-width="4cm" />
				<fo:table-column column-width="4cm" />
				<fo:table-column column-width="4cm" />
				<fo:table-body>
					<fo:table-row>
						<fo:table-cell border="1pt solid #aaaaaa" padding="2mm" number-columns-spanned="3">
							<fo:block text-align="center" font-weight="bold">
								Gewicht / Gruppe / Stilart
					</fo:block>
							<fo:block text-align="center" font-weight="bold"
								border-top="1pt solid #aaaaaa">
								<xsl:value-of select="../@name" />
					</fo:block>
						</fo:table-cell>
						<fo:table-cell border="1pt solid #aaaaaa" padding="2mm">
							<fo:block text-align="center" font-weight="bold">
								Matte
					</fo:block>
							<fo:block text-align="center" font-weight="bold"
								border-top="1pt solid #aaaaaa">
								<xsl:value-of select="tatami" />
							</fo:block>
						</fo:table-cell>
						<fo:table-cell border="1pt solid #aaaaaa" padding="2mm">
							<fo:block text-align="center" font-weight="bold">
								Runde
					</fo:block>
							<fo:block color="white" text-align="center" font-weight="bold"
								border-top="1pt solid #aaaaaa">
								H
					</fo:block>
						</fo:table-cell>
						<fo:table-cell border="1pt solid #aaaaaa" padding="2mm">
							<fo:block text-align="center" font-size="8pt"
								font-weight="bold">
								Datum 
					</fo:block>
							<fo:block text-align="center" font-weight="bold"
								border-top="1pt solid #aaaaaa">
								<xsl:value-of select="@date" />
							</fo:block>
						</fo:table-cell>
					</fo:table-row>
<!-- name boxes -->
					<fo:table-row height="2.4cm">
						<fo:table-cell border="3pt solid red" padding="0mm">
							<xsl:attribute name="number-columns-spanned">                
           				3                  
         			</xsl:attribute>
							<xsl:variable name="nameclubnat" select="name" />
							<xsl:variable name="nameonly"
								select="substring-before($nameclubnat, ' (')" />
							<xsl:variable name="restofstring"
								select="substring-after($nameclubnat, '(')" />
							<xsl:variable name="clubnat"
								select="substring-before($restofstring, ')')" />

							<fo:table table-layout="fixed" width="100%" height="100%"
								border="0pt solid red" text-align="center" padding="0mm"
								border-collapse="separate" border-separation="0mm">
								<fo:table-column column-width="3cm" />
								<fo:table-column column-width="8cm" />
								<fo:table-body>
									<fo:table-row height="2.4cm">
										<fo:table-cell border="8pt solid red"
											padding="0mm">
											<fo:block text-align="center" font-weight="bold"
												font-size="6pt">
												<xsl:text>ROUGE  RED  ROT</xsl:text>
											</fo:block>
										</fo:table-cell>

										<fo:table-cell border="0pt solid red"
											padding="0mm" display-align="center">
											
											<fo:table table-layout="fixed" width="100%" height="100%"
								border="0pt solid red" text-align="center" padding="0mm"
								border-collapse="separate" border-separation="0mm">
								<fo:table-column column-width="8.3cm" />
								<fo:table-body>
									<fo:table-row height="1.2cm">
											<fo:table-cell border-bottom="1pt solid red"
											padding="0mm" display-align="center">
           									<fo:block text-align="center" font-weight="bold"
												font-size="12pt" >
												<xsl:value-of select="$nameonly" />
											</fo:block>						
         									</fo:table-cell>
         									</fo:table-row>
         									<fo:table-row height="1.2cm">
											<fo:table-cell border="0pt solid red" padding="0mm" display-align="center">
											<fo:block text-align="center" font-weight="bold"
												 font-size="12pt">
												<xsl:value-of select="$clubnat" />
												
											</fo:block>
											</fo:table-cell>
									</fo:table-row>
								</fo:table-body>
							</fo:table>
										</fo:table-cell>
									</fo:table-row>
								</fo:table-body>
							</fo:table>
						</fo:table-cell>
						<fo:table-cell border="3pt solid blue" padding="0mm">
							<xsl:attribute name="number-columns-spanned">                
           				3                  
         			</xsl:attribute>
							<xsl:variable name="nameclubnat2" select="name2" />
							<xsl:variable name="nameonly2"
								select="substring-before($nameclubnat2, ' (')" />
							<xsl:variable name="restofstring2"
								select="substring-after($nameclubnat2, '(')" />
							<xsl:variable name="clubnat2"
								select="substring-before($restofstring2, ')')" />

							<fo:table table-layout="fixed" width="100%" height="100%"
								border="0pt solid blue" text-align="center" padding="0mm"
								border-collapse="separate" border-separation="0mm">
								<fo:table-column column-width="3cm" />
								<fo:table-column column-width="8cm" />
								<fo:table-body>
									<fo:table-row height="2.4cm">
										<fo:table-cell border="8pt solid blue"
											padding="0mm">
											<fo:block text-align="center" font-weight="bold"
												font-size="6pt">
												<xsl:text>BLEU  BLUE  BLAU</xsl:text>
											</fo:block>
										</fo:table-cell>

										<fo:table-cell border="0pt solid blue"
											padding="0mm" display-align="center">
											
											<fo:table table-layout="fixed" width="100%" height="100%"
								border="0pt solid blue" text-align="center" padding="0mm"
								border-collapse="separate" border-separation="0mm">
								<fo:table-column column-width="8.3cm" />
								<fo:table-body>
									<fo:table-row height="1.2cm">
											<fo:table-cell border-bottom="1pt solid blue"
											padding="0mm" display-align="center">
           									<fo:block text-align="center" font-weight="bold"
												font-size="12pt" >
												<xsl:value-of select="$nameonly2" />
											</fo:block>						
         									</fo:table-cell>
         									</fo:table-row>
         									<fo:table-row height="1.2cm">
											<fo:table-cell border="0pt solid blue" padding="0mm" display-align="center">
											<fo:block text-align="center" font-weight="bold"
												 font-size="12pt">
												<xsl:value-of select="$clubnat2" />
												
											</fo:block>
											</fo:table-cell>
									</fo:table-row>
								</fo:table-body>
							</fo:table>
										</fo:table-cell>
									</fo:table-row>
								</fo:table-body>
							</fo:table>
						</fo:table-cell>
					</fo:table-row>
					<!-- rows for rounds -->
					<fo:table-row>
					<!-- rows for rounds red -->
						<fo:table-cell border="0pt solid red" padding="0mm">
							<xsl:attribute name="number-columns-spanned">                
           					3                  
         				</xsl:attribute>
         				<fo:table table-layout="fixed" width="100%" height="100%"
								border="1pt solid red" text-align="center" padding="0mm"
								border-collapse="separate" border-separation="0mm">
								<fo:table-column column-width="1cm" />
								<fo:table-column column-width="7cm" />
								<fo:table-column column-width="2cm" />
								<fo:table-column column-width="1.5cm" />
								<fo:table-body>
									<fo:table-row height="1cm">
										<fo:table-cell border-right="1pt solid red"
											padding="0mm" display-align="center">
											<fo:block text-align="center" font-weight="bold"
												font-size="12pt" >
												R1
											</fo:block>		
										</fo:table-cell>
										<fo:table-cell border-right="1pt solid red"
											padding="0mm">
											<fo:block text-align="center" font-weight="bold"
												font-size="12pt" >
												<xsl:text> </xsl:text>
											</fo:block>		
										</fo:table-cell>
										<fo:table-cell border-right="1pt solid red"
											padding="0mm">
											<fo:block text-align="center" font-weight="bold"
												font-size="12pt" >
												<xsl:text> </xsl:text>
											</fo:block>		
										</fo:table-cell>
										<fo:table-cell border="0pt solid red"
											padding="0mm">
											<fo:block text-align="center" font-weight="bold"
												font-size="12pt" >
												<xsl:text> </xsl:text>
											</fo:block>		
										</fo:table-cell>
									</fo:table-row>
									<fo:table-row height="1cm">
										<fo:table-cell border-right="1pt solid red" border-top="1pt solid red"
											padding="0mm" display-align="center">
											<fo:block text-align="center" font-weight="bold"
												font-size="12pt" >
												R2
											</fo:block>		
										</fo:table-cell>
										<fo:table-cell border-right="1pt solid red" border-top="1pt solid red"
											padding="0mm">
											<fo:block text-align="center" font-weight="bold"
												font-size="12pt" >
												<xsl:text> </xsl:text>
											</fo:block>		
										</fo:table-cell>
										<fo:table-cell border-right="1pt solid red" border-top="1pt solid red"
											padding="0mm">
											<fo:block text-align="center" font-weight="bold"
												font-size="12pt" >
												<xsl:text> </xsl:text>
											</fo:block>		
										</fo:table-cell>
										<fo:table-cell border="0pt solid red" border-top="1pt solid red"
											padding="0mm">
											<fo:block text-align="center" font-weight="bold"
												font-size="12pt" >
												<xsl:text> </xsl:text>
											</fo:block>		
										</fo:table-cell>
									</fo:table-row>
									<fo:table-row height="1cm">
										<fo:table-cell border-right="1pt solid red" border-top="1pt solid red"
											padding="0mm" display-align="center">
											<fo:block text-align="center" font-weight="bold"
												font-size="12pt" >
												R3
											</fo:block>		
										</fo:table-cell>
										<fo:table-cell border-right="1pt solid red" border-top="1pt solid red"
											padding="0mm">
											<fo:block text-align="center" font-weight="bold"
												font-size="12pt" >
												<xsl:text> </xsl:text>
											</fo:block>		
										</fo:table-cell>
										<fo:table-cell border-right="1pt solid red" border-top="1pt solid red"
											padding="0mm"> 
											<fo:block text-align="center" font-weight="bold"
												font-size="12pt" >
												<xsl:text> </xsl:text>
											</fo:block>		
										</fo:table-cell>
										<fo:table-cell border="0pt solid red" border-top="1pt solid red"
											padding="0mm">
											<fo:block text-align="center" font-weight="bold"
												font-size="12pt" >
												<xsl:text> </xsl:text>
											</fo:block>		
										</fo:table-cell>
									</fo:table-row>
									<!-- technikpunkte rot -->
									<fo:table-row height="1cm">
										<fo:table-cell border-right="1pt solid red" border-top="1pt solid red"
											padding="0mm" display-align="center" margin-right="8pt">
											<xsl:attribute name="number-columns-spanned">                
           									2                  
         									</xsl:attribute>
											<fo:block text-align="right" font-weight="bold"
												font-size="12pt" >
												<xsl:text>Technikpunkte</xsl:text>
											</fo:block>		
										</fo:table-cell>
										<fo:table-cell border-right="1pt solid red" border-top="1pt solid red"
											padding="0mm">
											<fo:block text-align="center" font-weight="bold"
												font-size="12pt" >
												<xsl:text> </xsl:text>
											</fo:block>		
										</fo:table-cell>
										<fo:table-cell  border-top="1pt solid red"
											padding="0mm">
											<fo:block text-align="center" font-weight="bold"
												font-size="12pt" >
												<xsl:text> </xsl:text>
											</fo:block>		
										</fo:table-cell>
									</fo:table-row>
									<!-- klassifikationspunkte rot -->
									<fo:table-row height="1cm">
										<fo:table-cell border-right="1pt solid red" border-top="1pt solid red"
											padding="0mm" display-align="center" margin-right="8pt">
											<xsl:attribute name="number-columns-spanned">                
           									2                  
         									</xsl:attribute>
											<fo:block text-align="right" font-weight="bold"
												font-size="12pt" >
												<xsl:text>Klassifikationspunkte</xsl:text>
											</fo:block>		
										</fo:table-cell>
										<fo:table-cell  border-top="1pt solid red"
											padding="0mm">
											<xsl:attribute name="number-columns-spanned">                
           									2                  
         									</xsl:attribute>
											<fo:block text-align="center" font-weight="bold"
												font-size="12pt" >
												<xsl:text> </xsl:text>
											</fo:block>		
										</fo:table-cell>
									</fo:table-row>
								</fo:table-body>
							</fo:table>
							</fo:table-cell>
							<!-- rows for rounds blue -->
						<fo:table-cell border="0pt solid blue" padding="0mm">
							<xsl:attribute name="number-columns-spanned">                
           					3                  
         				</xsl:attribute>
         				<fo:table table-layout="fixed" width="100%" height="100%"
								border="1pt solid blue" text-align="center" padding="0mm"
								border-collapse="separate" border-separation="0mm">
								<fo:table-column column-width="1cm" />
								<fo:table-column column-width="7cm" />
								<fo:table-column column-width="2cm" />
								<fo:table-column column-width="1.5cm" />
								<fo:table-body>
									<fo:table-row height="1cm">
										<fo:table-cell border-right="1pt solid blue"
											padding="0mm" display-align="center">
											<fo:block text-align="center" font-weight="bold"
												font-size="12pt" >
												R1
											</fo:block>		
										</fo:table-cell>
										<fo:table-cell border-right="1pt solid blue"
											padding="0mm">
											<fo:block text-align="center" font-weight="bold"
												font-size="12pt" >
												<xsl:text> </xsl:text>
											</fo:block>		
										</fo:table-cell>
										<fo:table-cell border-right="1pt solid blue"
											padding="0mm">
											<fo:block text-align="center" font-weight="bold"
												font-size="12pt" >
												<xsl:text> </xsl:text>
											</fo:block>		
										</fo:table-cell>
										<fo:table-cell border="0pt solid blue"
											padding="0mm">
											<fo:block text-align="center" font-weight="bold"
												font-size="12pt" >
												<xsl:text> </xsl:text>
											</fo:block>		
										</fo:table-cell>
									</fo:table-row>
									<fo:table-row height="1cm">
										<fo:table-cell border-right="1pt solid blue" border-top="1pt solid blue"
											padding="0mm" display-align="center">
											<fo:block text-align="center" font-weight="bold"
												font-size="12pt" >
												R2
											</fo:block>		
										</fo:table-cell>
										<fo:table-cell border-right="1pt solid blue" border-top="1pt solid blue"
											padding="0mm">
											<fo:block text-align="center" font-weight="bold"
												font-size="12pt" >
												<xsl:text> </xsl:text>
											</fo:block>		
										</fo:table-cell>
										<fo:table-cell border-right="1pt solid blue" border-top="1pt solid blue"
											padding="0mm">
											<fo:block text-align="center" font-weight="bold"
												font-size="12pt" >
												<xsl:text> </xsl:text>
											</fo:block>		
										</fo:table-cell>
										<fo:table-cell border="0pt solid blue" border-top="1pt solid blue"
											padding="0mm">
											<fo:block text-align="center" font-weight="bold"
												font-size="12pt" >
												<xsl:text> </xsl:text>
											</fo:block>		
										</fo:table-cell>
									</fo:table-row>
									<fo:table-row height="1cm">
										<fo:table-cell border-right="1pt solid blue" border-top="1pt solid blue"
											padding="0mm" display-align="center">
											<fo:block text-align="center" font-weight="bold"
												font-size="12pt" >
												R3
											</fo:block>		
										</fo:table-cell>
										<fo:table-cell border-right="1pt solid blue" border-top="1pt solid blue"
											padding="0mm">
											<fo:block text-align="center" font-weight="bold"
												font-size="12pt" >
												<xsl:text> </xsl:text>
											</fo:block>		
										</fo:table-cell>
										<fo:table-cell border-right="1pt solid blue" border-top="1pt solid blue"
											padding="0mm"> 
											<fo:block text-align="center" font-weight="bold"
												font-size="12pt" >
												<xsl:text> </xsl:text>
											</fo:block>		
										</fo:table-cell>
										<fo:table-cell border="0pt solid blue" border-top="1pt solid blue"
											padding="0mm">
											<fo:block text-align="center" font-weight="bold"
												font-size="12pt" >
												<xsl:text> </xsl:text>
											</fo:block>		
										</fo:table-cell>
									</fo:table-row>
									<!-- technikpunkte blue -->
									<fo:table-row height="1cm">
										<fo:table-cell border-right="1pt solid blue" border-top="1pt solid blue"
											padding="0mm" display-align="center" margin-right="8pt">
											<xsl:attribute name="number-columns-spanned">                
           									2                  
         									</xsl:attribute>
											<fo:block text-align="right" font-weight="bold"
												font-size="12pt" >
												<xsl:text>Technikpunkte</xsl:text>
											</fo:block>		
										</fo:table-cell>
										<fo:table-cell border-right="1pt solid blue" border-top="1pt solid blue"
											padding="0mm">
											<fo:block text-align="center" font-weight="bold"
												font-size="12pt" >
												<xsl:text> </xsl:text>
											</fo:block>		
										</fo:table-cell>
										<fo:table-cell  border-top="1pt solid blue"
											padding="0mm">
											<fo:block text-align="center" font-weight="bold"
												font-size="12pt" >
												<xsl:text> </xsl:text>
											</fo:block>		
										</fo:table-cell>
									</fo:table-row>
									<!-- klassifikationspunkte blue -->
									<fo:table-row height="1cm">
										<fo:table-cell border-right="1pt solid blue" border-top="1pt solid blue"
											padding="0mm" display-align="center" margin-right="8pt">
											<xsl:attribute name="number-columns-spanned">                
           									2                  
         									</xsl:attribute>
											<fo:block text-align="right" font-weight="bold"
												font-size="12pt" >
												<xsl:text>Klassifikationspunkte</xsl:text>
											</fo:block>		
										</fo:table-cell>
										<fo:table-cell  border-top="1pt solid blue"
											padding="0mm">
											<xsl:attribute name="number-columns-spanned">                
           									2                  
         									</xsl:attribute>
											<fo:block text-align="center" font-weight="bold"
												font-size="12pt" >
												<xsl:text> </xsl:text>
											</fo:block>		
										</fo:table-cell>
									</fo:table-row>
								</fo:table-body>
							</fo:table>
							</fo:table-cell>
					</fo:table-row>
					
					<!-- bottom line -->
					
					<fo:table-row>
						<fo:table-cell border="1pt solid #aaaaaa" padding="2mm">
							<fo:block text-align="center" font-weight="bold">
								Zeit / Time
					</fo:block>
							<fo:block color="white" text-align="center" font-weight="bold"
								border-top="1pt solid #aaaaaa">
								H
					</fo:block>
						</fo:table-cell>
						<fo:table-cell border="1pt solid #aaaaaa" padding="0mm">
						<xsl:attribute name="number-columns-spanned">                
           				2                  
         				</xsl:attribute>
							<fo:table table-layout="fixed" width="100%" height="100%"
								border="0pt solid #aaaaaa" text-align="center" padding="0mm"
								border-collapse="separate" border-separation="0mm">
								<fo:table-column column-width="1.3cm" />
								<fo:table-column column-width="1.2cm" />
								<fo:table-column column-width="1.2cm" />
								<fo:table-column column-width="1.2cm" />
								<fo:table-column column-width="1.2cm" />
								<fo:table-column column-width="1.3cm" />
								<fo:table-body>
									<fo:table-row>
										<fo:table-cell border-right="1pt solid #aaaaaa"
											padding="0mm" display-align="center">
											<fo:block text-align="center" font-weight="bold">
												SS
											</fo:block>	
											<fo:block text-align="center" font-weight="bold">
												5:0
											</fo:block>		
										</fo:table-cell>
										<fo:table-cell border-right="1pt solid #aaaaaa"
											padding="0mm" display-align="center">
											<fo:block text-align="center" font-weight="bold">
												TP
											</fo:block>	
											<fo:block text-align="center" font-weight="bold">
												4:0/1
											</fo:block>		
										</fo:table-cell>
										<fo:table-cell border-right="1pt solid #aaaaaa"
											padding="0mm" display-align="center">
											<fo:block text-align="center" font-weight="bold">
												PS
											</fo:block>	
											<fo:block text-align="center" font-weight="bold">
												3:0/1
											</fo:block>		
										</fo:table-cell>
										<fo:table-cell border-right="1pt solid #aaaaaa"
											padding="0mm" display-align="center">
											<fo:block text-align="center" font-weight="bold">
												AG
											</fo:block>	
											<fo:block text-align="center" font-weight="bold">
												5:0
											</fo:block>		
										</fo:table-cell>
										<fo:table-cell border-right="1pt solid #aaaaaa"
											padding="0mm" display-align="center">
											<fo:block text-align="center" font-weight="bold">
												3V
											</fo:block>	
											<fo:block text-align="center" font-weight="bold">
												5:0
											</fo:block>		
										</fo:table-cell>
										<fo:table-cell border-right="0pt solid #aaaaaa"
											padding="0mm" display-align="center">
											<fo:block text-align="center" font-weight="bold">
												DIS
											</fo:block>	
											<fo:block text-align="center" font-weight="bold">
												5:0
											</fo:block>		
										</fo:table-cell>
									</fo:table-row>
									<fo:table-row>
										<fo:table-cell border-top="1pt solid #aaaaaa" border-right="1pt solid #aaaaaa"
											padding="0mm" display-align="center">
											<fo:block color="white" text-align="center" font-weight="bold">
												SS
											</fo:block>	
											<fo:block color="white" text-align="center" font-weight="bold">
												5:0
											</fo:block>		
										</fo:table-cell>
										<fo:table-cell border-top="1pt solid #aaaaaa" border-right="1pt solid #aaaaaa"
											padding="0mm" display-align="center">
											<fo:block color="white" text-align="center" font-weight="bold">
												SS
											</fo:block>	
											<fo:block color="white" text-align="center" font-weight="bold">
												5:0
											</fo:block>		
										</fo:table-cell>
										<fo:table-cell border-top="1pt solid #aaaaaa" border-right="1pt solid #aaaaaa"
											padding="0mm" display-align="center">
											<fo:block color="white" text-align="center" font-weight="bold">
												SS
											</fo:block>	
											<fo:block color="white" text-align="center" font-weight="bold">
												5:0
											</fo:block>		
										</fo:table-cell>
										<fo:table-cell border-top="1pt solid #aaaaaa" border-right="1pt solid #aaaaaa"
											padding="0mm" display-align="center">
											<fo:block color="white" text-align="center" font-weight="bold">
												SS
											</fo:block>	
											<fo:block color="white" text-align="center" font-weight="bold">
												5:0
											</fo:block>		
										</fo:table-cell>
										<fo:table-cell border-top="1pt solid #aaaaaa" border-right="1pt solid #aaaaaa"
											padding="0mm" display-align="center">
											<fo:block color="white" text-align="center" font-weight="bold">
												SS
											</fo:block>	
											<fo:block color="white" text-align="center" font-weight="bold">
												5:0
											</fo:block>		
										</fo:table-cell>
										<fo:table-cell border-top="1pt solid #aaaaaa" 
											padding="0mm" display-align="center">
											<fo:block color="white" text-align="center" font-weight="bold">
												SS
											</fo:block>	
											<fo:block color="white" text-align="center" font-weight="bold">
												5:0
											</fo:block>		
										</fo:table-cell>
									</fo:table-row>
								</fo:table-body>
							</fo:table>
						</fo:table-cell>
						<fo:table-cell border="1pt solid #aaaaaa" padding="2mm">
						<xsl:attribute name="number-columns-spanned">                
           				2                  
         				</xsl:attribute>
							<fo:block text-align="center" font-weight="bold">
								Sieger / Winner
					</fo:block>
							<fo:block color="white" text-align="center" font-weight="bold"
								border-top="1pt solid #aaaaaa">
								H
					</fo:block>
						</fo:table-cell>
						<fo:table-cell border="1pt solid #aaaaaa" padding="2mm">
							<fo:block text-align="center" font-weight="bold">
								Kampfrichter
					</fo:block>
							<fo:block color="white" text-align="center" font-weight="bold"
								border-top="1pt solid #aaaaaa">
								H
					</fo:block>
						</fo:table-cell>
					</fo:table-row>
				</fo:table-body>
			</fo:table>

		</fo:block>
	</xsl:template>

</xsl:stylesheet>
