<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.1"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format"
	exclude-result-prefixes="fo">
	<xsl:output method="xml" version="1.0" omit-xml-declaration="no"
		indent="yes" />

	<xsl:param name="licencse" select="''" />
	<xsl:param name="date" select="''" />

	<!-- ========================= -->
	<!-- Bitte hier den Pfad -->
	<!-- zum Hintergrundbild eintragen -->
	<!-- ========================= -->
	<xsl:param name="bgimage" select="'templates/results/1.jpg'" />

	<!-- ========================= -->
	<!-- root element -->
	<!-- ========================= -->
	<xsl:template match="List_of_results">
		<fo:root xmlns:fo="http://www.w3.org/1999/XSL/Format"
			font-family="Arial">

			<fo:layout-master-set>
				<fo:simple-page-master master-name="simpleA4"
					page-height="29.7cm" page-width="21cm" margin-top="2cm"
					margin-bottom="2cm" margin-left="2cm" margin-right="2cm">
					<fo:region-body margin-top="1.5cm" margin-bottom="1.5cm" />
					<fo:region-before extent="1.0cm" />
					<fo:region-after extent="1.0cm" />
				</fo:simple-page-master>
			</fo:layout-master-set>
			<fo:page-sequence master-reference="simpleA4">

				<fo:static-content flow-name="xsl-region-before"
					display-align="before">
					<fo:block-container absolute-position="absolute"
						top="-2cm" left="-2cm" width="21cm" height="29.7cm">
						<xsl:choose>
							<xsl:when test="string($bgimage)">
								<xsl:attribute name="background-image">
              <xsl:value-of select="$bgimage" />
            </xsl:attribute>
							</xsl:when>
						</xsl:choose>
						<fo:block />
					</fo:block-container>
					<fo:block font-size="8pt" text-align="center">
						<xsl:value-of select="@title" />
						/
						<xsl:value-of select="@event" />
						-
						<xsl:value-of select="@date" />
					</fo:block>
				</fo:static-content>

				<fo:static-content flow-name="xsl-region-after">
					<fo:block font-size="8pt" text-align="center">
						<xsl:value-of select="$licencse" />

					</fo:block>
					<fo:block font-size="8pt" text-align="right">
						<fo:page-number />
						/
						<fo:page-number-citation ref-id="theEnd" />
					</fo:block>

				</fo:static-content>

				<fo:flow flow-name="xsl-region-body">
					<fo:block font-size="16pt" font-weight="bold" space-after="5mm"
						text-align="center" margin-left="1cm">
						<xsl:value-of select="@title" />
					</fo:block>
					<fo:block font-size="16pt" font-weight="bold" space-after="5mm"
						text-align="center" margin-left="1cm">
						<xsl:value-of select="@event" />
						-
						<xsl:value-of select="@date" />
					</fo:block>
					<fo:block font-size="7pt" space-after="5mm" margin-left="1cm">
						<xsl:value-of select="$date" />
					</fo:block>
					<fo:block font-size="8pt" margin-left="1cm">
						<fo:table table-layout="fixed" width="100%"
							border-collapse="separate">
							<fo:table-column column-width="0.5cm" />
							<fo:table-column column-width="6cm" />
							<fo:table-column column-width="5cm" />
							<fo:table-column column-width="1cm" />
							<fo:table-column column-width="1cm" />
							<fo:table-column column-width="4cm" />
							<fo:table-body>
								<xsl:apply-templates select="Results" />
							</fo:table-body>
						</fo:table>
					</fo:block>
					<fo:block id="theEnd" />
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>

	<xsl:template match="Results">
		<xsl:apply-templates select="Result" />
	</xsl:template>

	<xsl:template match="Result">
		<xsl:if test="Nextcat = 'true'">
			<fo:table-row>
				<fo:table-cell number-columns-spanned="4">
					<fo:block white-space-collapse="false" space-after="10mm"
						color="white">
						<xsl:text>  </xsl:text>
					</fo:block>
				</fo:table-cell>
			</fo:table-row>
			<fo:table-row keep-with-next="always">
				<fo:table-cell number-columns-spanned="4">
					<fo:block color="blue">
						<xsl:attribute name="font-weight">bold</xsl:attribute>
						<xsl:attribute name="font-style">italic</xsl:attribute>
						<xsl:attribute name="font-size">10pt</xsl:attribute>
						<xsl:value-of select="Category" />
					</fo:block>
				</fo:table-cell>
			</fo:table-row>
		</xsl:if>
		<fo:table-row >
			<fo:table-cell>
				<fo:block>
					<xsl:value-of select="Place" />
				</fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block >
					<xsl:value-of select="Name" />
				</fo:block>
				<xsl:if test="CategoryType = 't'">
					<xsl:if test="Teammembers/Teammember[1]">
         				<xsl:apply-templates select="Teammembers"/>
        			</xsl:if>
				</xsl:if>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block>
					<xsl:value-of select="Club" />
				</fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block>
					<xsl:value-of select="Federal_Association" />
				</fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block>
					<fo:external-graphic height="0.3cm" width="0.6cm"
						content-height="scale-to-fit" content-width="scale-to-fit"
						scaling="uniform">
						<xsl:attribute name="src">
                 <xsl:value-of select="Nation_Img" />
              </xsl:attribute>
					</fo:external-graphic>
				</fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block>
					<xsl:value-of select="Nation" />
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
	</xsl:template>

	<xsl:template match="Teammembers">
		<xsl:apply-templates select="Teammember" />
	</xsl:template>

	<xsl:template match="Teammember">
		<fo:block keep-with-next="always">
			-
			<xsl:value-of select="NameTeam" />
		</fo:block>
	</xsl:template>

</xsl:stylesheet>
