<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" exclude-result-prefixes="fo">
  <xsl:output method="xml" version="1.0" omit-xml-declaration="no" indent="yes"/>
  
  <xsl:param name="licencse" select="''"/> 
  <xsl:param name="date" select="''"/>
  
  <!-- ========================= -->
  <!-- root element: projectteam -->
  <!-- ========================= -->
  <xsl:template match="Filereport">
    <fo:root xmlns:fo="http://www.w3.org/1999/XSL/Format" font-family="Arial">
     
      <fo:layout-master-set>
        <fo:simple-page-master master-name="simpleA4" page-height="29.7cm" page-width="21cm" margin-top="2cm" margin-bottom="2cm" margin-left="2cm" margin-right="2cm">
          <fo:region-body margin-top="1.5cm" margin-bottom="1.5cm"/>
		      <fo:region-before extent="1.0cm"/>
          <fo:region-after extent="1.0cm"/>
        </fo:simple-page-master>
      </fo:layout-master-set>
      <fo:page-sequence master-reference="simpleA4" language="de">
      
      	<fo:static-content flow-name="xsl-region-before" display-align="before">
      	  <fo:block font-size="8pt" text-align="center">
            <xsl:value-of select="@name"/> / <xsl:value-of select="@event"/> - <xsl:value-of select="@date"/> / <xsl:value-of select="@name2"/>
          </fo:block>
   		</fo:static-content>
   		
  		<fo:static-content flow-name="xsl-region-after">
	          <fo:block font-size="7pt" text-align="center">
          		<xsl:value-of select="$licencse"/>
          	</fo:block>
          	<fo:block font-size="8pt" text-align="right">
          		<fo:page-number/> / <fo:page-number-citation  ref-id="theEnd" />
          	</fo:block>
   		</fo:static-content>
        
        <fo:flow flow-name="xsl-region-body">
          <fo:block font-size="16pt" font-weight="bold" space-after="5mm" text-align="center">
            <xsl:value-of select="@name"/>
          </fo:block>
          <fo:block font-size="10pt" font-weight="bold" space-after="5mm" text-align="center">
            <xsl:value-of select="@event"/> - <xsl:value-of select="@date"/>
          </fo:block>
          <fo:block font-size="10pt" font-weight="bold" space-after="5mm" text-align="center">
            <xsl:value-of select="@name2"/>
          </fo:block>
          <fo:block font-size="8pt" space-after="5mm"><xsl:value-of select="$date"/>
          </fo:block>
          <fo:block font-size="8pt">
            <fo:table  table-layout="fixed" width="100%" >
                <fo:table-column column-width="1cm"/>
                <xsl:for-each select="Rowcount">
	              	<fo:table-column column-width="proportional-column-width(1)"/>
              	</xsl:for-each>
              <fo:table-body>
              <xsl:apply-templates />
              </fo:table-body>
            </fo:table>
          </fo:block>
          <fo:block font-size="10pt" font-weight="bold" space-before="10mm" space-after="10mm">
          Представитель
          </fo:block>
         <fo:block font-size="10pt" font-weight="bold" space-after="5mm">
		  Главный секретарь
          </fo:block>
          <fo:block id="theEnd" />
        </fo:flow>
     </fo:page-sequence>   
    </fo:root>
  </xsl:template>
  
  <xsl:template match="Head">
  	<fo:table-row background-color="#cccccc">
  		<fo:table-cell border="0.5pt solid black">
  			<fo:block font-size="10pt" font-weight="bold" >
  			№
    		</fo:block>
    	</fo:table-cell>
    	<fo:table-cell border="0.5pt solid black">
  			<fo:block font-size="10pt" font-weight="bold" >
  			Фамилия Имя
    		</fo:block>
    	</fo:table-cell>
    	<fo:table-cell border="0.5pt solid black">
  			<fo:block font-size="10pt" font-weight="bold" >
  			Категория
    		</fo:block>
    	</fo:table-cell>
    </fo:table-row>	
  </xsl:template>
  
  <xsl:template match="Row">
  	<fo:table-row>
  		<fo:table-cell border="0.5pt solid black">
  			<fo:block>
    			<xsl:value-of select="count(preceding-sibling::Row|.)" />
    		</fo:block>
    	</fo:table-cell>
    	<xsl:for-each select="Rowfield">
  			<fo:table-cell border="0.5pt solid black">
  				<fo:block>
    				<xsl:value-of select="." />
    			</fo:block>
    		</fo:table-cell>
  		</xsl:for-each>
    </fo:table-row>	
  </xsl:template>

</xsl:stylesheet>
