<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.1"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:fo="http://www.w3.org/1999/XSL/Format"
	exclude-result-prefixes="fo">
	<xsl:output method="xml" version="1.0"
		omit-xml-declaration="no" indent="yes" />

	<xsl:param name="licencse" select="''" />
	<xsl:param name="date" select="''" />
	<xsl:param name="logo_event" select="''" />
	<xsl:param name="logo_sponsor" select="''" />
	<xsl:param name="logo_federation" select="''" />

	<!-- ========================= -->
	<!-- root element: projectteam -->
	<!-- ========================= -->
	<xsl:template match="Filereport">
		<fo:root xmlns:fo="http://www.w3.org/1999/XSL/Format"
			font-family="Arial Narrow">

			<fo:layout-master-set>
				<fo:simple-page-master master-name="simpleA4"
					page-height="29.7cm" page-width="21cm" margin-top="1.5cm"
					margin-bottom="1.5cm" margin-left="1cm" margin-right="1cm">
					<fo:region-body margin-top="3cm"
						margin-bottom="1.5cm" />
					<fo:region-before extent="1.0cm" />
					<fo:region-after extent="1.0cm" />
				</fo:simple-page-master>
			</fo:layout-master-set>
			<fo:page-sequence master-reference="simpleA4"
				language="de">

				<fo:static-content flow-name="xsl-region-before"
					display-align="before">
					<fo:block font-size="8pt" text-align="center">
						<fo:table table-layout="fixed" width="100%">
							<fo:table-column column-width="2cm" />
							<fo:table-column column-width="15cm" />
							<fo:table-column column-width="2cm" />
							<fo:table-body>
								<fo:table-row>
									<xsl:choose>
										<xsl:when test="string($logo_event)">
											<fo:table-cell text-align="center"
												display-align="center">
												<fo:block text-align="center">
													<fo:external-graphic height="2cm"
														width="4cm" content-height="scale-to-fit"
														content-width="scale-to-fit" scaling="uniform">
														<xsl:attribute name="src">
															url(file:/<xsl:value-of select="$logo_event" />)
														</xsl:attribute>
													</fo:external-graphic>
												</fo:block>
											</fo:table-cell>
										</xsl:when>
										<xsl:otherwise>
											<fo:table-cell text-align="center"
												display-align="center">
												<fo:block>
												</fo:block>
											</fo:table-cell>
										</xsl:otherwise>
									</xsl:choose>
									<fo:table-cell text-align="center"
										display-align="center">
										<fo:block font-size="12pt" font-weight="bold"
											space-after="1mm" text-align="center" >
											<xsl:value-of select="@event" />
											
											
										</fo:block>
										<fo:block font-size="13pt" font-weight="bold"
											space-after="1mm" text-align="center" text-transform="uppercase" margin-bottom="25pt" >
											<xsl:value-of select="@name" />
										</fo:block>
									</fo:table-cell>
									<xsl:choose>
										<xsl:when test="string($logo_federation)">
											<fo:table-cell text-align="center"
												display-align="center">
												<fo:block text-align="center">
													<fo:external-graphic height="2cm"
														width="4cm" content-height="scale-to-fit"
														content-width="scale-to-fit" scaling="uniform" >
														<xsl:attribute name="src">
															url(file:/<xsl:value-of select="$logo_federation" />)
														</xsl:attribute>
													</fo:external-graphic>
												</fo:block>
											</fo:table-cell>
										</xsl:when>
										<xsl:otherwise>
											<fo:table-cell text-align="center"
												display-align="center">
												<fo:block>
												</fo:block>
											</fo:table-cell>
										</xsl:otherwise>
									</xsl:choose>
								</fo:table-row>
							</fo:table-body>
						</fo:table>
					</fo:block>
					<fo:block font-size="18pt" font-weight="bold"
						space-after="1mm" text-align="center" text-transform="uppercase">
						<fo:external-graphic height="0.5cm"
							width="0.7cm" content-height="scale-to-fit"
							content-width="scale-to-fit" scaling="uniform">
							<xsl:attribute name="src">
								
							</xsl:attribute>
						</fo:external-graphic>
						<xsl:text> </xsl:text>
						<xsl:value-of select="@name2" />
					</fo:block>
				</fo:static-content>

				<fo:static-content flow-name="xsl-region-after">
					<fo:block font-size="8pt" text-align="center">
						<fo:table table-layout="fixed" width="100%">
							<fo:table-column column-width="4cm" />
							<fo:table-column column-width="11cm" />
							<fo:table-column column-width="4cm" />
							<fo:table-body>
								<fo:table-row>
									<xsl:choose>
										<xsl:when test="string($logo_sponsor)">
											<fo:table-cell text-align="center"
												display-align="center">
												<fo:block text-align="center">
													<fo:external-graphic height="2cm"
														width="4cm" content-height="scale-to-fit"
														content-width="scale-to-fit" scaling="uniform">
														<xsl:attribute name="src">
															url(file:/<xsl:value-of select="$logo_sponsor" />)
														</xsl:attribute>
													</fo:external-graphic>
												</fo:block>
											</fo:table-cell>
										</xsl:when>
										<xsl:otherwise>
											<fo:table-cell text-align="center"
												display-align="center">
												<fo:block>
												</fo:block>
											</fo:table-cell>
										</xsl:otherwise>
									</xsl:choose>
									<fo:table-cell text-align="center"
										display-align="center">
										<fo:block font-size="7pt" text-align="center">
											<xsl:value-of select="$licencse" />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="center"
										display-align="center">
										<fo:block font-size="8pt" text-align="right">
											<fo:page-number />
											/
											<fo:page-number-citation
												ref-id="theEnd" />

												---
												<xsl:value-of select="@date" />
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
							</fo:table-body>
						</fo:table>
					</fo:block>
				</fo:static-content>

				<fo:flow flow-name="xsl-region-body">
					<fo:block font-size="10pt" font-weight="bold" color="white"
						space-after="1mm" text-align="center" text-transform="uppercase">
						<xsl:value-of select="@total" />
					</fo:block>
					<fo:block font-size="8pt" text-transform="uppercase" margin-left="1mm" margin-top="5mm" display-align="center">
						<fo:table table-layout="fixed" width="100%">
							<fo:table-column column-width="8.3cm" />
							<fo:table-column column-width="5.1cm" />
							<fo:table-column column-width="1.2cm" />
							<fo:table-column column-width="2cm" />
							<fo:table-column column-width="2.2cm" />
							<fo:table-body>
								<xsl:apply-templates />
							</fo:table-body>
						</fo:table>
					</fo:block>
					<fo:block id="theEnd" />
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>

	<xsl:template match="Head">
		<fo:table-row background-color="#cccccc">
			<xsl:for-each select="Headfield">
				<fo:table-cell border="1pt solid grenn" min-height="20pt" display-align="center">
					<fo:block color="black" font-size="12pt"
						font-weight="bold" text-align="center">
						<xsl:value-of select="." />
					</fo:block>
				</fo:table-cell>
			</xsl:for-each>
		</fo:table-row>
	</xsl:template>

	<xsl:template match="Row">
		<fo:table-row>
			<xsl:for-each select="Rowfield">
				<xsl:choose>
					<xsl:when test="string(@Isheader)">
						<fo:table-cell border="1pt solid black"	background-color="#cccccc" number-columns-spanned="5">
							<fo:block color="black" font-size="10pt"
								font-weight="bold">
								<xsl:value-of select="." />
							</fo:block>
						</fo:table-cell>
					</xsl:when>
					<xsl:otherwise>
						<fo:table-cell border="1pt solid black">
							<fo:block>
								<xsl:value-of select="." />
							</fo:block>
						</fo:table-cell >
					</xsl:otherwise>
				</xsl:choose>
			</xsl:for-each>
		</fo:table-row>
	</xsl:template>

	<xsl:template match="payment">
		<fo:table-row>
			<fo:table-cell border="0pt solid black">
				<fo:block color="black" font-size="10pt" font-weight="bold"
					text-align="left" display-align="center" space-after="mm">
							</fo:block>
				<fo:block color="black" font-size="10pt" font-weight="bold"
					text-align="left" display-align="center">
				</fo:block>
			</fo:table-cell>
			<fo:table-cell border="0pt solid red"
				number-columns-spanned="4">
				<fo:block color="black" font-size="12pt" font-weight="bold"
					text-align="right" keep-with-next="always" margin-top="5mm">
					<xsl:value-of select="@entryfee" />
				</fo:block>
				<fo:block color="black" font-size="12pt" font-weight="bold"
					text-align="right" keep-with-next="always" margin-top="2mm">
					<xsl:value-of select="@changesfee" />
				</fo:block>
				<fo:block color="black" font-size="12pt" font-weight="bold"
					text-align="right" keep-with-next="always" margin-top="2mm">
					<xsl:value-of select="@discount" />
				</fo:block>
				<fo:block color="green" font-size="12pt" font-weight="bold"
					text-align="right" border-bottom="2pt solid black"
					keep-with-next="always" margin-top="2mm">
					<xsl:value-of select="@amountpaid" />
				</fo:block>
				<fo:block color="black" font-size="16pt" font-weight="bold"
					text-align="right" keep-with-next="always" margin-top="2mm">
					<xsl:value-of select="@balance" />
				</fo:block>
				<fo:block color="black" font-size="12pt" font-weight="bold"
					text-align="right" keep-with-next="always" margin-top="2mm">
					<xsl:value-of select="@othercurrencies" />
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
	</xsl:template>

	<xsl:template match="qr">
		<fo:table-row>
			<fo:table-cell text-align="left" display-align="left" color="blue">
				<fo:block>
				</fo:block>
			</fo:table-cell>
			<fo:table-cell text-align="left" number-columns-spanned="2" border="0pt solid blue" margin-left="0mm" margin-top="0mm">
				<xsl:choose>
					<xsl:when test="string(qrcode2)">
						<fo:block text-align="left" color="blue" margin-left="-80mm" margin-top="-40mm">
							<fo:external-graphic height="3cm" width="3cm"
								content-height="scale-to-fit" content-width="scale-to-fit"
								scaling="uniform" color="white">
								<xsl:attribute name="src">
									<xsl:value-of select="qrcode2" />
									</xsl:attribute>
							</fo:external-graphic>
						</fo:block>
					</xsl:when>
					<xsl:otherwise>
						display-align="left">
						<fo:block>
						</fo:block>
					</xsl:otherwise>
				</xsl:choose>
			</fo:table-cell>
			<fo:table-cell text-align="right" display-align="right" number-columns-spanned="2" border="0pt solid green">
				<xsl:choose>
					<xsl:when test="string(qrcode2)">
						<fo:block text-align="center" color="white">
							<fo:external-graphic height="3.5cm" width="3.5cm"
								content-height="scale-to-fit" content-width="scale-to-fit"
								scaling="uniform" color="white">
								<xsl:attribute name="src">
									<xsl:value-of select="qrcode2" />
									</xsl:attribute>
							</fo:external-graphic>
						</fo:block>
					</xsl:when>
					<xsl:otherwise>
						display-align="center">
						<fo:block>
						</fo:block>
					</xsl:otherwise>
				</xsl:choose>
			</fo:table-cell>
		</fo:table-row>
		
		<fo:table-row>
		<fo:table-cell border="0pt solid ciano" display-align="center">
		<fo:block font-size="10pt" text-align="center">
						<fo:table table-layout="fixed" width="100%">
							<fo:table-column column-width="7cm" />
							<fo:table-column column-width="7cm" />
							<fo:table-column column-width="3.5cm" />
				
							<fo:table-body>
								<fo:table-row height="2.5cm">
									<fo:table-cell border="1pt solid black" text-align="center" display-align="center">
												<fo:block text-align="center" border-bottom="0pt solid black">
												FIRMA SOCIETA' ORGANIZZATRICE
												</fo:block>
									</fo:table-cell>
									<fo:table-cell border="1pt solid black" text-align="center" display-align="center">
												<fo:block text-align="center" border-bottom="0pt solid black">
												FIRMA PRESIDENTE O DELEGATO
												</fo:block>
									</fo:table-cell>
									<fo:table-cell border="0pt solid orange" text-align="center" display-align="center">
												<fo:block text-align="center" border-bottom="0pt solid black">
												</fo:block>

								
									</fo:table-cell>
								</fo:table-row>
							</fo:table-body>
						</fo:table>
					</fo:block>
							
		</fo:table-cell>
		</fo:table-row>
	</xsl:template>

</xsl:stylesheet>
