<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" exclude-result-prefixes="fo">
  <xsl:output method="xml" version="1.0" omit-xml-declaration="no" indent="yes"/>
  
  <xsl:param name="licencse" select="''"/> 
  <xsl:param name="date" select="''"/>
  
  <!-- ========================= -->
  <!-- root element: projectteam -->
  <!-- ========================= -->
  <xsl:template match="Filereport">
    <fo:root xmlns:fo="http://www.w3.org/1999/XSL/Format" font-family="Arial">
     
      <fo:layout-master-set>
        <fo:simple-page-master master-name="simpleA4" page-height="29.7cm" page-width="21cm" margin-top="2cm" margin-bottom="2cm" margin-left="2cm" margin-right="2cm">
          <fo:region-body margin-top="1.5cm" margin-bottom="1.5cm"/>
		      <fo:region-before extent="1.0cm"/>
          <fo:region-after extent="1.0cm"/>
        </fo:simple-page-master>
      </fo:layout-master-set>
      <fo:page-sequence master-reference="simpleA4" language="de">
      
      	<fo:static-content flow-name="xsl-region-before" display-align="before">
      	  <fo:block font-size="14pt" text-align="center">
           <xsl:value-of select="@event"/> - <xsl:value-of select="@date"/> - <xsl:value-of select="@name"/>
          </fo:block>
   		</fo:static-content>
   		
  		<fo:static-content flow-name="xsl-region-after">
	          <fo:block font-size="8pt" text-align="center">
          		<xsl:value-of select="$licencse"/>
          	</fo:block>
          	<fo:block font-size="8pt" text-align="right">
          		<fo:page-number/> / <fo:page-number-citation  ref-id="theEnd" />
          	</fo:block>
   		</fo:static-content>
        
        <fo:flow flow-name="xsl-region-body">
          <xsl:apply-templates select="category"/>
          <fo:block id="theEnd" />
        </fo:flow>
     </fo:page-sequence>   
    </fo:root>
  </xsl:template>
  
  <xsl:template match="category">
        <fo:block keep-with-next="always" space-before="5mm">
          <xsl:attribute name="font-weight">bold</xsl:attribute>
          <xsl:attribute name="font-size">10pt</xsl:attribute>
          <xsl:value-of select="@name"/>
        </fo:block>
        <xsl:apply-templates select="match"/>
  </xsl:template>
  
  <xsl:template match="match">
  <fo:block font-size="8pt" space-before="5mm" keep-together="always">
	<fo:table table-layout="fixed" width="100%" border="2pt solid #aaaaaa">
		<fo:table-column column-width="7.5cm" />
		<fo:table-column column-width="1cm" />
		<fo:table-column column-width="1cm" />
		<fo:table-column column-width="7.5cm" />
		<fo:table-body>
			<fo:table-row>
				<fo:table-cell border="1pt solid #aaaaaa">
					<fo:block text-align="left" font-size="6pt" font-weight="bold">
						NAME RED:
					</fo:block>
					<fo:block text-align="left">
						<xsl:value-of select="name" />
					</fo:block>
				</fo:table-cell>
				<fo:table-cell border="1pt solid #aaaaaa">
					<fo:block>
						<xsl:text> </xsl:text>
					</fo:block>
				</fo:table-cell>
				<fo:table-cell border="1pt solid #aaaaaa">
					<fo:block>
						<xsl:text> </xsl:text>
					</fo:block>
				</fo:table-cell>
				<fo:table-cell border="1pt solid #aaaaaa">
					<fo:block text-align="left" font-size="6pt" font-weight="bold">
						NAME BLUE:
					</fo:block>
					<fo:block text-align="left">
						<xsl:value-of select="name2" />
					</fo:block>
				</fo:table-cell>
			</fo:table-row>
			<fo:table-row height="0.5cm"> 
				<fo:table-cell border="1pt solid #aaaaaa">
					<fo:block text-align="left" font-size="6pt" font-weight="bold">
						SCORE RED:
					</fo:block>
				</fo:table-cell>
				<fo:table-cell border="1pt solid #aaaaaa">
					<fo:block>
						<xsl:text> </xsl:text>
					</fo:block>
				</fo:table-cell>
				<fo:table-cell border="1pt solid #aaaaaa">
					<fo:block>
						<xsl:text> </xsl:text>
					</fo:block>
				</fo:table-cell>
				<fo:table-cell border="1pt solid #aaaaaa">
					<fo:block text-align="left" font-size="6pt" font-weight="bold">
						SCORE BLUE:
					</fo:block>
				</fo:table-cell>
			</fo:table-row>
			<fo:table-row height="0.5cm"> 
				<fo:table-cell border="1pt solid #aaaaaa">
					<fo:block text-align="left" font-size="6pt" font-weight="bold">
						PENALTY RED:
					</fo:block>
				</fo:table-cell>
				<fo:table-cell border="1pt solid #aaaaaa">
					<fo:block>
						<xsl:text> </xsl:text>
					</fo:block>
				</fo:table-cell>
				<fo:table-cell border="1pt solid #aaaaaa">
					<fo:block>
						<xsl:text> </xsl:text>
					</fo:block>
				</fo:table-cell>
				<fo:table-cell border="1pt solid #aaaaaa">
					<fo:block text-align="left" font-size="6pt" font-weight="bold">
						PENALTY BLUE:
					</fo:block>
				</fo:table-cell>
			</fo:table-row>
			<fo:table-row height="0.5cm"> 
				<fo:table-cell border="1pt solid #aaaaaa">
					<fo:block text-align="left" font-size="6pt" font-weight="bold">
						WARNING RED:
					</fo:block>
				</fo:table-cell>
				<fo:table-cell border="1pt solid #aaaaaa">
					<fo:block>
						<xsl:text> </xsl:text>
					</fo:block>
				</fo:table-cell>
				<fo:table-cell border="1pt solid #aaaaaa">
					<fo:block>
						<xsl:text> </xsl:text>
					</fo:block>
				</fo:table-cell>
				<fo:table-cell border="1pt solid #aaaaaa">
					<fo:block text-align="left" font-size="6pt" font-weight="bold">
						WARNING BLUE:
					</fo:block>
				</fo:table-cell>
			</fo:table-row>
			<fo:table-row height="0.5cm"> 
				<fo:table-cell border="1pt solid #aaaaaa">
					<fo:block text-align="left" font-size="6pt" font-weight="bold">
						OTHER RED:
					</fo:block>
				</fo:table-cell>
				<fo:table-cell border="1pt solid #aaaaaa">
					<fo:block>
						<xsl:text> </xsl:text>
					</fo:block>
				</fo:table-cell>
				<fo:table-cell border="1pt solid #aaaaaa">
					<fo:block>
						<xsl:text> </xsl:text>
					</fo:block>
				</fo:table-cell>
				<fo:table-cell border="1pt solid #aaaaaa">
					<fo:block text-align="left" font-size="6pt" font-weight="bold">
						OTHER BLUE:
					</fo:block>
				</fo:table-cell>
			</fo:table-row>
		</fo:table-body>
	</fo:table>
	</fo:block>
</xsl:template>

</xsl:stylesheet>
