<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" exclude-result-prefixes="fo">
  <xsl:output method="xml" version="1.0" omit-xml-declaration="no" indent="yes"/>
  
  <xsl:param name="licencse" select="''"/> 
  <xsl:param name="date" select="''"/>
  
  <!-- ========================= -->
  <!-- root element: projectteam -->
  <!-- ========================= -->
  <xsl:template match="Filereport">
    <fo:root xmlns:fo="http://www.w3.org/1999/XSL/Format" font-family="Arial Narrow">     
      <fo:layout-master-set>
        <fo:simple-page-master master-name="simpleA4" page-height="29.7cm" page-width="21cm" margin-top="0mm" margin-bottom="0mm" margin-left="0mm" margin-right="0mm">
          <fo:region-body margin-top="0cm" margin-bottom="0cm"/>
        </fo:simple-page-master>
      </fo:layout-master-set>
      <fo:page-sequence master-reference="simpleA4" language="de">
        <fo:flow flow-name="xsl-region-body">
          <fo:block font-size="8pt">
            <fo:table table-layout="fixed" width="100%" >
	            <fo:table-column column-width="21cm"/>
              <fo:table-body>
              <xsl:apply-templates />
              </fo:table-body>
            </fo:table>
          </fo:block>
        </fo:flow>
     </fo:page-sequence>   
    </fo:root>
  </xsl:template>
  
  <xsl:template match="row">
  	 <xsl:apply-templates select="person"/>
  </xsl:template>
  
  <xsl:template match="person">
      <fo:table-row height="14.2cm">
  			<fo:table-cell border-style="dotted" height="14.2cm" width="21cm" border="0.5pt #aaaaaa" padding="3mm" text-align="center">
  			
  			           
  				<fo:block text-align="center" space-before="2mm" space-after="2mm">
  				  <fo:table table-layout="fixed" width="100%" >
              <fo:table-column column-width="20.3cm"/>
              <fo:table-body>
                <fo:table-row height="1cm">
                    <fo:table-cell height="1cm" text-align="center" display-align="center" border="2pt solid #000000" >
  	                 <fo:block width="20.3cm" font-weight="bold" font-size="18pt">
    				          <xsl:value-of select="event" />
    			           </fo:block>	
  	              </fo:table-cell>
                </fo:table-row>
              </fo:table-body>
            </fo:table>
          </fo:block>
  				
    			<fo:block text-align="center" space-before="1mm" space-after="1mm">
  				  <fo:table table-layout="fixed" width="100%">
              <fo:table-column column-width="20.3cm"/>
              <fo:table-body>
                <fo:table-row height="1.0cm">
                    <fo:table-cell height="1.0cm" text-align="center" display-align="center" >
                    <xsl:choose>
                    <xsl:when test="string(competitornumber)">
                      <fo:block color="black" font-size="150pt" font-weight="bold" >
    				          <xsl:value-of select="competitornumber" />
    			           </fo:block>
                    </xsl:when>
                  <xsl:otherwise>
                    <fo:block font-weight="bold" font-size="20pt" >
    				   <xsl:value-of select="binomio" />
    			    </fo:block>
    			     <fo:block font-weight="bold" font-size="30pt" >
    				   <xsl:value-of select="conduttore" />
    			    </fo:block>
    			     <fo:block font-weight="bold" font-size="30pt" >
    				   <xsl:value-of select="dog" />
    			    </fo:block>			
                  </xsl:otherwise>
                  </xsl:choose>
  	              </fo:table-cell>
                </fo:table-row>
              </fo:table-body>
            </fo:table>
          </fo:block>
          
          <fo:block text-align="center" space-before="1mm" space-after="1mm">
  				  <fo:table table-layout="fixed" width="100%" text-transform="uppercase">
              <fo:table-column column-width="3.0cm"/>
              <fo:table-column column-width="15.3cm"/>
              <fo:table-column column-width="3.0cm"/>
              <fo:table-body>
                <fo:table-row height="3.0cm">
  	              <xsl:choose>
                  <xsl:when test="string(logo-sponsor)">
                   <fo:table-cell text-align="center" display-align="center">
  	                 <fo:block text-align="center">
    				        
    			         </fo:block>
    			        </fo:table-cell> 
                 </xsl:when>
                 <xsl:otherwise>
                  <fo:table-cell  text-align="center" display-align="center">
  	                <fo:block>
    			         </fo:block>
    			        </fo:table-cell> 
                </xsl:otherwise>
                </xsl:choose>	
  	              <fo:table-cell text-align="center" display-align="center">
  	              <xsl:choose>
                    <xsl:when test="string(competitornumber)">
                     
    			       <fo:block font-size="25pt" font-weight="bold" width="9cm" margin-top="-50pt">
    				     <xsl:value-of select="conduttore" />
    			      </fo:block>
    			       <fo:block font-size="22pt" font-weight="bold" width="9cm">
    				     <xsl:value-of select="dog" />
    			      </fo:block>
                 <fo:block font-size="20pt" font-weight="bold" width="9cm" margin-bottom="-60pt">
                 <xsl:value-of select="binomio" />
                </fo:block>
                    </xsl:when>
                  <xsl:otherwise/>
                  </xsl:choose>
  	                 <fo:block font-size="16pt" font-weight="bold" width="9cm">
    				        
    			     </fo:block>	
  	              </fo:table-cell>
  	              <xsl:choose>
                  <xsl:when test="string(logo-sponsor)">
                   <fo:table-cell  text-align="center" display-align="center">
  	                 <fo:block >
    				          
    			         </fo:block>
    			        </fo:table-cell> 
                 </xsl:when>
                 <xsl:otherwise>
                <fo:table-cell  text-align="center" display-align="center">
  	                <fo:block text-align="center">
    			         </fo:block>
    			        </fo:table-cell> 
                </xsl:otherwise>
                </xsl:choose>	
                </fo:table-row>
              </fo:table-body>
            </fo:table>
          </fo:block>
          
          <fo:block font-size="18pt" space-before="2mm" space-after="2mm">
  				  <fo:table table-layout="fixed" width="100%" >
              <fo:table-column column-width="3cm"/>
              <fo:table-column column-width="17.3cm"/>
              <fo:table-body>
                <fo:table-row height="2.5cm">
                    <fo:table-cell height="2.5cm"  text-align="center" display-align="center" border="2pt solid #000000">
  	                <fo:block font-size="30pt" font-weight="bold">
  	                <xsl:choose>
					<xsl:when test="string(nation)">
    			           <fo:external-graphic height="2.5cm" width="2.5cm" content-height="scale-to-fit" content-width="scale-to-fit" scaling="uniform">
                        <xsl:attribute name="src">
                          <xsl:value-of select="eventlogo" />
                        </xsl:attribute>
                      </fo:external-graphic>
                    </xsl:when>
				</xsl:choose>
                   </fo:block>	
  	              </fo:table-cell>
  	              <fo:table-cell height="2.5cm"  text-align="center" display-align="center" border="2pt solid #000000">
  	                <fo:block font-size="30pt" font-weight="bold">
    				         <xsl:value-of select="substring-before(club, '(')" />
    			          </fo:block>	
  	              </fo:table-cell>
                </fo:table-row>
              </fo:table-body>
            </fo:table>
          </fo:block>
          
       </fo:table-cell>
      </fo:table-row>  
   </xsl:template>       

</xsl:stylesheet>
