<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:xhtml="http://www.w3.org/1999/xhtml" exclude-result-prefixes="fo">
  <xsl:output method="xml" version="1.0" omit-xml-declaration="no" indent="yes"/>
  
  <xsl:param name="hideclub" select="''"/>
	<xsl:param name="hidecountry" select="''"/>
  <xsl:param name="licencse" select="''"/> 
	<xsl:param name="date" select="''"/>
	<xsl:param name="logo_event" select="''"/>
	<xsl:param name="logo_sponsor" select="''"/>
	<xsl:param name="logo_federation" select="''"/>
  
  <!-- ========================= -->
  <!-- root element: projectteam -->
  <!-- ========================= -->
  <xsl:template match="Filereport">
    <fo:root xmlns:fo="http://www.w3.org/1999/XSL/Format" font-family="Arial">
     
      <fo:layout-master-set>
        <fo:simple-page-master master-name="simpleA4" page-height="29.7cm" page-width="21cm" margin-top="2cm" margin-bottom="2cm" margin-left="2cm" margin-right="2cm">
          <fo:region-body margin-top="1.5cm" margin-bottom="1.5cm"/>
		      <fo:region-before extent="1.0cm"/>
          <fo:region-after extent="1.0cm"/>
        </fo:simple-page-master>
      </fo:layout-master-set>
      <fo:page-sequence master-reference="simpleA4" language="de">
      
      
      <fo:static-content flow-name="xsl-region-before" display-align="before">
					<fo:block font-size="8pt" text-align="center">
						<fo:table table-layout="fixed" width="100%" >
							<fo:table-column column-width="4cm"/>
							<fo:table-column column-width="9cm"/>
							<fo:table-column column-width="4cm"/>
							<fo:table-body>
								<fo:table-row>
									<xsl:choose>
										<xsl:when test="string($logo_event)">
											<fo:table-cell text-align="center" display-align="center">
												<fo:block text-align="center">
													<fo:external-graphic height="2cm" width="4cm" content-height="scale-to-fit" content-width="scale-to-fit" scaling="uniform">
														<xsl:attribute name="src">
															url(file:/<xsl:value-of select="$logo_event" />)
														</xsl:attribute>
													</fo:external-graphic>
												</fo:block>
											</fo:table-cell> 
										</xsl:when>
										<xsl:otherwise>
											<fo:table-cell  text-align="center" display-align="center">
												<fo:block>
												</fo:block>
											</fo:table-cell> 
										</xsl:otherwise>
									</xsl:choose>	
									<fo:table-cell text-align="center" display-align="center">
									<fo:block font-size="8pt" text-align="center">
            								<fo:block font-size="10pt" font-weight="bold" space-after="1mm" text-align="center">
											<xsl:value-of select="@event"/> - <xsl:value-of select="@date"/>
										</fo:block>
										
										
         							</fo:block>

									</fo:table-cell>
									<xsl:choose>
										<xsl:when test="string($logo_federation)">
											<fo:table-cell text-align="center" display-align="center">
												<fo:block text-align="center">
													<fo:external-graphic height="2cm" width="4cm" content-height="scale-to-fit" content-width="scale-to-fit" scaling="uniform">
														<xsl:attribute name="src">
															url(file:/<xsl:value-of select="$logo_federation" />)
														</xsl:attribute>
													</fo:external-graphic>
												</fo:block>
											</fo:table-cell> 
										</xsl:when>
										<xsl:otherwise>
											<fo:table-cell  text-align="center" display-align="center">
												<fo:block>
												</fo:block>
											</fo:table-cell> 
										</xsl:otherwise>
									</xsl:choose>				 
								</fo:table-row>
							</fo:table-body>
						</fo:table>
					</fo:block>
				</fo:static-content>
      
  		
   		<fo:static-content flow-name="xsl-region-after">
					<fo:block font-size="8pt" text-align="center">
						<fo:table table-layout="fixed" width="100%" >
							<fo:table-column column-width="4cm"/>
							<fo:table-column column-width="9cm"/>
							<fo:table-column column-width="4cm"/>
							<fo:table-body>
								<fo:table-row>
									<xsl:choose>
										<xsl:when test="string($logo_sponsor)">
											<fo:table-cell text-align="center" display-align="center">
												<fo:block text-align="center">
													<fo:external-graphic height="2cm" width="4cm" content-height="scale-to-fit" content-width="scale-to-fit" scaling="uniform">
														<xsl:attribute name="src">
															url(file:/<xsl:value-of select="$logo_sponsor" />)
														</xsl:attribute>
													</fo:external-graphic>
												</fo:block>
											</fo:table-cell> 
										</xsl:when>
										<xsl:otherwise>
											<fo:table-cell  text-align="center" display-align="center">
												<fo:block>
												</fo:block>
											</fo:table-cell> 
										</xsl:otherwise>
									</xsl:choose>	
									<fo:table-cell text-align="center" display-align="center">
										<fo:block font-size="7pt" text-align="center">
											<xsl:value-of select="$licencse"/>
										</fo:block>
									</fo:table-cell> 
									<fo:table-cell text-align="center" display-align="center">
										<fo:block font-size="8pt" text-align="right">
											<fo:page-number/> / <fo:page-number-citation  ref-id="theEnd" />
										</fo:block>
									</fo:table-cell> 
								</fo:table-row>
							</fo:table-body>
						</fo:table>
					</fo:block>
				</fo:static-content>
        
        <fo:flow flow-name="xsl-region-body">
          <fo:block font-size="12pt" font-weight="bold" space-after="5mm" text-align="center">
            <xsl:value-of select="@name"/>
          </fo:block>
          <fo:block font-size="8pt">
            <fo:table table-layout="fixed" width="100%">
              <fo:table-column column-width="0.5cm"/>
              <fo:table-column column-width="3cm"/>
              
              <xsl:variable name="rowcounter" select="count(Rowcount) - 2"/>
              
              <xsl:for-each select="Rowcount">
              	<xsl:if test="$rowcounter >= position()">
              		<fo:table-column column-width="proportional-column-width(1)"/>
				</xsl:if>
			  </xsl:for-each>
              <fo:table-body>
                <xsl:apply-templates />
              </fo:table-body>
            </fo:table>
          </fo:block>
          <fo:block id="theEnd" />
        </fo:flow>
     </fo:page-sequence>   
    </fo:root>
  </xsl:template>
  
  <xsl:template match="Head">
  	<fo:table-row>
    	<xsl:for-each select="Headfield">
  			<fo:table-cell>
  				<fo:block color="blue" font-size="7pt" font-weight="bold" text-align="center">
    				<xsl:value-of select="." />
    			</fo:block>
    		</fo:table-cell>
  		</xsl:for-each>
    </fo:table-row>	
  </xsl:template>
  
  <xsl:template match="Row">
  	<fo:table-row keep-together.within-page="always">
    	<xsl:for-each select="Rowfield">
  			<fo:table-cell border="0.5pt solid black" text-align="center" display-align="center" min-height="15pt">
  				<fo:block font-size="7pt">
  					   <xsl:apply-templates />
    			</fo:block>
    		</fo:table-cell>
  		</xsl:for-each>
    </fo:table-row>	
  </xsl:template>
  
  <xsl:template match="table">
        <fo:table table-layout="auto" width="100%">
            <fo:table-body>
                <xsl:apply-templates />
            </fo:table-body>
        </fo:table>
    </xsl:template>
    
    <xsl:template match="tr">
        <fo:table-row keep-together.within-page="always">
            <xsl:apply-templates />
        </fo:table-row>
    </xsl:template>

    <xsl:template match="th">
        <fo:table-cell border="0.5pt solid black" text-align="center" display-align="center">
        	<xsl:if test="@bgcolor">
        		<xsl:attribute name="background-color">
					<xsl:value-of select="@bgcolor"/>
				</xsl:attribute>
        	</xsl:if>
        	<xsl:if test="@colspan">
        		<xsl:attribute name="number-columns-spanned">
					<xsl:value-of select="@colspan"/>
				</xsl:attribute>
        	</xsl:if>
            <fo:block color="blue" font-size="7pt" font-weight="bold" text-align="center">
                <xsl:value-of select="." />
            </fo:block>
        </fo:table-cell>
        
         <xsl:apply-templates />
         
    </xsl:template>

	 <xsl:template match="td">
        <fo:table-cell border="0.5pt solid black" text-align="center" display-align="center" font-size="7pt">
        	<xsl:if test="@bgcolor">
				<xsl:attribute name="font-weight">
					bold
				</xsl:attribute>
				<xsl:attribute name="border">
					1pt solid black
				</xsl:attribute>
        	</xsl:if>
        	<xsl:if test="@colspan">
        		<xsl:attribute name="number-columns-spanned">
					<xsl:value-of select="@colspan"/>
				</xsl:attribute>
        	</xsl:if>
            <fo:block text-align="center">
                 <xsl:apply-templates />
            </fo:block>
        </fo:table-cell>
    </xsl:template>
    
    <xsl:template match="strike">
        <fo:inline font-size="7pt" font-weight="bold" text-align="center" text-decoration="line-through" color="red">
            <xsl:value-of select="." />
        </fo:inline>         
    </xsl:template>
    
    <xsl:template match="span">
        <fo:inline font-size="12pt" font-weight="bold" text-align="center" text-decoration="underline">
            <xsl:value-of select="." />
        </fo:inline>         
    </xsl:template>

</xsl:stylesheet>
